/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.device.guiutil.midtool;

import com.mathworks.toolbox.instrument.device.drivers.xml.MethodDefinition;
import com.mathworks.toolbox.instrument.device.drivers.xml.Parser;
import com.mathworks.toolbox.instrument.device.drivers.xml.property.PropertyDefinition;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.DefaultDriverModel;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.DriverFunction;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.DriverGroup;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.DriverModel;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.DriverProperty;
import com.mathworks.toolbox.testmeas.util.TMException;
import java.util.Hashtable;
import java.util.Vector;

public class DriverFileReader {
    private DriverModel fData;
    private Parser fParser;

    public DriverFileReader(Parser parser) {
        this.fData = null;
        this.fParser = parser;
    }

    public DriverFileReader(String string) {
        this.fData = null;
        try {
            this.fParser = new Parser(string);
            this.fParser.setWarnState(false);
            this.fParser.parse();
        }
        catch (TMException tMException) {
            this.fParser = null;
        }
    }

    DriverFileReader(DriverModel driverModel) {
        this.fData = driverModel;
    }

    public DriverModel parserToModel() {
        if (this.fParser == null) {
            return null;
        }
        if (this.fData == null) {
            this.fData = new DefaultDriverModel();
        }
        this.readParserData();
        return this.fData;
    }

    protected void readXML(String string) throws TMException {
        this.fParser = new Parser(string);
        this.fParser.setWarnState(false);
        this.fParser.parse();
        this.readParserData();
    }

    protected void readParserData() {
        Vector<Object> vector;
        this.fData.setFileVersion(this.fParser.getFileVersion());
        this.fData.setDriverType(this.fParser.getDriverTypeId());
        String string = this.fParser.getDriverName();
        this.fData.setDriverName(string == null ? "" : string);
        string = this.fParser.getInstrumentManufacturer();
        this.fData.setInstrumentManufacturer(string == null ? "Manufacturer" : string);
        string = this.fParser.getInstrumentModel();
        this.fData.setInstrumentModel(string == null ? "Model" : string);
        string = this.fParser.getInstrumentType();
        this.fData.setInstrumentType(string == null ? "Custom Device" : string);
        string = this.fParser.getInstrumentVersion();
        this.fData.setInstrumentVersion(string == null ? "" : string);
        string = this.fParser.getCreateInitializationCode();
        this.fData.setCreateInitMCode(string == null ? "" : string);
        if (this.fParser.getConnectInitCodeType() == 1) {
            this.fData.setConnectInitType(0);
            vector = this.fParser.getConnectInitVector();
            this.fData.setConnectInitCode((Vector<String>)(vector == null ? new Vector() : vector));
        } else {
            this.fData.setConnectInitType(1);
            string = this.fParser.getConnectInitializationCode();
            this.fData.setConnectInitMCode(string == null ? "" : string);
        }
        if (this.fParser.getCleanupCodeType() == 1) {
            this.fData.setDisconnectType(0);
            vector = this.fParser.getCleanupVector();
            this.fData.setDisconnectCode((Vector<String>)(vector == null ? new Vector() : vector));
        } else {
            this.fData.setDisconnectType(1);
            string = this.fParser.getCleanupCode();
            this.fData.setDisconnectMCode(string == null ? "" : string);
        }
        string = this.fParser.getIdentifyCommand();
        this.fData.setIdentifyCommand(string == null ? "" : string);
        string = this.fParser.getResetCommand();
        this.fData.setResetCommand(string == null ? "" : string);
        string = this.fParser.getSelfTestCommand();
        this.fData.setSelfTestCommand(string == null ? "" : string);
        string = this.fParser.getErrorCommand();
        this.fData.setErrorCommand(string == null ? "" : string);
        DriverGroup driverGroup = this.loadDriverGroup(this.fParser, "parent");
        this.fData.add(driverGroup);
        vector = this.fParser.getPropertyGroups();
        for (int i = 0; i < vector.size(); ++i) {
            string = (String)vector.get(i);
            this.fData.add(this.loadDriverGroup(this.fParser, string));
        }
    }

    public DriverGroup loadDriverGroup(Parser parser, String string) {
        Object object;
        Vector<String> vector;
        DriverGroup driverGroup = new DriverGroup(string.toLowerCase());
        if (!string.equalsIgnoreCase("parent")) {
            driverGroup.setHelpText(parser.getGroupDescription(string));
            driverGroup.setCommand(parser.getGroupConfigureCommand(string));
            Hashtable<Integer, String> hashtable = parser.getGroupMappings(string);
            if (!hashtable.isEmpty()) {
                driverGroup.setIdMappings(hashtable);
            }
        }
        if ((vector = parser.getProperties(string)) != null) {
            for (int i = 0; i < vector.size(); ++i) {
                object = (PropertyDefinition)parser.getPropertyInformation(vector.get(i), string);
                driverGroup.add(DriverProperty.createFromPropertyDefinition((PropertyDefinition)object, driverGroup));
            }
        }
        if ((vector = parser.getMethods(string)) != null) {
            for (int i = 0; i < vector.size(); ++i) {
                object = parser.getMethodDefinition(vector.get(i), string);
                driverGroup.add(DriverFunction.createFromMethodDefinition((MethodDefinition)object, driverGroup));
            }
        }
        return driverGroup;
    }
}

