/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.device.guiutil.midtool;

import com.mathworks.mwswing.MJMenuItem;
import com.mathworks.mwswing.MJOptionPane;
import com.mathworks.mwswing.MJToolBar;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.DefaultDriverModel;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.DriverFunction;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.DriverGroup;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.DriverModel;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.DriverProperty;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.MIDNode;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.MIDTool;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.event.DriverModelEvent;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.event.DriverModelListener;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.panel.BasePanel;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.panel.FunctionPanel;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.panel.GroupPanel;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.panel.InitializationPanel;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.panel.ListPanel;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.panel.PropertyPanel;
import com.mathworks.toolbox.instrument.device.guiutil.midtool.panel.SummaryPanel;
import com.mathworks.toolbox.testmeas.browser.BaseBrowserClient;
import com.mathworks.toolbox.testmeas.browser.BrowserClient;
import com.mathworks.toolbox.testmeas.browser.BrowserTreeNode;
import com.mathworks.toolbox.testmeas.browser.TreeViewEditorListener;
import java.awt.Component;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class DriverClient
extends BaseBrowserClient
implements BrowserClient,
TreeViewEditorListener,
DriverModelListener {
    private static final String sRootNodeHelp = "instredit_csh\\top_page\\ic_instredit.html";
    private static final String sSummaryNodeHelp = "instredit_csh\\_summary.html";
    private static final String sInitNodeHelp = "instredit_csh\\_init_cleanup.html";
    private static final String sGroupListNodeHelp = "instredit_csh\\_groups.html";
    private static final String sGroupNodeHelp = "instredit_csh\\_groups_names.html";
    private static final String sPropertyListNodeHelp = "instredit_csh\\_properties.html";
    private static final String sPropertyGroupNodeHelp = "instredit_csh\\_properties.html";
    private static final String sPropertyNodeHelp = "instredit_csh\\_properties_names.html";
    private static final String sFunctionListNodeHelp = "instredit_csh\\_functions.html";
    private static final String sFunctionGroupNodeHelp = "instredit_csh\\_functions.html";
    private static final String sFunctionNodeHelp = "instredit_csh\\_functions_names.html";
    private MJMenuItem fAddPropertyMenu;
    private MJMenuItem fAddFunctionMenu;
    private MJMenuItem fAddGroupMenu;
    private MJMenuItem fRenameMenu;
    private MJMenuItem fDuplicateMenu;
    private MJMenuItem fDeleteMenu;
    private BasePanel[] treeNodePanels;
    private BasePanel lastSelectedPanel;
    private MIDNode lastSelectedNode;
    private MIDNode fRootNode;
    private MIDNode fSummaryNode;
    private MIDNode fInitializationNode;
    private MIDNode fGroupListNode;
    private Hashtable<String, MIDNode> fGroupNodes;
    private Hashtable<String, MIDNode> fGroupPropertyListNodes;
    private Hashtable<String, MIDNode> fGroupFunctionListNodes;
    private DefaultDriverModel fDriverData;
    private MIDTool tool;

    public DriverClient(MIDTool mIDTool) {
        this.tool = mIDTool;
        this.initialize();
    }

    private void initialize() {
        this.createDetailPanels();
        this.createContextualMenus();
    }

    private void createDetailPanels() {
        this.treeNodePanels = new BasePanel[11];
        for (int i = 0; i < 11; ++i) {
            this.treeNodePanels[i] = new BasePanel(this);
        }
        this.treeNodePanels[1] = new SummaryPanel(this);
        this.treeNodePanels[2] = new InitializationPanel(this);
        this.treeNodePanels[3] = new ListPanel(this, 0);
        this.treeNodePanels[4] = new GroupPanel(this);
        this.treeNodePanels[5] = new PropertyPanel(this);
        this.treeNodePanels[6] = new FunctionPanel(this);
        this.treeNodePanels[7] = new ListPanel(this, 1);
        this.treeNodePanels[8] = new ListPanel(this, 2);
        this.treeNodePanels[9] = new ListPanel(this, 1);
        this.treeNodePanels[10] = new ListPanel(this, 2);
        this.lastSelectedNode = null;
    }

    private void createContextualMenus() {
        Hashtable<String, Action> hashtable = this.tool.getActions();
        this.fAddPropertyMenu = new MJMenuItem();
        this.fAddPropertyMenu.setAction(hashtable.get("AddPropertyContext"));
        this.fAddFunctionMenu = new MJMenuItem();
        this.fAddFunctionMenu.setAction(hashtable.get("AddFunctionContext"));
        this.fAddGroupMenu = new MJMenuItem();
        this.fAddGroupMenu.setAction(hashtable.get("AddGroupContext"));
        this.fRenameMenu = new MJMenuItem();
        this.fRenameMenu.setAction(hashtable.get("RenameContext"));
        this.fDuplicateMenu = new MJMenuItem();
        this.fDuplicateMenu.setAction(hashtable.get("DuplicateContext"));
        this.fDeleteMenu = new MJMenuItem();
        this.fDeleteMenu.setAction(hashtable.get("DeleteContext"));
    }

    public DefaultTreeModel setDocument(DefaultDriverModel defaultDriverModel) {
        this.lastSelectedNode = null;
        this.lastSelectedPanel = null;
        if (this.fDriverData != null) {
            for (int i = 0; i < 11; ++i) {
                this.treeNodePanels[i].driverWillUnload(this.fDriverData);
            }
        }
        this.fDriverData = defaultDriverModel;
        if (defaultDriverModel != null) {
            DefaultTreeModel defaultTreeModel = this.loadDriverData();
            for (int i = 0; i < 11; ++i) {
                this.treeNodePanels[i].driverDidLoad(defaultDriverModel);
            }
            this.fDriverData.addDriverModelListener(this);
            return defaultTreeModel;
        }
        return null;
    }

    public DriverModel getDriverModel() {
        return this.fDriverData;
    }

    public MIDNode getDefaultNode() {
        return this.fSummaryNode;
    }

    @Override
    public void driverStateChanged(DriverModelEvent driverModelEvent) {
        switch (driverModelEvent.getType()) {
            case 3: {
                this.insert((DriverGroup)driverModelEvent.getTarget(), driverModelEvent.getIndex(), false);
                break;
            }
            case 4: {
                this.remove((DriverGroup)driverModelEvent.getTarget());
                break;
            }
            case 7: {
                this.insert((DriverProperty)driverModelEvent.getTarget(), driverModelEvent.getIndex(), false);
                break;
            }
            case 8: {
                this.remove((DriverProperty)driverModelEvent.getTarget());
                break;
            }
            case 11: {
                this.insert((DriverFunction)driverModelEvent.getTarget(), driverModelEvent.getIndex(), false);
                break;
            }
            case 12: {
                this.remove((DriverFunction)driverModelEvent.getTarget());
                break;
            }
            case 6: {
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                DriverGroup driverGroup = (DriverGroup)driverModelEvent.getSource();
                String string = (String)driverModelEvent.getTarget();
                MIDNode mIDNode = this.fGroupPropertyListNodes.remove(string);
                this.fGroupPropertyListNodes.put(driverGroup.getName(), mIDNode);
                mIDNode = this.fGroupFunctionListNodes.remove(string);
                this.fGroupFunctionListNodes.put(driverGroup.getName(), mIDNode);
                mIDNode = this.fGroupNodes.remove(string);
                this.fGroupNodes.put(driverGroup.getName(), mIDNode);
                mIDNode.setUserObject(driverGroup.getName());
                if (this.tool.getTreeView().isExpanded(new TreePath(mIDNode.getPath()))) {
                    bl = true;
                }
                if (this.tool.getTreeView().isExpanded(new TreePath(((DefaultMutableTreeNode)mIDNode.getChildAt(0)).getPath()))) {
                    bl2 = true;
                }
                if (this.tool.getTreeView().isExpanded(new TreePath(((DefaultMutableTreeNode)mIDNode.getChildAt(1)).getPath()))) {
                    bl3 = true;
                }
                this.sortNode(mIDNode, false);
                if (bl) {
                    this.tool.getTreeView().expandPath(new TreePath(mIDNode.getPath()));
                }
                if (bl2) {
                    this.tool.getTreeView().expandPath(new TreePath(((DefaultMutableTreeNode)mIDNode.getChildAt(0)).getPath()));
                }
                if (bl3) {
                    this.tool.getTreeView().expandPath(new TreePath(((DefaultMutableTreeNode)mIDNode.getChildAt(1)).getPath()));
                }
                this.postNodeUpdatedEvent(mIDNode);
                break;
            }
            case 10: {
                DriverProperty driverProperty = (DriverProperty)driverModelEvent.getSource();
                String string = (String)driverModelEvent.getTarget();
                MIDNode mIDNode = this.fGroupPropertyListNodes.get(driverProperty.getGroup().getName());
                for (int i = 0; i < mIDNode.getChildCount(); ++i) {
                    MIDNode mIDNode2 = (MIDNode)((Object)mIDNode.getChildAt(i));
                    if (!((String)mIDNode2.getUserObject()).equalsIgnoreCase(string)) continue;
                    mIDNode2.setUserObject(driverProperty.getName());
                    this.sortNode(mIDNode2, false);
                    this.postNodeUpdatedEvent(mIDNode2);
                }
                break;
            }
            case 14: {
                DriverFunction driverFunction = (DriverFunction)driverModelEvent.getSource();
                String string = (String)driverModelEvent.getTarget();
                MIDNode mIDNode = this.fGroupFunctionListNodes.get(driverFunction.getGroup().getName());
                for (int i = 0; i < mIDNode.getChildCount(); ++i) {
                    MIDNode mIDNode3 = (MIDNode)((Object)mIDNode.getChildAt(i));
                    if (!((String)mIDNode3.getUserObject()).equalsIgnoreCase(string)) continue;
                    mIDNode3.setUserObject(driverFunction.getName());
                    this.sortNode(mIDNode3, false);
                    this.postNodeUpdatedEvent(mIDNode3);
                }
                break;
            }
        }
    }

    public void prepareToSave() {
        if (this.lastSelectedNode != null && this.lastSelectedPanel != null) {
            this.lastSelectedPanel.updateNode(this.lastSelectedNode);
            this.postNodeUpdatedEvent(this.lastSelectedNode);
        }
        this.fRootNode.setUserObject(this.fDriverData.getDocumentName(false));
        this.postNodeUpdatedEvent(this.fRootNode);
    }

    private DefaultTreeModel loadDriverData() {
        String string = this.fDriverData.getDocumentName(false);
        this.fRootNode = new MIDNode(string, this, 0, null);
        this.fRootNode.setHelpDirectoryAndPage("instrument", sRootNodeHelp);
        this.fRootNode.setShowHelpOnly(true);
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel((TreeNode)((Object)this.fRootNode));
        this.fSummaryNode = new MIDNode("Summary", this, 1, null);
        this.fSummaryNode.setHelpDirectoryAndPage("instrument", sSummaryNodeHelp);
        defaultTreeModel.insertNodeInto((MutableTreeNode)((Object)this.fSummaryNode), (MutableTreeNode)((Object)this.fRootNode), 0);
        this.fInitializationNode = new MIDNode("Initialization and Cleanup", this, 2, null);
        this.fInitializationNode.setHelpDirectoryAndPage("instrument", sInitNodeHelp);
        defaultTreeModel.insertNodeInto((MutableTreeNode)((Object)this.fInitializationNode), (MutableTreeNode)((Object)this.fRootNode), 1);
        this.fGroupListNode = new MIDNode("Groups", this, 3, null);
        this.fGroupListNode.setHelpDirectoryAndPage("instrument", sGroupListNodeHelp);
        defaultTreeModel.insertNodeInto((MutableTreeNode)((Object)this.fGroupListNode), (MutableTreeNode)((Object)this.fRootNode), 2);
        this.fGroupNodes = new Hashtable();
        this.fGroupPropertyListNodes = new Hashtable();
        this.fGroupFunctionListNodes = new Hashtable();
        DriverGroup driverGroup = this.fDriverData.getGroup("parent");
        MIDNode mIDNode = new MIDNode("Properties", this, 7, driverGroup);
        mIDNode.setHelpDirectoryAndPage("instrument", "instredit_csh\\_properties.html");
        defaultTreeModel.insertNodeInto((MutableTreeNode)((Object)mIDNode), (MutableTreeNode)((Object)this.fRootNode), 3);
        this.fGroupPropertyListNodes.put(driverGroup.getName(), mIDNode);
        mIDNode = new MIDNode("Functions", this, 8, driverGroup);
        mIDNode.setHelpDirectoryAndPage("instrument", "instredit_csh\\_functions.html");
        defaultTreeModel.insertNodeInto((MutableTreeNode)((Object)mIDNode), (MutableTreeNode)((Object)this.fRootNode), 4);
        this.fGroupFunctionListNodes.put(driverGroup.getName(), mIDNode);
        DriverGroup[] driverGroupArray = this.fDriverData.getGroups();
        for (int i = 0; i < driverGroupArray.length; ++i) {
            if (driverGroupArray[i].isParentGroup()) continue;
            MIDNode mIDNode2 = new MIDNode(driverGroupArray[i].getDisplayName(), this, 4, driverGroupArray[i]);
            mIDNode2.setHelpDirectoryAndPage("instrument", sGroupNodeHelp);
            defaultTreeModel.insertNodeInto((MutableTreeNode)((Object)mIDNode2), (MutableTreeNode)((Object)this.fGroupListNode), this.fGroupListNode.getChildCount());
            this.fGroupNodes.put(driverGroupArray[i].getName(), mIDNode2);
            mIDNode = new MIDNode("Properties", this, 9, driverGroupArray[i]);
            mIDNode.setHelpDirectoryAndPage("instrument", "instredit_csh\\_properties.html");
            defaultTreeModel.insertNodeInto((MutableTreeNode)((Object)mIDNode), (MutableTreeNode)((Object)mIDNode2), mIDNode2.getChildCount());
            this.fGroupPropertyListNodes.put(driverGroupArray[i].getName(), mIDNode);
            mIDNode = new MIDNode("Functions", this, 10, driverGroupArray[i]);
            mIDNode.setHelpDirectoryAndPage("instrument", "instredit_csh\\_functions.html");
            defaultTreeModel.insertNodeInto((MutableTreeNode)((Object)mIDNode), (MutableTreeNode)((Object)mIDNode2), mIDNode2.getChildCount());
            this.fGroupFunctionListNodes.put(driverGroupArray[i].getName(), mIDNode);
        }
        for (int i = 0; i < driverGroupArray.length; ++i) {
            MIDNode mIDNode3 = this.fGroupPropertyListNodes.get(driverGroupArray[i].getName());
            this.addPropertiesToTree(defaultTreeModel, mIDNode3, driverGroupArray[i]);
            mIDNode3 = this.fGroupFunctionListNodes.get(driverGroupArray[i].getName());
            this.addFunctionsToTree(defaultTreeModel, mIDNode3, driverGroupArray[i]);
        }
        return defaultTreeModel;
    }

    private void addPropertiesToTree(DefaultTreeModel defaultTreeModel, MIDNode mIDNode, DriverGroup driverGroup) {
        Vector<Object> vector = driverGroup.getProperties();
        for (int i = 0; i < vector.size(); ++i) {
            DriverProperty driverProperty = (DriverProperty)vector.get(i);
            MIDNode mIDNode2 = new MIDNode(driverProperty.getName(), this, 5, driverProperty);
            mIDNode2.setHelpDirectoryAndPage("instrument", sPropertyNodeHelp);
            defaultTreeModel.insertNodeInto((MutableTreeNode)((Object)mIDNode2), (MutableTreeNode)((Object)mIDNode), mIDNode.getChildCount());
        }
    }

    private void addFunctionsToTree(DefaultTreeModel defaultTreeModel, MIDNode mIDNode, DriverGroup driverGroup) {
        Vector<DriverFunction> vector = driverGroup.getFunctions();
        for (int i = 0; i < vector.size(); ++i) {
            DriverFunction driverFunction = vector.get(i);
            MIDNode mIDNode2 = new MIDNode(driverFunction.getName(), this, 6, driverFunction);
            mIDNode2.setHelpDirectoryAndPage("instrument", sFunctionNodeHelp);
            defaultTreeModel.insertNodeInto((MutableTreeNode)((Object)mIDNode2), (MutableTreeNode)((Object)mIDNode), mIDNode.getChildCount());
        }
    }

    public boolean isValidPropertyName(String string, DriverGroup driverGroup, boolean bl) {
        if (string.length() == 0) {
            if (bl) {
                MJOptionPane.showConfirmDialog((Component)this.getBrowserFrame(), (Object)"Empty property names are not allowed.", (String)"Invalid Property Name", (int)-1, (int)0);
            }
            return false;
        }
        if (this.fDriverData == null) {
            return false;
        }
        int n = this.fDriverData.isValidPropertyName(string, driverGroup);
        if (n == 0) {
            return true;
        }
        if (!bl) {
            return false;
        }
        String string2 = "";
        switch (n) {
            case 1: {
                string2 = "Duplicate property names are not allowed.";
                break;
            }
            case 6: {
                string2 = "Properties at the device level cannot be the same as an existing group name.";
                break;
            }
            case 2: {
                string2 = "Using a reserved property name is not allowed.";
                break;
            }
            case 3: {
                string2 = string + " is not a valid MATLAB property name.";
            }
        }
        MJOptionPane.showConfirmDialog((Component)this.getBrowserFrame(), (Object)string2, (String)"Invalid Property Name", (int)-1, (int)0);
        return false;
    }

    public void createProperty(MIDNode mIDNode) {
        String string = null;
        int n = mIDNode.getType();
        DriverGroup driverGroup = n == 4 || n == 9 ? (DriverGroup)mIDNode.getUserData() : this.fDriverData.getGroup("parent");
        do {
            if ((string = this.uiGetString("Property name:", "Add Property")) != null) continue;
            return;
        } while (!this.isValidPropertyName(string, driverGroup, true));
        DriverProperty driverProperty = this.fDriverData.createProperty(string, driverGroup);
        this.fDriverData.add(driverProperty);
    }

    public void insert(DriverProperty driverProperty, int n, boolean bl) {
        int n2 = n;
        MIDNode mIDNode = this.fGroupPropertyListNodes.get(driverProperty.getGroup().getName());
        if (n2 < 0) {
            n2 = mIDNode.getChildCount();
        }
        MIDNode mIDNode2 = new MIDNode(driverProperty.getName(), this, 5, driverProperty);
        mIDNode2.setHelpDirectoryAndPage("instrument", sPropertyNodeHelp);
        this.postNodeAddedEvent(mIDNode, mIDNode2, bl, n2);
    }

    public boolean isValidFunctionName(String string, DriverGroup driverGroup, boolean bl) {
        if (string.length() == 0) {
            if (bl) {
                MJOptionPane.showConfirmDialog((Component)this.getBrowserFrame(), (Object)"Empty function names are not allowed.", (String)"Invalid Function Name", (int)-1, (int)0);
            }
            return false;
        }
        if (this.fDriverData == null) {
            return false;
        }
        int n = this.fDriverData.isValidFunctionName(string, driverGroup);
        if (n == 0) {
            return true;
        }
        if (!bl) {
            return false;
        }
        switch (n) {
            case 1: {
                MJOptionPane.showConfirmDialog((Component)this.getBrowserFrame(), (Object)"Duplicate function names are not allowed.", (String)"Invalid Function Name", (int)-1, (int)0);
                break;
            }
            case 2: {
                MJOptionPane.showConfirmDialog((Component)this.getBrowserFrame(), (Object)"Using a reserved function name is not allowed.", (String)"Invalid Function Name", (int)-1, (int)0);
                break;
            }
            case 3: {
                MJOptionPane.showConfirmDialog((Component)this.getBrowserFrame(), (Object)(string + " is not a valid MATLAB function name."), (String)"Invalid Function Name", (int)-1, (int)0);
            }
        }
        return false;
    }

    public void createFunction(MIDNode mIDNode) {
        String string = null;
        int n = mIDNode.getType();
        DriverGroup driverGroup = n == 4 || n == 10 ? (DriverGroup)mIDNode.getUserData() : this.fDriverData.getGroup("parent");
        do {
            if ((string = this.uiGetString("Function name:", "Add Function")) != null) continue;
            return;
        } while (!this.isValidFunctionName(string, driverGroup, true));
        DriverFunction driverFunction = this.fDriverData.createFunction(string, driverGroup);
        this.fDriverData.add(driverFunction);
    }

    public void insert(DriverFunction driverFunction, int n, boolean bl) {
        int n2 = n;
        MIDNode mIDNode = this.fGroupFunctionListNodes.get(driverFunction.getGroup().getName());
        if (n2 < 0) {
            n2 = mIDNode.getChildCount();
        }
        MIDNode mIDNode2 = new MIDNode(driverFunction.getName(), this, 6, driverFunction);
        mIDNode2.setHelpDirectoryAndPage("instrument", sFunctionNodeHelp);
        this.postNodeAddedEvent(mIDNode, mIDNode2, bl, n2);
    }

    public boolean isValidGroupName(String string, boolean bl) {
        if (string.length() == 0) {
            if (bl) {
                MJOptionPane.showConfirmDialog((Component)this.getBrowserFrame(), (Object)"Empty group names are not allowed.", (String)"Invalid Group Name", (int)-1, (int)0);
            }
            return false;
        }
        if (this.fDriverData == null) {
            return false;
        }
        int n = this.fDriverData.isValidGroupName(string);
        if (n == 0) {
            return true;
        }
        if (!bl) {
            return false;
        }
        String string2 = "";
        switch (n) {
            case 1: {
                string2 = "Duplicate group names are not allowed.";
                break;
            }
            case 5: {
                string2 = string + " is the name of an existing device property.";
                break;
            }
            case 2: {
                string2 = "Using a reserved property name is not allowed for group names.";
                break;
            }
            case 3: {
                string2 = string + " is not a valid MATLAB property name and cannot be used as a group name.";
            }
        }
        MJOptionPane.showConfirmDialog((Component)this.getBrowserFrame(), (Object)string2, (String)"Invalid Group Name", (int)-1, (int)0);
        return false;
    }

    public void createGroup(MIDNode mIDNode) {
        String string = null;
        do {
            if ((string = this.uiGetString("Group name:", "Add Group")) != null) continue;
            return;
        } while (!this.isValidGroupName(string, true));
        DriverGroup driverGroup = this.fDriverData.createGroup(string);
        this.fDriverData.add(driverGroup);
    }

    public void insert(DriverGroup driverGroup, int n, boolean bl) {
        int n2 = n;
        if (n2 < 0) {
            n2 = this.fGroupNodes.size() - 1;
        }
        MIDNode mIDNode = new MIDNode(driverGroup.getDisplayName(), this, 4, driverGroup);
        mIDNode.setHelpDirectoryAndPage("instrument", sGroupNodeHelp);
        this.fGroupNodes.put(driverGroup.getName(), mIDNode);
        this.postNodeAddedEvent(this.fGroupListNode, mIDNode, bl, n2);
        MIDNode mIDNode2 = new MIDNode("Properties", this, 9, driverGroup);
        mIDNode2.setHelpDirectoryAndPage("instrument", "instredit_csh\\_properties.html");
        this.fGroupPropertyListNodes.put(driverGroup.getName(), mIDNode2);
        this.postNodeAddedEvent(mIDNode, mIDNode2, bl, mIDNode.getChildCount());
        mIDNode2 = new MIDNode("Functions", this, 10, driverGroup);
        mIDNode2.setHelpDirectoryAndPage("instrument", "instredit_csh\\_functions.html");
        this.fGroupFunctionListNodes.put(driverGroup.getName(), mIDNode2);
        this.postNodeAddedEvent(mIDNode, mIDNode2, bl, mIDNode.getChildCount());
    }

    private String uiGetString(String string, String string2) {
        String string3 = MJOptionPane.showInputDialog((Component)this.tool.getBrowser().getFrame(), (Object)string, (String)string2, (int)-1);
        return string3;
    }

    public void duplicate(MIDNode mIDNode) {
        switch (mIDNode.getType()) {
            case 5: {
                this.duplicatePropertyNode(mIDNode);
                break;
            }
            case 6: {
                this.duplicateFunctionNode(mIDNode);
                break;
            }
            default: {
                return;
            }
        }
    }

    private MIDNode duplicatePropertyNode(MIDNode mIDNode) {
        int n = 1;
        DriverProperty driverProperty = (DriverProperty)mIDNode.getUserData();
        String string = driverProperty.getName() + n++;
        while (this.fDriverData.getProperty(string, driverProperty.getGroup().getName()) != null) {
            string = driverProperty.getName() + n++;
        }
        DriverProperty driverProperty2 = (DriverProperty)driverProperty.clone();
        driverProperty2.setName(string);
        MIDNode mIDNode2 = new MIDNode(string, this, mIDNode.getType(), driverProperty2);
        this.fDriverData.add(driverProperty2);
        return mIDNode2;
    }

    private MIDNode duplicateFunctionNode(MIDNode mIDNode) {
        int n = 1;
        DriverFunction driverFunction = (DriverFunction)mIDNode.getUserData();
        String string = driverFunction.getName() + n++;
        while (this.fDriverData.getFunction(string, driverFunction.getGroup()) != null) {
            string = driverFunction.getName() + n++;
        }
        DriverFunction driverFunction2 = (DriverFunction)driverFunction.clone();
        driverFunction2.setName(string);
        MIDNode mIDNode2 = new MIDNode(string, this, mIDNode.getType(), driverFunction2);
        this.fDriverData.add(driverFunction2);
        return mIDNode2;
    }

    public void remove(MIDNode mIDNode) {
        if (mIDNode == null || mIDNode.getUserData() == null) {
            return;
        }
        switch (mIDNode.getType()) {
            case 5: {
                this.fDriverData.remove((DriverProperty)mIDNode.getUserData());
                break;
            }
            case 6: {
                this.fDriverData.remove((DriverFunction)mIDNode.getUserData());
                break;
            }
            case 4: {
                DriverGroup driverGroup = (DriverGroup)mIDNode.getUserData();
                if (driverGroup.getProperties().isEmpty() && driverGroup.getFunctions().isEmpty()) {
                    this.fDriverData.remove(driverGroup);
                    break;
                }
                int n = MJOptionPane.showConfirmDialog((Component)this.tool.getBrowser().getFrame(), (Object)("The " + driverGroup.getName() + " group contains properties and/or functions\n that will also be deleted." + "  Continue with group deletion?"), (String)"Delete Group", (int)0, (int)3);
                if (n != 0) break;
                this.fDriverData.remove(driverGroup);
                break;
            }
            default: {
                return;
            }
        }
    }

    public void remove(DriverProperty driverProperty) {
        MIDNode mIDNode = this.fGroupPropertyListNodes.get(driverProperty.getGroup().getName());
        MIDNode mIDNode2 = null;
        String string = driverProperty.getName();
        for (int i = 0; i < mIDNode.getChildCount() && ((DriverProperty)(mIDNode2 = (MIDNode)((Object)mIDNode.getChildAt(i))).getUserData()).getName().compareTo(string) != 0; ++i) {
        }
        if (mIDNode2 != null) {
            this.postNodeRemovedEvent(mIDNode, mIDNode2);
        }
    }

    public void remove(DriverFunction driverFunction) {
        MIDNode mIDNode = this.fGroupFunctionListNodes.get(driverFunction.getGroup().getName());
        MIDNode mIDNode2 = null;
        String string = driverFunction.getName();
        for (int i = 0; !(i >= mIDNode.getChildCount() || (mIDNode2 = (MIDNode)((Object)mIDNode.getChildAt(i))).getUserData() instanceof DriverFunction && ((DriverFunction)mIDNode2.getUserData()).getName().compareTo(string) == 0); ++i) {
        }
        if (mIDNode2 != null) {
            this.postNodeRemovedEvent(mIDNode, mIDNode2);
        }
    }

    public void remove(DriverGroup driverGroup) {
        MIDNode mIDNode = this.fGroupNodes.get(driverGroup.getName());
        if (mIDNode != null) {
            this.postNodeRemovedEvent(this.fGroupListNode, mIDNode);
        }
        this.fGroupNodes.remove(driverGroup.getName());
        this.fGroupPropertyListNodes.remove(driverGroup.getName());
        this.fGroupFunctionListNodes.remove(driverGroup.getName());
    }

    private void propertyNodeNameChanged(BrowserTreeNode browserTreeNode) {
        if (browserTreeNode == null) {
            return;
        }
        DriverProperty driverProperty = (DriverProperty)browserTreeNode.getUserData();
        String string = (String)browserTreeNode.getUserObject();
        if (!driverProperty.getName().equals(string) && driverProperty.getName().equalsIgnoreCase(string)) {
            driverProperty.setName(new String(string));
        } else if (this.isValidPropertyName(string, driverProperty.getGroup(), true)) {
            this.sortNode(browserTreeNode, true);
            driverProperty.setName(new String(string));
        } else {
            browserTreeNode.setUserObject((Object)new String(driverProperty.getName()));
            this.postNodeUpdatedEvent(browserTreeNode);
        }
    }

    private void functionNodeNameChanged(BrowserTreeNode browserTreeNode) {
        if (browserTreeNode == null) {
            return;
        }
        DriverFunction driverFunction = (DriverFunction)browserTreeNode.getUserData();
        String string = (String)browserTreeNode.getUserObject();
        if (this.isValidFunctionName(string, driverFunction.getGroup(), true)) {
            this.sortNode(browserTreeNode, true);
            driverFunction.setName(new String(string));
        } else {
            browserTreeNode.setUserObject((Object)new String(driverFunction.getName()));
            this.postNodeUpdatedEvent(browserTreeNode);
        }
    }

    private void groupNodeNameChanged(BrowserTreeNode browserTreeNode) {
        if (browserTreeNode == null) {
            return;
        }
        DriverGroup driverGroup = (DriverGroup)browserTreeNode.getUserData();
        String string = (String)browserTreeNode.getUserObject();
        if (driverGroup.getName().equalsIgnoreCase(string)) {
            driverGroup.setName(string);
            return;
        }
        if (this.isValidGroupName(string, true)) {
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            if (this.tool.getTreeView().isExpanded(new TreePath(browserTreeNode.getPath()))) {
                bl = true;
            }
            if (this.tool.getTreeView().isExpanded(new TreePath(((DefaultMutableTreeNode)browserTreeNode.getChildAt(0)).getPath()))) {
                bl2 = true;
            }
            if (this.tool.getTreeView().isExpanded(new TreePath(((DefaultMutableTreeNode)browserTreeNode.getChildAt(1)).getPath()))) {
                bl3 = true;
            }
            this.sortNode(browserTreeNode, true);
            if (bl) {
                this.tool.getTreeView().expandPath(new TreePath(browserTreeNode.getPath()));
            }
            if (bl2) {
                this.tool.getTreeView().expandPath(new TreePath(((DefaultMutableTreeNode)browserTreeNode.getChildAt(0)).getPath()));
            }
            if (bl3) {
                this.tool.getTreeView().expandPath(new TreePath(((DefaultMutableTreeNode)browserTreeNode.getChildAt(1)).getPath()));
            }
            driverGroup.setName(new String(string));
        } else {
            browserTreeNode.setUserObject((Object)new String(driverGroup.getName()));
            this.postNodeUpdatedEvent(browserTreeNode);
        }
    }

    private void sortNode(BrowserTreeNode browserTreeNode, boolean bl) {
        if (browserTreeNode == null) {
            return;
        }
        BrowserTreeNode browserTreeNode2 = (BrowserTreeNode)browserTreeNode.getParent();
        if (browserTreeNode2 == null) {
            return;
        }
        int n = browserTreeNode2.getChildCount();
        String string = (String)browserTreeNode.getUserObject();
        this.postNodeRemovedEvent(browserTreeNode);
        int n2 = n;
        for (int i = 0; i < n - 1; ++i) {
            String string2 = (String)((DefaultMutableTreeNode)browserTreeNode2.getChildAt(i)).getUserObject();
            if (string.compareToIgnoreCase(string2) > 0) continue;
            n2 = i;
            break;
        }
        this.postNodeAddedEvent(browserTreeNode2, browserTreeNode, bl, n2);
    }

    public JPanel getPanel(BrowserTreeNode browserTreeNode, BrowserTreeNode browserTreeNode2, BrowserTreeNode[] browserTreeNodeArray) {
        if (browserTreeNode == browserTreeNode2) {
            return this.lastSelectedPanel;
        }
        if (browserTreeNode2 != browserTreeNode) {
            if (this.lastSelectedNode != null && this.lastSelectedPanel != null) {
                this.lastSelectedPanel.updateNode(this.lastSelectedNode);
            }
            this.lastSelectedNode = (MIDNode)browserTreeNode;
            this.lastSelectedPanel = this.treeNodePanels[this.lastSelectedNode.getType()];
            this.lastSelectedPanel.updatePanel(this.lastSelectedNode);
        }
        return this.lastSelectedPanel;
    }

    public void addToolbarButtons(MJToolBar mJToolBar) {
        mJToolBar.setBorder(null);
        this.tool.addToolbarButtons(mJToolBar);
    }

    public JMenu[] getMenus() {
        return this.tool.getMenus();
    }

    public boolean defineRightClickMenuItems(BrowserTreeNode browserTreeNode, JPopupMenu jPopupMenu) {
        if (browserTreeNode == null) {
            return false;
        }
        MIDNode mIDNode = (MIDNode)browserTreeNode;
        this.fAddGroupMenu.putClientProperty((Object)"ActualSelectedNode", (Object)browserTreeNode);
        this.fAddPropertyMenu.putClientProperty((Object)"ActualSelectedNode", (Object)browserTreeNode);
        this.fAddFunctionMenu.putClientProperty((Object)"ActualSelectedNode", (Object)browserTreeNode);
        this.fRenameMenu.putClientProperty((Object)"ActualSelectedNode", (Object)browserTreeNode);
        this.fDuplicateMenu.putClientProperty((Object)"ActualSelectedNode", (Object)browserTreeNode);
        this.fDeleteMenu.putClientProperty((Object)"ActualSelectedNode", (Object)browserTreeNode);
        switch (mIDNode.getType()) {
            case 0: {
                jPopupMenu.add((JMenuItem)this.fAddGroupMenu);
                jPopupMenu.add((JMenuItem)this.fAddPropertyMenu);
                jPopupMenu.add((JMenuItem)this.fAddFunctionMenu);
                break;
            }
            case 1: {
                return false;
            }
            case 2: {
                return false;
            }
            case 3: {
                jPopupMenu.add((JMenuItem)this.fAddGroupMenu);
                break;
            }
            case 4: {
                jPopupMenu.add((JMenuItem)this.fAddPropertyMenu);
                jPopupMenu.add((JMenuItem)this.fAddFunctionMenu);
                break;
            }
            case 9: {
                jPopupMenu.add((JMenuItem)this.fAddPropertyMenu);
                break;
            }
            case 10: {
                jPopupMenu.add((JMenuItem)this.fAddFunctionMenu);
                break;
            }
            case 7: {
                jPopupMenu.add((JMenuItem)this.fAddPropertyMenu);
                break;
            }
            case 8: {
                jPopupMenu.add((JMenuItem)this.fAddFunctionMenu);
                break;
            }
            case 5: {
                break;
            }
        }
        if (mIDNode.isEditable()) {
            jPopupMenu.addSeparator();
            this.fRenameMenu.putClientProperty((Object)"ActualSelectedNode", (Object)browserTreeNode);
            jPopupMenu.add((JMenuItem)this.fRenameMenu);
        }
        if (mIDNode.isCloneable()) {
            if (!mIDNode.isEditable()) {
                jPopupMenu.addSeparator();
            }
            this.fDuplicateMenu.putClientProperty((Object)"ActualSelectedNode", (Object)browserTreeNode);
            jPopupMenu.add((JMenuItem)this.fDuplicateMenu);
        }
        if (mIDNode.isRemoveable()) {
            jPopupMenu.addSeparator();
            this.fDeleteMenu.putClientProperty((Object)"ActualSelectedNode", (Object)browserTreeNode);
            jPopupMenu.add((JMenuItem)this.fDeleteMenu);
        }
        return true;
    }

    public void nodeEditingStopped(ChangeEvent changeEvent, BrowserTreeNode browserTreeNode) {
        switch (browserTreeNode.getType()) {
            case 5: {
                this.propertyNodeNameChanged(browserTreeNode);
                break;
            }
            case 6: {
                this.functionNodeNameChanged(browserTreeNode);
                break;
            }
            case 4: {
                this.groupNodeNameChanged(browserTreeNode);
            }
        }
    }

    public ImageIcon getNodeIcon(BrowserTreeNode browserTreeNode) {
        return browserTreeNode.getIcon();
    }

    public BrowserTreeNode getRootNode() {
        return null;
    }

    public BrowserTreeNode[] getLevelOneNodes() {
        return null;
    }

    public String getToolboxVersion() {
        return null;
    }

    public String getToolboxName() {
        return "instrument";
    }

    public void nodeEditingCanceled(ChangeEvent changeEvent, BrowserTreeNode browserTreeNode) {
    }
}

