/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.device.drivers.xml;

import com.mathworks.toolbox.testmeas.util.TMException;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import java.util.Vector;

public class MethodDefinition {
    private String name;
    private String signature;
    private String capabilityGroup;
    private Vector<String> code = new Vector();
    private String mCodeToEvaluate;
    private Vector<String> output = new Vector();
    private Vector<String> inputs = new Vector();
    private Vector<String> outputFormat = new Vector();
    private Vector<String> readOutputAs = new Vector();
    private String description;
    private String location;
    private String methodType;

    public MethodDefinition(String string, String string2) {
        this.name = string;
        this.capabilityGroup = string2;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getCapabilityGroup() {
        return this.capabilityGroup;
    }

    public void setCapabilityGroup(String string) {
        this.capabilityGroup = string;
    }

    public void setMCodeToEvaluate(String string) {
        this.mCodeToEvaluate = string;
    }

    public String getMCodeToEvaluate() {
        return this.mCodeToEvaluate;
    }

    public void clearCode() {
        this.code.removeAllElements();
        this.output.removeAllElements();
        this.outputFormat.removeAllElements();
        this.readOutputAs.removeAllElements();
    }

    public void addLineOfCode(String string, String string2, String string3, String string4) {
        this.code.add(string);
        this.output.add(string2);
        this.outputFormat.add(string4);
        this.readOutputAs.add(string3);
    }

    public int getNumberOfCommands() {
        return this.code.size();
    }

    public int getNumberOfOutputCommands() {
        int n = 0;
        for (int i = 0; i < this.output.size(); ++i) {
            if (!this.hasOutput(i)) continue;
            ++n;
        }
        return n;
    }

    public boolean hasOutput(int n) {
        return this.output.elementAt(n).equals("true");
    }

    public String getOutputFormat(int n) {
        return this.outputFormat.elementAt(n);
    }

    public String getTypeOfOutputRead(int n) {
        return this.readOutputAs.elementAt(n);
    }

    public Vector<String> getRawCommands() {
        return this.code;
    }

    public void addInput(String string) {
        if (this.inputs == null) {
            this.inputs = new Vector();
        }
        this.inputs.addElement(string);
    }

    public Vector<String> getRawInputs() {
        return this.inputs;
    }

    public int getNumberOfInputs() {
        if (this.inputs == null) {
            return 0;
        }
        return this.inputs.size();
    }

    public void setLocation(String string) {
        this.location = string;
    }

    public String getLocation() {
        return this.location;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setType(String string) {
        this.methodType = string;
    }

    public String getType() {
        return this.methodType;
    }

    public String getCommand(int n, Object[] objectArray) throws TMException {
        return this.getCommand(this.code.elementAt(n), objectArray);
    }

    private String getCommand(String string, Object[] objectArray) {
        if (objectArray == null) {
            return string;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            String string2 = this.inputs.elementAt(i);
            Object object = objectArray[i];
            String string3 = "" + object + "";
            string = TMStringUtil.strrep((String)string, (String)("<" + string2 + ">"), (String)string3);
        }
        return string;
    }

    public String getSignature() {
        if (this.signature != null) {
            return this.signature;
        }
        this.signature = this.methodType.toLowerCase().equals("mcode") ? this.getInvokeCommandMCode() : this.getInvokeCommandInstrumentCommands();
        return this.signature;
    }

    public String getInvokeCommand() {
        if (this.methodType == null) {
            return "";
        }
        if (this.methodType.toLowerCase().equals("mcode")) {
            return this.getInvokeCommandMCode();
        }
        return this.getInvokeCommandInstrumentCommands();
    }

    private String getInvokeCommandMCode() {
        String string = "";
        int n = 0;
        int n2 = this.mCodeToEvaluate.indexOf(10, n);
        while (n2 != -1) {
            String string2 = this.mCodeToEvaluate.substring(n, n2);
            n = n2 + 1;
            n2 = this.mCodeToEvaluate.indexOf(10, n);
            if (!string2.startsWith("function")) continue;
            string = string2;
            n2 = -1;
        }
        if (string.equals("")) {
            return "";
        }
        string = TMStringUtil.strrep((String)string, (String)"function ", (String)"");
        int n3 = string.indexOf("=");
        String string3 = "";
        if (n3 != -1) {
            string3 = string.substring(0, n3 - 1);
            string3 = TMStringUtil.strrep((String)string3, (String)" ", (String)"");
            string3 = TMStringUtil.strrep((String)string3, (String)"[", (String)"");
            string3 = TMStringUtil.strrep((String)string3, (String)"]", (String)"");
            string = string.substring(n3);
        }
        int n4 = string.indexOf("(");
        String string4 = "";
        if (n4 != -1) {
            string4 = string.substring(n4 + 1, string.indexOf(")"));
            string4 = TMStringUtil.strrep((String)string4, (String)" ", (String)"");
            string = string.substring(0, n4);
        }
        String string5 = "";
        if (!string3.equals("")) {
            string5 = "[" + string3.toUpperCase() + "] = ";
        }
        string5 = string5 + "INVOKE(OBJ,'" + this.name + "'";
        int n5 = string4.indexOf(",");
        if (!(string4 = n5 == -1 ? "" : string4.substring(n5 + 1)).equals("")) {
            string5 = string5 + "," + string4.toUpperCase();
        }
        string5 = string5 + ")";
        return string5;
    }

    private String getInvokeCommandInstrumentCommands() {
        try {
            int n;
            String string = "INVOKE(OBJ, '" + this.name + "'";
            for (n = 0; n < this.inputs.size(); ++n) {
                string = string + ", " + this.inputs.elementAt(n).toUpperCase();
            }
            string = string + ");";
            n = 0;
            for (int i = 0; i < this.output.size(); ++i) {
                if (!this.output.elementAt(i).toLowerCase().equals("true")) continue;
                ++n;
            }
            if (n == 0) {
                return string;
            }
            String string2 = "[";
            for (int i = 0; i < n; ++i) {
                string2 = string2 + "OUT" + (i + 1) + ", ";
            }
            string2 = string2.substring(0, string2.length() - 2);
            string = string2 + "] = " + string;
            return string;
        }
        catch (Exception exception) {
            return "";
        }
    }
}

