/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.device.drivers.xml;

import com.mathworks.toolbox.instrument.device.drivers.xml.ParserErrorHandler;
import com.mathworks.toolbox.instrument.device.drivers.xml.SortableTreeNode;
import com.mathworks.toolbox.instrument.device.drivers.xml.XmlTreeElement;
import com.mathworks.toolbox.testmeas.util.TMException;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class IviCWrapperXMLParser {
    public DefaultMutableTreeNode parseString(String string) throws TMException {
        Object object;
        Document document = null;
        Node node = null;
        try {
            object = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = ((DocumentBuilderFactory)object).newDocumentBuilder();
            documentBuilder.setErrorHandler(new ParserErrorHandler());
            document = documentBuilder.parse(new ByteArrayInputStream(string.getBytes()));
            node = document.getFirstChild();
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (node == null) {
            TMStringUtil.error((String)"Failed to parse XML string.");
            return null;
        }
        object = null;
        try {
            object = this.getTreeFromDocument(document);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return object;
    }

    public DefaultMutableTreeNode parseFile(String string) throws TMException {
        Serializable serializable;
        Document document = null;
        Node node = null;
        try {
            serializable = new File(string);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setErrorHandler(new ParserErrorHandler());
            document = documentBuilder.parse((File)serializable);
            node = document.getFirstChild();
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (node == null) {
            TMStringUtil.error((String)("The MATLAB instrument driver file: " + string + " could not be parsed."));
            return null;
        }
        serializable = null;
        try {
            serializable = this.getTreeFromDocument(document);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return serializable;
    }

    private SortableTreeNode getTreeFromDocument(Document document) throws ParserConfigurationException, SAXException, IOException {
        SortableTreeNode sortableTreeNode = null;
        Node node = document.getFirstChild();
        while (node.getNodeType() != 1) {
            node = node.getNextSibling();
        }
        sortableTreeNode = this.processHierarchy(node);
        return sortableTreeNode;
    }

    private SortableTreeNode processHierarchy(Node node) {
        XmlTreeElement xmlTreeElement = new XmlTreeElement(node);
        SortableTreeNode sortableTreeNode = new SortableTreeNode(xmlTreeElement);
        SortableTreeNode sortableTreeNode2 = null;
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String string;
                if (nodeList.item(i).getNodeType() != 1 || (string = nodeList.item(i).getNodeName()).equalsIgnoreCase("description") || string.equalsIgnoreCase("inputArgs") || string.equalsIgnoreCase("outputArgs")) continue;
                sortableTreeNode2 = this.processHierarchy((Element)nodeList.item(i));
                sortableTreeNode.add(sortableTreeNode2);
            }
        }
        return sortableTreeNode;
    }
}

