/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.device.drivers.vxipnp.sub;

import com.mathworks.toolbox.instrument.device.drivers.vxipnp.sub.SubFileParser;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import java.util.Hashtable;
import java.util.Vector;

public class ValueSet {
    public static final int INTEGER = 0;
    public static final int REAL = 1;
    public static final int STRING = 2;
    private String name = "";
    private int dataType = 0;
    private boolean isHex = false;
    Vector<String> keys = new Vector();
    Hashtable<String, Comparable<?>> values = new Hashtable();
    Hashtable<String, String> help = new Hashtable();

    public static ValueSet initWithStringArray(String[] stringArray) {
        if (stringArray.length < 4) {
            return null;
        }
        ValueSet valueSet = new ValueSet();
        valueSet.setName(stringArray[1]);
        if (stringArray[1].toLowerCase().startsWith("x_")) {
            valueSet.setIsHex(true);
        }
        int n = 2;
        if (stringArray[2].startsWith("DataType")) {
            char c = stringArray[3].charAt(1);
            switch (c) {
                case 'i': {
                    valueSet.setDataType(0);
                    break;
                }
                case 'd': {
                    valueSet.setDataType(1);
                    break;
                }
                case 's': {
                    valueSet.setDataType(2);
                }
            }
            n = 4;
        }
        while (n < stringArray.length) {
            if (stringArray.length <= n + 1) {
                return valueSet;
            }
            String string = stringArray[n];
            String string2 = stringArray[n + 1];
            String string3 = "";
            if (stringArray.length > n + 2) {
                int n2 = 2;
                while (stringArray.length > n + n2 && stringArray[n + n2].startsWith("\"")) {
                    string3 = string3 + stringArray[n + n2++] + ' ';
                }
                n += n2;
            } else {
                n += 2;
            }
            valueSet.addConstantValue(string, string2, SubFileParser.formatHelpString(string3));
        }
        return valueSet;
    }

    public ValueSet() {
    }

    public ValueSet(String string, int n) {
        this();
        this.name = string;
        this.dataType = n;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public int getDataType() {
        return this.dataType;
    }

    public void setDataType(int n) {
        this.dataType = n;
    }

    public boolean isHex() {
        return this.isHex;
    }

    public void setIsHex(boolean bl) {
        this.isHex = bl;
    }

    public void addConstantValue(String string, String string2, String string3) {
        this.keys.add(string);
        this.help.put(string, string3);
        string2 = string2.replaceAll("[()]", "");
        switch (this.dataType) {
            case 0: {
                try {
                    if (string2.endsWith("L")) {
                        string2 = string2.substring(0, string2.length() - 1);
                    }
                    Double d = Double.valueOf(string2);
                    this.values.put(string, new Integer(d.intValue()));
                }
                catch (NumberFormatException numberFormatException) {
                    TMStringUtil.warning((String)("Can not parse number " + string2 + "'s value"));
                }
                break;
            }
            case 1: {
                this.values.put(string, Double.valueOf(string2));
                break;
            }
            case 2: {
                this.values.put(string, (Comparable<?>)((Object)string2));
            }
        }
    }
}

