/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.device.drivers.vxipnp.fp;

import com.mathworks.toolbox.instrument.device.drivers.vxipnp.fp.Argument;
import com.mathworks.toolbox.instrument.device.drivers.vxipnp.fp.FunctionPanel;
import com.mathworks.toolbox.testmeas.util.TMException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;

public class FunctionPanelParser {
    protected static final int sMagicNumber = 1946026426;
    protected String fileName;
    protected int majorVersion;
    protected int minorVersion;
    protected int functionTreeNodeOffset;
    protected int functionTreeNodeCount;
    protected int winInfoOffset;
    protected int userDataTypeCount;
    protected String driverPrefix;
    protected String driverName;
    protected Hashtable<String, FunctionPanel> fpFunctions = new Hashtable();
    protected Hashtable<Integer, String> userDataTypes = new Hashtable();
    protected Vector<String> windowGroup = new Vector();
    protected RandomAccessFile stream;
    private static Hashtable<String, String> sVendorLookup = null;
    private static Hashtable<Integer, String> sStandardDataTypes = null;
    protected static final int kClassNode = 1;
    protected static final int kFunctionPanelWindowNode = 2;

    public FunctionPanelParser(String string) throws FileNotFoundException {
        if (sStandardDataTypes == null) {
            this.loadStandardDataTypes();
        }
        this.fileName = string;
        this.stream = new RandomAccessFile(this.fileName, "r");
    }

    public void parse() throws IOException, TMException {
        int n = this.stream.readInt();
        if (n != 1946026426) {
            throw new TMException("The file does not appear to be a VXIplug&play or IVI-C functional panel file.");
        }
        this.majorVersion = this.stream.readInt();
        if (this.majorVersion == 4) {
            this.readVersion4FcnTreeHeader();
        } else {
            this.readVersion5FcnTreeHeader();
        }
        this.readUserDataTypes();
        this.readTreeNodes();
        this.stream.seek(this.winInfoOffset);
        for (int i = 0; i < this.windowGroup.size(); ++i) {
            this.readWindow(this.windowGroup.get(i));
        }
    }

    public String getDriverName() {
        return this.driverName;
    }

    public String getPrefix() {
        return this.driverPrefix;
    }

    public String getVendorName() {
        return FunctionPanelParser.identifyVendor(this.getVendorAbbreviation());
    }

    public String getVendorAbbreviation() {
        if (this.driverPrefix.length() > 1) {
            return this.driverPrefix.substring(0, 2).toLowerCase();
        }
        return "xx";
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public Hashtable<String, FunctionPanel> getFunctionPanels() {
        return this.fpFunctions;
    }

    private void readVersion4FcnTreeHeader() throws IOException {
        this.stream.skipBytes(4);
        this.functionTreeNodeOffset = this.stream.readInt();
        this.functionTreeNodeCount = this.stream.readInt();
        this.winInfoOffset = this.stream.readInt();
        this.stream.skipBytes(4);
        this.stream.skipBytes(4);
        this.userDataTypeCount = this.stream.readInt();
        this.stream.skipBytes(4);
        this.stream.skipBytes(24);
        this.minorVersion = this.stream.readShort();
        this.stream.skipBytes(2);
        this.stream.skipBytes(1);
        this.stream.skipBytes(3);
        this.driverPrefix = this.readString(8);
        this.stream.skipBytes(1);
        this.stream.skipBytes(3);
        this.driverName = this.readString(40);
        this.stream.skipBytes(1);
        this.stream.skipBytes(3);
    }

    private void readVersion5FcnTreeHeader() throws IOException {
        this.stream.skipBytes(4);
        this.functionTreeNodeOffset = this.stream.readInt();
        this.functionTreeNodeCount = this.stream.readInt();
        this.winInfoOffset = this.stream.readInt();
        this.stream.skipBytes(4);
        this.stream.skipBytes(4);
        this.userDataTypeCount = this.stream.readInt();
        this.stream.skipBytes(4);
        this.stream.skipBytes(24);
        this.minorVersion = this.stream.readShort();
        this.stream.skipBytes(2);
        this.stream.skipBytes(1);
        this.stream.skipBytes(3);
        this.driverPrefix = this.readString(31);
        this.stream.skipBytes(1);
        this.driverName = this.readString(40);
        this.stream.skipBytes(1);
        this.stream.skipBytes(3);
        this.stream.skipBytes(55);
        this.stream.skipBytes(1);
    }

    private void readUserDataTypes() throws IOException {
        for (int i = 0; i < this.userDataTypeCount; ++i) {
            this.stream.skipBytes(2);
            this.stream.skipBytes(2);
            short s = this.stream.readShort();
            short s2 = this.stream.readShort();
            this.stream.skipBytes(2);
            this.stream.skipBytes(2);
            String string = this.readString(s);
            if (s2 <= 999) continue;
            this.userDataTypes.put(new Integer(s2), string);
        }
    }

    private void readTreeNodes() throws IOException {
        Stack<String> stack = new Stack<String>();
        this.stream.seek(this.functionTreeNodeOffset);
        stack.push("parent");
        block4: for (int i = 0; i < this.functionTreeNodeCount; ++i) {
            int n = this.stream.readUnsignedByte();
            byte by = this.stream.readByte();
            this.stream.skipBytes(1);
            this.stream.skipBytes(1);
            this.stream.skipBytes(4);
            String string = this.majorVersion == 4 ? this.readString(31) : this.readString(79);
            this.stream.skipBytes(1);
            if ((n == 1 || n == 2) && by < stack.size()) {
                int n2 = stack.size() - by;
                for (int j = 0; j < n2; ++j) {
                    if (stack.empty()) {
                        throw new IOException("Could not parse " + this.fileName);
                    }
                    stack.pop();
                }
            }
            switch (n) {
                case 1: {
                    if (string.equalsIgnoreCase("configure functions") || string.equalsIgnoreCase("query functions") || string.equalsIgnoreCase("configure functions") || string.equalsIgnoreCase("query functions")) continue block4;
                    stack.push(string);
                    continue block4;
                }
                case 2: {
                    this.windowGroup.add(this.getCompleteGroupName(stack));
                }
            }
        }
    }

    private String getCompleteGroupName(Stack<String> stack) {
        String string = "";
        Object[] objectArray = stack.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            string = string + objectArray[i].toString();
        }
        if (string.equalsIgnoreCase("parent")) {
            return "parent";
        }
        if (string.startsWith("parent")) {
            string = string.substring(6);
        }
        return string;
    }

    private void readWindow(String string) throws IOException {
        this.stream.skipBytes(4);
        this.stream.skipBytes(2);
        this.stream.skipBytes(2);
        int n = this.stream.readShort();
        this.stream.skipBytes(2);
        if (this.majorVersion == 4) {
            for (int i = 0; i < n; ++i) {
                this.readVersion4FcnPanel(string);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                this.readVersion5FcnPanel(string);
            }
        }
    }

    private void readVersion4FcnPanel(String string) throws IOException {
        int n = this.stream.readInt();
        String string2 = this.readHelpText(n);
        int n2 = this.stream.readInt();
        short s = this.stream.readShort();
        this.stream.skipBytes(2);
        this.stream.skipBytes(2);
        this.stream.skipBytes(2);
        this.stream.skipBytes(2);
        this.stream.skipBytes(2);
        this.stream.skipBytes(1);
        this.stream.skipBytes(1);
        this.stream.skipBytes(1);
        this.stream.skipBytes(1);
        String string3 = this.readString(31);
        this.stream.skipBytes(1);
        FunctionPanel functionPanel = new FunctionPanel(string3, string, this.driverPrefix);
        functionPanel.setHelpText(string2);
        this.readControls(functionPanel, n2, s);
        this.addFunction(functionPanel);
    }

    private void readVersion5FcnPanel(String string) throws IOException {
        int n = this.stream.readInt();
        String string2 = this.readHelpText(n);
        int n2 = this.stream.readInt();
        this.stream.skipBytes(4);
        this.stream.skipBytes(4);
        short s = this.stream.readShort();
        this.stream.skipBytes(2);
        this.stream.skipBytes(2);
        this.stream.skipBytes(2);
        this.stream.skipBytes(2);
        this.stream.skipBytes(2);
        this.stream.skipBytes(2);
        this.stream.skipBytes(2);
        this.stream.skipBytes(1);
        this.stream.skipBytes(1);
        this.stream.skipBytes(1);
        this.stream.skipBytes(1);
        String string3 = this.readString(79);
        this.stream.skipBytes(1);
        this.stream.skipBytes(55);
        this.stream.skipBytes(1);
        FunctionPanel functionPanel = new FunctionPanel(string3, string, this.driverPrefix);
        functionPanel.setHelpText(string2);
        this.readControls(functionPanel, n2, s);
        this.addFunction(functionPanel);
    }

    private void readControls(FunctionPanel functionPanel, int n, int n2) throws IOException {
        int n3;
        Argument[] argumentArray = new Argument[n2];
        long l = this.stream.getFilePointer();
        this.stream.seek(n);
        for (n3 = 0; n3 < n2; ++n3) {
            int n4 = this.stream.readInt();
            this.readHelpText(n4);
            this.stream.skipBytes(2);
            this.stream.skipBytes(2);
            short s = this.stream.readShort();
            int n5 = this.stream.readUnsignedShort();
            int n6 = this.stream.readUnsignedByte();
            byte by = this.stream.readByte();
            this.stream.skipBytes(2);
            this.stream.skipBytes(4);
            String string = this.readString(31);
            this.stream.skipBytes(1);
            if (n6 != 8) {
                String string2 = this.userDataTypes.get(new Integer(n5));
                if (string2 == null) {
                    string2 = sStandardDataTypes.get(new Integer(n5));
                }
                argumentArray[n3] = new Argument(string, n6, string2);
                argumentArray[n3].setPosition(s);
                argumentArray[n3].setRingType(by);
                functionPanel.setArgument(argumentArray[n3]);
                continue;
            }
            argumentArray[n3] = new Argument("Dummy", 8, "ViChar[]");
        }
        for (n3 = 0; n3 < n2; ++n3) {
            this.readControlType(argumentArray[n3]);
        }
        this.stream.seek(l);
    }

    public void readControlType(Argument argument) throws IOException {
        int n = argument.getType();
        int n2 = argument.getRingType();
        switch (n) {
            case 1: {
                int n3 = this.stream.readInt();
                this.readString(n3 - 1);
                this.stream.skipBytes(1);
                break;
            }
            case 2: {
                int n4 = this.stream.readInt();
                this.stream.skipBytes(4);
                this.stream.readByte();
                this.stream.skipBytes(3);
                this.readString(n4 - 8 - 1);
                this.stream.skipBytes(1);
                break;
            }
            case 3: {
                switch (n2) {
                    case 1: {
                        this.stream.skipBytes(4);
                        this.stream.readInt();
                        this.stream.readInt();
                        int n5 = this.stream.readInt();
                        this.readString(n5 - 1);
                        this.stream.skipBytes(1);
                        break;
                    }
                    case 2: {
                        int n6 = this.stream.readInt();
                        int n7 = this.stream.readInt();
                        int n8 = this.stream.readInt();
                        int n9 = this.stream.readInt();
                        argument.setIncrement(n6);
                        argument.setMaxValue(n7);
                        argument.setMinValue(n8);
                        argument.setDefaultNumericValue(n9);
                        this.stream.skipBytes(4);
                        this.stream.readByte();
                        this.stream.skipBytes(3);
                        break;
                    }
                    case 3: {
                        double d = this.stream.readDouble();
                        double d2 = this.stream.readDouble();
                        double d3 = this.stream.readDouble();
                        double d4 = this.stream.readDouble();
                        argument.setIncrement(d);
                        argument.setMaxValue(d2);
                        argument.setMinValue(d3);
                        argument.setDefaultNumericValue(d4);
                        this.stream.skipBytes(8);
                        this.stream.readByte();
                        this.stream.readByte();
                        this.stream.skipBytes(2);
                    }
                }
                break;
            }
            case 4: {
                short s = this.stream.readShort();
                this.stream.skipBytes(1);
                byte by = this.stream.readByte();
                this.readString(s - 1);
                this.stream.skipBytes(1);
                break;
            }
            case 5: {
                this.stream.skipBytes(4);
                this.stream.readInt();
                this.stream.readInt();
                int n10 = this.stream.readInt();
                this.readString(n10 - 1);
                this.stream.skipBytes(1);
                break;
            }
            case 6: {
                int n11 = this.stream.readInt();
                this.stream.skipBytes(4);
                this.stream.skipBytes(1);
                this.stream.skipBytes(3);
                this.stream.skipBytes(1);
                break;
            }
            case 7: {
                int n12 = this.stream.readInt();
                this.stream.skipBytes(4);
                this.stream.readByte();
                this.stream.skipBytes(3);
                this.readString(n12 - 8 - 1);
                this.stream.skipBytes(1);
                break;
            }
            case 8: {
                int n13 = this.stream.readInt();
                this.readString(n13 - 1);
                this.stream.skipBytes(1);
            }
        }
    }

    private String readHelpText(int n) throws IOException {
        if (n <= 0) {
            return "";
        }
        long l = this.stream.getFilePointer();
        this.stream.seek(n);
        int n2 = this.stream.readInt();
        this.stream.skipBytes(4);
        byte[] byArray = new byte[n2];
        this.stream.read(byArray);
        this.stream.seek(l);
        return new String(byArray).substring(0, byArray.length - 2);
    }

    protected String readString(int n) throws IOException {
        byte[] byArray = new byte[n];
        this.stream.read(byArray);
        return new String(byArray).trim();
    }

    protected void addFunction(FunctionPanel functionPanel) {
        if (functionPanel.getName().length() == 0) {
            return;
        }
        this.fpFunctions.put(functionPanel.getName(), functionPanel);
    }

    public static String identifyVendor(String string) {
        String string2;
        if (sVendorLookup == null) {
            FunctionPanelParser.loadVendors();
        }
        if ((string2 = sVendorLookup.get(string.toUpperCase())) == null) {
            string2 = "Unknown";
        }
        return string2;
    }

    private static void loadVendors() {
        sVendorLookup = new Hashtable();
        sVendorLookup.put("AQ", "Acquiris");
        sVendorLookup.put("AV", "Advantest Corporation");
        sVendorLookup.put("AF", "Aeroflex Laboratories");
        sVendorLookup.put("AG", "Agilent Technologies");
        sVendorLookup.put("AI", "AIM GmbH");
        sVendorLookup.put("AM", "AMP Incorporated");
        sVendorLookup.put("AN", "Analogic, Corp.");
        sVendorLookup.put("AD", "Ando Electric Company Limited");
        sVendorLookup.put("AU", "Anritsu Company");
        sVendorLookup.put("AO", "AOIP Instrumentation");
        sVendorLookup.put("AS", "ASCOR Incorporated");
        sVendorLookup.put("AP", "Audio Precision, Inc");
        sVendorLookup.put("BB", "B&B Technologies");
        sVendorLookup.put("BA", "BAE Systems");
        sVendorLookup.put("BK", "Bruel & Kjaer");
        sVendorLookup.put("BU", "Bustec Production Ltd.");
        sVendorLookup.put("CA", "CAL-AV Labs, Inc.");
        sVendorLookup.put("CH", "C&H Technologies, Inc.");
        sVendorLookup.put("CC", "Compressor Controls Corporation");
        sVendorLookup.put("CY", "CYTEC Corporation");
        sVendorLookup.put("DP", "Directed Perceptions, Inc.");
        sVendorLookup.put("DS", "DSP Technology, Inc.");
        sVendorLookup.put("EI", "EIP Microwave, Inc.");
        sVendorLookup.put("FL", "Fluke Company, Inc.");
        sVendorLookup.put("GR", "GenRad");
        sVendorLookup.put("GT", "Giga-tronics, Inc.");
        sVendorLookup.put("GN", "gnubi communications, Inc.");
        sVendorLookup.put("HP", "Hewlett-Packard Company");
        sVendorLookup.put("IF", "IFR");
        sVendorLookup.put("IE", "Instrumentation Engineering, Inc.");
        sVendorLookup.put("IC", "Integrated Control systems");
        sVendorLookup.put("KE", "Keithley Instruments");
        sVendorLookup.put("KP", "Kepco, Inc.");
        sVendorLookup.put("KI", "Kikusui");
        sVendorLookup.put("KS", "KineticSystems, Corp.");
        sVendorLookup.put("MP", "MAC Panel Company");
        sVendorLookup.put("MT", "ManTech Test Systems");
        sVendorLookup.put("MI", "Marconi Instruments");
        sVendorLookup.put("MS", "Microscan");
        sVendorLookup.put("NI", "National Instruments Corp.");
        sVendorLookup.put("NT", "NEUTRIK AG");
        sVendorLookup.put("NH", "NH Research");
        sVendorLookup.put("NA", "North Atlantic Instruments");
        sVendorLookup.put("PM", "Phase Metrics");
        sVendorLookup.put("PI", "Pickering Interfaces");
        sVendorLookup.put("PT", "Power-Tek Inc.");
        sVendorLookup.put("RI", "Racal Instruments, Inc.");
        sVendorLookup.put("RA", "Radisys Corp.");
        sVendorLookup.put("RS", "Rohde & Schwarz GmbH");
        sVendorLookup.put("SL", "Schlumberger Technologies");
        sVendorLookup.put("SC", "Scicom");
        sVendorLookup.put("SR", "Scientific Research Corporation");
        sVendorLookup.put("SU", "Serendipity Systems, Inc.");
        sVendorLookup.put("ST", "sont/Tektronix Corporation");
        sVendorLookup.put("SS", "Spectrum Signal Processing, Inc.");
        sVendorLookup.put("TA", "Talon Instruments");
        sVendorLookup.put("TK", "Tektronix, Inc.");
        sVendorLookup.put("TE", "Teradyne");
        sVendorLookup.put("TM", "Transmagnetics, Inc.");
        sVendorLookup.put("TT", "TTI Testron, Inc.");
        sVendorLookup.put("VP", "Virginia Panel, Corp.");
        sVendorLookup.put("VT", "VXI Technology, Inc.");
        sVendorLookup.put("VA", "VXIbus Associates, Inc.");
        sVendorLookup.put("WT", "Wavetek Corp.");
        sVendorLookup.put("WG", "Wandal & Goltermann");
        sVendorLookup.put("XX", "Unknown");
        sVendorLookup.put("YK", "Yokogawa Electric Corporation");
    }

    private void loadStandardDataTypes() {
        sStandardDataTypes = new Hashtable();
        sStandardDataTypes.put(new Integer(0), "ViInt32");
        sStandardDataTypes.put(new Integer(1), "ViInt32");
        sStandardDataTypes.put(new Integer(2), "ViInt16");
        sStandardDataTypes.put(new Integer(3), "ViInt8");
        sStandardDataTypes.put(new Integer(4), "ViUInt32");
        sStandardDataTypes.put(new Integer(5), "ViUInt32");
        sStandardDataTypes.put(new Integer(6), "ViUInt16");
        sStandardDataTypes.put(new Integer(7), "ViUInt8");
        sStandardDataTypes.put(new Integer(8), "ViInt32[]");
        sStandardDataTypes.put(new Integer(9), "ViInt32[]");
        sStandardDataTypes.put(new Integer(10), "ViInt16[]");
        sStandardDataTypes.put(new Integer(11), "ViInt8[]");
        sStandardDataTypes.put(new Integer(12), "ViUInt32[]");
        sStandardDataTypes.put(new Integer(13), "ViUInt32[]");
        sStandardDataTypes.put(new Integer(14), "ViUInt16[]");
        sStandardDataTypes.put(new Integer(15), "ViUInt8[]");
        sStandardDataTypes.put(new Integer(16), "ViReal64");
        sStandardDataTypes.put(new Integer(17), "ViReal32");
        sStandardDataTypes.put(new Integer(18), "ViReal64[]");
        sStandardDataTypes.put(new Integer(19), "ViReal32[]");
        sStandardDataTypes.put(new Integer(20), "ViPChar");
        sStandardDataTypes.put(new Integer(21), "ViChar[]");
        sStandardDataTypes.put(new Integer(22), "ViInt64");
        sStandardDataTypes.put(new Integer(23), "ViInt64[]");
        sStandardDataTypes.put(new Integer(24), "ViUInt64");
        sStandardDataTypes.put(new Integer(25), "ViUInt64[]");
    }
}

