/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.browser.objects;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.types.MLArrayRef;
import com.mathworks.toolbox.instrument.Serial;
import com.mathworks.toolbox.instrument.browser.objects.BrowserObject;
import com.mathworks.toolbox.testmeas.util.TMException;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;

public class SerialObject
extends BrowserObject
implements Runnable {
    private static final String[] FLOWCONTROL = new String[]{"none", "hardware", "software"};
    private static final String[] PARITY = new String[]{"none", "odd", "even", "mark", "space"};
    private static final String[] STOPBITS = new String[]{"", "1", "2", "1.5"};
    private String port;
    private String visaPort;
    private int index;
    private int baudrate = 9600;
    private String dataBits = "8";
    private String dataTerminalReady = "on";
    private String flowControl = "none";
    private String parity = "none";
    private String requestToSend = "on";
    private String stopBits = "1";
    private MLArrayRef terminator = null;

    public SerialObject(String string, String string2, String string3, int n) {
        super(string2, string3);
        this.port = string;
        this.index = n;
        Matlab.whenMatlabReady((Runnable)this);
    }

    @Override
    public void run() {
        try {
            Object[] objectArray = new Object[]{new Integer(45), "LF"};
            this.terminator = (MLArrayRef)Matlab.mtFeval((String)"system_dependent", (Object[])objectArray, (int)1);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public String[] getHeadingInfoColumnOne() {
        String[] stringArray = new String[]{"Port: ", this.port, " ", " ", " ", " "};
        return stringArray;
    }

    @Override
    public String getDescriptiveText() {
        return this.port;
    }

    @Override
    public String getType() {
        return "serial";
    }

    public String getPort() {
        return this.port;
    }

    public String getVISAPort() {
        return this.visaPort;
    }

    public void setVISAPort(String string) {
        this.visaPort = string;
    }

    public int getIndex() {
        return this.index;
    }

    public int getBaudRate() {
        return this.baudrate;
    }

    public void setBaudRate(int n) {
        if (this.baudrate < 0) {
            return;
        }
        if (this.instrumentObject == null) {
            this.baudrate = n;
            return;
        }
        try {
            ((Serial)this.instrumentObject).setBaudRate(n);
            this.baudrate = n;
        }
        catch (TMException tMException) {
            TMStringUtil.error((String)"Error Setting BaudRate", (String)tMException.getMessage());
        }
    }

    public String getDataBits() {
        return this.dataBits;
    }

    public void setDataBits(String string) {
        this.dataBits = string;
        if (this.instrumentObject == null) {
            return;
        }
        try {
            ((Serial)this.instrumentObject).setDataBits(TMStringUtil.str2int((String)string));
        }
        catch (TMException tMException) {
            TMStringUtil.error((String)"Error Setting DataBits", (String)tMException.getMessage());
        }
    }

    public String getDataTerminalReady() {
        return this.dataTerminalReady;
    }

    public void setDataTerminalReady(String string) {
        this.dataTerminalReady = string;
        if (this.instrumentObject == null) {
            return;
        }
        try {
            ((Serial)this.instrumentObject).setDataTerminalReady(this.str2bool(this.dataTerminalReady));
        }
        catch (TMException tMException) {
            TMStringUtil.error((String)"Error Setting DataTerminalReady", (String)tMException.getMessage());
        }
    }

    public String getFlowControl() {
        return this.flowControl;
    }

    public void setFlowControl(String string) {
        this.flowControl = string;
        if (this.instrumentObject == null) {
            return;
        }
        try {
            ((Serial)this.instrumentObject).setFlowControl(this.getIndex(FLOWCONTROL, this.flowControl));
        }
        catch (Exception exception) {
            TMStringUtil.error((String)"Error Setting FlowControl", (String)exception.getMessage());
        }
    }

    public String getParity() {
        return this.parity;
    }

    public void setParity(String string) throws TMException {
        this.parity = string;
        if (this.instrumentObject == null) {
            return;
        }
        try {
            ((Serial)this.instrumentObject).setParity(this.getIndex(PARITY, this.parity));
        }
        catch (Exception exception) {
            TMStringUtil.error((String)"Error Setting Parity", (String)exception.getMessage());
        }
    }

    public String getRequestToSend() {
        return this.requestToSend;
    }

    public void setRequestToSend(String string) {
        this.requestToSend = string;
        if (this.instrumentObject == null) {
            return;
        }
        try {
            ((Serial)this.instrumentObject).setRequestToSend(this.str2bool(this.requestToSend));
        }
        catch (TMException tMException) {
            TMStringUtil.error((String)"Error Setting RequestToSend", (String)tMException.getMessage());
        }
    }

    public String getStopBits() {
        return this.stopBits;
    }

    public void setStopBits(String string) throws TMException {
        this.stopBits = string;
        if (this.instrumentObject == null) {
            return;
        }
        try {
            ((Serial)this.instrumentObject).setStopBits(this.getIndex(STOPBITS, this.stopBits));
        }
        catch (Exception exception) {
            TMStringUtil.error((String)"Error Setting StopBits", (String)exception.getMessage());
        }
    }

    public MLArrayRef getTerminator() {
        return this.terminator;
    }

    public void setTerminator(MLArrayRef mLArrayRef) {
        if (this.terminator != mLArrayRef) {
            this.terminator.dispose();
        }
        this.terminator = mLArrayRef;
        if (this.instrumentObject == null) {
            return;
        }
        try {
            ((Serial)this.instrumentObject).setTerminator(this.terminator);
        }
        catch (Exception exception) {
            TMStringUtil.error((String)"Error Setting Terminator", (String)exception.getMessage());
        }
    }
}

