/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.browser.deviceobj;

import com.mathworks.mwswing.MJFrame;
import com.mathworks.toolbox.instrument.browser.deviceobj.CommunicationTableContextMenu;
import com.mathworks.toolbox.instrument.browser.deviceobj.DeviceMCode;
import com.mathworks.toolbox.instrument.browser.deviceobj.DeviceMCodeBank;
import com.mathworks.toolbox.instrument.browser.deviceobj.DeviceObjectPageInfo;
import com.mathworks.toolbox.instrument.browser.deviceobj.DeviceObjectResultsExporter;
import com.mathworks.toolbox.instrument.browser.deviceobj.InvokeMCode;
import com.mathworks.toolbox.instrument.browser.deviceobj.ResultsMCode;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;

public class DeviceObjectCommunicationTable
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static Point POINT_ZERO = new Point(0, 0);
    private static final String[] columnNames = new String[]{"Function", "Object", "Input", "Output"};
    private JScrollPane scrollPane;
    private JTable table;
    private DeviceObjectTableModel model;
    private Object[][] data;
    private CommunicationTableContextMenu contextMenu = null;
    private Dimension tableDimension = new Dimension(0, 0);
    private Dimension scrollPaneDimension = new Dimension(0, 0);
    private Vector<DeviceMCode> allCode = new Vector();
    private DeviceMCodeBank codeBank = null;

    public DeviceObjectCommunicationTable() {
        this.layoutPanel();
        this.contextMenu = new CommunicationTableContextMenu(this);
        this.contextMenu.addContextMenu(this.table);
        this.contextMenu.cleanup(this);
    }

    public void cleanup(DeviceObjectPageInfo deviceObjectPageInfo) {
        this.contextMenu.cleanup(this);
        if (deviceObjectPageInfo != null) {
            deviceObjectPageInfo.setTableData(this.data);
        }
    }

    public void setup(DeviceObjectPageInfo deviceObjectPageInfo) {
        this.contextMenu.setup(this);
        this.setData(deviceObjectPageInfo.getTableData());
        this.allCode.removeAllElements();
        Vector vector = (Vector)this.codeBank.getCode().clone();
        for (int i = 0; i < vector.size(); ++i) {
            DeviceMCode deviceMCode = (DeviceMCode)vector.elementAt(i);
            if (!deviceMCode.isvalid() || deviceMCode.getType() == 3) continue;
            this.allCode.addElement(deviceMCode);
        }
    }

    private void layoutPanel() {
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)this.createTablePanel(), "Center");
    }

    private JScrollPane createTablePanel() {
        this.model = new DeviceObjectTableModel();
        this.table = new JTable(this.model);
        this.table.setName("Export Table");
        this.scrollPane = new JScrollPane(this.table);
        this.scrollPane.setPreferredSize(new Dimension(100, 100));
        this.scrollPane.getViewport().setScrollMode(0);
        JTableHeader jTableHeader = this.table.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        this.table.setSelectionMode(2);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(100);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(100);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(150);
        this.table.getColumnModel().getColumn(3).setPreferredWidth(150);
        return this.scrollPane;
    }

    public Object[][] getData() {
        return this.data;
    }

    public void setData(Object[][] objectArray) {
        this.data = objectArray;
        this.model.fireTableDataChanged();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JComponent jComponent = (JComponent)actionEvent.getSource();
        int n = (Integer)jComponent.getClientProperty("ACTION");
        switch (n) {
            case 0: {
                int[] nArray = this.table.getSelectedRows();
                if (nArray.length == 0) {
                    TMStringUtil.error((String)"Delete Error", (String)"To delete a row in the table, the row must be selected.");
                    return;
                }
                for (int i = nArray.length - 1; i >= 0; --i) {
                    try {
                        this.deleteRow(nArray[i]);
                        continue;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        System.out.println(arrayIndexOutOfBoundsException.getMessage());
                    }
                }
                this.table.getSelectionModel().clearSelection();
                break;
            }
            case 1: {
                this.deleteAllRows();
                this.table.getSelectionModel().clearSelection();
                break;
            }
            case 2: {
                int[] nArray = this.table.getSelectedRows();
                if (nArray.length == 0) {
                    TMStringUtil.error((String)"Export Error", (String)"To export a row's data from the table, the row must be selected.");
                    return;
                }
                ResultsMCode[] resultsMCodeArray = new ResultsMCode[nArray.length];
                for (int i = 0; i < resultsMCodeArray.length; ++i) {
                    resultsMCodeArray[i] = (ResultsMCode)this.allCode.elementAt(nArray[i]);
                }
                MJFrame mJFrame = (MJFrame)SwingUtilities.windowForComponent(this);
                new DeviceObjectResultsExporter(resultsMCodeArray).showAsDialog(mJFrame);
            }
        }
    }

    public void setCodeBank(DeviceMCodeBank deviceMCodeBank) {
        this.codeBank = deviceMCodeBank;
    }

    public void appendData(Object[] objectArray, DeviceMCode deviceMCode) {
        this.model.append(objectArray);
        this.allCode.addElement(deviceMCode);
        this.codeBank.addCode(deviceMCode);
        this.tableDimension = this.table.getSize(this.tableDimension);
        this.scrollPaneDimension = this.scrollPane.getSize(this.scrollPaneDimension);
        if (this.tableDimension.height + 34 >= this.scrollPaneDimension.height) {
            this.scrollPane.getViewport().setViewPosition(new Point(0, this.tableDimension.height + 5));
        } else {
            this.scrollPane.getViewport().setViewPosition(POINT_ZERO);
        }
    }

    public void deleteRow(int n) {
        this.model.remove(n);
        DeviceMCode deviceMCode = this.allCode.elementAt(n);
        if (deviceMCode instanceof ResultsMCode) {
            ResultsMCode resultsMCode = (ResultsMCode)deviceMCode;
            resultsMCode.setVariables(null);
            System.gc();
        }
        deviceMCode.setIsvalid(false);
        this.allCode.removeElementAt(n);
    }

    public boolean hasOutput(int n) {
        if (n >= this.allCode.size()) {
            return false;
        }
        DeviceMCode deviceMCode = this.allCode.elementAt(n);
        if (!(deviceMCode instanceof ResultsMCode)) {
            return false;
        }
        return ((ResultsMCode)deviceMCode).hasVariables();
    }

    public void deleteAllRows() {
        for (int i = 0; i < this.allCode.size(); ++i) {
            DeviceMCode deviceMCode = this.allCode.elementAt(i);
            deviceMCode.setIsvalid(false);
            if (!(deviceMCode instanceof ResultsMCode)) continue;
            ResultsMCode resultsMCode = (ResultsMCode)deviceMCode;
            resultsMCode.setVariables(null);
            System.gc();
        }
        this.data = null;
        this.model.fireTableDataChanged();
        this.allCode.removeAllElements();
    }

    public InvokeMCode getLastInvokeMCode() {
        return this.codeBank.getLastInvokeMCode();
    }

    public String generateCode() {
        return this.codeBank.generateCode();
    }

    public void exportHistoryTable(MJFrame mJFrame) {
        int n = 0;
        for (int i = 0; i < this.allCode.size(); ++i) {
            if (!(this.allCode.elementAt(i) instanceof ResultsMCode) || !((ResultsMCode)this.allCode.elementAt(i)).hasVariables()) continue;
            ++n;
        }
        ResultsMCode[] resultsMCodeArray = new ResultsMCode[n];
        n = 0;
        for (int i = 0; i < this.allCode.size(); ++i) {
            if (!(this.allCode.elementAt(i) instanceof ResultsMCode) || !((ResultsMCode)this.allCode.elementAt(i)).hasVariables()) continue;
            resultsMCodeArray[n++] = (ResultsMCode)this.allCode.elementAt(i);
        }
        new DeviceObjectResultsExporter(resultsMCodeArray).showAsDialog(mJFrame);
    }

    static /* synthetic */ Object[][] access$102(DeviceObjectCommunicationTable deviceObjectCommunicationTable, Object[][] objectArray) {
        deviceObjectCommunicationTable.data = objectArray;
        return objectArray;
    }

    public class DeviceObjectTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        @Override
        public int getColumnCount() {
            return columnNames.length;
        }

        @Override
        public int getRowCount() {
            if (DeviceObjectCommunicationTable.this.data == null) {
                return 0;
            }
            return DeviceObjectCommunicationTable.this.data.length;
        }

        @Override
        public String getColumnName(int n) {
            return columnNames[n];
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return DeviceObjectCommunicationTable.this.data[n][n2];
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            ((DeviceObjectCommunicationTable)DeviceObjectCommunicationTable.this).data[n][n2] = object;
            this.fireTableCellUpdated(n, n2);
        }

        public Class<? extends Object> getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public void append(Object[] objectArray) {
            int n;
            int n2 = this.getRowCount() + 1;
            Object[][] objectArray2 = new Object[n2][this.getColumnCount()];
            if (DeviceObjectCommunicationTable.this.data != null) {
                for (n = 0; n < n2 - 1; ++n) {
                    for (int i = 0; i < this.getColumnCount(); ++i) {
                        objectArray2[n][i] = DeviceObjectCommunicationTable.this.data[n][i];
                    }
                }
            }
            for (n = 0; n < objectArray.length; ++n) {
                objectArray2[n2 - 1][n] = objectArray[n];
            }
            DeviceObjectCommunicationTable.access$102(DeviceObjectCommunicationTable.this, null);
            DeviceObjectCommunicationTable.access$102(DeviceObjectCommunicationTable.this, objectArray2);
            this.fireTableRowsInserted(n2 - 1, DeviceObjectCommunicationTable.this.data.length);
        }

        public void remove(int n) {
            int n2;
            int n3;
            int n4 = this.getRowCount() - 1;
            Object[][] objectArray = new Object[n4][this.getColumnCount()];
            for (n3 = 0; n3 < n; ++n3) {
                for (n2 = 0; n2 < this.getColumnCount(); ++n2) {
                    objectArray[n3][n2] = DeviceObjectCommunicationTable.this.data[n3][n2];
                }
            }
            for (n3 = n; n3 < n4; ++n3) {
                for (n2 = 0; n2 < this.getColumnCount(); ++n2) {
                    objectArray[n3][n2] = DeviceObjectCommunicationTable.this.data[n3 + 1][n2];
                }
            }
            DeviceObjectCommunicationTable.access$102(DeviceObjectCommunicationTable.this, null);
            DeviceObjectCommunicationTable.access$102(DeviceObjectCommunicationTable.this, objectArray);
            this.fireTableRowsInserted(n4 - 1, DeviceObjectCommunicationTable.this.data.length);
        }
    }
}

