/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.instrument.browser.deviceobj;

import com.mathworks.jmi.types.MLArrayRef;
import com.mathworks.toolbox.instrument.Instrument;
import com.mathworks.toolbox.instrument.PropertyChangedListener;
import com.mathworks.toolbox.instrument.browser.deviceobj.DeviceMCode;
import com.mathworks.toolbox.instrument.browser.deviceobj.InvokeMCode;
import com.mathworks.toolbox.instrument.device.drivers.mwid.MWIDDriver;
import com.mathworks.toolbox.instrument.device.icdevice.ICDevice;
import com.mathworks.toolbox.testmeas.util.TMStringUtil;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Vector;

public class DeviceMCodeBank
implements PropertyChangedListener {
    private static final String TAB = "    ";
    private ICDevice deviceObject;
    private Instrument instrument;
    private Vector<DeviceMCode> allCode = new Vector();
    private int lastType = -1;
    private boolean isConnected = false;

    public DeviceMCodeBank(ICDevice iCDevice, Instrument instrument) {
        this.deviceObject = iCDevice;
        this.instrument = instrument;
    }

    public void setup() {
        Instrument.addPropertyChangedListener(this);
    }

    public void cleanup() {
        Instrument.removePropertyChangedListener(this);
    }

    public void addCode(DeviceMCode deviceMCode) {
        this.allCode.addElement(deviceMCode);
    }

    public Vector<DeviceMCode> getCode() {
        return this.allCode;
    }

    public InvokeMCode getLastInvokeMCode() {
        for (int i = this.allCode.size() - 1; i >= 0; --i) {
            if (!(this.allCode.elementAt(i) instanceof InvokeMCode)) continue;
            return (InvokeMCode)this.allCode.elementAt(i);
        }
        return null;
    }

    public void createFile(String string, String string2) {
        try {
            String string3 = this.getComments(string2);
            String string4 = this.generateCode();
            String string5 = this.getCleanupCode();
            String string6 = string3 + "\n\n" + string4 + "\n" + string5;
            File file = new File(string);
            file.delete();
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
            randomAccessFile.writeBytes(string6 + "\n");
            randomAccessFile.close();
        }
        catch (IOException iOException) {
            System.out.println("Exception: " + iOException.getMessage());
        }
    }

    public String generateCode() {
        String string = this.generateConstructorCode() + "\n";
        this.lastType = -1;
        this.isConnected = false;
        for (int i = 0; i < this.allCode.size(); ++i) {
            DeviceMCode deviceMCode = this.allCode.elementAt(i);
            if (!deviceMCode.isvalid()) continue;
            switch (deviceMCode.getType()) {
                case 1: {
                    this.isConnected = true;
                    break;
                }
                case 2: {
                    this.isConnected = false;
                    break;
                }
                case 0: {
                    if (this.isConnected) break;
                    string = string + "\n" + "% Connect device object to hardware." + "\n";
                    string = string + "connect(deviceObj);" + "\n";
                    break;
                }
                case 4: {
                    if (this.isConnected && !deviceMCode.wasConnected()) {
                        string = string + "\n" + "% Disconnect device object from hardware." + "\n";
                        string = string + "disconnect(deviceObj);" + "\n";
                        break;
                    }
                    if (this.isConnected || !deviceMCode.wasConnected()) break;
                    string = string + "\n" + "% Connect device object to hardware." + "\n";
                    string = string + "connect(deviceObj);" + "\n";
                    break;
                }
                case 3: {
                    if (this.isConnected && !deviceMCode.wasConnected()) {
                        string = string + "\n" + "% Disconnect device object from hardware." + "\n";
                        string = string + "disconnect(deviceObj);" + "\n";
                        break;
                    }
                    if (this.isConnected || !deviceMCode.wasConnected()) break;
                    string = string + "\n" + "% Connect device object to hardware." + "\n";
                    string = string + "connect(deviceObj);" + "\n";
                }
            }
            string = string + this.getCode(deviceMCode);
        }
        return string;
    }

    private String getCode(DeviceMCode deviceMCode) {
        String string = "";
        if (this.lastType != deviceMCode.getType()) {
            string = "\n" + string + deviceMCode.getComment() + "\n";
            this.lastType = deviceMCode.getType();
        }
        return string + deviceMCode.getCode() + "\n";
    }

    private String generateConstructorCode() {
        Object object;
        String string = "";
        if (this.deviceObject.getDriverType() == 0) {
            object = ((MWIDDriver)this.deviceObject.getDriver()).getInterfaceObject();
            string = string + "% Create a " + ((Instrument)object).getType().toUpperCase() + " object.\n";
            string = string + "interfaceObj = instrfind" + ((Instrument)object).getInstrfindArgs() + "\n\n";
            string = string + "% Create the " + ((Instrument)object).getType().toUpperCase() + " object if it does not exist\n";
            string = string + "% otherwise use the object that was found.\n";
            string = string + "if isempty(interfaceObj)" + "\n";
            string = string + TAB + "interfaceObj = " + this.deviceObject.getInterfaceConstructor() + "\n";
            string = string + "else" + "\n";
            string = string + TAB + "fclose(interfaceObj);" + "\n";
            string = string + TAB + "interfaceObj = interfaceObj(1);" + "\n";
            string = string + "end" + "\n\n";
        }
        string = string + "% Create a device object. " + "\n";
        object = "deviceObj = " + this.deviceObject.getConstructor();
        if (this.deviceObject.getDriverType() == 0) {
            object = TMStringUtil.strrep((String)object, (String)"HWOBJ", (String)"interfaceObj");
        }
        string = string + (String)object;
        return string;
    }

    private String getCleanupCode() {
        if (this.deviceObject.getDriverType() == 0) {
            return "% Delete objects.\ndelete([deviceObj interfaceObj]);";
        }
        return "% Delete object.\ndelete(deviceObj);";
    }

    private String getComments(String string) {
        String string2 = string;
        if (string.indexOf(".") > 0) {
            string = string.substring(0, string.indexOf("."));
        }
        String string3 = "%" + string.toUpperCase() + " Code for communicating with an instrument. \n";
        string3 = string3 + "%  \n";
        string3 = string3 + "%   This is the machine generated representation of an instrument control \n";
        string3 = string3 + "%   session using a device object. The instrument control session comprises  \n";
        string3 = string3 + "%   all the steps you are likely to take when communicating with your  \n";
        string3 = string3 + "%   instrument. These steps are:\n";
        string3 = string3 + "%       \n";
        string3 = string3 + "%       1. Create a device object   \n";
        string3 = string3 + "%       2. Connect to the instrument \n";
        string3 = string3 + "%       3. Configure properties \n";
        string3 = string3 + "%       4. Invoke functions \n";
        string3 = string3 + "%       5. Disconnect from the instrument \n";
        string3 = string3 + "%  \n";
        string3 = string3 + "%   To run the instrument control session, type the name of the file,\n";
        string3 = string3 + "%   " + string + ", at the MATLAB command prompt.\n";
        string3 = string3 + "% \n";
        string3 = string3 + "%   The file, " + string2.toUpperCase() + " must be on your MATLAB PATH. For additional information\n";
        string3 = string3 + "%   on setting your MATLAB PATH, type 'help addpath' at the MATLAB command\n";
        string3 = string3 + "%   prompt.\n";
        string3 = string3 + "%\n";
        string3 = string3 + "%   Example:\n";
        string3 = string3 + "%       " + string + ";\n";
        string3 = string3 + "%\n";
        string3 = string3 + "%   See also ICDEVICE.\n";
        string3 = string3 + "%\n";
        string3 = string3 + "\n";
        string3 = string3 + "%   Creation time: " + TMStringUtil.getDate() + " \n";
        return string3;
    }

    @Override
    public void propertyChanged(Instrument instrument, String string, Object object) {
        if (this.instrument == null || !this.instrument.equals(instrument)) {
            return;
        }
        if (string.equals("Status") || string.equals("RecordStatus")) {
            return;
        }
        if (object instanceof MLArrayRef) {
            if (string.equals("Terminator")) {
                String string2 = "set(interfaceObj, 'Terminator', " + this.convertMLArrayRef((MLArrayRef)object) + ");";
                this.addCode(DeviceMCode.createPropertyChangedCode(string2, false));
            } else if (string.equals("EOSCharCode")) {
                String string3 = "set(interfaceObj, 'EOSCharCode', " + this.convertMLArrayRef((MLArrayRef)object) + ");";
                this.addCode(DeviceMCode.createPropertyChangedCode(string3, false));
            }
            return;
        }
        String string4 = "";
        string4 = object instanceof String ? "set(interfaceObj, '" + string + "', '" + object + "');" : "set(interfaceObj, '" + string + "', " + object + ");";
        this.addCode(DeviceMCode.createPropertyChangedCode(string4, false));
    }

    private String convertMLArrayRef(MLArrayRef mLArrayRef) {
        String string = "";
        if (mLArrayRef.getType() == 1) {
            Object[] objectArray = (Object[])mLArrayRef.getData();
            switch (objectArray.length) {
                case 1: {
                    string = "{" + this.createDisplay(objectArray[0]) + "}";
                    break;
                }
                case 2: {
                    string = "{" + this.createDisplay(objectArray[0]) + "," + this.createDisplay(objectArray[1]) + "}";
                }
            }
        } else {
            string = this.createDisplay(mLArrayRef.getData());
        }
        return string;
    }

    protected String createDisplay(Object object) {
        String string = "";
        if (object instanceof Double) {
            string = object.toString();
            return string.substring(0, string.indexOf("."));
        }
        if (object instanceof double[]) {
            double[] dArray = (double[])object;
            if (dArray.length == 0) {
                return "[]";
            }
            string = new Double(dArray[0]).toString();
            return string.substring(0, string.indexOf("."));
        }
        if (object == null || object.equals("")) {
            return "''";
        }
        if (object instanceof String || object instanceof Character) {
            return "'" + object + "'";
        }
        return string;
    }
}

