/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.search.lucene;

import com.mathworks.search.lucene.IndexLocation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.SimpleAnalyzer;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;

public class LuceneMultiIndexMerger {
    private final IndexLocation fDestination;
    private final List<IndexLocation> fSources;

    public LuceneMultiIndexMerger(IndexLocation destination, IndexLocation ... sources) {
        this(destination, Arrays.asList(sources));
    }

    public LuceneMultiIndexMerger(IndexLocation destination, Collection<IndexLocation> sources) {
        this.fDestination = destination;
        this.fSources = new ArrayList<IndexLocation>(sources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doMerge() throws IOException {
        Directory[] toMerge = this.getIndexesToMerge();
        Directory destination = this.fDestination.getSearchDirectory();
        IndexWriter writer = new IndexWriter(destination, (Analyzer)new SimpleAnalyzer(), true);
        try {
            writer.addIndexes(toMerge);
            writer.optimize();
        }
        finally {
            writer.close();
        }
    }

    private Directory[] getIndexesToMerge() {
        Directory[] dirs = new Directory[this.fSources.size()];
        for (int i = 0; i < dirs.length; ++i) {
            dirs[i] = this.fSources.get(i).getSearchDirectory();
        }
        return dirs;
    }
}

