/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.fiddler;

import com.sun.jini.fiddler.Fiddler;
import com.sun.jini.fiddler.ProxyUtil;
import com.sun.jini.proxy.ConstrainableProxyUtil;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.rmi.MarshalledObject;
import java.rmi.RemoteException;
import net.jini.admin.Administrable;
import net.jini.core.constraint.MethodConstraints;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.event.RemoteEventListener;
import net.jini.discovery.LookupDiscoveryRegistration;
import net.jini.discovery.LookupDiscoveryService;
import net.jini.id.ReferentUuid;
import net.jini.id.ReferentUuids;
import net.jini.id.Uuid;
import net.jini.security.proxytrust.ProxyTrustIterator;
import net.jini.security.proxytrust.SingletonProxyTrustIterator;

class FiddlerProxy
implements Administrable,
LookupDiscoveryService,
ReferentUuid,
Serializable {
    private static final long serialVersionUID = 2L;
    final Fiddler server;
    final Uuid proxyID;
    static /* synthetic */ Class class$net$jini$admin$Administrable;
    static /* synthetic */ Class class$net$jini$discovery$LookupDiscoveryService;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class array$Lnet$jini$core$discovery$LookupLocator;
    static /* synthetic */ Class class$net$jini$core$event$RemoteEventListener;
    static /* synthetic */ Class class$java$rmi$MarshalledObject;
    static /* synthetic */ Class class$com$sun$jini$fiddler$Fiddler;

    public static FiddlerProxy createServiceProxy(Fiddler fiddler, Uuid uuid) {
        if (fiddler instanceof RemoteMethodControl) {
            return new ConstrainableFiddlerProxy(fiddler, uuid, null);
        }
        return new FiddlerProxy(fiddler, uuid);
    }

    private FiddlerProxy(Fiddler fiddler, Uuid uuid) {
        this.server = fiddler;
        this.proxyID = uuid;
    }

    public Object getAdmin() throws RemoteException {
        return this.server.getAdmin();
    }

    public LookupDiscoveryRegistration register(String[] stringArray, LookupLocator[] lookupLocatorArray, RemoteEventListener remoteEventListener, MarshalledObject marshalledObject, long l) throws RemoteException {
        return this.server.register(stringArray, lookupLocatorArray, remoteEventListener, marshalledObject, l);
    }

    public Uuid getReferentUuid() {
        return this.proxyID;
    }

    public int hashCode() {
        return this.proxyID.hashCode();
    }

    public boolean equals(Object object) {
        return ReferentUuids.compare((Object)this, (Object)object);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.server == null) {
            throw new InvalidObjectException("FiddlerProxy.readObject failure - server field is null");
        }
        if (this.proxyID == null) {
            throw new InvalidObjectException("FiddlerProxy.readObject failure - proxyID field is null");
        }
    }

    private void readObjectNoData() throws InvalidObjectException {
        throw new InvalidObjectException("no data found when attempting to deserialize FiddlerProxy instance");
    }

    static final class ConstrainableFiddlerProxy
    extends FiddlerProxy
    implements RemoteMethodControl {
        static final long serialVersionUID = 2L;
        private static final Method[] methodMapArray = new Method[]{ProxyUtil.getMethod(class$net$jini$admin$Administrable == null ? (class$net$jini$admin$Administrable = FiddlerProxy.class$("net.jini.admin.Administrable")) : class$net$jini$admin$Administrable, "getAdmin", new Class[0]), ProxyUtil.getMethod(class$net$jini$admin$Administrable == null ? (class$net$jini$admin$Administrable = FiddlerProxy.class$("net.jini.admin.Administrable")) : class$net$jini$admin$Administrable, "getAdmin", new Class[0]), ProxyUtil.getMethod(class$net$jini$discovery$LookupDiscoveryService == null ? (class$net$jini$discovery$LookupDiscoveryService = FiddlerProxy.class$("net.jini.discovery.LookupDiscoveryService")) : class$net$jini$discovery$LookupDiscoveryService, "register", new Class[]{array$Ljava$lang$String == null ? (array$Ljava$lang$String = FiddlerProxy.class$("[Ljava.lang.String;")) : array$Ljava$lang$String, array$Lnet$jini$core$discovery$LookupLocator == null ? (array$Lnet$jini$core$discovery$LookupLocator = FiddlerProxy.class$("[Lnet.jini.core.discovery.LookupLocator;")) : array$Lnet$jini$core$discovery$LookupLocator, class$net$jini$core$event$RemoteEventListener == null ? (class$net$jini$core$event$RemoteEventListener = FiddlerProxy.class$("net.jini.core.event.RemoteEventListener")) : class$net$jini$core$event$RemoteEventListener, class$java$rmi$MarshalledObject == null ? (class$java$rmi$MarshalledObject = FiddlerProxy.class$("java.rmi.MarshalledObject")) : class$java$rmi$MarshalledObject, Long.TYPE}), ProxyUtil.getMethod(class$com$sun$jini$fiddler$Fiddler == null ? (class$com$sun$jini$fiddler$Fiddler = FiddlerProxy.class$("com.sun.jini.fiddler.Fiddler")) : class$com$sun$jini$fiddler$Fiddler, "register", new Class[]{array$Ljava$lang$String == null ? (array$Ljava$lang$String = FiddlerProxy.class$("[Ljava.lang.String;")) : array$Ljava$lang$String, array$Lnet$jini$core$discovery$LookupLocator == null ? (array$Lnet$jini$core$discovery$LookupLocator = FiddlerProxy.class$("[Lnet.jini.core.discovery.LookupLocator;")) : array$Lnet$jini$core$discovery$LookupLocator, class$net$jini$core$event$RemoteEventListener == null ? (class$net$jini$core$event$RemoteEventListener = FiddlerProxy.class$("net.jini.core.event.RemoteEventListener")) : class$net$jini$core$event$RemoteEventListener, class$java$rmi$MarshalledObject == null ? (class$java$rmi$MarshalledObject = FiddlerProxy.class$("java.rmi.MarshalledObject")) : class$java$rmi$MarshalledObject, Long.TYPE})};
        private MethodConstraints methodConstraints;

        private ConstrainableFiddlerProxy(Fiddler fiddler, Uuid uuid, MethodConstraints methodConstraints) {
            super(ConstrainableFiddlerProxy.constrainServer(fiddler, methodConstraints), uuid);
            this.methodConstraints = methodConstraints;
        }

        private static Fiddler constrainServer(Fiddler fiddler, MethodConstraints methodConstraints) {
            MethodConstraints methodConstraints2 = ConstrainableProxyUtil.translateConstraints(methodConstraints, methodMapArray);
            RemoteMethodControl remoteMethodControl = ((RemoteMethodControl)fiddler).setConstraints(methodConstraints2);
            return (Fiddler)remoteMethodControl;
        }

        public RemoteMethodControl setConstraints(MethodConstraints methodConstraints) {
            return new ConstrainableFiddlerProxy(this.server, this.proxyID, methodConstraints);
        }

        public MethodConstraints getConstraints() {
            return this.methodConstraints;
        }

        private ProxyTrustIterator getProxyTrustIterator() {
            return new SingletonProxyTrustIterator((Object)this.server);
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            ConstrainableProxyUtil.verifyConsistentConstraints(this.methodConstraints, this.server, methodMapArray);
        }
    }
}

