/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.services;

import com.mathworks.services.Prefs;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class PrefUtils {
    private PrefUtils() {
    }

    public static List<File> readFileList(String string, boolean bl) {
        return PrefUtils.readFileList(string, bl, false);
    }

    public static List<File> readFileListUsingPrefDir(String string, boolean bl) {
        return PrefUtils.readFileList(string, bl, true);
    }

    private static List<File> readFileList(String string, boolean bl, boolean bl2) {
        ArrayList<File> arrayList = new ArrayList<File>();
        StringTokenizer stringTokenizer = new StringTokenizer(Prefs.getStringPref(string, ""), File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            File file = new File(stringTokenizer.nextToken());
            if (bl2 && !file.isAbsolute()) {
                file = new File(Prefs.getPropertyDirectory(), file.getName());
            }
            if (bl && !file.exists() || arrayList.contains(file)) continue;
            arrayList.add(file);
        }
        return arrayList;
    }

    public static void writeFileList(String string, List<File> list) {
        PrefUtils.writeFileList(string, list, false);
    }

    public static void writeFileListUsingPrefDir(String string, List<File> list) throws IllegalArgumentException {
        PrefUtils.writeFileList(string, list, true);
    }

    private static void writeFileList(String string, List<File> list, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<File> iterator = list.iterator();
        while (iterator.hasNext()) {
            File file = iterator.next();
            String string2 = file.getPath();
            if (bl) {
                if (file.getParent() == null) {
                    throw new IllegalArgumentException("A path was stored with no parent: " + file.getPath());
                }
                if (file.getParent().equals(Prefs.getPropertyDirectory())) {
                    string2 = file.getName();
                }
            }
            stringBuilder.append(string2);
            if (!iterator.hasNext()) continue;
            stringBuilder.append(File.pathSeparator);
        }
        Prefs.setStringPref(string, stringBuilder.toString());
    }
}

