/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.matlab.guide.undoredo;

import com.mathworks.toolbox.matlab.guide.LayoutArea;
import com.mathworks.toolbox.matlab.guide.LayoutLooper;
import com.mathworks.toolbox.matlab.guide.palette.GObjectWrapper;
import com.mathworks.toolbox.matlab.guide.palette.LOControlWrapper;
import com.mathworks.toolbox.matlab.guide.palette.LOWrapperOwner;
import com.mathworks.toolbox.matlab.guide.undoredo.LayoutUndoableEdit;
import java.awt.Component;
import java.awt.Container;
import java.util.Enumeration;
import java.util.Vector;

public class UndoReorder
extends LayoutUndoableEdit {
    private LayoutArea fLayout;
    private int fDirection;
    private Vector<UndoLayerReorder> fLayers;

    public UndoReorder(LayoutArea layoutArea, int n) {
        this.fLayout = layoutArea;
        this.fDirection = n;
        this.fLayers = new Vector();
    }

    LayoutArea getLayout() {
        return this.fLayout;
    }

    public void addLayer(Vector vector) {
        LOControlWrapper lOControlWrapper = (LOControlWrapper)vector.firstElement();
        LOWrapperOwner lOWrapperOwner = lOControlWrapper.getParent();
        if (lOWrapperOwner == null) {
            lOWrapperOwner = this.fLayout;
        }
        this.fLayers.addElement(new UndoLayerReorder(lOWrapperOwner, vector, this.fDirection));
    }

    public boolean reorderComplete() {
        if (this.fLayers.isEmpty()) {
            return false;
        }
        Enumeration<UndoLayerReorder> enumeration = this.fLayers.elements();
        while (enumeration.hasMoreElements()) {
            UndoLayerReorder undoLayerReorder = enumeration.nextElement();
            undoLayerReorder.reorderComplete(this.fDirection);
        }
        this.fDirection = this.fDirection == 0 ? 1 : 0;
        return true;
    }

    @Override
    public void undo() {
        this.fLayout.selectAll(false);
        Enumeration<UndoLayerReorder> enumeration = this.fLayers.elements();
        while (enumeration.hasMoreElements()) {
            UndoLayerReorder undoLayerReorder = enumeration.nextElement();
            undoLayerReorder.reorder(this.fDirection);
        }
        this.fDirection = this.fDirection == 0 ? 1 : 0;
        this.fLayout.fireContentChangedEvent();
        this.fLayout.updateSelection();
        this.fLayout.repaint(5L);
    }

    @Override
    public void redo() {
        this.fLayout.selectAll(false);
        Enumeration<UndoLayerReorder> enumeration = this.fLayers.elements();
        while (enumeration.hasMoreElements()) {
            UndoLayerReorder undoLayerReorder = enumeration.nextElement();
            undoLayerReorder.reorder(this.fDirection);
        }
        this.fDirection = this.fDirection == 0 ? 1 : 0;
        this.fLayout.fireContentChangedEvent();
        this.fLayout.updateSelection();
        this.fLayout.repaint(5L);
    }

    @Override
    String getUndoTypeKey() {
        return "undo.reorder";
    }

    private class UndoLayerReorder {
        private LOWrapperOwner fOwner;
        private Vector fLayer;
        private int fWrapperCount;
        private LOControlWrapper[] fWrappers;
        private int[] fForwardIndexs;
        private int[] fBackwardIndexs;

        UndoLayerReorder(LOWrapperOwner lOWrapperOwner, Vector vector, int n) {
            this.fOwner = lOWrapperOwner;
            this.fLayer = vector;
            this.fWrapperCount = 0;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                LOControlWrapper lOControlWrapper = (LOControlWrapper)enumeration.nextElement();
                if (!lOControlWrapper.isSelected()) continue;
                ++this.fWrapperCount;
            }
            this.fWrappers = new LOControlWrapper[this.fWrapperCount];
            this.fForwardIndexs = new int[this.fWrapperCount];
            this.fBackwardIndexs = new int[this.fWrapperCount];
            int n2 = 0;
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                LOControlWrapper lOControlWrapper = (LOControlWrapper)enumeration.nextElement();
                if (!lOControlWrapper.isSelected()) continue;
                this.fWrappers[n2] = lOControlWrapper;
                if (n == 0) {
                    this.fBackwardIndexs[n2] = this.fLayer.indexOf(this.fWrappers[n2]);
                } else if (n == 1) {
                    this.fForwardIndexs[n2] = this.fLayer.indexOf(this.fWrappers[n2]);
                }
                ++n2;
            }
        }

        void reorderComplete(int n) {
            block3: {
                block2: {
                    if (n != 0) break block2;
                    for (int i = 0; i < this.fWrapperCount; ++i) {
                        this.fForwardIndexs[i] = this.fLayer.indexOf(this.fWrappers[i]);
                    }
                    break block3;
                }
                if (n != 1) break block3;
                for (int i = 0; i < this.fWrapperCount; ++i) {
                    this.fBackwardIndexs[i] = this.fLayer.indexOf(this.fWrappers[i]);
                }
            }
        }

        void reorder(int n) {
            int n2 = this.fLayer.size();
            Vector<LOControlWrapper> vector = new Vector<LOControlWrapper>(this.fWrapperCount);
            Vector<Integer> vector2 = new Vector<Integer>(this.fWrapperCount);
            if (n == 0) {
                Object object;
                for (int i = this.fWrapperCount - 1; i >= 0; --i) {
                    int n3;
                    this.fLayer.removeElement(this.fWrappers[i]);
                    this.fLayer.insertElementAt(this.fWrappers[i], this.fForwardIndexs[i]);
                    UndoReorder.this.fLayout.selectObject(this.fWrappers[i], true);
                    object = this.fWrappers[i].getControl();
                    Container container = ((Component)object).getParent();
                    if (container != null && container.getComponentCount() == n2) {
                        n3 = n2 - this.fForwardIndexs[i] - 1;
                        container.remove((Component)object);
                        container.add((Component)object, n3);
                    }
                    UndoReorder.this.getLayout().move(this.fWrappers[i], this.fForwardIndexs[i]);
                    if (!this.fWrappers[i].isGObject()) continue;
                    n3 = this.fForwardIndexs[i] - this.fBackwardIndexs[i];
                    n3 = n3 > 0 ? n3 : -n3;
                    vector.addElement(this.fWrappers[i]);
                    vector2.addElement(n3);
                }
                if (vector.size() > 0) {
                    GObjectWrapper[] gObjectWrapperArray = new GObjectWrapper[vector.size()];
                    object = new Integer[vector.size()];
                    for (int i = 0; i < vector.size(); ++i) {
                        gObjectWrapperArray[i] = (GObjectWrapper)vector.elementAt(i);
                        object[i] = (Integer)vector2.elementAt(i);
                    }
                    LayoutLooper.moveNForward(gObjectWrapperArray, (Integer[])object, UndoReorder.this.fLayout);
                }
            } else if (n == 1) {
                Object object;
                for (int i = 0; i < this.fWrapperCount; ++i) {
                    int n4;
                    this.fLayer.removeElement(this.fWrappers[i]);
                    this.fLayer.insertElementAt(this.fWrappers[i], this.fBackwardIndexs[i]);
                    UndoReorder.this.fLayout.selectObject(this.fWrappers[i], true);
                    object = this.fWrappers[i].getControl();
                    Container container = ((Component)object).getParent();
                    if (container != null && container.getComponentCount() == n2) {
                        n4 = n2 - this.fBackwardIndexs[i] - 1;
                        container.remove((Component)object);
                        container.add((Component)object, n4);
                    }
                    UndoReorder.this.getLayout().move(this.fWrappers[i], this.fBackwardIndexs[i]);
                    if (!this.fWrappers[i].isGObject()) continue;
                    n4 = this.fForwardIndexs[i] - this.fBackwardIndexs[i];
                    n4 = n4 > 0 ? n4 : -n4;
                    vector.addElement(this.fWrappers[i]);
                    vector2.addElement(n4);
                }
                if (vector.size() > 0) {
                    GObjectWrapper[] gObjectWrapperArray = new GObjectWrapper[vector.size()];
                    object = new Integer[vector.size()];
                    for (int i = 0; i < vector.size(); ++i) {
                        gObjectWrapperArray[i] = (GObjectWrapper)vector.elementAt(i);
                        object[i] = (Integer)vector2.elementAt(i);
                    }
                    LayoutLooper.moveNBackward(gObjectWrapperArray, (Integer[])object, UndoReorder.this.fLayout);
                }
            }
        }
    }
}

