/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.matlab.guide.palette;

import com.mathworks.toolbox.matlab.guide.LayoutStackingArea;
import com.mathworks.toolbox.matlab.guide.RuntimeArea;
import com.mathworks.toolbox.matlab.guide.palette.GObjectProxy;
import com.mathworks.toolbox.matlab.guide.palette.GObjectWrapper;
import com.mathworks.toolbox.matlab.guide.palette.LOWrapperOwner;
import com.mathworks.toolbox.matlab.guide.palette.LayoutHandleEnum;
import com.mathworks.toolbox.matlab.guide.palette.LayoutWrapperOwner;
import com.mathworks.toolbox.matlab.guide.palette.MObjectProxy;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Vector;

public class LOControlWrapper
implements LOWrapperOwner {
    private Component fControl;
    private int fType;
    private boolean fSelected;
    private LOControlWrapper fParent;
    protected LayoutWrapperOwner fWrapperOwner;
    private static final int HANDLE_INSET = 2;
    private static final int HANDLE_OUTSET = 3;
    private static final int HANDLE_SIZE = 5;

    public LOControlWrapper(Component component, boolean bl, int n) {
        this.fSelected = bl;
        this.fControl = component;
        this.fType = n;
        this.fWrapperOwner = new LayoutWrapperOwner(this.isEnclosure());
    }

    LOControlWrapper findContainer(Point point) {
        return this.fWrapperOwner.findContainer(point);
    }

    public int getTop() {
        return this.getBaseLocation().y;
    }

    public int getLeft() {
        return this.getBaseLocation().x;
    }

    public int getBottom() {
        return this.getBaseLocation().y + this.fControl.getSize().height;
    }

    public int getRight() {
        return this.getBaseLocation().x + this.fControl.getSize().width;
    }

    public int getControlType() {
        return this.fType;
    }

    public boolean ptInControlRect(Point point) {
        Point point2 = this.getBaseLocation();
        Dimension dimension = this.fControl.getSize();
        int n = point2.x;
        int n2 = point2.y;
        int n3 = n + dimension.width;
        int n4 = n2 + dimension.height;
        return point.x >= n && point.x <= n3 && point.y >= n2 && point.y <= n4;
    }

    public void offsetRect(int n, int n2) {
        Point point = this.fControl.getLocation();
        point.translate(n, n2);
        this.fControl.setLocation(point.x, point.y);
    }

    public boolean objInRect(int n, int n2, int n3, int n4) {
        boolean bl = true;
        int n5 = n + n3;
        int n6 = n2 + n4;
        Point point = this.getBaseLocation();
        Dimension dimension = this.fControl.getSize();
        int n7 = point.x;
        int n8 = point.y;
        int n9 = n7 + dimension.width;
        int n10 = n8 + dimension.height;
        if (n7 < n || n7 > n5) {
            bl = false;
        }
        if (n9 < n || n9 > n5) {
            bl = false;
        }
        if (n10 < n2 || n10 > n6) {
            bl = false;
        }
        if (n8 < n2 || n8 > n6) {
            bl = false;
        }
        return bl;
    }

    void setControl(Component component) {
        this.fControl = component;
    }

    public Component getControl() {
        return this.fControl;
    }

    public Object getBean() {
        return this.getControl();
    }

    public final boolean getNeedsLayout() {
        return this.fControl != null && this.fControl instanceof Container;
    }

    boolean isLightweight() {
        return true;
    }

    public boolean isBean() {
        return false;
    }

    public boolean isGObject() {
        return false;
    }

    public void setSelected(boolean bl) {
        this.fSelected = bl;
    }

    public boolean isSelected() {
        return this.fSelected;
    }

    public boolean isEnclosure() {
        return this.fType == 17;
    }

    public boolean isEnclosable() {
        return this.fType < 23 || this.fType > 63;
    }

    boolean canEnclose(int n) {
        return this.isEnclosure() && (n < 23 || n > 63);
    }

    public LayoutHandleEnum findResizeHandle(Point point) {
        Point point2 = this.getBaseLocation();
        Dimension dimension = this.fControl.getSize();
        int n = point2.x + dimension.width - 2;
        int n2 = point2.y + dimension.height - 2;
        int n3 = n + 5;
        int n4 = n2 + 5;
        if (point.x >= n && point.x <= n3 && point.y >= n2 && point.y <= n4) {
            return LayoutHandleEnum.BR_HANDLE;
        }
        n = point2.x + dimension.width - 2;
        n2 = point2.y + dimension.height / 2 - 2;
        n3 = n + 5;
        n4 = n2 + 5;
        if (point.x >= n && point.x <= n3 && point.y >= n2 && point.y <= n4) {
            return LayoutHandleEnum.MR_HANDLE;
        }
        n = point2.x + dimension.width - 2;
        n2 = point2.y - 3;
        n3 = n + 5;
        n4 = n2 + 5;
        if (point.x >= n && point.x <= n3 && point.y >= n2 && point.y <= n4) {
            return LayoutHandleEnum.TR_HANDLE;
        }
        n = point2.x - 3;
        n2 = point2.y - 3;
        n3 = n + 5;
        n4 = n2 + 5;
        if (point.x >= n && point.x <= n3 && point.y >= n2 && point.y <= n4) {
            return LayoutHandleEnum.TL_HANDLE;
        }
        n = point2.x - 3;
        n2 = point2.y + dimension.height / 2 - 3;
        n3 = n + 5;
        n4 = n2 + 5;
        if (point.x >= n && point.x <= n3 && point.y >= n2 && point.y <= n4) {
            return LayoutHandleEnum.ML_HANDLE;
        }
        n = point2.x - 3;
        n2 = point2.y + dimension.height - 2;
        n3 = n + 5;
        n4 = n2 + 5;
        if (point.x >= n && point.x <= n3 && point.y >= n2 && point.y <= n4) {
            return LayoutHandleEnum.BL_HANDLE;
        }
        n = point2.x + dimension.width / 2 - 3;
        n2 = point2.y - 2;
        n3 = n + 5;
        n4 = n2 + 5;
        if (point.x >= n && point.x <= n3 && point.y >= n2 && point.y <= n4) {
            return LayoutHandleEnum.MT_HANDLE;
        }
        n = point2.x + dimension.width / 2 - 3;
        n2 = point2.y + dimension.height - 2;
        n3 = n + 5;
        n4 = n2 + 5;
        if (point.x >= n && point.x <= n3 && point.y >= n2 && point.y <= n4) {
            return LayoutHandleEnum.MB_HANDLE;
        }
        return LayoutHandleEnum.NO_HANDLE;
    }

    public boolean ptOverResizehandle(Point point) {
        return this.findResizeHandle(point) != LayoutHandleEnum.NO_HANDLE;
    }

    public void drawHandles(Graphics graphics) {
        Point point = this.getBaseLocation();
        Dimension dimension = this.fControl.getSize();
        Color color = graphics.getColor();
        graphics.setColor(Color.black);
        int n = 5;
        graphics.fillRect(point.x - 2, point.y - 2, n, n);
        graphics.fillRect(point.x + dimension.width / 2 - 2, point.y - 2, n, n);
        graphics.fillRect(point.x + dimension.width - 3, point.y - 2, n, n);
        graphics.fillRect(point.x - 2, point.y + dimension.height - 3, n, n);
        graphics.fillRect(point.x + dimension.width / 2 - 2, point.y + dimension.height - 3, n, n);
        graphics.fillRect(point.x + dimension.width - 3, point.y + dimension.height - 3, n, n);
        graphics.fillRect(point.x - 2, point.y + dimension.height / 2 - 2, n, n);
        graphics.fillRect(point.x + dimension.width - 3, point.y + dimension.height / 2 - 2, n, n);
        graphics.setColor(Color.white);
        graphics.drawRect(point.x - 2, point.y - 2, n, n);
        graphics.drawRect(point.x + dimension.width / 2 - 2, point.y - 2, n, n);
        graphics.drawRect(point.x + dimension.width - 3, point.y - 2, n, n);
        graphics.drawRect(point.x - 2, point.y + dimension.height - 3, n, n);
        graphics.drawRect(point.x + dimension.width / 2 - 2, point.y + dimension.height - 3, n, n);
        graphics.drawRect(point.x + dimension.width - 3, point.y + dimension.height - 3, n, n);
        graphics.drawRect(point.x - 2, point.y + dimension.height / 2 - 2, n, n);
        graphics.drawRect(point.x + dimension.width - 3, point.y + dimension.height / 2 - 2, n, n);
        graphics.setColor(color);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics) {
        Rectangle rectangle = graphics.getClipBounds();
        if (this.fControl != null) {
            Rectangle rectangle2 = this.fControl.getBounds();
            if (rectangle == null || rectangle2.intersects(rectangle)) {
                Graphics graphics2 = graphics.create(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                graphics2.setColor(Color.black);
                try {
                    this.fControl.paint(graphics2);
                }
                finally {
                    graphics2.dispose();
                }
            }
        }
    }

    void setParent(LOControlWrapper lOControlWrapper) {
        this.fParent = lOControlWrapper;
    }

    public final LOControlWrapper getParent() {
        return this.fParent;
    }

    public Point getBaseLocation() {
        if (this.getParent() == null) {
            return this.getControl().getLocation();
        }
        Point point = this.getControl().getLocation();
        for (Container container = this.getControl().getParent(); container != null && !(container instanceof RuntimeArea); container = container.getParent()) {
            Point point2 = container.getLocation();
            point.translate(point2.x, point2.y);
        }
        return point;
    }

    public void translateFromBaseCoordinates(Point point) {
        Point point2 = this.getBaseLocation();
        point.translate(-point2.x, -point2.y);
    }

    public void translateToBaseCoordinates(Point point) {
        Point point2 = this.getBaseLocation();
        point.translate(point2.x, point2.y);
    }

    public final Vector getSublayer() {
        return this.fWrapperOwner.getLayer(this);
    }

    public Vector[] getLayers() {
        return this.fWrapperOwner.getLayers();
    }

    LOControlWrapper findControl(Point point) {
        return this.fWrapperOwner.findControl(point);
    }

    @Override
    public void addWrapper(LOControlWrapper lOControlWrapper, int n, boolean bl) {
        this.fWrapperOwner.addWrapper(lOControlWrapper, n, bl);
        if (n != -2) {
            lOControlWrapper.setParent(this);
            Container container = (Container)this.getControl();
            if (container != null) {
                lOControlWrapper.addToLayout(container, n, bl);
            }
        }
    }

    @Override
    public void removeWrapper(LOControlWrapper lOControlWrapper, boolean bl) {
        Container container = (Container)this.getControl();
        if (container != null) {
            lOControlWrapper.removeFromLayout(container, bl);
        }
        this.fWrapperOwner.removeWrapper(lOControlWrapper, bl);
    }

    @Override
    public int getIndexOfWrapper(LOControlWrapper lOControlWrapper) {
        return this.fWrapperOwner.getIndexOfWrapper(lOControlWrapper);
    }

    @Override
    public LOControlWrapper findWrapper(Object object) {
        LOControlWrapper lOControlWrapper = object.equals(this.getBean()) ? this : this.fWrapperOwner.findWrapper(object);
        return lOControlWrapper;
    }

    public Enumeration baseWrappers() {
        return this.fWrapperOwner.baseWrappers();
    }

    public Enumeration wrappers() {
        return this.fWrapperOwner.wrappers();
    }

    Enumeration baselayers() {
        return this.fWrapperOwner.baseLayers();
    }

    Enumeration layers() {
        return this.fWrapperOwner.layers();
    }

    public static LOControlWrapper buildWrapper(int n, Object object) {
        LOControlWrapper lOControlWrapper;
        switch (n) {
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                MObjectProxy mObjectProxy = (MObjectProxy)object;
                lOControlWrapper = new GObjectWrapper(mObjectProxy);
                break;
            }
            default: {
                Component component = (Component)object;
                lOControlWrapper = new LOControlWrapper(component, false, n);
            }
        }
        return lOControlWrapper;
    }

    public void addToLayout(Container container, int n, boolean bl) {
        if (container != null) {
            if (container instanceof LayoutStackingArea) {
                ((LayoutStackingArea)((Object)container)).addToLayer(this, 0);
            } else {
                container.add(this.getControl(), n);
            }
        }
        this.setup(bl);
    }

    public void setup(boolean bl) {
    }

    public void removeFromLayout(Container container, boolean bl) {
        if (container != null) {
            if (container instanceof LayoutStackingArea) {
                ((LayoutStackingArea)((Object)container)).removeFromLayer(this);
            } else {
                container.remove(this.getControl());
            }
        }
        this.cleanUp(bl);
    }

    public void cleanUp(boolean bl) {
        Enumeration enumeration = this.fWrapperOwner.baseWrappers();
        while (enumeration.hasMoreElements()) {
            LOControlWrapper lOControlWrapper = (LOControlWrapper)enumeration.nextElement();
            lOControlWrapper.cleanUp(false);
        }
    }

    public boolean isGObjectType(int n) {
        if (this.getControl() instanceof GObjectProxy) {
            int n2 = ((GObjectProxy)this.getControl()).getStyle();
            return n2 == n;
        }
        return false;
    }

    public int getGObjectType() {
        if (this.getControl() instanceof GObjectProxy) {
            return ((GObjectProxy)this.getControl()).getStyle();
        }
        return -1;
    }
}

