/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.matlab.guide.menueditor;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.bean.UDDObject;
import com.mathworks.mlservices.MLInspectorServices;
import com.mathworks.services.ObjectRegistry;
import com.mathworks.toolbox.matlab.guide.LayoutEditor;
import com.mathworks.toolbox.matlab.guide.menueditor.MenuEditor;
import com.mathworks.toolbox.matlab.guide.menueditor.MenuEditorLooper;
import com.mathworks.toolbox.matlab.guide.utils.LayoutWorker;
import java.util.List;
import java.util.Vector;

public class MenuNode {
    public static final int ROOT = 0;
    public static final int UIMENU = 1;
    public static final int UICONTEXTMENU = 2;
    public static final int NUM_TYPES = 3;
    private LayoutEditor fEditor;
    private int fType;
    private double fHandle;
    private UDDObject fMenu;
    private String fLabel;
    private String fTag;
    private String fCallback;
    private boolean fChecked;
    private boolean fSeparator;
    private boolean fEnabled;
    private String fAccelerator;
    private MenuNode fParent;
    private List<MenuNode> fChildren;
    private MenuEditor fMenuEditor;

    public MenuNode(int n, double d, UDDObject uDDObject, MenuEditor menuEditor) {
        this.fType = n;
        this.fHandle = d;
        this.fMenu = uDDObject;
        this.fMenuEditor = menuEditor;
        this.fParent = null;
        this.fChildren = new Vector<MenuNode>();
        this.fLabel = null;
        this.fTag = null;
        this.fCallback = null;
        this.fAccelerator = null;
        this.fChecked = false;
        this.fSeparator = false;
        this.fEnabled = true;
        this.updateMenuNode(menuEditor);
    }

    public MenuNode() {
        this(0, 0.0, null, null);
    }

    public void addChild(MenuNode menuNode) {
        if (menuNode != null) {
            this.fChildren.add(menuNode);
            menuNode.setParent(this);
        }
    }

    public void removeChild(MenuNode menuNode) {
        if (menuNode != null) {
            this.fChildren.remove(menuNode);
            menuNode.setParent(null);
        }
    }

    public double getHandle() {
        return this.fHandle;
    }

    public UDDObject getUDDNode() {
        return this.fMenu;
    }

    public int getType() {
        return this.fType;
    }

    public String getLabel() {
        return this.fLabel;
    }

    public void setLabel(String string) {
        if (!string.equals(this.fLabel)) {
            this.fLabel = string;
            MenuEditorLooper.doSetProperty(this.fHandle, "Label", string, new PropertySetObserver());
            this.fMenuEditor.fireNodeChange();
        }
    }

    public String getTag() {
        return this.fTag;
    }

    public void setTag(String string) {
        if (!string.equals(this.fTag)) {
            String string2 = this.fTag;
            this.fTag = string;
            if (string2 != null) {
                this.updateTag(this.fTag);
            }
        }
    }

    void updateTag(String string) {
        Object[] objectArray = new Object[]{this.fHandle};
        MenuEditorLooper.updateTag(objectArray, this.fTag, new PropertySetObserver());
    }

    public String getCallback() {
        return this.fCallback;
    }

    public void setCallback(String string) {
        if (!string.equals(this.fCallback)) {
            this.fCallback = string;
            MenuEditorLooper.doSetProperty(this.fHandle, "Callback", string, new PropertySetObserver());
        }
    }

    public void editCallback(MenuEditor menuEditor) {
        Object[] objectArray = new Object[]{this.fHandle};
        MenuEditorLooper.viewCallback(menuEditor.getFigHandle(), objectArray, "Callback", new EditCallbackObserver(this));
    }

    public void inspectMenuProperty() {
        LayoutEditor.showInspector();
        MLInspectorServices.inspectObject((Object)this.getUDDNode());
    }

    public boolean getSeparator() {
        return this.fSeparator;
    }

    public void setSeparator(boolean bl) {
        if (this.fSeparator != bl) {
            this.fSeparator = bl;
            MenuEditorLooper.doSetProperty(this.fHandle, "Separator", bl ? "on" : "off", new PropertySetObserver());
        }
    }

    public boolean getChecked() {
        return this.fChecked;
    }

    public void setChecked(boolean bl) {
        if (this.fChecked != bl) {
            this.fChecked = bl;
            MenuEditorLooper.doSetProperty(this.fHandle, "Checked", bl ? "on" : "off", new PropertySetObserver());
        }
    }

    public boolean getEnabled() {
        return this.fEnabled;
    }

    public void setEnabled(boolean bl) {
        if (this.fEnabled != bl) {
            this.fEnabled = bl;
            MenuEditorLooper.doSetProperty(this.fHandle, "Enable", bl ? "on" : "off", new PropertySetObserver());
        }
    }

    public String getAccelerator() {
        return this.fAccelerator;
    }

    public void setAccelerator(String string) {
        if (!string.equals(this.fAccelerator)) {
            this.fAccelerator = string;
            MenuEditorLooper.doSetProperty(this.fHandle, "Accelerator", string, new PropertySetObserver());
        }
    }

    void setTarget(LayoutEditor layoutEditor) {
        this.fEditor = layoutEditor;
    }

    protected List<MenuNode> getChildren() {
        return this.fChildren;
    }

    boolean isRoot() {
        return this.fParent != null && this.fParent.getType() == 0;
    }

    private void setParent(MenuNode menuNode) {
        this.fParent = menuNode;
    }

    void fireObjectChangedEvent() {
        if (this.fMenu != null) {
            ObjectRegistry.getLayoutRegistry().change(new Object[]{this.fMenu});
        }
    }

    void updateMenuNode(MenuEditor menuEditor) {
        if (this.fHandle != 0.0) {
            MenuEditorLooper.doGetProperty(this.fHandle, new PropertyGetObserver(menuEditor, this));
        }
    }

    private void updateProperties(Object[] objectArray) {
        if (objectArray != null) {
            Object[] objectArray2 = (Object[])objectArray[0];
            Object[] objectArray3 = (Object[])objectArray[1];
            for (int i = 0; i < objectArray2.length; ++i) {
                if (objectArray2[i].equals("Accelerator")) {
                    this.fAccelerator = MenuNode.getValueString(objectArray3[i]);
                    continue;
                }
                if (objectArray2[i].equals("Callback")) {
                    this.fCallback = MenuNode.getValueString(objectArray3[i]);
                    continue;
                }
                if (objectArray2[i].equals("Checked")) {
                    this.fChecked = objectArray3[i].equals("on");
                    continue;
                }
                if (objectArray2[i].equals("Enable")) {
                    this.fEnabled = objectArray3[i].equals("on");
                    continue;
                }
                if (objectArray2[i].equals("Label")) {
                    this.fLabel = MenuNode.getValueString(objectArray3[i]);
                    continue;
                }
                if (objectArray2[i].equals("Separator")) {
                    this.fSeparator = objectArray3[i].equals("on");
                    continue;
                }
                if (!objectArray2[i].equals("Tag")) continue;
                this.setTag(MenuNode.getValueString(objectArray3[i]));
            }
        }
    }

    private static String getValueString(Object object) {
        String string = "";
        if (object instanceof Character) {
            string = new String(new char[]{((Character)object).charValue()});
        } else if (object instanceof String) {
            string = (String)object;
        }
        return string;
    }

    private class EditCallbackObserver
    implements CompletionObserver {
        private MenuNode fNode;

        private EditCallbackObserver(MenuNode menuNode2) {
            this.fNode = menuNode2;
        }

        public void completed(int n, Object object) {
            if (LayoutWorker.isRunOnMatlabThreadSuccessful(n)) {
                this.fNode.fireObjectChangedEvent();
            }
        }
    }

    private class PropertyGetObserver
    implements CompletionObserver {
        private MenuEditor fGetPropEditor;
        private MenuNode fNode;

        private PropertyGetObserver(MenuEditor menuEditor, MenuNode menuNode2) {
            this.fGetPropEditor = menuEditor;
            this.fNode = menuNode2;
        }

        public void completed(int n, Object object) {
            if (LayoutWorker.isRunOnMatlabThreadSuccessful(n) && object != null && object instanceof Object[]) {
                this.fNode.updateProperties((Object[])object);
                if (this.fGetPropEditor != null) {
                    this.fGetPropEditor.updateControls(3);
                }
            }
        }
    }

    private class PropertySetObserver
    implements CompletionObserver {
        private PropertySetObserver() {
        }

        public void completed(int n, Object object) {
            MenuNode.this.fEditor.contentChanged(null);
            MenuNode.this.fireObjectChangedEvent();
        }
    }
}

