/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.matlab.guide.dragdrop;

import com.mathworks.toolbox.matlab.guide.LayoutArea;
import com.mathworks.toolbox.matlab.guide.dragdrop.DragTracker;
import com.mathworks.toolbox.matlab.guide.palette.GObjectWrapper;
import com.mathworks.toolbox.matlab.guide.palette.LOControlWrapper;
import com.mathworks.toolbox.matlab.guide.palette.LayoutHandleEnum;
import com.mathworks.toolbox.matlab.guide.undoredo.UndoResize;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.MouseEvent;

public class ResizeDrag
extends DragTracker {
    private static final int NO_CONSTRAINT = 0;
    private static final int CONSTRAIN_HEIGHT = 1;
    private static final int CONSTRAIN_HEIGHT_AND_WIDTH = 2;
    private static final int CONSTRAIN_HEIGHT_OR_WIDTH = 3;
    private static final int MIN_LENGTH = 50;
    private LOControlWrapper fWrapper;
    private Point fStartLocation;
    private Point fAnchorPt;
    private Point fSnapPt;
    private Point fCurrentPt;
    private Dimension fMinSize;
    private Dimension fControlSize;
    private int fConstraint;
    private LayoutHandleEnum fDirection;
    private int fXfudge;
    private int fYfudge;

    public ResizeDrag(LayoutArea layoutArea, LOControlWrapper lOControlWrapper) {
        super(layoutArea);
        this.fWrapper = lOControlWrapper;
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.fDirection = this.fWrapper.findResizeHandle(mouseEvent.getPoint());
        this.fMinSize = this.fWrapper.getControl().getMinimumSize();
        this.fControlSize = this.fWrapper.getControl().getSize();
        this.fStartLocation = this.fWrapper.getBaseLocation();
        this.fLayoutArea.ensureMinimumSize(this.fMinSize);
        Dimension dimension = this.fWrapper.getControl().getSize();
        switch (this.fDirection) {
            case BR_HANDLE: {
                this.fXfudge = 1;
                this.fYfudge = 1;
                this.fAnchorPt = new Point(this.fStartLocation.x, this.fStartLocation.y);
                this.fSnapPt = new Point(this.fStartLocation.x + dimension.width, this.fStartLocation.y + dimension.height);
                break;
            }
            case TR_HANDLE: {
                this.fXfudge = 1;
                this.fAnchorPt = new Point(this.fStartLocation.x, this.fStartLocation.y + dimension.height);
                this.fSnapPt = new Point(this.fStartLocation.x + dimension.width, this.fStartLocation.y);
                break;
            }
            case TL_HANDLE: {
                this.fAnchorPt = new Point(this.fStartLocation.x + dimension.width, this.fStartLocation.y + dimension.height);
                this.fSnapPt = new Point(this.fStartLocation.x, this.fStartLocation.y);
                break;
            }
            case BL_HANDLE: {
                this.fYfudge = 1;
                this.fAnchorPt = new Point(this.fStartLocation.x + dimension.width, this.fStartLocation.y);
                this.fSnapPt = new Point(this.fStartLocation.x, this.fStartLocation.y + dimension.height);
                break;
            }
            case MT_HANDLE: {
                this.fAnchorPt = new Point(this.fStartLocation.x, this.fStartLocation.y + dimension.height);
                this.fSnapPt = new Point(this.fStartLocation.x, this.fStartLocation.y);
                break;
            }
            case MB_HANDLE: {
                this.fYfudge = 1;
                this.fAnchorPt = new Point(this.fStartLocation.x, this.fStartLocation.y);
                this.fSnapPt = new Point(this.fStartLocation.x, this.fStartLocation.y + dimension.height);
                break;
            }
            case ML_HANDLE: {
                this.fAnchorPt = new Point(this.fStartLocation.x + dimension.width, this.fStartLocation.y + dimension.height);
                this.fSnapPt = new Point(this.fStartLocation.x, this.fStartLocation.y + dimension.height);
                break;
            }
            case MR_HANDLE: {
                this.fXfudge = 1;
                this.fAnchorPt = new Point(this.fStartLocation.x, this.fStartLocation.y + dimension.height);
                this.fSnapPt = new Point(this.fStartLocation.x + dimension.width, this.fStartLocation.y + dimension.height);
            }
        }
        this.fConstraint = 0;
        int n = this.fWrapper.getControlType();
        if (n == 11 || n == 12 || n == 18 || n == 21 || n == 22) {
            this.fConstraint = 1;
            int n2 = this.fWrapper.getControl().getPreferredSize().height;
            switch (this.fDirection) {
                case BR_HANDLE: 
                case BL_HANDLE: 
                case MB_HANDLE: {
                    this.fSnapPt.y = this.fStartLocation.y + n2;
                    break;
                }
                case TR_HANDLE: 
                case TL_HANDLE: 
                case MT_HANDLE: {
                    this.fSnapPt.y = this.fStartLocation.y + dimension.height - n2;
                }
            }
        } else if (n == 14) {
            this.fConstraint = 3;
            int n3 = this.fWrapper.getControl().getPreferredSize().width;
            switch (this.fDirection) {
                case BR_HANDLE: 
                case BL_HANDLE: 
                case MB_HANDLE: {
                    this.fSnapPt.y = this.fStartLocation.y + n3;
                    break;
                }
                case TR_HANDLE: 
                case TL_HANDLE: 
                case MT_HANDLE: {
                    this.fSnapPt.y = this.fStartLocation.y + dimension.height - n3;
                }
            }
            switch (this.fDirection) {
                case BR_HANDLE: 
                case TR_HANDLE: 
                case MR_HANDLE: {
                    this.fSnapPt.x = this.fStartLocation.x + n3;
                    break;
                }
                case TL_HANDLE: 
                case BL_HANDLE: 
                case ML_HANDLE: {
                    this.fSnapPt.x = this.fStartLocation.x + dimension.width - n3;
                }
            }
        }
        if (this.fLayoutArea.getLayoutStatusBar() != null) {
            this.fLayoutArea.getLayoutStatusBar().setPosition(this.fWrapper.getParent(), this.fWrapper, false);
        }
        this.fLayoutArea.selectAll(false);
        this.fLayoutArea.selectObject(this.fWrapper, true);
        this.fLayoutArea.drawNow();
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        Graphics graphics = this.getXORGraphics();
        this.drawMarquee(graphics);
        this.fCurrentPt = mouseEvent.getPoint();
        this.constrainPoint(this.fCurrentPt);
        this.fLayoutArea.getGrid().snapToGrid(this.fCurrentPt, this.fXfudge, this.fYfudge);
        this.constrainSize(mouseEvent.isShiftDown());
        this.drawMarquee(graphics);
        graphics.dispose();
        Point point = new Point(this.fCurrentPt.x, this.fCurrentPt.y);
        Point point2 = new Point(this.fWrapper.getLeft(), this.fWrapper.getBottom());
        Point point3 = new Point(this.fWrapper.getRight(), this.fWrapper.getTop());
        Point point4 = new Point(0, 0);
        Point point5 = new Point(0, 0);
        switch (this.fDirection) {
            case BR_HANDLE: {
                point.translate(-1, -1);
                point4 = new Point(point2.x, this.fCurrentPt.y);
                point5 = new Point(this.fCurrentPt.x, point3.y);
                break;
            }
            case TR_HANDLE: {
                point.translate(-1, 0);
                point4 = new Point(point2.x, point2.y);
                point5 = this.fCurrentPt;
                break;
            }
            case TL_HANDLE: {
                point4 = new Point(this.fCurrentPt.x, point2.y);
                point5 = new Point(point3.x, this.fCurrentPt.y);
                break;
            }
            case BL_HANDLE: {
                point.translate(0, -1);
                point4 = this.fCurrentPt;
                point5 = point3;
                break;
            }
            case MT_HANDLE: {
                point4 = new Point((point2.x + this.fCurrentPt.x) / 2, point2.y);
                point5 = new Point((this.fCurrentPt.x + point3.x) / 2, this.fCurrentPt.y);
                break;
            }
            case MB_HANDLE: {
                point.translate(0, -1);
                point4 = new Point((point2.x + this.fCurrentPt.x) / 2, this.fCurrentPt.y);
                point5 = new Point((this.fCurrentPt.x + point3.x) / 2, point3.y);
                break;
            }
            case ML_HANDLE: {
                point4 = new Point(this.fCurrentPt.x, (this.fCurrentPt.y + point2.y) / 2);
                point5 = new Point(point3.x, (this.fCurrentPt.y + point3.y) / 2);
                break;
            }
            case MR_HANDLE: {
                point.translate(-1, 0);
                point4 = new Point(point2.x, (this.fCurrentPt.y + point2.y) / 2);
                point5 = new Point(this.fCurrentPt.x, (this.fCurrentPt.y + point3.y) / 2);
            }
        }
        if (this.fLayoutArea.getLayoutStatusBar() != null) {
            this.fLayoutArea.getLayoutStatusBar().setPosition(this.fWrapper.getParent(), point4, point5, false);
        }
        this.fLayoutArea.getHRuler().doMouseTrackMouseMoved(point);
        this.fLayoutArea.getVRuler().doMouseTrackMouseMoved(point);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        Graphics graphics = this.getXORGraphics();
        this.drawMarquee(graphics);
        graphics.dispose();
        this.fCurrentPt = mouseEvent.getPoint();
        this.constrainPoint(this.fCurrentPt);
        this.fLayoutArea.getGrid().snapToGrid(this.fCurrentPt, this.fXfudge, this.fYfudge);
        this.constrainSize(mouseEvent.isShiftDown());
        UndoResize undoResize = new UndoResize(this.fLayoutArea, this.fWrapper);
        int n = Math.abs(this.fCurrentPt.x - this.fAnchorPt.x);
        int n2 = Math.abs(this.fCurrentPt.y - this.fAnchorPt.y);
        switch (this.fDirection) {
            case BR_HANDLE: {
                break;
            }
            case TR_HANDLE: {
                this.fWrapper.offsetRect(0, this.fCurrentPt.y - this.fStartLocation.y);
                break;
            }
            case TL_HANDLE: {
                this.fWrapper.offsetRect(this.fCurrentPt.x - this.fStartLocation.x, this.fCurrentPt.y - this.fStartLocation.y);
                break;
            }
            case BL_HANDLE: {
                this.fWrapper.offsetRect(this.fCurrentPt.x - this.fStartLocation.x, 0);
                break;
            }
            case MR_HANDLE: {
                n2 = this.fControlSize.height;
                break;
            }
            case ML_HANDLE: {
                n2 = this.fControlSize.height;
                this.fWrapper.offsetRect(this.fCurrentPt.x - this.fStartLocation.x, 0);
                break;
            }
            case MT_HANDLE: {
                n = this.fControlSize.width;
                this.fWrapper.offsetRect(0, this.fCurrentPt.y - this.fStartLocation.y);
                break;
            }
            case MB_HANDLE: {
                n = this.fControlSize.width;
            }
        }
        this.fWrapper.getControl().setSize(n, n2);
        if (this.fWrapper.getNeedsLayout()) {
            LayoutArea.forceLayout((Container)this.fWrapper.getControl());
        }
        if (undoResize.resizeComplete()) {
            this.fLayoutArea.updateSelection();
            this.fLayoutArea.fireContentChangedEvent();
            this.fLayoutArea.fireUndoEvent(undoResize);
            if (this.fWrapper.isGObject()) {
                ((GObjectWrapper)this.fWrapper).updatePosition();
            } else {
                this.fLayoutArea.fireObjectChangedEvent(this.fWrapper);
            }
        }
    }

    private void constrainSize(boolean bl) {
        switch (this.fConstraint) {
            case 2: {
                this.fCurrentPt.x = this.fSnapPt.x;
            }
            case 1: {
                this.fCurrentPt.y = this.fSnapPt.y;
                break;
            }
            case 3: {
                int n = Math.abs(this.fCurrentPt.x - this.fAnchorPt.x);
                int n2 = Math.abs(this.fCurrentPt.y - this.fAnchorPt.y);
                if (n > n2) {
                    this.fCurrentPt.y = this.fSnapPt.y;
                    switch (this.fDirection) {
                        case BR_HANDLE: 
                        case TR_HANDLE: 
                        case MR_HANDLE: {
                            if (this.fCurrentPt.x >= this.fAnchorPt.x + 50) break;
                            this.fCurrentPt.x = this.fAnchorPt.x + 50;
                            break;
                        }
                        case TL_HANDLE: 
                        case BL_HANDLE: 
                        case ML_HANDLE: {
                            if (this.fCurrentPt.x <= this.fAnchorPt.x - 50) break;
                            this.fCurrentPt.x = this.fAnchorPt.x - 50;
                        }
                    }
                } else {
                    this.fCurrentPt.x = this.fSnapPt.x;
                    switch (this.fDirection) {
                        case BR_HANDLE: 
                        case BL_HANDLE: 
                        case MB_HANDLE: {
                            if (this.fCurrentPt.y >= this.fAnchorPt.y + 50) break;
                            this.fCurrentPt.y = this.fAnchorPt.y + 50;
                            break;
                        }
                        case TR_HANDLE: 
                        case TL_HANDLE: 
                        case MT_HANDLE: {
                            if (this.fCurrentPt.y <= this.fAnchorPt.y - 50) break;
                            this.fCurrentPt.y = this.fAnchorPt.y - 50;
                        }
                    }
                }
                return;
            }
            default: {
                int n;
                if (!bl) break;
                int n3 = Math.abs(this.fCurrentPt.x - this.fSnapPt.x);
                if (n3 > (n = Math.abs(this.fCurrentPt.y - this.fSnapPt.y))) {
                    this.fCurrentPt.y = this.fSnapPt.y;
                    break;
                }
                this.fCurrentPt.x = this.fSnapPt.x;
            }
        }
        switch (this.fDirection) {
            case BR_HANDLE: {
                if (this.fCurrentPt.x < this.fAnchorPt.x + this.fMinSize.width) {
                    this.fCurrentPt.x = this.fAnchorPt.x + this.fMinSize.width;
                }
                if (this.fCurrentPt.y >= this.fAnchorPt.y + this.fMinSize.height) break;
                this.fCurrentPt.y = this.fAnchorPt.y + this.fMinSize.height;
                break;
            }
            case TR_HANDLE: {
                if (this.fCurrentPt.x < this.fAnchorPt.x + this.fMinSize.width) {
                    this.fCurrentPt.x = this.fAnchorPt.x + this.fMinSize.width;
                }
                if (this.fCurrentPt.y <= this.fAnchorPt.y - this.fMinSize.height) break;
                this.fCurrentPt.y = this.fAnchorPt.y - this.fMinSize.height;
                break;
            }
            case TL_HANDLE: {
                if (this.fCurrentPt.x > this.fAnchorPt.x - this.fMinSize.width) {
                    this.fCurrentPt.x = this.fAnchorPt.x - this.fMinSize.width;
                }
                if (this.fCurrentPt.y <= this.fAnchorPt.y - this.fMinSize.height) break;
                this.fCurrentPt.y = this.fAnchorPt.y - this.fMinSize.height;
                break;
            }
            case BL_HANDLE: {
                if (this.fCurrentPt.x > this.fAnchorPt.x - this.fMinSize.width) {
                    this.fCurrentPt.x = this.fAnchorPt.x - this.fMinSize.width;
                }
                if (this.fCurrentPt.y >= this.fAnchorPt.y + this.fMinSize.height) break;
                this.fCurrentPt.y = this.fAnchorPt.y + this.fMinSize.height;
                break;
            }
            case ML_HANDLE: {
                if (this.fCurrentPt.x <= this.fAnchorPt.x - this.fMinSize.width) break;
                this.fCurrentPt.x = this.fAnchorPt.x - this.fMinSize.width;
                break;
            }
            case MR_HANDLE: {
                if (this.fCurrentPt.x >= this.fAnchorPt.x + this.fMinSize.width) break;
                this.fCurrentPt.x = this.fAnchorPt.x + this.fMinSize.width;
                break;
            }
            case MT_HANDLE: {
                if (this.fCurrentPt.y <= this.fAnchorPt.y - this.fMinSize.height) break;
                this.fCurrentPt.y = this.fAnchorPt.y - this.fMinSize.height;
                break;
            }
            case MB_HANDLE: {
                if (this.fCurrentPt.y >= this.fAnchorPt.y + this.fMinSize.height) break;
                this.fCurrentPt.y = this.fAnchorPt.y + this.fMinSize.height;
            }
        }
    }

    private void drawMarquee(Graphics graphics) {
        if (this.fCurrentPt != null) {
            int n = Math.min(this.fCurrentPt.x, this.fAnchorPt.x);
            int n2 = Math.min(this.fCurrentPt.y, this.fAnchorPt.y);
            int n3 = Math.abs(this.fCurrentPt.x - this.fAnchorPt.x);
            int n4 = Math.abs(this.fCurrentPt.y - this.fAnchorPt.y);
            switch (this.fDirection) {
                case MT_HANDLE: 
                case MB_HANDLE: {
                    n = this.fAnchorPt.x;
                    n3 = this.fControlSize.width;
                    break;
                }
                case ML_HANDLE: 
                case MR_HANDLE: {
                    n2 = this.fAnchorPt.y - this.fControlSize.height;
                    n4 = this.fControlSize.height;
                }
            }
            if (n3 > 1 && n4 > 1) {
                graphics.drawRect(n, n2, n3 - 1, n4 - 1);
            }
        }
    }
}

