/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.matlab.api.explorer;

import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.Predicate;
import java.util.List;
import java.util.Vector;
import java.util.regex.Pattern;

public class SearchCriteria
implements Predicate<FileSystemEntry> {
    private final List<Pattern> fPatterns;
    private final String fSimplePattern;
    private final String fSearchText;

    public SearchCriteria(String string) {
        this.fSearchText = string;
        this.fPatterns = new Vector<Pattern>();
        if (string != null) {
            StringBuffer stringBuffer = new StringBuffer();
            StringBuilder stringBuilder = new StringBuilder();
            int n = 0;
            while (n < string.length()) {
                int n2 = string.indexOf(42, n);
                if (n2 == n) {
                    stringBuffer.append(".*");
                    stringBuilder.append("*");
                    ++n;
                    continue;
                }
                if (n2 == -1) {
                    stringBuffer.append("\\Q");
                    stringBuffer.append(string.substring(n));
                    stringBuffer.append("\\E");
                    stringBuilder.append(string.substring(n));
                    n = string.length();
                    continue;
                }
                stringBuffer.append("\\Q");
                stringBuffer.append(string.substring(n, n2));
                stringBuffer.append("\\E.*");
                stringBuilder.append(string.substring(n, n2));
                stringBuilder.append("*");
                n = n2 + 1;
            }
            if (!string.equalsIgnoreCase("")) {
                if (!string.contains("*")) {
                    StringBuffer stringBuffer2 = new StringBuffer();
                    stringBuffer2.append(".*");
                    stringBuffer2.append(stringBuffer);
                    stringBuffer2.append(".*");
                    stringBuffer = stringBuffer2;
                    stringBuilder.insert(0, '*');
                    if (!stringBuilder.toString().equals("*")) {
                        stringBuilder.append('*');
                    }
                } else if (PlatformInfo.isWindows() && string.equals("*.*")) {
                    StringBuffer stringBuffer3 = new StringBuffer();
                    stringBuffer3.append(".*");
                    stringBuffer = stringBuffer3;
                }
            }
            this.fSimplePattern = stringBuilder.toString();
            this.fPatterns.add(Pattern.compile(stringBuffer.toString(), 2));
        } else {
            this.fSimplePattern = null;
        }
    }

    public boolean accept(FileSystemEntry fileSystemEntry) {
        if (this.fPatterns.isEmpty()) {
            return true;
        }
        for (Pattern pattern : this.fPatterns) {
            if (!pattern.matcher(fileSystemEntry.getName()).matches()) continue;
            return true;
        }
        return false;
    }

    public String getSearchText() {
        return this.fSearchText;
    }

    public String getSimplePattern() {
        return this.fSimplePattern;
    }
}

