/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.index.microdata;

import com.mathworks.helpsearch.CategoryUtils;
import com.mathworks.helpsearch.ContentFormat;
import com.mathworks.helpsearch.InformationType;
import com.mathworks.helpsearch.ResultCategory;
import com.mathworks.helpsearch.index.DocumentationDocument;
import com.mathworks.helpsearch.index.IndexUtils;
import com.mathworks.helpsearch.index.classic.TocTypeMap;
import com.mathworks.helpsearch.index.doccenter.InfoTypeMap;
import com.mathworks.helpsearch.index.microdata.MicrodataItem;
import com.mathworks.helpsearch.product.DocProduct;
import com.mathworks.helpsearch.reference.ReferenceEntity;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;

public class MicrodataDocumentBuilder {
    private final ContentFormat fFormat;

    public MicrodataDocumentBuilder(ContentFormat format) {
        this.fFormat = format;
    }

    public void populateDocument(DocumentationDocument doc, MicrodataItem item) {
        List<ReferenceEntity> refEntities;
        String content;
        List<String> syntaxLines;
        String description;
        String purpose;
        String title = MicrodataDocumentBuilder.getStringProperty(item, "title");
        if (title != null && title.trim().length() > 0) {
            doc.setTitle(title);
        }
        if ((purpose = MicrodataDocumentBuilder.getStringProperty(item, "purpose")) != null && purpose.trim().length() > 0) {
            doc.setPageSummary(MicrodataDocumentBuilder.fixWhitespace(purpose));
        }
        if ((description = MicrodataDocumentBuilder.getStringProperty(item, "description")) != null && description.trim().length() > 0) {
            doc.setDescription(MicrodataDocumentBuilder.fixWhitespace(description));
        }
        if ((syntaxLines = item.getStringProperties().get("syntax")) != null && !syntaxLines.isEmpty()) {
            doc.addSyntaxLines(MicrodataDocumentBuilder.fixWhitespace(syntaxLines));
        }
        if ((content = MicrodataDocumentBuilder.getStringProperty(item, "content")) != null && content.trim().length() > 0) {
            doc.setBody(content);
        }
        this.determineInfoType(item, doc);
        List<ResultCategory> breadCrumbs = this.getBreadCrumbs(doc.getProduct(), doc.getRelativePath(), item);
        if (breadCrumbs != null && !breadCrumbs.isEmpty()) {
            doc.setBreadCrumbs(breadCrumbs);
        }
        if ((refEntities = this.getReferenceEntities(item)) != null) {
            doc.addReferenceEntities(refEntities);
        }
    }

    private void determineInfoType(MicrodataItem item, DocumentationDocument doc) {
        switch (this.fFormat) {
            case DOC_CENTER_DOC: {
                MicrodataDocumentBuilder.determineDocCenterInfoType(item, doc);
                break;
            }
            case CLASSIC_DOC: {
                doc.setType(MicrodataDocumentBuilder.determineClassicDocInfoType(item));
            }
        }
    }

    private static void determineDocCenterInfoType(MicrodataItem item, DocumentationDocument doc) {
        List<String> typeStrings = item.getStringProperties().get("infotype");
        String pageType = MicrodataDocumentBuilder.getStringProperty(item, "pagetype");
        if (MicrodataDocumentBuilder.isFeaturedExample(doc.getRelativePath(), typeStrings, pageType)) {
            doc.setIgnoreForCategoryFacet(true);
            doc.setType(InformationType.EXAMPLES_HOWTO);
            return;
        }
        if (typeStrings == null) {
            return;
        }
        typeStrings = MicrodataDocumentBuilder.expandSpaceDelimitedTypes(typeStrings);
        doc.setInfoTypeStrings(typeStrings);
        InformationType infoType = InfoTypeMap.mapInfoType(typeStrings);
        doc.setType(infoType);
    }

    private static boolean isFeaturedExample(String relPath, List<String> infoTypeStrings, String pageType) {
        if (pageType != null && pageType.equals("fe")) {
            return relPath.matches("^/?examples/index.html.*$") || infoTypeStrings.contains("ug");
        }
        return false;
    }

    private static List<String> expandSpaceDelimitedTypes(List<String> typeStrings) {
        LinkedList<String> allInfoTypes = new LinkedList<String>();
        for (String typeString : typeStrings) {
            allInfoTypes.addAll(Arrays.asList(typeString.split("\\s+")));
        }
        return allInfoTypes;
    }

    private static InformationType determineClassicDocInfoType(MicrodataItem item) {
        String pageType = MicrodataDocumentBuilder.getStringProperty(item, "pagetype");
        return TocTypeMap.mapTocType(pageType);
    }

    private List<ResultCategory> getBreadCrumbs(DocProduct product, String docPath, MicrodataItem item) {
        String[] docDirs = docPath == null ? new String[]{} : IndexUtils.getDirectoriesForFilePath(docPath);
        List<MicrodataItem> breadcrumbItems = item.getItemProperties().get("breadcrumb");
        if (breadcrumbItems != null) {
            ResultCategory current = null;
            for (MicrodataItem breadcrumb : breadcrumbItems) {
                String title = MicrodataDocumentBuilder.getStringProperty(breadcrumb, "title");
                String url = MicrodataDocumentBuilder.getStringProperty(breadcrumb, "url");
                url = IndexUtils.resolveRelativePath(url, docDirs);
                if (title == null || title.trim().length() <= 0 || !IndexUtils.includeLinkInBreadCrumb(url)) continue;
                String id = CategoryUtils.createIdFromFilePath(product, url);
                current = new ResultCategory(current, title, url, id);
            }
            if (current != null) {
                LinkedList<ResultCategory> breadCrumbs = new LinkedList<ResultCategory>();
                breadCrumbs.add(current);
                return breadCrumbs;
            }
        }
        return null;
    }

    private static String getStringProperty(MicrodataItem item, String property) {
        List<String> values = item.getStringProperties().get(property);
        if (values != null) {
            StringBuilder stringValue = new StringBuilder();
            for (String value : values) {
                stringValue.append('\n').append(value);
            }
            if (stringValue.length() > 0) {
                stringValue.deleteCharAt(0);
            }
            return stringValue.toString();
        }
        return null;
    }

    private List<ReferenceEntity> getReferenceEntities(MicrodataItem item) {
        List<String> entities = item.getStringProperties().get("refentity");
        if (entities != null) {
            LinkedList<ReferenceEntity> entityList = new LinkedList<ReferenceEntity>();
            for (String entityStr : entities) {
                ReferenceEntity entity = ReferenceEntity.fromRefPageMetaData(entityStr);
                if (entity == null) continue;
                entityList.add(entity);
            }
            return entityList;
        }
        return null;
    }

    private static List<String> fixWhitespace(List<String> values) {
        LinkedList<String> fixed = new LinkedList<String>();
        for (String value : values) {
            String fixedValue = value == null ? null : MicrodataDocumentBuilder.fixWhitespace(value);
            fixed.add(fixedValue);
        }
        return fixed;
    }

    private static String fixWhitespace(String value) {
        return value.replaceAll("\\s+", " ");
    }
}

