/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.index.doccenter;

import com.mathworks.helpsearch.index.DocumentationDocument;
import com.mathworks.helpsearch.index.XmlFragmentHandler;
import com.mathworks.helpsearch.index.XmlFragmentReader;
import com.mathworks.helpsearch.index.XmlTagInfo;
import java.util.regex.Pattern;

class TitleFragmentHandler
implements XmlFragmentHandler,
XmlFragmentReader {
    private boolean fTitleTagFound = false;
    private String fTitle = "";
    private static final Pattern TITLE_CLASS_PATTERN = Pattern.compile("r?20\\d\\d[ab]|(ref)?title");

    TitleFragmentHandler() {
    }

    @Override
    public String[] getEnclosingTagNames() {
        return new String[]{"div", "h1", "h2"};
    }

    @Override
    public boolean useHandler(XmlTagInfo xmlTag) {
        if (this.fTitleTagFound) {
            return false;
        }
        this.fTitleTagFound = this.isTitleTag(xmlTag);
        return this.fTitleTagFound;
    }

    private boolean isTitleTag(XmlTagInfo xmlTag) {
        String classAttribute;
        if (xmlTag.getTagName().equals("div")) {
            String id = xmlTag.getAttribute("id");
            return id != null && id.equals("contenttitle");
        }
        if ((xmlTag.getTagName().equals("h1") || xmlTag.getTagName().equals("h2")) && (classAttribute = xmlTag.getAttribute("class")) != null) {
            String[] htmlClasses;
            for (String htmlClass : htmlClasses = classAttribute.split("\\s")) {
                if (!TITLE_CLASS_PATTERN.matcher(htmlClass).matches()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean continueHandling() {
        return false;
    }

    @Override
    public void startElement(XmlTagInfo tagInfo) {
    }

    @Override
    public void characters(XmlTagInfo location, String chars) {
        this.fTitle = this.fTitle + chars;
    }

    @Override
    public void endElement(XmlTagInfo location) {
    }

    @Override
    public XmlFragmentReader startFragment(XmlTagInfo location) {
        return this;
    }

    @Override
    public void endFragment(XmlTagInfo location) {
    }

    private String getTitle() {
        return this.fTitle;
    }

    @Override
    public void populateDocument(DocumentationDocument doc) {
        if (doc.getTitle() == null) {
            doc.setTitle(this.getTitle());
        }
    }
}

