/*
 * Decompiled with CFR 0.152.
 */
package net.jini.jeri.ssl;

import com.sun.jini.jeri.internal.connection.BasicConnManagerFactory;
import com.sun.jini.jeri.internal.connection.ConnManager;
import com.sun.jini.jeri.internal.connection.ConnManagerFactory;
import com.sun.jini.jeri.internal.runtime.Util;
import com.sun.jini.logging.Levels;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.cert.CertPath;
import java.security.cert.X509Certificate;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.SocketFactory;
import javax.security.auth.Subject;
import javax.security.auth.x500.X500Principal;
import javax.security.auth.x500.X500PrivateCredential;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.io.UnsupportedConstraintException;
import net.jini.jeri.Endpoint;
import net.jini.jeri.OutboundRequest;
import net.jini.jeri.OutboundRequestIterator;
import net.jini.jeri.connection.Connection;
import net.jini.jeri.connection.ConnectionEndpoint;
import net.jini.jeri.connection.OutboundRequestHandle;
import net.jini.jeri.ssl.CallContext;
import net.jini.jeri.ssl.ConnectionContext;
import net.jini.jeri.ssl.SslConnection;
import net.jini.jeri.ssl.SubjectCredentials;
import net.jini.jeri.ssl.Utilities;
import net.jini.security.AuthenticationPermission;

class SslEndpointImpl
extends Utilities
implements ConnectionEndpoint {
    static final Logger logger;
    private static final Map connectionMgrs;
    private static final int CACHE_SIZE = 4;
    private static final ConnManagerFactory connectionManagerFactory;
    final Endpoint endpoint;
    final String serverHost;
    final int port;
    final SocketFactory socketFactory;
    boolean disableSocketConnect;
    private ConnectionContextCache[] connectionContextCache = new ConnectionContextCache[4];
    private int cacheNext;
    ConnManager connectionManager;
    static final /* synthetic */ boolean $assertionsDisabled;

    SslEndpointImpl(Endpoint endpoint, String string, int n, SocketFactory socketFactory) {
        this.endpoint = endpoint;
        if (string == null) {
            throw new NullPointerException("serverHost is null");
        }
        this.serverHost = string;
        if (n <= 0 || n > 65535) {
            throw new IllegalArgumentException("Invalid port: " + n);
        }
        this.port = n;
        this.socketFactory = socketFactory;
    }

    public String toString() {
        return SslEndpointImpl.getClassName(this) + this.fieldsToString();
    }

    final String fieldsToString() {
        return "[" + this.serverHost + ":" + this.port + (this.socketFactory != null ? ", " + this.socketFactory : "") + "]";
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this.serverHost.hashCode() ^ this.port ^ (this.socketFactory != null ? this.socketFactory.hashCode() : 0);
    }

    public boolean equals(Object object) {
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        SslEndpointImpl sslEndpointImpl = (SslEndpointImpl)object;
        return this.serverHost.equals(sslEndpointImpl.serverHost) && this.port == sslEndpointImpl.port && Util.sameClassAndEquals(this.socketFactory, sslEndpointImpl.socketFactory);
    }

    final OutboundRequestIterator newRequest(InvocationConstraints invocationConstraints) {
        if (invocationConstraints == null) {
            throw new NullPointerException("Constraints cannot be null");
        }
        try {
            return this.newRequest(this.getCallContext(invocationConstraints));
        }
        catch (UnsupportedConstraintException unsupportedConstraintException) {
            return new ExceptionOutboundRequestIterator(unsupportedConstraintException);
        }
        catch (SecurityException securityException) {
            return new ExceptionOutboundRequestIterator(securityException);
        }
    }

    OutboundRequestIterator newRequest(CallContext callContext) {
        return this.getConnectionManager().newRequest(callContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConnManager getConnectionManager() {
        Map map = connectionMgrs;
        synchronized (map) {
            if (this.connectionManager == null) {
                Reference reference = (Reference)connectionMgrs.get(this);
                ConnManager connManager = this.connectionManager = reference != null ? (ConnManager)reference.get() : null;
                if (this.connectionManager == null) {
                    this.connectionManager = connectionManagerFactory.create(this);
                    connectionMgrs.put(this, new WeakReference<ConnManager>(this.connectionManager));
                }
            }
            return this.connectionManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CallContext getCallContext(InvocationConstraints invocationConstraints) throws UnsupportedConstraintException {
        Collection<Principal> collection;
        final AccessControlContext accessControlContext = AccessController.getContext();
        Subject subject = (Subject)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Subject.getSubject(accessControlContext);
            }
        });
        Set<Object> set = SslEndpointImpl.getClientPrincipals(invocationConstraints.requirements());
        boolean bl = set != null;
        boolean bl2 = SslEndpointImpl.getServerPrincipals(invocationConstraints) != null;
        Boolean bl3 = null;
        if (!bl) {
            if (subject == null) {
                set = Collections.EMPTY_SET;
            } else {
                collection = subject.getPrincipals();
                synchronized (collection) {
                    set = subject.getPrincipals(X500Principal.class);
                }
            }
            if (set.isEmpty() && (bl3 = SslEndpointImpl.getSubjectPermitted()) == Boolean.FALSE) {
                set = Collections.singleton(UNKNOWN_PRINCIPAL);
            }
        }
        collection = new CopyOnRemoveList(this.getConnectionContexts(invocationConstraints, set));
        if (bl2) {
            try {
                collection = SslEndpointImpl.checkAuthenticationPermissions(collection);
            }
            catch (SecurityException securityException) {
                if (bl3 == null) {
                    bl3 = SslEndpointImpl.getSubjectPermitted();
                }
                if (bl3 == Boolean.TRUE) {
                    if (logger.isLoggable(Levels.FAILED)) {
                        SslEndpointImpl.logThrow(logger, Levels.FAILED, SslEndpointImpl.class, "getCallContext", "new request for {0}\nwith {1}\nand {2}\nthrows", new Object[]{this.endpoint, invocationConstraints, SslEndpointImpl.subjectString(subject)}, securityException);
                    }
                    throw securityException;
                }
                CallContext callContext = this.createCallContext(this.getConnectionContexts(invocationConstraints, Collections.singleton(UNKNOWN_PRINCIPAL)), null);
                if (logger.isLoggable(Levels.FAILED)) {
                    SslEndpointImpl.logThrow(logger, Levels.FAILED, SslEndpointImpl.class, "getCallContext", "new request for {0}\nwith {1}\nand {2}\nwill fail but cannot throw because caller has no subject access\nreturns {3}\ncaught exception", new Object[]{this.endpoint, invocationConstraints, SslEndpointImpl.subjectString(subject), callContext}, securityException);
                }
                return callContext;
            }
        }
        UnsupportedConstraintException unsupportedConstraintException = null;
        if (collection.isEmpty()) {
            unsupportedConstraintException = new UnsupportedConstraintException("Constraints not supported: " + invocationConstraints);
        } else {
            boolean bl4;
            if (bl2) {
                bl4 = true;
            } else {
                if (bl3 == null) {
                    bl3 = SslEndpointImpl.getSubjectPermitted();
                }
                boolean bl5 = bl4 = bl3 == Boolean.TRUE;
            }
            if (bl4) {
                try {
                    collection = SslEndpointImpl.checkSubject(collection, subject, bl2, invocationConstraints);
                }
                catch (UnsupportedConstraintException unsupportedConstraintException2) {
                    unsupportedConstraintException = unsupportedConstraintException2;
                }
            }
        }
        if (unsupportedConstraintException != null) {
            if (logger.isLoggable(Levels.FAILED)) {
                SslEndpointImpl.logThrow(logger, Levels.FAILED, SslEndpointImpl.class, "getCallContext", "new request for {0}\nwith {1}\nand {2}\nthrows", new Object[]{this.endpoint, invocationConstraints, SslEndpointImpl.subjectString(subject)}, unsupportedConstraintException);
            }
            throw unsupportedConstraintException;
        }
        CallContext callContext = this.createCallContext((List)collection, subject);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "new request for {0}\nwith {1}\nand {2}\nreturns {3}", new Object[]{this.endpoint, invocationConstraints, SslEndpointImpl.subjectString(subject), callContext});
        }
        return callContext;
    }

    private CallContext createCallContext(List list, Subject subject) {
        boolean bl = true;
        boolean bl2 = false;
        HashSet<Principal> hashSet = null;
        HashSet<Principal> hashSet2 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl3 = false;
        boolean bl4 = false;
        long l = -1L;
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            ConnectionContext connectionContext = (ConnectionContext)list.get(i);
            if (connectionContext.client == null) {
                bl = false;
            } else {
                bl2 = true;
                if (hashSet == null) {
                    hashSet = new HashSet<Principal>();
                }
                if (connectionContext.client != UNKNOWN_PRINCIPAL) {
                    hashSet.add(connectionContext.client);
                }
            }
            if (connectionContext.server != null && connectionContext.server != UNKNOWN_PRINCIPAL) {
                if (hashSet2 == null) {
                    hashSet2 = new HashSet<Principal>();
                }
                hashSet2.add(connectionContext.server);
            }
            if (!arrayList.contains(connectionContext.cipherSuite)) {
                arrayList.add(connectionContext.cipherSuite);
            }
            if (connectionContext.getIntegrityRequired()) {
                bl3 = true;
            } else if (connectionContext.getIntegrityPreferred()) {
                bl4 = true;
            }
            if (connectionContext.getConnectionTime() == -1L || l != -1L && l <= connectionContext.getConnectionTime()) continue;
            l = connectionContext.getConnectionTime();
        }
        return new CallContext(this.endpoint, this, bl2 ? subject : null, bl, hashSet, hashSet2, arrayList, bl3, bl4, l);
    }

    private static List checkSubject(List list, Subject subject, boolean bl, InvocationConstraints invocationConstraints) throws UnsupportedConstraintException {
        Map map = SslEndpointImpl.getPublicCredentials(subject);
        X500PrivateCredential[] x500PrivateCredentialArray = subject != null && bl ? (X500PrivateCredential[])AccessController.doPrivileged(new SubjectCredentials.GetAllPrivateCredentialsAction(subject)) : new X500PrivateCredential[]{};
        HashSet<Principal> hashSet = new HashSet<Principal>();
        HashSet<Principal> hashSet2 = new HashSet<Principal>();
        int n = list.size();
        block0: while (--n >= 0) {
            ConnectionContext connectionContext = (ConnectionContext)list.get(n);
            if (connectionContext.client == null) continue;
            Collection collection = (Collection)map.get(connectionContext.client);
            if (collection == null) {
                logger.log(Levels.HANDLED, "missing principal or public credentials: {0}", connectionContext.client);
                list.remove(n);
                hashSet.add(connectionContext.client);
                continue;
            }
            if (!bl) continue;
            int n2 = x500PrivateCredentialArray.length;
            while (--n2 >= 0) {
                X509Certificate x509Certificate = x500PrivateCredentialArray[n2].getCertificate();
                if (x509Certificate == null || !collection.contains(x509Certificate)) continue;
                continue block0;
            }
            logger.log(Levels.HANDLED, "missing private credentials: {0}", connectionContext.client);
            list.remove(n);
            hashSet2.add(connectionContext.client);
        }
        if (!list.isEmpty()) {
            return list;
        }
        throw new UnsupportedConstraintException("Constraints not supported: " + invocationConstraints + ";" + (hashSet.isEmpty() ? "" : "\nmissing principals or public credentials: " + hashSet) + (hashSet2.isEmpty() ? "" : "\nmissing private credentials: " + hashSet2));
    }

    private static Boolean getSubjectPermitted() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            try {
                securityManager.checkPermission(getSubjectPermission);
            }
            catch (SecurityException securityException) {
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }

    private static List checkAuthenticationPermissions(List list) {
        if (list.isEmpty()) {
            return list;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return list;
        }
        HashMap<AuthenticationPermission, Boolean> hashMap = new HashMap<AuthenticationPermission, Boolean>();
        HashSet<SecurityException> hashSet = new HashSet<SecurityException>();
        int n = list.size();
        while (--n >= 0) {
            ConnectionContext connectionContext = (ConnectionContext)list.get(n);
            if (connectionContext.client == null) continue;
            if (connectionContext.server == UNKNOWN_PRINCIPAL) break;
            AuthenticationPermission authenticationPermission = new AuthenticationPermission(Collections.singleton(connectionContext.client), Collections.singleton(connectionContext.server), "connect");
            Object v = hashMap.get(authenticationPermission);
            if (Boolean.FALSE.equals(v)) {
                list.remove(n);
                continue;
            }
            if (Boolean.TRUE.equals(v)) continue;
            try {
                securityManager.checkPermission(authenticationPermission);
                hashMap.put(authenticationPermission, Boolean.TRUE);
            }
            catch (SecurityException securityException) {
                logger.log(Levels.HANDLED, "check authentication permission caught exception", securityException);
                hashMap.put(authenticationPermission, Boolean.FALSE);
                hashSet.add(securityException);
                list.remove(n);
            }
        }
        if (!list.isEmpty()) {
            return list;
        }
        if (hashSet.size() == 1) {
            throw (SecurityException)hashSet.iterator().next();
        }
        throw new SecurityException(((Object)hashSet).toString());
    }

    private static Map getPublicCredentials(Subject subject) {
        HashMap<X500Principal, ArrayList<X509Certificate>> hashMap = new HashMap<X500Principal, ArrayList<X509Certificate>>();
        List list = SubjectCredentials.getCertificateChains(subject);
        if (list != null) {
            int n = list.size();
            while (--n >= 0) {
                CertPath certPath = (CertPath)list.get(n);
                X509Certificate x509Certificate = SubjectCredentials.firstX509Cert(certPath);
                X500Principal x500Principal = SubjectCredentials.getPrincipal(subject, x509Certificate);
                if (x500Principal == null) continue;
                ArrayList<X509Certificate> arrayList = (ArrayList<X509Certificate>)hashMap.get(x500Principal);
                if (arrayList == null) {
                    arrayList = new ArrayList<X509Certificate>(1);
                    hashMap.put(x500Principal, arrayList);
                }
                arrayList.add(x509Certificate);
            }
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List getConnectionContexts(InvocationConstraints invocationConstraints, Set set) {
        Object object = this.connectionContextCache;
        synchronized (this.connectionContextCache) {
            ConnectionContextCache[] connectionContextCacheArray;
            int n = 4;
            while (--n >= 0) {
                connectionContextCacheArray = this.connectionContextCache[n];
                if (connectionContextCacheArray == null || !connectionContextCacheArray.constraints.equals(invocationConstraints) || !((Object)connectionContextCacheArray.clientPrincipals).equals(set)) continue;
                logger.log(Level.FINEST, "used connection cache");
                // ** MonitorExit[var3_3 /* !! */ ] (shouldn't be in output)
                return connectionContextCacheArray.connectionContexts;
            }
            // ** MonitorExit[var3_3 /* !! */ ] (shouldn't be in output)
            object = SslEndpointImpl.getServerPrincipals(invocationConstraints);
            if (object == null) {
                object = Collections.singleton(UNKNOWN_PRINCIPAL);
            }
            List list = Collections.unmodifiableList(SslEndpointImpl.computeConnectionContexts(SslEndpointImpl.getSupportedCipherSuites(), set, (Set)object, invocationConstraints));
            connectionContextCacheArray = this.connectionContextCache;
            synchronized (this.connectionContextCache) {
                this.connectionContextCache[this.cacheNext] = new ConnectionContextCache(invocationConstraints, set, list);
                if (this.cacheNext == 0) {
                    this.cacheNext = 4;
                }
                --this.cacheNext;
                // ** MonitorExit[var5_6] (shouldn't be in output)
                return list;
            }
        }
    }

    private static List computeConnectionContexts(String[] stringArray, Set set, Set set2, InvocationConstraints invocationConstraints) {
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>(stringArray.length * (set.size() + 1) * (set2.size() + 1));
        int n = stringArray.length;
        while (--n >= 0) {
            Principal principal;
            object = stringArray[n];
            Iterator iterator = set.iterator();
            do {
                Principal principal2;
                if (iterator.hasNext()) {
                    principal = (Principal)iterator.next();
                    if (!$assertionsDisabled && principal == null) {
                        throw new AssertionError();
                    }
                } else {
                    principal = null;
                }
                Iterator iterator2 = set2.iterator();
                do {
                    if (iterator2.hasNext()) {
                        principal2 = (Principal)iterator2.next();
                        if (!$assertionsDisabled && principal2 == null) {
                            throw new AssertionError();
                        }
                    } else {
                        principal2 = null;
                    }
                    int n2 = 2;
                    while (--n2 >= 0) {
                        boolean bl = n2 == 0;
                        ConnectionContext connectionContext = ConnectionContext.getInstance((String)object, principal, principal2, bl, true, invocationConstraints);
                        if (connectionContext == null) continue;
                        arrayList.add(new ComparableConnectionContext(connectionContext, n));
                    }
                } while (principal2 != null);
            } while (principal != null);
        }
        Collections.sort(arrayList);
        logger.log(Level.FINEST, "compute connection contexts produces {0}", arrayList);
        n = arrayList.size();
        while (--n >= 0) {
            object = (ComparableConnectionContext)arrayList.get(n);
            arrayList.set(n, ((ComparableConnectionContext)object).context);
        }
        return arrayList;
    }

    public Connection connect(OutboundRequestHandle outboundRequestHandle) throws IOException {
        SslConnection sslConnection = new SslConnection(CallContext.coerce(outboundRequestHandle, this.endpoint), this.serverHost, this.port, this.socketFactory);
        sslConnection.establishCallContext();
        return sslConnection;
    }

    public Connection connect(OutboundRequestHandle outboundRequestHandle, Collection collection, Collection collection2) {
        CallContext callContext = CallContext.coerce(outboundRequestHandle, this.endpoint);
        if (collection == null || collection2 == null) {
            throw new NullPointerException("Arguments cannot be null");
        }
        SslConnection sslConnection = null;
        ConnectionsIterator connectionsIterator = new ConnectionsIterator(this.endpoint, collection, collection2);
        while (connectionsIterator.hasNext()) {
            SslConnection sslConnection2 = (SslConnection)connectionsIterator.next();
            if (!sslConnection2.useFor(callContext)) continue;
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                try {
                    securityManager.checkConnect(this.serverHost, this.port);
                }
                catch (SecurityException securityException) {
                    if (logger.isLoggable(Levels.FAILED)) {
                        SslEndpointImpl.logThrow(logger, Levels.FAILED, SslEndpointImpl.class, "connect", "choose connection for {0}\nthrows", new Object[]{this}, securityException);
                    }
                    throw securityException;
                }
            }
            sslConnection = sslConnection2;
            break;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "choose connection for {0}\nwith active {1}\nand idle {2}\nreturns {3}", new Object[]{outboundRequestHandle, collection, collection2, sslConnection});
        }
        return sslConnection;
    }

    static {
        $assertionsDisabled = !SslEndpointImpl.class.desiredAssertionStatus();
        logger = clientLogger;
        connectionMgrs = new WeakHashMap();
        connectionManagerFactory = new BasicConnManagerFactory();
    }

    private static final class ConnectionsIterator
    implements Iterator {
        private final Endpoint endpoint;
        private Collection active;
        private final Collection idle;
        private Iterator iter;

        ConnectionsIterator(Endpoint endpoint, Collection collection, Collection collection2) {
            this.endpoint = endpoint;
            this.active = collection;
            this.idle = collection2;
            this.iter = collection.iterator();
            if (!this.iter.hasNext()) {
                this.active = null;
                this.iter = collection2.iterator();
            }
        }

        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object e = this.iter.next();
            if (e == null) {
                throw new NullPointerException("Connection cannot be null");
            }
            if (!(e instanceof SslConnection)) {
                throw new IllegalArgumentException("Connection must be of type SslConnection: " + e);
            }
            SslConnection sslConnection = (SslConnection)e;
            if (!this.endpoint.equals(sslConnection.callContext.endpoint)) {
                throw new IllegalArgumentException("Connection has wrong endpoint: found " + sslConnection.callContext.endpoint + ", expected " + this.endpoint);
            }
            if (!this.iter.hasNext() && this.active != null) {
                this.active = null;
                this.iter = this.idle.iterator();
            }
            return sslConnection;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class ComparableConnectionContext
    implements Comparable {
        final ConnectionContext context;
        private final int suiteIndex;

        ComparableConnectionContext(ConnectionContext connectionContext, int n) {
            this.context = connectionContext;
            this.suiteIndex = n;
        }

        public int compareTo(Object object) {
            ComparableConnectionContext comparableConnectionContext = (ComparableConnectionContext)object;
            int n = comparableConnectionContext.context.getPreferences() - this.context.getPreferences();
            if (n == 0) {
                n = this.suiteIndex - comparableConnectionContext.suiteIndex;
            }
            return n;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("ComparableConnectionContext[");
            this.context.fieldsToString(stringBuffer);
            stringBuffer.append(", index: ").append(this.suiteIndex);
            stringBuffer.append("]");
            return stringBuffer.toString();
        }
    }

    private static final class ConnectionContextCache {
        final InvocationConstraints constraints;
        final Set clientPrincipals;
        final List connectionContexts;

        ConnectionContextCache(InvocationConstraints invocationConstraints, Set set, List list) {
            this.constraints = invocationConstraints;
            this.clientPrincipals = set;
            this.connectionContexts = list;
        }
    }

    private static final class CopyOnRemoveList
    extends AbstractList {
        private List list;
        private boolean modified;

        CopyOnRemoveList(List list) {
            this.list = list;
        }

        public Object get(int n) {
            return this.list.get(n);
        }

        public int size() {
            return this.list.size();
        }

        public Object remove(int n) {
            if (!this.modified) {
                this.list = new ArrayList(this.list);
                this.modified = true;
            }
            return this.list.remove(n);
        }
    }

    private static final class ExceptionOutboundRequestIterator
    implements OutboundRequestIterator {
        private final Exception exception;
        private boolean done = false;

        ExceptionOutboundRequestIterator(Exception exception) {
            this.exception = exception;
        }

        public synchronized boolean hasNext() {
            return !this.done;
        }

        public synchronized OutboundRequest next() throws IOException {
            if (this.done) {
                throw new NoSuchElementException();
            }
            this.done = true;
            if (this.exception instanceof SecurityException) {
                throw (SecurityException)this.exception;
            }
            throw (IOException)this.exception;
        }
    }
}

