/*
 * Decompiled with CFR 0.152.
 */
package net.jini.jeri.connection;

import com.sun.jini.action.GetLongAction;
import com.sun.jini.jeri.internal.mux.MuxClient;
import com.sun.jini.thread.Executor;
import com.sun.jini.thread.GetThreadPoolAction;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.jeri.OutboundRequest;
import net.jini.jeri.OutboundRequestIterator;
import net.jini.jeri.connection.Connection;
import net.jini.jeri.connection.ConnectionEndpoint;
import net.jini.jeri.connection.OutboundRequestHandle;

public final class ConnectionManager {
    private static final long TIMEOUT;
    private static final Logger logger;
    private static final Executor systemThreadPool;
    private final ConnectionEndpoint ep;
    private final List muxes = new ArrayList(1);
    private final List active = new ArrayList(1);
    private final Collection roactive = Collections.unmodifiableCollection(this.active);
    private final List idle = new ArrayList(1);
    private final Collection roidle = Collections.unmodifiableCollection(this.idle);
    private int pendingConnects = 0;
    private Reaper reaper = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ConnectionManager(ConnectionEndpoint connectionEndpoint) {
        this.ep = connectionEndpoint;
    }

    synchronized void connectPending() {
        ++this.pendingConnects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    OutboundMux connect(OutboundRequestHandle outboundRequestHandle) throws IOException {
        Object object;
        block28: {
            OutboundMux outboundMux;
            block27: {
                ConnectionManager connectionManager;
                OutboundMux outboundMux2;
                block26: {
                    try {
                        Object object2;
                        Object object3 = this;
                        synchronized (object3) {
                            this.active.clear();
                            this.idle.clear();
                            int n = this.muxes.size();
                            while (--n >= 0) {
                                object = (OutboundMux)this.muxes.get(n);
                                try {
                                    int n2 = ((OutboundMux)object).requestsInProgress();
                                    if (n2 == 0) {
                                        this.idle.add(((OutboundMux)object).getConnection());
                                        continue;
                                    }
                                    if (n2 >= 128) continue;
                                    this.active.add(((OutboundMux)object).getConnection());
                                }
                                catch (IOException iOException) {
                                    this.muxes.remove(n);
                                }
                            }
                            object2 = this.ep.connect(outboundRequestHandle, this.roactive, this.roidle);
                            if (object2 != null) {
                                int n3 = this.muxes.size();
                                while (--n3 >= 0) {
                                    OutboundMux outboundMux3 = (OutboundMux)this.muxes.get(n3);
                                    if (object2 != outboundMux3.getConnection()) continue;
                                    if (logger.isLoggable(Level.FINEST)) {
                                        logger.log(Level.FINEST, "using {0}", object2);
                                    }
                                    outboundMux3.newRequestPending();
                                    outboundMux2 = outboundMux3;
                                    // MONITOREXIT @DISABLED, blocks:[0, 16, 7, 25] lbl33 : MonitorExitStatement: MONITOREXIT : var2_2
                                    Object var10_13 = null;
                                    connectionManager = this;
                                    break block26;
                                }
                                OutboundMux outboundMux4 = OutboundMux.create((Connection)object2);
                                outboundMux4.newRequestPending();
                                if (this.reaper == null) {
                                    this.reaper = new Reaper();
                                    systemThreadPool.execute(this.reaper, "ConnectionManager[" + this.ep + "].Reaper");
                                }
                                this.muxes.add(outboundMux4);
                                outboundMux = outboundMux4;
                                // MONITOREXIT @DISABLED, blocks:[0, 7, 25] lbl46 : MonitorExitStatement: MONITOREXIT : var2_2
                                break block27;
                            }
                        }
                        object3 = this.ep.connect(outboundRequestHandle);
                        object2 = OutboundMux.create((Connection)object3);
                        ((OutboundMux)object2).newRequestPending();
                        object = this;
                        synchronized (object) {
                            if (this.reaper == null) {
                                this.reaper = new Reaper();
                                systemThreadPool.execute(this.reaper, "ConnectionManager[" + this.ep + "].Reaper");
                            }
                            this.muxes.add(object2);
                        }
                        object = object2;
                        break block28;
                    }
                    catch (Throwable throwable) {
                        Object var10_16 = null;
                        ConnectionManager connectionManager2 = this;
                        synchronized (connectionManager2) {
                            if (!$assertionsDisabled && this.pendingConnects <= 0) {
                                throw new AssertionError();
                            }
                            --this.pendingConnects;
                            throw throwable;
                        }
                    }
                }
                synchronized (connectionManager) {
                    if (!$assertionsDisabled && this.pendingConnects <= 0) {
                        throw new AssertionError();
                    }
                    --this.pendingConnects;
                    return outboundMux2;
                }
            }
            Object var10_14 = null;
            ConnectionManager connectionManager = this;
            synchronized (connectionManager) {
                if (!$assertionsDisabled && this.pendingConnects <= 0) {
                    throw new AssertionError();
                }
                --this.pendingConnects;
                return outboundMux;
            }
        }
        Object var10_15 = null;
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            if (!$assertionsDisabled && this.pendingConnects <= 0) {
                throw new AssertionError();
            }
            --this.pendingConnects;
            return object;
        }
    }

    synchronized boolean checkIdle(long l, List list) {
        int n = this.muxes.size();
        while (--n >= 0) {
            OutboundMux outboundMux = (OutboundMux)this.muxes.get(n);
            if (!outboundMux.checkIdle(l)) continue;
            this.muxes.remove(n);
            list.add(outboundMux);
        }
        return this.pendingConnects == 0 && this.muxes.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(OutboundMux outboundMux) {
        ConnectionManager connectionManager = this;
        synchronized (connectionManager) {
            this.muxes.remove(outboundMux);
        }
        outboundMux.shutdown("writeRequestData failed");
    }

    public OutboundRequestIterator newRequest(OutboundRequestHandle outboundRequestHandle) {
        return new ReqIterator(outboundRequestHandle);
    }

    static {
        $assertionsDisabled = !ConnectionManager.class.desiredAssertionStatus();
        TIMEOUT = (Long)AccessController.doPrivileged(new GetLongAction("com.sun.jini.jeri.connectionTimeout", 15000L));
        logger = Logger.getLogger("net.jini.jeri.connection.ConnectionManager");
        systemThreadPool = (Executor)AccessController.doPrivileged(new GetThreadPoolAction(false));
    }

    private final class ReqIterator
    implements OutboundRequestIterator {
        private final OutboundRequestHandle handle;
        private boolean first = true;
        private OutboundMux mux;

        ReqIterator(OutboundRequestHandle outboundRequestHandle) {
            this.handle = outboundRequestHandle;
        }

        public synchronized boolean hasNext() {
            return this.first || this.mux != null && this.mux.shouldRetry();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized OutboundRequest next() throws IOException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.first = false;
            this.mux = null;
            ConnectionManager.this.connectPending();
            this.mux = ConnectionManager.this.connect(this.handle);
            OutboundRequest outboundRequest = this.mux.newRequest();
            Outbound outbound = null;
            try {
                Connection connection = this.mux.getConnection();
                connection.writeRequestData(this.handle, outboundRequest.getRequestOutputStream());
                outbound = new Outbound(outboundRequest, connection, this.handle);
                Object var5_4 = null;
                if (outbound == null) {
                    ConnectionManager.this.remove(this.mux);
                }
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (outbound == null) {
                    ConnectionManager.this.remove(this.mux);
                }
                throw throwable;
            }
            return outbound;
        }
    }

    private final class Reaper
    implements Runnable {
        Reaper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean bl;
            ArrayList arrayList = new ArrayList(1);
            do {
                try {
                    Thread.sleep(TIMEOUT);
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
                long l = System.currentTimeMillis();
                ConnectionManager connectionManager = ConnectionManager.this;
                synchronized (connectionManager) {
                    ConnectionManager.this.checkIdle(l, arrayList);
                    bl = ConnectionManager.this.muxes.isEmpty();
                    if (bl) {
                        ConnectionManager.this.reaper = null;
                    }
                }
                int n = arrayList.size();
                while (--n >= 0) {
                    ((OutboundMux)arrayList.get(n)).shutdown("idle");
                }
                arrayList.clear();
            } while (!bl);
        }
    }

    private static final class Outbound
    implements OutboundRequest {
        private final OutboundRequest req;
        private final Connection c;
        private final OutboundRequestHandle handle;
        private final InputStream in;
        private boolean status = true;

        Outbound(OutboundRequest outboundRequest, Connection connection, OutboundRequestHandle outboundRequestHandle) {
            this.req = outboundRequest;
            this.c = connection;
            this.handle = outboundRequestHandle;
            this.in = new Input(outboundRequestHandle);
        }

        public OutputStream getRequestOutputStream() {
            return this.req.getRequestOutputStream();
        }

        public InputStream getResponseInputStream() {
            return this.in;
        }

        public void populateContext(Collection collection) {
            this.c.populateContext(this.handle, collection);
        }

        public InvocationConstraints getUnfulfilledConstraints() {
            return this.c.getUnfulfilledConstraints(this.handle);
        }

        public boolean getDeliveryStatus() {
            return this.status && this.req.getDeliveryStatus();
        }

        public void abort() {
            this.req.abort();
        }

        private final class Input
        extends InputStream {
            private final InputStream in;
            private OutboundRequestHandle handle;

            Input(OutboundRequestHandle outboundRequestHandle) {
                this.in = Outbound.this.req.getResponseInputStream();
                this.handle = outboundRequestHandle;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private synchronized void readFirst() throws IOException {
                if (this.handle != null) {
                    try {
                        IOException iOException = Outbound.this.c.readResponseData(this.handle, this.in);
                        if (iOException != null) {
                            Outbound.this.status = false;
                            throw iOException;
                        }
                        Object var3_2 = null;
                        this.handle = null;
                    }
                    catch (Throwable throwable) {
                        Object var3_3 = null;
                        this.handle = null;
                        throw throwable;
                    }
                }
            }

            public int read() throws IOException {
                this.readFirst();
                return this.in.read();
            }

            public int read(byte[] byArray, int n, int n2) throws IOException {
                this.readFirst();
                return this.in.read(byArray, n, n2);
            }

            public long skip(long l) throws IOException {
                this.readFirst();
                return this.in.skip(l);
            }

            public int available() throws IOException {
                this.readFirst();
                return this.in.available();
            }

            public void close() throws IOException {
                this.in.close();
            }
        }
    }

    private static final class OutboundMux
    extends MuxClient {
        private final Connection c;
        private boolean pendingStart = true;
        private int pendingNewRequests = 0;
        private long idleTime = 0L;
        static final /* synthetic */ boolean $assertionsDisabled;

        private OutboundMux(Connection connection) throws IOException {
            super(connection.getOutputStream(), connection.getInputStream());
            this.c = connection;
        }

        private OutboundMux(Connection connection, boolean bl) throws IOException {
            super(connection.getChannel());
            this.c = connection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static OutboundMux create(Connection connection) throws IOException {
            logger.log(Level.FINEST, "opened {0}", connection);
            OutboundMux outboundMux = null;
            try {
                outboundMux = connection.getChannel() == null ? new OutboundMux(connection) : new OutboundMux(connection, true);
                Object var3_2 = null;
                if (outboundMux != null) return outboundMux;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                if (outboundMux != null) throw throwable;
                try {
                    connection.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                connection.close();
                return outboundMux;
            }
            catch (IOException iOException) {}
            return outboundMux;
        }

        Connection getConnection() {
            return this.c;
        }

        synchronized void newRequestPending() {
            ++this.pendingNewRequests;
        }

        public synchronized OutboundRequest newRequest() throws IOException {
            if (!$assertionsDisabled && this.pendingNewRequests <= 0) {
                throw new AssertionError();
            }
            --this.pendingNewRequests;
            if (this.pendingStart) {
                this.pendingStart = false;
                this.start();
            }
            this.idleTime = 0L;
            return super.newRequest();
        }

        public synchronized int requestsInProgress() throws IOException {
            return super.requestsInProgress() + this.pendingNewRequests;
        }

        synchronized boolean checkIdle(long l) {
            try {
                if (this.requestsInProgress() == 0) {
                    if (this.idleTime == 0L) {
                        this.idleTime = l;
                    } else {
                        return l - this.idleTime > TIMEOUT;
                    }
                }
                return false;
            }
            catch (IOException iOException) {
                return true;
            }
        }

        protected void handleDown() {
            try {
                this.c.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        boolean shouldRetry() {
            return false;
        }

        static {
            $assertionsDisabled = !(class$net$jini$jeri$connection$ConnectionManager == null ? (class$net$jini$jeri$connection$ConnectionManager = ConnectionManager.class$("net.jini.jeri.connection.ConnectionManager")) : class$net$jini$jeri$connection$ConnectionManager).desiredAssertionStatus();
        }
    }
}

