/*
 * Decompiled with CFR 0.152.
 */
package net.jini.jeri;

import com.sun.jini.jeri.internal.runtime.DgcClient;
import com.sun.jini.jeri.internal.runtime.Util;
import java.io.EOFException;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectInputValidation;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.id.Uuid;
import net.jini.io.ObjectStreamContext;
import net.jini.io.context.AcknowledgmentSource;
import net.jini.jeri.Endpoint;
import net.jini.jeri.ObjectEndpoint;
import net.jini.jeri.OutboundRequest;
import net.jini.jeri.OutboundRequestIterator;
import net.jini.security.proxytrust.TrustEquivalence;

public final class BasicObjectEndpoint
implements ObjectEndpoint,
TrustEquivalence,
Serializable {
    private static final long serialVersionUID = 3235008605817758127L;
    private static final DgcClient dgcClient = new DgcClient();
    private static final Map streamBatches = new WeakHashMap(11);
    private final Endpoint ep;
    private final Uuid id;
    private final boolean dgc;
    private transient Object impl;

    public BasicObjectEndpoint(Endpoint endpoint, Uuid uuid, boolean bl) {
        if (endpoint == null) {
            throw new NullPointerException("null endpoint");
        }
        if (uuid == null) {
            throw new NullPointerException("null object identifier");
        }
        this.ep = endpoint;
        this.id = uuid;
        this.dgc = bl;
        if (this.dgc) {
            dgcClient.registerRefs(endpoint, Collections.singleton(this));
        }
    }

    BasicObjectEndpoint(Endpoint endpoint, Uuid uuid, boolean bl, Object object) {
        this.ep = endpoint;
        this.id = uuid;
        this.dgc = bl;
        if (this.dgc) {
            this.impl = object;
        }
    }

    public OutboundRequestIterator newCall(InvocationConstraints invocationConstraints) {
        final OutboundRequestIterator outboundRequestIterator = this.ep.newRequest(invocationConstraints);
        return new OutboundRequestIterator(){

            public boolean hasNext() {
                return outboundRequestIterator.hasNext();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public OutboundRequest next() throws IOException {
                OutboundRequest outboundRequest = outboundRequestIterator.next();
                boolean bl = false;
                try {
                    BasicObjectEndpoint.this.id.write(outboundRequest.getRequestOutputStream());
                    bl = true;
                    Object var4_3 = null;
                    if (!bl) {
                        outboundRequest.abort();
                    }
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    if (!bl) {
                        outboundRequest.abort();
                    }
                    throw throwable;
                }
                return outboundRequest;
            }
        };
    }

    public RemoteException executeCall(OutboundRequest outboundRequest) throws IOException {
        int n = outboundRequest.getResponseInputStream().read();
        switch (n) {
            case -1: {
                throw new EOFException();
            }
            case 0: {
                return new NoSuchObjectException("no such object in table");
            }
            case 1: {
                return null;
            }
        }
        return new UnmarshalException("unexpected invocation status: " + Integer.toHexString(n));
    }

    public Endpoint getEndpoint() {
        return this.ep;
    }

    public Uuid getObjectIdentifier() {
        return this.id;
    }

    public boolean getEnableDGC() {
        return this.dgc;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof BasicObjectEndpoint)) {
            return false;
        }
        BasicObjectEndpoint basicObjectEndpoint = (BasicObjectEndpoint)object;
        return this.id.equals(basicObjectEndpoint.id) && this.dgc == basicObjectEndpoint.dgc && Util.sameClassAndEquals(this.ep, basicObjectEndpoint.ep);
    }

    public boolean checkTrustEquivalence(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof BasicObjectEndpoint)) {
            return false;
        }
        BasicObjectEndpoint basicObjectEndpoint = (BasicObjectEndpoint)object;
        return this.id.equals(basicObjectEndpoint.id) && this.dgc == basicObjectEndpoint.dgc && Util.checkTrustEquivalence(this.ep, basicObjectEndpoint.ep);
    }

    public String toString() {
        return "BasicObjectEndpoint[" + (this.dgc ? "DGC," : "") + this.id + "," + this.ep + "]";
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.dgc && objectOutputStream instanceof ObjectStreamContext) {
            Collection collection = ((ObjectStreamContext)((Object)objectOutputStream)).getObjectStreamContext();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!(e instanceof AcknowledgmentSource)) continue;
                AcknowledgmentSource acknowledgmentSource = (AcknowledgmentSource)e;
                acknowledgmentSource.addAcknowledgmentListener(new AckListener(this));
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.ep == null) {
            throw new InvalidObjectException("null endpoint");
        }
        if (this.id == null) {
            throw new InvalidObjectException("null object identifier");
        }
        if (this.dgc) {
            DgcBatchContext dgcBatchContext;
            Map map = streamBatches;
            synchronized (map) {
                dgcBatchContext = (DgcBatchContext)streamBatches.get(objectInputStream);
                if (dgcBatchContext == null) {
                    dgcBatchContext = new DgcBatchContext();
                    try {
                        objectInputStream.registerValidation(dgcBatchContext, 0);
                    }
                    catch (InvalidObjectException invalidObjectException) {
                        throw new AssertionError();
                    }
                    streamBatches.put(objectInputStream, dgcBatchContext);
                }
            }
            dgcBatchContext.addLiveRef(this);
        }
    }

    private static class DgcBatchContext
    implements ObjectInputValidation {
        private final Map endpointTable = new HashMap(3);

        DgcBatchContext() {
        }

        void addLiveRef(BasicObjectEndpoint basicObjectEndpoint) {
            Endpoint endpoint = basicObjectEndpoint.getEndpoint();
            ArrayList<BasicObjectEndpoint> arrayList = (ArrayList<BasicObjectEndpoint>)this.endpointTable.get(endpoint);
            if (arrayList == null) {
                arrayList = new ArrayList<BasicObjectEndpoint>();
                this.endpointTable.put(endpoint, arrayList);
            }
            arrayList.add(basicObjectEndpoint);
        }

        public void validateObject() {
            Iterator iterator = this.endpointTable.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Endpoint endpoint = (Endpoint)entry.getKey();
                Collection collection = (Collection)entry.getValue();
                dgcClient.registerRefs(endpoint, collection);
            }
            this.endpointTable.clear();
        }
    }

    private static class AckListener
    implements AcknowledgmentSource.Listener {
        private volatile BasicObjectEndpoint ref;

        AckListener(BasicObjectEndpoint basicObjectEndpoint) {
            this.ref = basicObjectEndpoint;
        }

        public void acknowledgmentReceived(boolean bl) {
            this.ref = null;
        }
    }
}

