/*
 * Decompiled with CFR 0.152.
 */
package net.jini.id;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.security.SecureRandom;
import net.jini.id.Uuid;

public final class UuidFactory {
    private static final Object lock = new Object();
    private static SecureRandom secureRandom;

    public static Uuid create(long l, long l2) {
        return new Impl(l, l2);
    }

    public static Uuid create(String string) {
        long l;
        long l2;
        long l3;
        long l4;
        long l5;
        if (string.length() != 36 || string.charAt(8) != '-' || string.charAt(13) != '-' || string.charAt(18) != '-' || string.charAt(23) != '-') {
            throw new IllegalArgumentException("invalid string representation: \"" + string + "\"");
        }
        try {
            l5 = Long.parseLong(string.substring(0, 8), 16);
            l4 = Long.parseLong(string.substring(9, 13), 16);
            l3 = Long.parseLong(string.substring(14, 18), 16);
            l2 = Long.parseLong(string.substring(19, 23), 16);
            l = Long.parseLong(string.substring(24, 36), 16);
        }
        catch (NumberFormatException numberFormatException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("invalid string representation: \"" + string + "\"");
            illegalArgumentException.initCause(numberFormatException);
            throw illegalArgumentException;
        }
        if (l5 < 0L || l4 < 0L || l3 < 0L || l2 < 0L || l < 0L) {
            throw new IllegalArgumentException("invalid string representation: \"" + string + "\"");
        }
        long l6 = l5 << 32 | l4 << 16 | l3;
        long l7 = l2 << 48 | l;
        return UuidFactory.create(l6, l7);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Uuid generate() {
        Object object = lock;
        synchronized (object) {
            if (secureRandom == null) {
                secureRandom = new SecureRandom();
            }
        }
        long l = secureRandom.nextLong();
        long l2 = secureRandom.nextLong();
        l &= 0xFFFFFFFFFFFF0FFFL;
        l2 &= 0x3FFFFFFFFFFFFFFFL;
        return UuidFactory.create(l |= 0x4000L, l2 |= Long.MIN_VALUE);
    }

    public static Uuid read(InputStream inputStream) throws IOException {
        long l = UuidFactory.readLong(inputStream);
        long l2 = UuidFactory.readLong(inputStream);
        return UuidFactory.create(l, l2);
    }

    private static long readLong(InputStream inputStream) throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = inputStream.read();
        if ((n4 | (n3 = inputStream.read()) | (n2 = inputStream.read()) | (n = inputStream.read())) == -1) {
            throw new EOFException();
        }
        int n5 = n4 << 24 | n3 << 16 | n2 << 8 | n;
        n4 = inputStream.read();
        if ((n4 | (n3 = inputStream.read()) | (n2 = inputStream.read()) | (n = inputStream.read())) == -1) {
            throw new EOFException();
        }
        int n6 = n4 << 24 | n3 << 16 | n2 << 8 | n;
        return (long)n5 << 32 | (long)n6 & 0xFFFFFFFFL;
    }

    private UuidFactory() {
        throw new AssertionError();
    }

    private static class Impl
    extends Uuid {
        private static final long serialVersionUID = 1089722863511468966L;

        Impl(long l, long l2) {
            super(l, l2);
        }
    }
}

