/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.freehep.util.io.DecodingInputStream;

public class ConditionalInputStream
extends DecodingInputStream {
    private int[] buffer = new int[4096];
    private int index;
    private int len;
    private InputStream in;
    private Properties defines;
    private int nesting;
    private boolean[] ok = new boolean[50];
    private boolean escape;

    public ConditionalInputStream(InputStream input, Properties defines) {
        this.in = input;
        this.defines = defines;
        this.nesting = 0;
        this.escape = false;
        this.index = 0;
        this.len = 0;
    }

    public int read() throws IOException {
        int n;
        int b;
        if (this.index < this.len) {
            b = this.buffer[this.index];
            ++this.index;
        } else {
            b = this.in.read();
        }
        if (b < 0) {
            return -1;
        }
        if (b == 92) {
            n = this.in.read();
            if (n == 64) {
                b = 32;
                this.escape = true;
            }
            this.buffer[0] = n;
            this.index = 0;
            this.len = 1;
        }
        if (b == 64) {
            if (this.escape) {
                this.escape = false;
            } else {
                this.index = 0;
                StringBuffer s = new StringBuffer();
                n = this.in.read();
                while (n >= 0 && !Character.isWhitespace((char)n)) {
                    s.append((char)n);
                    this.buffer[this.index] = n;
                    n = this.in.read();
                    ++this.index;
                }
                this.buffer[this.index] = n;
                ++this.index;
                b = 32;
                String keyword = s.toString();
                if (keyword.equals("ifdef") || keyword.equals("ifndef")) {
                    s = new StringBuffer();
                    n = this.in.read();
                    while (n >= 0 && Character.isWhitespace((char)n)) {
                        this.buffer[this.index] = n;
                        n = this.in.read();
                        ++this.index;
                    }
                    while (n >= 0 && !Character.isWhitespace((char)n)) {
                        s.append((char)n);
                        this.buffer[this.index] = n;
                        n = this.in.read();
                        ++this.index;
                    }
                    this.buffer[this.index] = n;
                    ++this.index;
                    String property = s.toString();
                    this.ok[this.nesting] = this.defines.getProperty(property) != null ? (this.nesting <= 0 || this.ok[this.nesting - 1]) && keyword.equals("ifdef") : (this.nesting <= 0 || this.ok[this.nesting - 1]) && keyword.equals("ifndef");
                    ++this.nesting;
                    this.replaceBufferWithWhitespace(this.index);
                } else if (keyword.equals("else")) {
                    if (this.nesting <= 0) {
                        throw new RuntimeException("@else without corresponding @ifdef");
                    }
                    this.ok[this.nesting - 1] = (this.nesting <= 1 || this.ok[this.nesting - 2]) && !this.ok[this.nesting - 1];
                    this.replaceBufferWithWhitespace(this.index);
                } else if (keyword.equals("endif")) {
                    if (this.nesting <= 0) {
                        throw new RuntimeException("@endif without corresponding @ifdef");
                    }
                    --this.nesting;
                    this.replaceBufferWithWhitespace(this.index);
                } else {
                    b = 64;
                }
                this.len = this.index;
                this.index = 0;
            }
        }
        if (this.nesting > 0 && !this.ok[this.nesting - 1] && !Character.isWhitespace((char)b)) {
            b = 32;
        }
        return b & 0xFF;
    }

    private void replaceBufferWithWhitespace(int size) {
        for (int i = 0; i < size; ++i) {
            if (Character.isWhitespace((char)this.buffer[i])) continue;
            this.buffer[i] = 32;
        }
    }
}

