/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.beans.editors;

import com.mathworks.beans.editors.BooleanEditor;
import com.mathworks.beans.editors.CategoricalVariableEditor;
import com.mathworks.beans.editors.CharEditor;
import com.mathworks.beans.editors.ColorEditor;
import com.mathworks.beans.editors.DimensionEditor;
import com.mathworks.beans.editors.DoubleArrayEditor;
import com.mathworks.beans.editors.EditorCustomizer;
import com.mathworks.beans.editors.FontEditor;
import com.mathworks.beans.editors.IntArrayEditor;
import com.mathworks.beans.editors.PointEditor;
import com.mathworks.beans.editors.RectangleEditor;
import com.mathworks.beans.editors.StringArrayEditor;
import com.mathworks.util.CategoricalVariable;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Array;
import java.util.HashMap;

public class EditorManager {
    private static boolean sEditorsRegistered = false;
    private static HashMap<Object, EditorCustomizer> sCustomEditorMap = new HashMap();

    public static void init() {
        if (!sEditorsRegistered) {
            PropertyEditorManager.registerEditor(Color.class, ColorEditor.class);
            PropertyEditorManager.registerEditor(Point.class, PointEditor.class);
            PropertyEditorManager.registerEditor(Rectangle.class, RectangleEditor.class);
            PropertyEditorManager.registerEditor(Dimension.class, DimensionEditor.class);
            PropertyEditorManager.registerEditor(Boolean.TYPE, BooleanEditor.class);
            PropertyEditorManager.registerEditor(Boolean.class, BooleanEditor.class);
            PropertyEditorManager.registerEditor(Character.TYPE, CharEditor.class);
            PropertyEditorManager.registerEditor(Font.class, FontEditor.class);
            PropertyEditorManager.registerEditor(Array.newInstance(String.class, 0).getClass(), StringArrayEditor.class);
            double[] dArray = new double[]{};
            PropertyEditorManager.registerEditor(dArray.getClass(), DoubleArrayEditor.class);
            int[] nArray = new int[]{};
            PropertyEditorManager.registerEditor(nArray.getClass(), IntArrayEditor.class);
            PropertyEditorManager.registerEditor(CategoricalVariable.class, CategoricalVariableEditor.class);
        }
    }

    public static void registerCustomEditor(EditorCustomizer editorCustomizer) {
        if (editorCustomizer != null) {
            sCustomEditorMap.put(editorCustomizer.getTargetClassKey(), editorCustomizer);
        }
    }

    public static PropertyEditor getCustomEditor(Object object, PropertyDescriptor propertyDescriptor, PropertyEditor propertyEditor) {
        PropertyEditor propertyEditor2 = null;
        if (object != null && sCustomEditorMap.containsKey(object) && sCustomEditorMap.get(object).hasCustomEditorForProperty(propertyDescriptor)) {
            propertyEditor2 = sCustomEditorMap.get(object).getCustomPropertyEditor(propertyDescriptor, propertyEditor);
        }
        return propertyEditor2;
    }
}

