/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.beans.editors;

import com.mathworks.beans.editors.ApplyPropertyEditor;
import com.mathworks.beans.editors.EnhancedPropertyEditor;
import com.mathworks.beans.editors.PrimitiveArrayEditPanel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Image;
import java.beans.PropertyEditorSupport;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;

public class DoubleArrayEditor
extends PropertyEditorSupport
implements EnhancedPropertyEditor,
ApplyPropertyEditor {
    private static Image sIcon = null;
    private PrimitiveArrayEditPanel fEditPanel = null;

    @Override
    public String getAsText() {
        return DoubleArrayEditor.doubleArrayToString((double[])this.getValue());
    }

    @Override
    public void setAsText(String string) {
        this.setValue(DoubleArrayEditor.stringToDoubleArray(string));
    }

    @Override
    public Object getValue() {
        Object object = super.getValue();
        if (object == null) {
            object = new double[0];
        }
        return object;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        this.fEditPanel = new PrimitiveArrayEditPanel((double[])this.getValue());
        return this.fEditPanel;
    }

    @Override
    public void apply() {
        if (this.fEditPanel != null) {
            this.setValue(this.fEditPanel.getDoubleArray());
        }
    }

    @Override
    public boolean hasAttachedData() {
        return false;
    }

    @Override
    public String getDataKey() {
        return null;
    }

    @Override
    public void setData(Object object) {
    }

    @Override
    public void setFrame(Frame frame) {
    }

    @Override
    public Image getIcon() {
        if (sIcon == null) {
            sIcon = new ImageIcon(this.getClass().getResource("resources/ArrayIconMono16.gif")).getImage();
        }
        return sIcon;
    }

    public static void STATIC______________() {
    }

    public static String doubleArrayToString(double[] dArray) {
        String string;
        if (dArray != null && dArray.length > 0) {
            StringBuffer stringBuffer = new StringBuffer(dArray.length * 6);
            stringBuffer.append("[ ");
            for (double d : dArray) {
                stringBuffer.append(d + "; ");
            }
            stringBuffer.setLength(stringBuffer.length() - 2);
            stringBuffer.append(" ]");
            string = stringBuffer.toString();
        } else {
            string = "[]";
        }
        return string;
    }

    public static double[] stringToDoubleArray(String string) {
        double[] dArray;
        boolean bl;
        if (string == null || string.length() == 0) {
            return new double[0];
        }
        int n = string.indexOf(";");
        boolean bl2 = n >= 0;
        boolean bl3 = bl = string.indexOf(",") >= 0;
        if (!bl && bl2) {
            boolean bl4 = bl = string.substring(0, n).lastIndexOf(" ") > 0;
        }
        if (bl2 && bl) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ";[]");
            double[][] dArrayArray = new double[stringTokenizer.countTokens()][];
            int n2 = 0;
            while (stringTokenizer.hasMoreElements()) {
                dArrayArray[n2++] = DoubleArrayEditor.stringToDoubleArray(stringTokenizer.nextToken());
            }
            dArray = new double[dArrayArray.length * dArrayArray[0].length];
            for (n2 = 0; n2 < dArrayArray.length; ++n2) {
                for (int i = 0; i < dArrayArray[0].length; ++i) {
                    dArray[n2 * dArrayArray[0].length + i] = dArrayArray[n2][i];
                }
            }
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ;,[]");
            dArray = new double[stringTokenizer.countTokens()];
            int n3 = 0;
            while (stringTokenizer.hasMoreElements()) {
                dArray[n3++] = Double.valueOf(stringTokenizer.nextToken());
            }
        }
        return dArray;
    }
}

