/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.beans.editors;

import com.mathworks.beans.editors.ColorPicker;
import com.mathworks.beans.editors.MWPropertyEditorSupport;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import javax.swing.ImageIcon;

public class ColorEditor
extends MWPropertyEditorSupport {
    private static Image sIcon = null;
    private ColorPicker fPicker = null;

    @Override
    public boolean isPaintable() {
        return true;
    }

    @Override
    public void paintValue(Graphics graphics, Rectangle rectangle) {
        Rectangle rectangle2 = new Rectangle(rectangle);
        Color color = (Color)this.getValue();
        rectangle2.grow(-3, -2);
        if (rectangle2.width > 60) {
            rectangle2.width = 60;
        }
        if (color != null) {
            graphics.setColor(color);
            graphics.fillRect(rectangle2.x + 1, rectangle2.y + 1, rectangle2.width - 2, rectangle2.height - 2);
            graphics.setColor(Color.black);
            graphics.drawRect(rectangle2.x, rectangle2.y, rectangle2.width - 1, rectangle2.height - 1);
            graphics.setColor(Color.darkGray);
            graphics.drawLine(rectangle2.x + 1, rectangle2.y + rectangle2.height, rectangle2.x + rectangle2.width, rectangle2.y + rectangle2.height);
            graphics.drawLine(rectangle2.x + rectangle2.width, rectangle2.y + rectangle2.height, rectangle2.x + rectangle2.width, rectangle2.y + 1);
        }
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        Color color;
        if (this.fPicker == null) {
            this.fPicker = new ColorPicker(0, 0, 0, 255);
        }
        if ((color = (Color)this.getValue()) == null) {
            color = Color.black;
        }
        this.fPicker.setSelectedColor(color.getRed(), color.getGreen(), color.getBlue());
        this.fPicker.setInitialColor(color.getRed(), color.getGreen(), color.getBlue());
        return this.fPicker;
    }

    @Override
    public Image getIcon() {
        if (sIcon == null) {
            sIcon = new ImageIcon(this.getClass().getResource("resources/ColorIcon.gif")).getImage();
        }
        return sIcon;
    }

    @Override
    public boolean canApply() {
        return true;
    }

    @Override
    public void apply() {
        Color color = this.fPicker != null ? this.fPicker.getSelectedColor() : null;
        this.setValue(color);
    }
}

