/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt.table;

import com.mathworks.mwt.table.Selection;
import com.mathworks.mwt.table.TableUtils;

public class SelectionOptions {
    public static final int SELECT_NONE = 0;
    public static final int SELECT_SINGLE = 1;
    public static final int SELECT_CONTIGUOUS = 2;
    public static final int SELECT_COMPLEX = 3;
    public static final int SELECT_BY_CELL = 0;
    public static final int SELECT_BY_ROW = 1;
    public static final int SELECT_BY_COLUMN = 2;
    public static final int SEL_NONE = 0;
    public static final int SEL_ACTIVE = 1;
    public static final int SEL_INACTIVE = 2;
    public static final int DRAG_NONE = 0;
    public static final int DRAG_ALLOWED = 1;
    public static final int DRAG_STARTED = 2;
    public static final int KEY_NAVIGATION_NONE = 0;
    public static final int KEY_NAVIGATION_CHANGES_SEL = 1;
    public static final int MOVE_NONE = 0;
    public static final int MOVE_RIGHT = 1;
    public static final int MOVE_LEFT = 2;
    public static final int MOVE_DOWN = 3;
    public static final int MOVE_UP = 4;
    private Selection fSelection;
    private int fMode;
    private int fSelectBy;
    private int fSelectionVisibility;
    private int fDragMode;
    private int fNavMode;
    private int fReturnMode;
    private int fTabMode;

    SelectionOptions(Selection selection) {
        this.fSelection = selection;
        this.fMode = 1;
        this.fSelectBy = 0;
        this.fSelectionVisibility = 1;
        this.fDragMode = 0;
        this.fNavMode = 0;
        this.fReturnMode = 3;
        this.fTabMode = 1;
        if (!TableUtils.isMac()) {
            this.fNavMode = 1;
        }
    }

    protected void setSelection(Selection selection) {
        this.fSelection = selection;
    }

    public int getMode() {
        return this.fMode;
    }

    public void setMode(int n) {
        if (this.fMode != n) {
            if (this.fSelection != null) {
                this.fSelection.clearSelection(true);
            }
            this.fMode = n;
        }
    }

    public int getSelectBy() {
        return this.fSelectBy;
    }

    public void setSelectBy(int n) {
        if (n != this.fSelectBy) {
            if (this.fSelection != null) {
                this.fSelection.clearSelection(true);
            }
            this.fSelectBy = n;
        }
    }

    public int getSelectionVisibility() {
        return this.fSelectionVisibility;
    }

    public void setSelectionVisibility(int n) {
        if (n != this.fSelectionVisibility) {
            this.fSelectionVisibility = n;
        }
    }

    public int getDragMode() {
        return this.fDragMode;
    }

    public void setDragMode(int n) {
        if (n != this.fDragMode && n >= 0 && n <= 2) {
            this.fDragMode = n;
        }
    }

    public int getNavigationMode() {
        return this.fNavMode;
    }

    public void setNavigationMode(int n) {
        if (n != this.fNavMode && n >= 0 && n <= 1) {
            this.fNavMode = n;
        }
    }

    public int getReturnKeyMode() {
        return this.fReturnMode;
    }

    public void setReturnKeyMode(int n) {
        if (n != this.fReturnMode && n >= 0 && n <= 4) {
            this.fReturnMode = n;
        }
    }

    public int getTabKeyMode() {
        return this.fTabMode;
    }

    public void setTabKeyMode(int n) {
        if (n != this.fTabMode && n >= 0 && n <= 4) {
            this.fTabMode = n;
        }
    }
}

