/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt.table;

import com.mathworks.mwt.table.SelectionEvent;
import com.mathworks.mwt.table.SelectionListener;
import com.mathworks.mwt.table.SelectionOptions;
import com.mathworks.mwt.table.Table;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Vector;

public class Selection {
    protected static final int NO_MODIFIER = 0;
    protected static final int CONTIGUOUS_MODIFIER = 1;
    protected static final int COMPLEX_MODIFIER = 2;
    private static final int REPLACE_ALL = 0;
    private static final int REPLACE_LAST = 1;
    private static final int APPEND = 2;
    private static final int REMOVE = 3;
    private static final int REMOVE_ALL = 4;
    private Table fTable;
    private SelectionOptions fOptions;
    private Vector fSelection;
    private boolean fTracking;
    private Rectangle fTrackingRect;
    private Point fAnchor;
    private Point fLastCell;
    private int fTrackBy;
    private int fReplaceMode;
    private Vector fSelectionListeners;

    protected Selection(Table table) {
        this.fTable = table;
        this.fOptions = new SelectionOptions(this);
        this.fSelectionListeners = null;
        this.fSelection = new Vector();
        this.fTracking = false;
        this.fTrackingRect = new Rectangle();
        this.fTrackBy = 0;
        this.fAnchor = new Point(-2, -2);
        this.fLastCell = new Point(-2, -2);
        this.fReplaceMode = 0;
    }

    protected SelectionOptions getOptions() {
        return this.fOptions;
    }

    protected void setOptions(SelectionOptions selectionOptions) {
        this.fOptions = selectionOptions;
        if (this.fOptions == null) {
            this.fOptions.setSelection(this);
        }
    }

    protected void select(Rectangle[] rectangleArray) {
        if (this.getOptions().getMode() != 0 && rectangleArray != null && rectangleArray.length > 0 && rectangleArray[0] != null) {
            Enumeration enumeration = this.fSelection.elements();
            Rectangle rectangle = null;
            Rectangle rectangle2 = null;
            if (enumeration.hasMoreElements()) {
                rectangle = new Rectangle((Rectangle)enumeration.nextElement());
                while (enumeration.hasMoreElements()) {
                    rectangle = rectangle.union((Rectangle)enumeration.nextElement());
                }
            }
            this.fSelection.removeAllElements();
            switch (this.getOptions().getMode()) {
                case 1: {
                    if (rectangleArray[0].x == -2 || rectangleArray[0].y == -2) break;
                    rectangle2 = new Rectangle(rectangleArray[0].x, rectangleArray[0].y, 1, 1);
                    this.enforceSelectBy(rectangle2, true);
                    this.fSelection.addElement(rectangle2);
                    break;
                }
                case 2: {
                    if (rectangleArray[0].x == -2 || rectangleArray[0].y == -2) break;
                    rectangle2 = new Rectangle(rectangleArray[0]);
                    this.enforceSelectBy(rectangle2, false);
                    this.fSelection.addElement(rectangle2);
                    break;
                }
                case 3: {
                    for (int i = 0; i < rectangleArray.length; ++i) {
                        if (rectangleArray[i] == null || rectangleArray[i].x == -2 || rectangleArray[i].y == -2) continue;
                        Rectangle rectangle3 = new Rectangle(rectangleArray[i]);
                        this.enforceSelectBy(rectangle3, false);
                        rectangle2 = rectangle2 == null ? new Rectangle(rectangle3) : rectangle2.union(rectangle3);
                        this.fSelection.addElement(rectangle3);
                    }
                    break;
                }
            }
            if (this.fSelection.size() > 0) {
                Rectangle rectangle4 = (Rectangle)this.fSelection.elementAt(this.fSelection.size() - 1);
                this.fAnchor.x = rectangle4.x;
                this.fAnchor.y = rectangle4.y;
                this.fLastCell.x = rectangle4.x + rectangle4.width - 1;
                this.fLastCell.y = rectangle4.y + rectangle4.height - 1;
            }
            if (rectangle != null && rectangle2 != null && !rectangle2.isEmpty()) {
                this.fireSelectionEvent(new SelectionEvent(rectangle, rectangle2));
            } else if (rectangle2 != null && !rectangle2.isEmpty()) {
                this.fireSelectionEvent(new SelectionEvent(0, rectangle2));
            }
        }
    }

    protected void select(Rectangle rectangle) {
        Rectangle[] rectangleArray = new Rectangle[]{rectangle};
        this.select(rectangleArray);
    }

    protected boolean isSelEmpty() {
        return this.fSelection.size() == 0;
    }

    protected Rectangle[] getSelection() {
        Rectangle[] rectangleArray = new Rectangle[this.fSelection.size()];
        for (int i = 0; i < rectangleArray.length; ++i) {
            rectangleArray[i] = (Rectangle)this.fSelection.elementAt(i);
        }
        return rectangleArray;
    }

    protected boolean isTracking() {
        return this.fTracking;
    }

    protected Point getAnchor() {
        return this.fAnchor;
    }

    protected boolean isAnchor(int n, int n2) {
        return this.fAnchor.x == n2 && this.fAnchor.y == n;
    }

    protected Rectangle getHiliteRect() {
        return this.fTrackingRect;
    }

    protected boolean isHilited(int n, int n2) {
        boolean bl = false;
        if (!this.fTracking) {
            bl = this.isSelected(n, n2);
        } else if (this.fReplaceMode == 4) {
            bl = false;
        } else if (this.fReplaceMode == 3) {
            bl = this.isSelected(n, n2);
            if (bl) {
                bl = !this.fTrackingRect.contains(n2, n);
            }
        } else if (this.fReplaceMode == 0) {
            bl = this.fTrackingRect.contains(n2, n);
        } else if (this.fReplaceMode == 2) {
            bl = this.isSelected(n, n2) || this.fTrackingRect.contains(n2, n);
        } else {
            bl = false;
            for (int i = 0; i < this.fSelection.size() && !bl; ++i) {
                Rectangle rectangle = i == this.fSelection.size() - 1 ? this.fTrackingRect : (Rectangle)this.fSelection.elementAt(i);
                bl = rectangle.contains(n2, n);
            }
        }
        return bl;
    }

    protected boolean isSelected(int n, int n2) {
        boolean bl = false;
        if (this.fSelection.size() > 0) {
            Enumeration enumeration = this.fSelection.elements();
            while (!bl && enumeration.hasMoreElements()) {
                Rectangle rectangle = (Rectangle)enumeration.nextElement();
                bl = rectangle.contains(n2, n);
            }
        }
        return bl;
    }

    public void clearSelected(int n, int n2) {
        if (this.fSelection.size() > 0) {
            Enumeration enumeration = this.fSelection.elements();
            while (enumeration.hasMoreElements()) {
                Rectangle rectangle = (Rectangle)enumeration.nextElement();
                if (!rectangle.contains(n2, n)) continue;
                this.fSelection.removeElement(rectangle);
                break;
            }
        }
    }

    public void clearSelection(boolean bl) {
        if (this.fSelection != null) {
            this.fSelection.removeAllElements();
            this.fAnchor.x = -2;
            this.fAnchor.y = -2;
            this.fLastCell.x = -2;
            this.fLastCell.y = -2;
            if (bl) {
                this.fireSelectionEvent(new SelectionEvent(1, null));
            }
        }
    }

    protected void trackSelection(int n, int n2, int n3) {
        if (this.isCellValid(n, n2)) {
            boolean bl;
            boolean bl2 = n == -1;
            boolean bl3 = n2 == -1;
            int n4 = this.getOptions().getMode();
            boolean bl4 = n3 == 1 && this.isCellValid(this.fAnchor.y, this.fAnchor.x);
            boolean bl5 = bl = bl4 && this.fSelection.size() > 0 && this.getOptions().getSelectBy() != 0;
            if (!this.fTracking) {
                this.fReplaceMode = 0;
                if (this.getOptions().getMode() == 3) {
                    if (this.getOptions().getSelectBy() != 0) {
                        if (this.isSelected(n, n2)) {
                            if (n3 == 1) {
                                this.fReplaceMode = 4;
                            } else if (n3 == 2) {
                                this.fReplaceMode = 3;
                            }
                        } else if (n3 == 2) {
                            this.fReplaceMode = 2;
                        }
                    } else if (n3 == 1) {
                        this.fReplaceMode = 1;
                    } else if (n3 == 2) {
                        this.fReplaceMode = this.isSelected(n, n2) ? 3 : 2;
                    }
                }
                if (bl) {
                    if (this.getOptions().getSelectBy() == 1) {
                        int[] nArray = this.fTable.getSelectedRows();
                        int n5 = nArray[0];
                        int n6 = nArray[nArray.length - 1];
                        this.fAnchor.y = n < n5 ? n6 : n5;
                    } else if (this.getOptions().getSelectBy() == 2) {
                        int[] nArray = this.fTable.getSelectedColumns();
                        int n7 = nArray[0];
                        int n8 = nArray[nArray.length - 1];
                        this.fAnchor.y = n2 < n7 ? n8 : n7;
                    }
                } else if (!bl4) {
                    this.fAnchor.x = bl3 ? 0 : n2;
                    int n9 = this.fAnchor.y = bl2 ? 0 : n;
                }
                this.fTrackBy = bl3 ? 1 : (bl2 ? 2 : this.getOptions().getSelectBy());
                this.fTracking = true;
            }
            this.fLastCell.x = bl3 ? 0 : n2;
            int n10 = this.fLastCell.y = bl2 ? 0 : n;
            if (this.getOptions().getMode() == 1) {
                this.fAnchor.x = this.fLastCell.x;
                this.fAnchor.y = this.fLastCell.y;
            }
            this.fTrackingRect.x = Math.min(this.fAnchor.x, this.fLastCell.x);
            this.fTrackingRect.y = Math.min(this.fAnchor.y, this.fLastCell.y);
            this.fTrackingRect.width = Math.abs(this.fAnchor.x - this.fLastCell.x) + 1;
            this.fTrackingRect.height = Math.abs(this.fAnchor.y - this.fLastCell.y) + 1;
            if (this.fTrackBy == 1) {
                this.fTrackingRect.x = 0;
                this.fTrackingRect.width = this.fTable.getTableSize().width;
            } else if (this.fTrackBy == 2) {
                this.fTrackingRect.y = 0;
                this.fTrackingRect.height = this.fTable.getTableSize().height;
            }
            this.fTable.repaint();
        }
    }

    protected void commitSelection(int n, int n2, int n3) {
        Rectangle rectangle = null;
        Rectangle rectangle2 = null;
        this.trackSelection(n, n2, n3);
        if (this.fReplaceMode == 3) {
            boolean bl = false;
            Enumeration enumeration = this.fSelection.elements();
            while (enumeration.hasMoreElements()) {
                Rectangle rectangle3;
                Rectangle rectangle4 = (Rectangle)enumeration.nextElement();
                if (!this.fTrackingRect.intersects(rectangle4)) continue;
                Rectangle rectangle5 = this.fTrackingRect.intersection(rectangle4);
                if (rectangle5.equals(rectangle4)) {
                    this.fSelection.removeElement(rectangle4);
                } else if (this.getOptions().getSelectBy() == 1) {
                    if (rectangle4.y == this.fTrackingRect.y) {
                        rectangle4.y += this.fTrackingRect.height;
                        rectangle4.height -= this.fTrackingRect.height;
                    } else if (rectangle4.y + rectangle4.height == this.fTrackingRect.y + this.fTrackingRect.height) {
                        rectangle4.height = this.fTrackingRect.y - rectangle4.y;
                    } else {
                        rectangle3 = new Rectangle(rectangle4);
                        rectangle3.y = this.fTrackingRect.y + this.fTrackingRect.height;
                        rectangle3.height = rectangle4.y + rectangle4.height - this.fTrackingRect.y - this.fTrackingRect.height;
                        this.fSelection.addElement(rectangle3);
                        rectangle4.height = this.fTrackingRect.y - rectangle4.y;
                    }
                } else if (this.getOptions().getSelectBy() == 2) {
                    if (rectangle4.x == this.fTrackingRect.x) {
                        rectangle4.x += this.fTrackingRect.width;
                        rectangle4.width -= this.fTrackingRect.width;
                    } else if (rectangle4.x + rectangle4.width == this.fTrackingRect.x + this.fTrackingRect.width) {
                        rectangle4.width = this.fTrackingRect.x - rectangle4.x;
                    } else {
                        rectangle3 = new Rectangle(rectangle4);
                        rectangle3.x = this.fTrackingRect.x + this.fTrackingRect.width;
                        rectangle3.width = rectangle4.x + rectangle4.width - this.fTrackingRect.x - this.fTrackingRect.width;
                        this.fSelection.addElement(rectangle3);
                        rectangle4.width = this.fTrackingRect.x - rectangle4.x;
                    }
                }
                bl = true;
            }
            rectangle2 = new Rectangle(this.fTrackingRect);
            if (bl && !rectangle2.isEmpty()) {
                this.fireSelectionEvent(new SelectionEvent(1, rectangle2));
            }
        } else {
            if (this.fReplaceMode == 0 || this.fReplaceMode == 4) {
                this.fSelection.removeAllElements();
                Enumeration enumeration = this.fSelection.elements();
                if (enumeration.hasMoreElements()) {
                    rectangle = (Rectangle)enumeration.nextElement();
                    while (enumeration.hasMoreElements()) {
                        rectangle = rectangle.union((Rectangle)enumeration.nextElement());
                    }
                }
            } else if (this.fReplaceMode == 1) {
                rectangle = (Rectangle)this.fSelection.lastElement();
                this.fSelection.removeElement(rectangle);
            }
            if (this.fReplaceMode == 4) {
                if (rectangle != null) {
                    this.fireSelectionEvent(new SelectionEvent(1, rectangle));
                }
            } else {
                rectangle2 = new Rectangle(this.fTrackingRect);
                this.fSelection.addElement(rectangle2);
                if (rectangle != null && !rectangle2.isEmpty()) {
                    this.fireSelectionEvent(new SelectionEvent(rectangle, rectangle2));
                } else if (rectangle == null && !rectangle2.isEmpty()) {
                    this.fireSelectionEvent(new SelectionEvent(0, rectangle2));
                }
            }
        }
        this.fTracking = false;
    }

    protected void commitSelection(int n, int n2, Point point) {
        if (this.isCellValid(this.fLastCell.y, this.fLastCell.x)) {
            if (n2 == 2) {
                n2 = 0;
            }
            switch (n) {
                case 38: {
                    if (this.fLastCell.y <= 0) break;
                    this.commitSelection(this.fLastCell.y - 1, this.fLastCell.x, n2);
                    break;
                }
                case 40: {
                    if (this.fLastCell.y >= this.fTable.getTableSize().height - 1) break;
                    this.commitSelection(this.fLastCell.y + 1, this.fLastCell.x, n2);
                    break;
                }
                case 37: {
                    if (this.fLastCell.x <= 0) break;
                    this.commitSelection(this.fLastCell.y, this.fLastCell.x - 1, n2);
                    break;
                }
                case 39: {
                    if (this.fLastCell.x >= this.fTable.getTableSize().width - 1) break;
                    this.commitSelection(this.fLastCell.y, this.fLastCell.x + 1, n2);
                    break;
                }
                case 33: {
                    if (this.fLastCell.y <= 0) break;
                    this.commitSelection(this.fTable.getFirstRow(), this.fLastCell.x, n2);
                    break;
                }
                case 34: {
                    if (this.fLastCell.y >= this.fTable.getTableSize().height - 1) break;
                    this.commitSelection(this.fTable.getLastRow(), this.fLastCell.x, n2);
                    break;
                }
                case 36: {
                    if (this.fLastCell.y <= 0) break;
                    if (this.fTable.isExcelMode()) {
                        this.commitSelection(this.fLastCell.y, 0, n2);
                        break;
                    }
                    this.commitSelection(0, this.fLastCell.x, n2);
                    break;
                }
                case 35: {
                    if (this.fLastCell.y >= this.fTable.getTableSize().height - 1) break;
                    this.commitSelection(this.fTable.getTableSize().height - 1, this.fLastCell.x, n2);
                }
            }
            if (point != null) {
                point.x = this.fLastCell.x;
                point.y = this.fLastCell.y;
            }
        }
    }

    protected void addSelectionListener(SelectionListener selectionListener) {
        if (this.fSelectionListeners == null) {
            this.fSelectionListeners = new Vector();
        }
        if (!this.fSelectionListeners.contains(selectionListener)) {
            this.fSelectionListeners.addElement(selectionListener);
        }
    }

    protected void removeSelectionListener(SelectionListener selectionListener) {
        if (this.fSelectionListeners != null && this.fSelectionListeners.contains(selectionListener)) {
            this.fSelectionListeners.removeElement(selectionListener);
        }
        if (this.fSelectionListeners.size() == 0) {
            this.fSelectionListeners = null;
        }
    }

    private void enforceSelectBy(Rectangle rectangle, boolean bl) {
        int n = this.getOptions().getSelectBy();
        if (!bl) {
            if (rectangle.y == -1 && this.fTable.getColumnOptions().isHeaderSelectable()) {
                rectangle.y = 0;
                rectangle.height = this.fTable.getTableSize().height;
                n = -1;
            } else if (rectangle.x == -1 && this.fTable.getRowOptions().isHeaderSelectable()) {
                rectangle.x = 0;
                rectangle.width = this.fTable.getTableSize().width;
                n = -1;
            }
        }
        switch (n) {
            case 1: {
                rectangle.x = 0;
                rectangle.width = this.fTable.getTableSize().width;
                break;
            }
            case 2: {
                rectangle.y = 0;
                rectangle.height = this.fTable.getTableSize().height;
            }
        }
    }

    private boolean isCellValid(int n, int n2) {
        boolean bl = true;
        if (this.getOptions().getMode() == 0) {
            bl = false;
        } else if (n == -2 || n2 == -2) {
            bl = false;
        } else if (n == -1 && n2 == -1) {
            bl = false;
        } else if (n == -1) {
            if (!this.fTable.getColumnOptions().isHeaderSelectable() || this.getOptions().getMode() == 1) {
                bl = false;
            }
        } else if (!(n2 != -1 || this.fTable.getRowOptions().isHeaderSelectable() && this.getOptions().getMode() != 1)) {
            bl = false;
        }
        return bl;
    }

    private void fireSelectionEvent(SelectionEvent selectionEvent) {
        if (this.fSelectionListeners != null) {
            Vector vector = (Vector)this.fSelectionListeners.clone();
            for (int i = 0; i < vector.size(); ++i) {
                SelectionListener selectionListener = (SelectionListener)vector.elementAt(i);
                selectionListener.selectionChanged(selectionEvent);
            }
        }
    }
}

