/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt.table;

import com.mathworks.mwt.decorations.Decorations;
import com.mathworks.mwt.table.Cell;
import com.mathworks.mwt.table.Style;
import com.mathworks.mwt.table.Table;
import com.mathworks.mwt.table.TableDecorations;
import com.mathworks.mwt.table.TableUtils;
import com.mathworks.mwt.table.TreeCellData;
import com.mathworks.mwt.table.TreeData;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;

public class CellTreeCellData
extends Cell {
    private boolean fMouseIn = false;
    private Rectangle fTrackRect = null;
    private Rectangle fDrawRect = new Rectangle();

    public CellTreeCellData(Table table) {
        super(71, table);
    }

    @Override
    public void render(Graphics graphics, int n, int n2, Rectangle rectangle, Object object, Style style, boolean bl) {
        if (object instanceof TreeCellData) {
            TreeCellData treeCellData = (TreeCellData)object;
            Point point = this.getTable().getTrackingCell();
            boolean bl2 = this.getTable().getShowRootlines();
            if (!TableUtils.isMac()) {
                TreeData treeData = this.getTable().getTreeData();
                int n3 = TableUtils.getTreeIndent();
                int n4 = rectangle.y + rectangle.height / 2;
                int n5 = rectangle.x + rectangle.width - n3 / 2;
                int n6 = rectangle.x + rectangle.width;
                int n7 = treeData.getItemId(n);
                boolean bl3 = true;
                graphics.setColor(Decorations.getColor(9));
                if (bl2 || treeData.getParent(n7) != -1 || this.hasTwisty(treeCellData)) {
                    graphics.drawLine(n5, n4, n6, n4);
                }
                while (n7 != -1) {
                    if (bl2 || treeData.getParent(n7) != -1) {
                        if (bl3 && n > 0) {
                            graphics.drawLine(n5, n4, n5, rectangle.y);
                        }
                        if (treeData.getNextSibling(n7) != -1) {
                            if (n > 0) {
                                graphics.drawLine(n5, n4, n5, rectangle.y);
                            }
                            graphics.drawLine(n5, n4, n5, rectangle.y + rectangle.height);
                        }
                    }
                    n7 = treeData.getParent(n7);
                    n5 -= n3;
                    bl3 = false;
                }
            }
            if (this.hasTwisty(treeCellData)) {
                boolean bl4 = this.fMouseIn && n == point.y && n2 == point.x;
                TableDecorations.getTreeControlBounds(rectangle, this.fDrawRect);
                TableDecorations.renderTreeControl(graphics, this.fDrawRect, treeCellData.isExpanded(), bl4);
            }
        }
    }

    private boolean hasTwisty(TreeCellData treeCellData) {
        boolean bl = TableUtils.isMac() ? treeCellData.isBranch() : treeCellData.isBranch() && treeCellData.getHasChildren();
        return bl;
    }

    @Override
    public boolean mousePressed(MouseEvent mouseEvent, int n, int n2, Object object) {
        boolean bl = false;
        if (object instanceof TreeCellData) {
            TreeCellData treeCellData = (TreeCellData)object;
            Rectangle rectangle = this.getTable().getCellBounds(n, n2);
            Rectangle rectangle2 = new Rectangle();
            TableDecorations.getTreeControlBounds(rectangle, rectangle2);
            if (!TableUtils.isMac()) {
                int n3 = (rectangle.height - rectangle2.width) / 2;
                int n4 = (rectangle.height - rectangle2.height) / 2;
                rectangle2.grow(n3, n4);
            }
            if (this.hasTwisty(treeCellData) && rectangle2.contains(mouseEvent.getPoint())) {
                this.getTable().setTrackingCell(n, n2);
                this.fMouseIn = true;
                this.fTrackRect = rectangle2;
                this.getTable().repaint(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                bl = true;
            }
        }
        return bl;
    }

    @Override
    public boolean mouseReleased(MouseEvent mouseEvent, int n, int n2, Object object) {
        Point point = this.getTable().getTrackingCell();
        boolean bl = false;
        if (point.x == n2 && point.y == n && this.fTrackRect.contains(mouseEvent.getPoint())) {
            Object object2 = this.getTable().getCellData(n, n2);
            if (object2 instanceof TreeCellData) {
                boolean bl2 = ((TreeCellData)object2).isExpanded();
                int n3 = this.getTable().getTreeData().getItemId(n);
                TreeData treeData = this.getTable().getTreeData();
                if (bl2) {
                    treeData.collapseItem(n3);
                } else {
                    treeData.expandItem(n3);
                    if (this.getTable().getScrollOnExpand()) {
                        this.getTable().showRows(n, treeData.getChildren(n3).length + 1);
                    }
                }
                this.getTable().expandColumn();
                this.getTable().layoutScrollbars();
                this.getTable().fireValueChangedEvent(n, n2, new Boolean(bl2));
            }
            this.fMouseIn = false;
            this.getTable().repaint(this.fTrackRect.x, this.fTrackRect.y, this.fTrackRect.width, this.fTrackRect.height);
            this.fTrackRect = null;
            bl = true;
        }
        this.getTable().setTrackingCell(-2, -2);
        return bl;
    }

    @Override
    public boolean mouseDragged(MouseEvent mouseEvent, int n, int n2, Object object) {
        Point point = this.getTable().getTrackingCell();
        boolean bl = false;
        if (point.x == n2 && point.y == n) {
            boolean bl2 = this.fTrackRect.contains(mouseEvent.getPoint());
            if (bl2 != this.fMouseIn) {
                this.fMouseIn = bl2;
                this.getTable().repaint(this.fTrackRect.x, this.fTrackRect.y, this.fTrackRect.width, this.fTrackRect.height);
            }
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean mouseClicked(MouseEvent mouseEvent, int n, int n2, Object object) {
        return mouseEvent.getClickCount() == 2;
    }
}

