/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt.table;

import com.mathworks.mwt.MWTextField;
import com.mathworks.mwt.decorations.Decorations;
import com.mathworks.mwt.table.Cell;
import com.mathworks.mwt.table.Style;
import com.mathworks.mwt.table.Table;
import com.mathworks.util.PlatformInfo;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;

public class CellText
extends Cell {
    private MWTextField fField = null;

    public CellText(Table table) {
        this(4, table);
    }

    protected CellText(int n, Table table) {
        super(n, table);
    }

    @Override
    public void render(Graphics graphics, int n, int n2, Rectangle rectangle, Object object, Style style, boolean bl) {
        if (object instanceof String) {
            boolean bl2 = this.isTableActive();
            String string = CellText.displayString((String)object);
            graphics.setFont(style.getFont());
            Point point = this.getTextLocation(rectangle, graphics.getFontMetrics(), string, style);
            if (bl && style.getCustomHilite()) {
                FontMetrics fontMetrics = graphics.getFontMetrics();
                int n3 = fontMetrics.stringWidth(string);
                int n4 = point.y - fontMetrics.getMaxAscent();
                int n5 = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent();
                graphics.setColor(Decorations.getColor(4, bl2, this.getTable().getBackground()));
                graphics.fillRect(point.x - 1, n4 - 1, n3 + 2, n5 + 2);
            }
            if (bl && PlatformInfo.getAppearance() != 0) {
                graphics.setColor(Decorations.getColor(5, bl2, null));
            } else {
                graphics.setColor(style.getForeground());
            }
            graphics.drawString(string, point.x, point.y);
        }
    }

    private Point getTextLocation(Rectangle rectangle, FontMetrics fontMetrics, String string, Style style) {
        Point point = new Point();
        Insets insets = style.getMargins();
        int n = rectangle.width - insets.left - insets.right;
        int n2 = fontMetrics.stringWidth(string);
        switch (style.getHAlignment()) {
            case 0: {
                point.x = rectangle.x + insets.left;
                break;
            }
            case 1: {
                point.x = rectangle.x + insets.left + (n - n2) / 2;
                break;
            }
            case 2: {
                point.x = rectangle.x + rectangle.width - insets.right - n2;
            }
        }
        int n3 = rectangle.height - insets.top - insets.bottom;
        int n4 = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent();
        switch (style.getVAlignment()) {
            case 0: {
                point.y = rectangle.y + insets.top + fontMetrics.getMaxAscent();
                break;
            }
            case 1: {
                point.y = rectangle.y + insets.top + (n3 - n4) / 2 + fontMetrics.getMaxAscent();
                break;
            }
            case 2: {
                point.y = rectangle.y + rectangle.height - insets.bottom - fontMetrics.getMaxDescent();
            }
        }
        return point;
    }

    protected Rectangle getFieldBounds(int n, int n2) {
        Style style = this.getTable().getCellStyle(n, n2);
        int n3 = style.isVGridVisible() ? 1 : 0;
        int n4 = style.isHGridVisible() ? 1 : 0;
        Rectangle rectangle = this.getTable().getCellBounds(n, n2);
        if (rectangle != null) {
            rectangle.width -= n3;
            rectangle.height -= n4;
        }
        return rectangle;
    }

    protected String getInitialValue(int n, int n2) {
        String string = "";
        Object object = this.getTable().getData().getData(n, n2);
        if (object instanceof String) {
            string = (String)object;
        }
        return string;
    }

    public void beginEdit(int n, int n2, KeyEvent keyEvent) {
        this.beginEdit(n, n2);
        if (this.fField != null) {
            this.fField.dispatchTextComponentEvent(keyEvent);
        }
    }

    @Override
    public void beginEdit(int n, int n2) {
        Style style = this.getTable().getCellStyle(n, n2);
        if (style.isEditable()) {
            Rectangle rectangle = this.getFieldBounds(n, n2);
            if (this.fField == null) {
                this.fField = new MWTextField(8);
                this.fField.setBevelOn(false);
                TextFieldHandler textFieldHandler = new TextFieldHandler();
                this.fField.addActionListener(textFieldHandler);
                this.fField.addKeyListener(textFieldHandler);
                this.fField.addFocusListener(textFieldHandler);
            }
            this.fField.setVisible(false);
            this.getTable().add(this.fField);
            this.fField.setText(this.getInitialValue(n, n2));
            this.fField.setFont(style.getFont());
            this.fField.setStandardMargin(style.getMargins().left);
            this.fField.setBottomMargin(style.getMargins().bottom);
            this.fField.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            this.fField.validate();
            this.fField.getView().setHScrollAmount(0);
            this.fField.selectAll();
            this.fField.setVisible(true);
            this.fField.requestFocus();
            this.getTable().setEditingCell(n, n2);
        }
    }

    @Override
    public void commitEdit(int n, int n2) {
        if (this.getField() != null) {
            String string = this.getField().getText();
            this.commitEdit(n, n2, string);
        } else {
            super.commitEdit(n, n2);
        }
    }

    @Override
    public void cancelEdit(int n, int n2) {
        this.cancelEdit(n, n2, false);
    }

    private void cancelEdit(int n, int n2, boolean bl) {
        this.getTable().setEditingCell(-2, -2);
        if (this.fField != null) {
            this.fField.setVisible(false);
            this.getTable().remove(this.fField);
            this.getTable().requestFocus();
        }
        if (bl) {
            this.getTable().fireEditCancelledEvent(n, n2);
        }
    }

    @Override
    public boolean mouseClicked(MouseEvent mouseEvent, int n, int n2, Object object) {
        if (n2 != -1 && n != -1 && n2 != -2 && n != -2 && mouseEvent.getClickCount() == 2) {
            this.beginEdit(n, n2);
            this.getTable().setExcelEdit(null);
        }
        return false;
    }

    @Override
    protected void getPreferredCellSize(int n, int n2, Dimension dimension) {
        if (dimension != null) {
            super.getPreferredCellSize(n, n2, dimension);
            Font font = this.getTable().getCellStyle(n, n2).getFont();
            Object object = this.getTable().getCellData(n, n2);
            if (font != null && object instanceof String) {
                FontMetrics fontMetrics = this.getTable().getFontMetrics(font);
                dimension.height += fontMetrics.getHeight();
                dimension.width += fontMetrics.stringWidth(CellText.displayString((String)object));
            }
        }
    }

    @Override
    public boolean grabFocus(int n, int n2) {
        boolean bl = false;
        if (this.fField != null && this.fField.isVisible()) {
            bl = true;
            this.fField.requestFocus();
        }
        return bl;
    }

    protected MWTextField getField() {
        return this.fField;
    }

    public MWTextField getFieldForQE() {
        return this.fField;
    }

    protected static final String displayString(String string) {
        if (string.indexOf(9) != -1) {
            return string.replace('\t', ' ');
        }
        return string;
    }

    private class TextFieldHandler
    extends KeyAdapter
    implements ActionListener,
    FocusListener {
        private boolean fHandleFocus = true;

        private TextFieldHandler() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 27) {
                this.fHandleFocus = false;
                Point point = CellText.this.getTable().getEditingCell();
                CellText.this.cancelEdit(point.y, point.x, true);
            }
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.fHandleFocus = false;
            Point point = CellText.this.getTable().getEditingCell();
            CellText.this.commitEdit(point.y, point.x);
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            if (this.fHandleFocus) {
                Point point = CellText.this.getTable().getEditingCell();
                if (point.x != -2 && point.y != -2) {
                    CellText.this.commitEdit(point.y, point.x);
                }
            }
            this.fHandleFocus = true;
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
        }
    }
}

