/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt.table;

import com.mathworks.mwt.MWCanvas;
import com.mathworks.mwt.MWPopupList;
import com.mathworks.mwt.MWTextField;
import com.mathworks.mwt.decorations.Decorations;
import com.mathworks.mwt.floater.DragForwarder;
import com.mathworks.mwt.floater.Floater;
import com.mathworks.mwt.floater.FloaterOwner;
import com.mathworks.mwt.table.CellText;
import com.mathworks.mwt.table.DynamicEnumWithState;
import com.mathworks.mwt.table.EnumWithState;
import com.mathworks.mwt.table.Style;
import com.mathworks.mwt.table.Table;
import com.mathworks.util.PlatformInfo;
import java.awt.CheckboxMenuItem;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;

public class CellEnumData
extends CellText {
    private PopupMenu fMenu = null;
    private MWCanvas fBackground = null;
    private MWPopupList fList = new MWPopupList(true);
    private MWTextField fField = null;
    private int fTrackRow = -2;
    private int fTrackCol = -2;
    private boolean fHasRollover;
    private MenuItemHandler fMenuHandler = null;

    public CellEnumData(Table table) {
        super(71, table);
        DragForwarder dragForwarder = new DragForwarder(this.fList);
        table.addMouseListener(dragForwarder);
        table.addMouseMotionListener(dragForwarder);
        this.fMenu = null;
    }

    @Override
    public void beginEdit(int n, int n2) {
        DynamicEnumWithState dynamicEnumWithState;
        if (this.fList != null && this.fList.isVisible()) {
            this.fList.collapse();
        } else if (this.fMenu != null) {
            this.hideMenu();
        }
        Style style = this.getTable().getCellStyle(n, n2);
        Object object = this.getTable().getData().getData(n, n2);
        if (style.isEditable() && object instanceof DynamicEnumWithState && (dynamicEnumWithState = (DynamicEnumWithState)object).isEditable()) {
            super.beginEdit(n, n2);
        }
    }

    @Override
    protected Rectangle getFieldBounds(int n, int n2) {
        Style style = this.getTable().getCellStyle(n, n2);
        FontMetrics fontMetrics = this.getTable().getFontMetrics(style.getFont());
        Rectangle rectangle = CellEnumData.getControlBounds(this.getTable().getCellBounds(n, n2), fontMetrics, style);
        rectangle.x += 2;
        rectangle.y += 2;
        rectangle.width = PlatformInfo.getAppearance() == 1 ? (rectangle.width -= rectangle.height) : (rectangle.width -= rectangle.height + 6);
        rectangle.height -= 4;
        return rectangle;
    }

    @Override
    public void cancelEdit(int n, int n2) {
        super.cancelEdit(n, n2);
        this.hideMenu();
    }

    private void hideMenu() {
        if (this.fBackground != null && this.fBackground.isVisible()) {
            this.fBackground.setVisible(false);
            this.getTable().remove(this.fBackground);
            this.getTable().requestFocus();
        }
    }

    @Override
    public void commitEdit(int n, int n2, Object object) {
        if (object == null) {
            this.cancelEdit(n, n2);
        }
        Object object2 = this.getTable().getData().getData(n, n2);
        if (object instanceof String && object2 instanceof DynamicEnumWithState) {
            DynamicEnumWithState dynamicEnumWithState = (DynamicEnumWithState)object2;
            String string = dynamicEnumWithState.getCurrentString();
            if (string != null && !string.equals(object)) {
                DynamicEnumWithState dynamicEnumWithState2 = null;
                try {
                    dynamicEnumWithState2 = (DynamicEnumWithState)dynamicEnumWithState.clone();
                }
                catch (Exception exception) {
                    dynamicEnumWithState2 = dynamicEnumWithState;
                    System.err.println("Warning! CellEnumData could not make a proper copy off Enum data: " + dynamicEnumWithState);
                }
                dynamicEnumWithState2.setCurrentString((String)object);
                super.commitEdit(n, n2, dynamicEnumWithState2);
            } else {
                this.cancelEdit(n, n2);
            }
        } else {
            super.commitEdit(n, n2, object);
        }
    }

    @Override
    protected String getInitialValue(int n, int n2) {
        String string = null;
        Object object = this.getTable().getData().getData(n, n2);
        if (object instanceof EnumWithState) {
            string = ((EnumWithState)object).getCurrentString();
        }
        return string == null ? "" : string;
    }

    @Override
    public boolean mousePressed(MouseEvent mouseEvent, int n, int n2, Object object) {
        boolean bl = this.mouseReaction(mouseEvent, n, n2, object);
        if (this.fList != null && this.fList.isVisible()) {
            this.getTable().select(n, n2);
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean mouseDragged(MouseEvent mouseEvent, int n, int n2, Object object) {
        Point point = this.getTable().getTrackingCell();
        if (this.fList != null && this.fList.isVisible() && n == point.y && n2 == point.x) {
            this.fTrackRow = n;
            this.fTrackCol = n2;
        }
        return point.x == n2 && point.y == n;
    }

    @Override
    public boolean mouseReleased(MouseEvent mouseEvent, int n, int n2, Object object) {
        boolean bl;
        Point point = this.getTable().getTrackingCell();
        boolean bl2 = bl = n == point.y && n2 == point.x;
        if (bl) {
            this.getTable().setTrackingCell(-2, -2);
        }
        this.fTrackRow = -2;
        this.fTrackCol = -2;
        return bl;
    }

    private boolean mouseReaction(MouseEvent mouseEvent, int n, int n2, Object object) {
        boolean bl = false;
        Style style = this.getTable().getCellStyle(n, n2);
        if (object instanceof EnumWithState && style.isEditable()) {
            EnumWithState enumWithState = (EnumWithState)object;
            String[] stringArray = enumWithState.getAllStrings();
            Rectangle rectangle = this.getTable().getCellBounds(n, n2);
            FontMetrics fontMetrics = this.getTable().getFontMetrics(style.getFont());
            Rectangle rectangle2 = CellEnumData.getControlBounds(rectangle, fontMetrics, style);
            Point point = mouseEvent.getPoint();
            boolean bl2 = rectangle2.contains(point);
            boolean bl3 = object instanceof DynamicEnumWithState && ((DynamicEnumWithState)object).isEditable();
            boolean bl4 = bl3 = bl3 && bl2 && point.x < rectangle2.x + rectangle2.width - rectangle2.height;
            if (this.fList != null) {
                if (bl3) {
                    this.beginEdit(n, n2);
                } else if (this.fList.isVisible()) {
                    this.fList.collapse();
                } else if (bl2) {
                    this.makePopupList(stringArray, rectangle2, n, n2, enumWithState);
                }
            } else if (this.fMenu != null) {
                if (bl3) {
                    this.beginEdit(n, n2);
                } else if (bl2) {
                    bl = true;
                    this.makePopupMenu(stringArray, rectangle2, n, n2, enumWithState);
                }
            }
        }
        return bl;
    }

    private void makePopupList(String[] stringArray, Rectangle rectangle, int n, int n2, EnumWithState enumWithState) {
        int n3 = -1;
        String string = enumWithState.getCurrentString();
        this.fList.removeAllItems();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.fList.addItem(stringArray[i]);
                if (!stringArray[i].equals(string)) continue;
                n3 = i;
            }
        }
        this.fList.setSelectedIndex(n3);
        ListItemHandler listItemHandler = new ListItemHandler(n, n2, enumWithState);
        this.fList.addItemListener(listItemHandler);
        this.fList.setFloaterOwner(listItemHandler);
        this.getTable().setTrackingCell(n, n2);
        this.fList.show(this.getTable(), rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    private void makePopupMenu(String[] stringArray, Rectangle rectangle, int n, int n2, EnumWithState enumWithState) {
        CheckboxMenuItem checkboxMenuItem = null;
        String string = enumWithState.getCurrentString();
        this.getTable().add(this.fBackground);
        this.fBackground.setVisible(true);
        MenuItemHandler menuItemHandler = new MenuItemHandler(n, n2, enumWithState);
        this.fMenu.removeAll();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                checkboxMenuItem = new CheckboxMenuItem(stringArray[i]);
                checkboxMenuItem.addItemListener(menuItemHandler);
                checkboxMenuItem.setState(stringArray[i].equals(string));
                this.fMenu.add(checkboxMenuItem);
            }
        }
        this.fMenu.show(this.getTable(), rectangle.x, rectangle.y + rectangle.height);
    }

    @Override
    public void render(Graphics graphics, int n, int n2, Rectangle rectangle, Object object, Style style, boolean bl) {
        if (object instanceof EnumWithState) {
            String string = ((EnumWithState)object).getCurrentString();
            FontMetrics fontMetrics = this.getTable().getFontMetrics(style.getFont());
            Point point = this.getTable().getTrackingCell();
            boolean bl2 = this.fList != null && n == point.y && n2 == point.x ? this.fList.isVisible() : false;
            Rectangle rectangle2 = CellEnumData.getControlBounds(rectangle, fontMetrics, style);
            graphics.setFont(style.getFont());
            if (this.getTable().getSelectionOptions().getSelectBy() == 1 && this.getTable().getFirstSelectedRow() == n) {
                bl2 = true;
            }
            if (object instanceof DynamicEnumWithState && ((DynamicEnumWithState)object).isEditable()) {
                Decorations.drawComboControl(graphics, rectangle2, bl2, style.isEditable(), this.fHasRollover);
                if (PlatformInfo.getAppearance() != 1) {
                    Decorations.drawBevelFrame(graphics, rectangle2.x, rectangle2.y, rectangle2.width - rectangle2.height - 2, rectangle2.height);
                }
                graphics.setColor(bl ? Decorations.getColor(5, this.isTableActive(), null) : style.getForeground());
                rectangle2 = this.getFieldBounds(n, n2);
                Rectangle rectangle3 = graphics.getClipBounds();
                graphics.clipRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                graphics.drawString(string, rectangle2.x + 2, rectangle2.y + fontMetrics.getAscent() + fontMetrics.getLeading() + 2);
                graphics.setClip(rectangle3);
            } else {
                Decorations.drawPopupControl(graphics, rectangle2, string, bl2, style.isEditable(), this.fHasRollover);
            }
        }
    }

    public Object getPopupForQE() {
        if (this.fList != null) {
            return this.fList;
        }
        if (this.fMenu != null) {
            return this.fMenu;
        }
        return null;
    }

    private static void INNER_CLASSES___() {
    }

    private static void STATIC_________() {
    }

    private static Rectangle getControlBounds(Rectangle rectangle, FontMetrics fontMetrics, Style style) {
        Rectangle rectangle2 = new Rectangle(rectangle);
        rectangle2.height = fontMetrics.getHeight() + 7;
        if (style.isHGridVisible()) {
            --rectangle2.width;
        }
        switch (style.getVAlignment()) {
            case 1: {
                rectangle2.y += (rectangle.height - rectangle2.height) / 2;
                break;
            }
            case 2: {
                int n = style.isHGridVisible() ? 1 : 0;
                rectangle2.y += rectangle.height - n - rectangle2.height;
            }
        }
        return rectangle2;
    }

    private class ListItemHandler
    implements ItemListener,
    FloaterOwner {
        int r;
        int c;
        EnumWithState local_data = null;

        public ListItemHandler(int n, int n2, EnumWithState enumWithState) {
            this.r = n;
            this.c = n2;
            this.local_data = enumWithState;
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            String string;
            if (CellEnumData.this.fList.equals(itemEvent.getSource()) && this.equals(CellEnumData.this.fList.getFloaterOwner()) && (string = CellEnumData.this.fList.getSelectedItem()) != null && !string.equals(this.local_data.getCurrentString())) {
                this.local_data.setCurrentString(string);
                CellEnumData.this.getTable().getData().setData(this.r, this.c, this.local_data);
                CellEnumData.this.getTable().fireValueChangedEvent(this.r, this.c);
            }
        }

        @Override
        public void floaterAutoCollapsed(Floater floater) {
            CellEnumData.this.fList.removeItemListener(this);
            if (this.equals(CellEnumData.this.fList.getFloaterOwner())) {
                CellEnumData.this.fList.setFloaterOwner(null);
                CellEnumData.this.cancelEdit(this.r, this.c);
                if (CellEnumData.this.fTrackRow != this.r || CellEnumData.this.fTrackCol != this.c) {
                    CellEnumData.this.getTable().setTrackingCell(-2, -2);
                }
            }
            CellEnumData.this.getTable().repaintCells(this.r, this.c - 1, this.r, this.c);
        }
    }

    private class MenuItemHandler
    implements ItemListener {
        int r;
        int c;
        EnumWithState local_data = null;

        public MenuItemHandler(int n, int n2, EnumWithState enumWithState) {
            this.r = n;
            this.c = n2;
            this.local_data = enumWithState;
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            CheckboxMenuItem checkboxMenuItem = (CheckboxMenuItem)itemEvent.getItemSelectable();
            String string = checkboxMenuItem.getLabel();
            if (!string.equals(this.local_data.getCurrentString())) {
                this.local_data.setCurrentString(string);
                CellEnumData.this.getTable().getData().setData(this.r, this.c, this.local_data);
                CellEnumData.this.getTable().fireValueChangedEvent(this.r, this.c);
            }
            CellEnumData.this.cancelEdit(this.r, this.c);
            CellEnumData.this.getTable().repaintCells(this.r, this.c - 1, this.r, this.c);
        }
    }

    private class MyTextActionHandler
    implements ActionListener {
        private MyTextActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Point point = CellEnumData.this.getTable().getEditingCell();
            CellEnumData.this.commitEdit(point.y, point.x);
        }
    }
}

