/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt.dialog;

import com.mathworks.mwt.MWButton;
import com.mathworks.mwt.MWCheckbox;
import com.mathworks.mwt.MWLabel;
import com.mathworks.mwt.MWPanel;
import com.mathworks.mwt.MWTextField;
import com.mathworks.mwt.MWTranslate;
import com.mathworks.mwt.decorations.Decorations;
import com.mathworks.mwt.dialog.MWDialog;
import com.mathworks.mwt.window.MWWindowActivater;
import com.mathworks.mwt.window.MWWindowResizer;
import com.mathworks.util.PlatformInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class MWFindDialog
extends MWDialog
implements ActionListener {
    public static final int MATCH_CASE = 1;
    public static final int WRAP_AROUND = 2;
    public static final int WHOLE_WORD = 4;
    public static final int REVERSE = 8;
    private String fFindString;
    private MWButton fFindButton;
    private MWButton fCancel;
    private MWCheckbox fMatchCase;
    private MWCheckbox fWrapAround;
    private MWCheckbox fWholeWord;
    private MWTextField fText;
    private Label fLabel;
    private int fWidth;

    public MWFindDialog(Frame frame, String string, int n) {
        super(frame, MWTranslate.intlString("labelFind"), true);
        this.fFindString = string;
        this.setLayout(new BorderLayout());
        this.setBackground(Decorations.getColor(1));
        MWPanel mWPanel = new MWPanel();
        mWPanel.setOpaque(false);
        mWPanel.setInsets(new Insets(7, 3, 3, 3));
        this.add((Component)mWPanel, "Center");
        mWPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 3, 5);
        this.fFindButton = new MWButton(MWTranslate.intlString("labelFindNext"));
        this.fFindButton.addActionListener(this);
        this.fFindButton.setDefault(true);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        mWPanel.add((Component)this.fFindButton, gridBagConstraints);
        this.fCancel = new MWButton(MWTranslate.intlString("labelCancel"));
        this.fCancel.addActionListener(this);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        mWPanel.add((Component)this.fCancel, gridBagConstraints);
        this.fMatchCase = new MWCheckbox(MWTranslate.intlString("labelMatchCase"));
        this.fMatchCase.setState((n & 1) != 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        mWPanel.add((Component)this.fMatchCase, gridBagConstraints);
        this.fWholeWord = new MWCheckbox(MWTranslate.intlString("labelWholeWord"));
        this.fWholeWord.setState((n & 4) != 0);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        mWPanel.add((Component)this.fWholeWord, gridBagConstraints);
        this.fWrapAround = new MWCheckbox(MWTranslate.intlString("labelWrapAround"));
        this.fWrapAround.setState((n & 2) != 0);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        mWPanel.add((Component)this.fWrapAround, gridBagConstraints);
        MWLabel mWLabel = new MWLabel(MWTranslate.intlString("labelFindWhat"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        mWPanel.add((Component)mWLabel, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 2;
        this.fText = new MWTextField(this.fFindString, 20);
        this.fText.selectAll();
        this.fText.addActionListener(this);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        mWPanel.add((Component)this.fText, gridBagConstraints);
        this.addWindowListener(new WindowEventHandler());
        this.addWindowListener(new MWWindowActivater(this));
        this.pack();
        Rectangle rectangle = frame.getBounds();
        rectangle.x += rectangle.width / 2 - this.getSize().width / 2;
        rectangle.y += rectangle.height / 3 - this.getSize().height / 2;
        this.setLocation(rectangle.x, rectangle.y);
        this.setResizable(false);
        if (PlatformInfo.isUnix()) {
            this.addComponentListener(new MWWindowResizer(this.getSize().width, this.getSize().height, this.getSize().width, this.getSize().height, false));
        }
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof MWTextField) {
            this.fFindString = this.fText.getText();
            this.setVisible(false);
        } else {
            String string = actionEvent.getActionCommand();
            if (string.equals(MWTranslate.intlString("labelFindNext"))) {
                this.fFindString = this.fText.getText();
                this.setVisible(false);
            } else if (string.equals(MWTranslate.intlString("labelCancel"))) {
                this.fFindString = "";
                this.setVisible(false);
            }
        }
    }

    public String getText() {
        return this.fFindString;
    }

    public int getOptions() {
        int n = 0;
        if (this.fMatchCase.getState()) {
            ++n;
        }
        if (this.fWrapAround.getState()) {
            n += 2;
        }
        if (this.fWholeWord.getState()) {
            n += 4;
        }
        return n;
    }

    public static void main(String[] stringArray) {
        Frame frame = new Frame("MATLAB Editor");
        frame.setVisible(true);
        frame.setBounds(500, 500, 500, 500);
        new MWFindDialog(frame, "findstring", 0);
    }

    class WindowEventHandler
    extends WindowAdapter {
        WindowEventHandler() {
        }

        @Override
        public void windowActivated(WindowEvent windowEvent) {
            MWFindDialog.this.fText.requestFocus();
        }
    }
}

