/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt;

import com.mathworks.mwt.MWButton;
import com.mathworks.mwt.MWImageResource;
import com.mathworks.mwt.MWPanel;
import com.mathworks.mwt.MWToolTip;
import com.mathworks.mwt.MWToolbarSpacer;
import com.mathworks.mwt.command.MWCommandCenter;
import com.mathworks.mwt.decorations.Decorations;
import com.mathworks.util.PlatformInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Vector;

public class MWToolbar
extends MWPanel {
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    private static final int DEFAULT_INSET = 1;
    private static final int DEFAULT_MARGIN = 6;
    private MWCommandCenter fCenter;
    private Vector fToolList;
    private int fMargin = 6;
    private int fTopInset = 1;
    private int fLeftInset = 1;
    private int fBottomInset = 1;
    private int fRightInset = 1;

    public MWToolbar() {
        this((MWCommandCenter)null);
    }

    public MWToolbar(MWCommandCenter mWCommandCenter) {
        this(mWCommandCenter, null);
    }

    public MWToolbar(MWCommandCenter mWCommandCenter, LayoutManager layoutManager) {
        this.setOpaqueInsets(false);
        this.fCenter = mWCommandCenter;
        if (PlatformInfo.getAppearance() == 1) {
            this.fMargin = 4;
            this.fLeftInset = 0;
            this.fRightInset = 0;
        }
        if (layoutManager == null) {
            this.setLayout(new ToolbarLayout(this.fMargin));
        } else {
            this.setLayout(layoutManager);
        }
        this.fToolList = new Vector();
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        Enumeration enumeration = this.fToolList.elements();
        while (enumeration.hasMoreElements()) {
            Component component = (Component)enumeration.nextElement();
            component.setEnabled(bl);
        }
    }

    @Override
    public Insets getInsets() {
        return new Insets(this.fTopInset, this.fLeftInset, this.fBottomInset, this.fRightInset);
    }

    public final void setTopInset(int n) {
        this.fTopInset = n;
    }

    public final void setLeftInset(int n) {
        this.fLeftInset = n;
    }

    public final void setBottomInset(int n) {
        this.fBottomInset = n;
    }

    public final void setRightInset(int n) {
        this.fRightInset = n;
    }

    public MWButton addImageButton(String string, int n) {
        return this.addImageButton(string, n, null, this.fCenter);
    }

    public MWButton addImageButton(String string, int n, String string2) {
        return this.addImageButton(string, n, string2, this.fCenter);
    }

    public MWButton addImageButton(String string, int n, MWCommandCenter mWCommandCenter) {
        return this.addImageButton(string, n, null, mWCommandCenter);
    }

    public MWButton addImageButton(String string, int n, String string2, MWCommandCenter mWCommandCenter) {
        MWButton mWButton = new MWButton(new MWImageResource(string));
        mWButton.setFocusBehavior(false);
        if (mWCommandCenter != null) {
            mWCommandCenter.addCommandSource(mWButton, n);
        }
        mWButton.setHideBevel(true);
        mWButton.setToolbarBevel(true);
        if (string2 != null) {
            Rectangle rectangle = mWButton.getBounds();
            rectangle.y = 0;
            rectangle.x = 0;
            new MWToolTip(mWButton, string2, rectangle);
        }
        this.addComponent((Component)mWButton, string2);
        return mWButton;
    }

    public void addComponent(Component component) {
        this.addComponent(component, 1);
    }

    public void addComponent(Component component, String string) {
        component.setName(string);
        this.addComponent(component, 1);
    }

    public void addComponent(Component component, int n) {
        this.fToolList.addElement(component);
        this.add(component);
        this.validate();
    }

    public void removeComponent(String string) {
        Enumeration enumeration = this.fToolList.elements();
        while (enumeration.hasMoreElements()) {
            Component component = (Component)enumeration.nextElement();
            if (!string.equals(component.getName())) continue;
            this.fToolList.removeElement(component);
            this.remove(component);
            this.validate();
            return;
        }
    }

    public void addSpacer(int n) {
        MWToolbarSpacer mWToolbarSpacer = new MWToolbarSpacer(n);
        this.addComponent(mWToolbarSpacer);
    }

    public void addSpacer(int n, String string) {
        MWToolbarSpacer mWToolbarSpacer = new MWToolbarSpacer(n);
        this.addComponent((Component)mWToolbarSpacer, string);
    }

    public void addSpacer() {
        this.addSpacer(10);
    }

    public void addSpacer(String string) {
        this.addSpacer(10, string);
    }

    public void addBandSpacer() {
        MWToolbarSpacer mWToolbarSpacer = new MWToolbarSpacer(16, true);
        this.addComponent(mWToolbarSpacer);
    }

    public void addBandSpacer(String string) {
        MWToolbarSpacer mWToolbarSpacer = new MWToolbarSpacer(16, true);
        this.addComponent((Component)mWToolbarSpacer, string);
    }

    public Component getTool(String string) {
        for (int i = 0; i < this.fToolList.size(); ++i) {
            Component component = (Component)this.fToolList.elementAt(i);
            if (!(component instanceof MWButton) || !((MWButton)component).getActionCommand().equals(string)) continue;
            return component;
        }
        return null;
    }

    public Component getTool(int n) {
        for (int i = 0; i < this.fToolList.size(); ++i) {
            Component component = (Component)this.fToolList.elementAt(i);
            if (!(component instanceof MWButton) || ((MWButton)component).getCommand() != n) continue;
            return component;
        }
        return null;
    }

    @Override
    public void paint(Graphics graphics) {
        Color color = Decorations.getColor(7);
        Color color2 = Decorations.getColor(9);
        super.paint(graphics);
        Dimension dimension = this.getSize();
        int n = this.fTopInset - 2;
        int n2 = this.fLeftInset - 2;
        int n3 = dimension.height - this.fBottomInset + 2;
        int n4 = dimension.width - this.fRightInset + 2;
        graphics.setColor(color);
        graphics.drawLine(n2 + 1, n + 1, n4 - 2, n + 1);
        graphics.drawLine(n2 + 1, n + 2, n2 + 1, n3 - 2);
        graphics.drawLine(n2 + 1, n3 - 1, n4 - 1, n3 - 1);
        graphics.drawLine(n4 - 1, n3 - 2, n4 - 1, n + 1);
        graphics.setColor(color2);
        graphics.drawLine(n2 + 2, n3 - 2, n4 - 2, n3 - 2);
        graphics.drawLine(n4 - 2, n3 - 3, n4 - 2, n + 2);
        graphics.drawLine(n2, n, n4 - 1, n);
        graphics.drawLine(n2, n + 1, n2, n3 - 1);
        graphics.setColor(Color.black);
        graphics.drawLine(n2, n3 - 1, n4 - 1, n3 - 1);
    }

    private static class ToolbarLayout
    implements LayoutManager {
        private static final int LEFT_MARGIN = 5;
        private static final int DIVIDER_MARGIN = 4;
        private int fMargin;

        ToolbarLayout(int n) {
            this.fMargin = n;
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
        }

        @Override
        public void removeLayoutComponent(Component component) {
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            Dimension dimension = new Dimension(5, 0);
            int n = container.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component component = container.getComponent(i);
                Dimension dimension2 = component.getPreferredSize();
                dimension.width += dimension2.width;
                dimension.height = Math.max(dimension.height, dimension2.height);
            }
            Insets insets = container.getInsets();
            dimension.width += insets.left + insets.right;
            dimension.height += insets.top + insets.bottom + this.fMargin;
            return dimension;
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            Dimension dimension = new Dimension(5, 0);
            int n = container.getComponentCount();
            for (int i = 0; i < n; ++i) {
                Component component = container.getComponent(i);
                Dimension dimension2 = component.getMinimumSize();
                dimension.width += dimension2.width;
                dimension.height = Math.max(dimension.height, dimension2.height);
            }
            Insets insets = container.getInsets();
            dimension.width += insets.left + insets.right;
            dimension.height += insets.top + insets.bottom + this.fMargin;
            return dimension;
        }

        @Override
        public void layoutContainer(Container container) {
            Insets insets = container.getInsets();
            Dimension dimension = container.getSize();
            int n = container.getComponentCount();
            int n2 = insets.left + 5;
            int n3 = dimension.height - insets.top - insets.bottom;
            for (int i = 0; i < n; ++i) {
                Component component = container.getComponent(i);
                Dimension dimension2 = component.getPreferredSize();
                if (component instanceof MWToolbarSpacer) {
                    dimension2.height = dimension.height - 4;
                }
                int n4 = insets.top + (n3 - dimension2.height) / 2;
                component.setBounds(n2, n4, dimension2.width, dimension2.height);
                n2 += dimension2.width;
            }
        }
    }
}

