/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt;

import com.mathworks.mwt.MWClipboard;
import com.mathworks.mwt.decorations.Decorations;
import com.mathworks.mwt.text.MWKeyMap;
import com.mathworks.mwt.text.MWTextComponent;
import com.mathworks.mwt.text.MWTextView;
import com.mathworks.util.PlatformInfo;
import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;

public class MWTextField
extends MWTextComponent {
    private int fColumns;
    protected int fWidth;
    protected int fHeight;
    private int fStandardMargin = 1;
    private int fBottomMargin = 2;
    private ActionListener fActionListener;
    private static MWKeyMap sKeyMap;
    private static Clipboard sClip;
    private static ActionListener sPasteAction;

    public MWTextField() {
        this("", 20);
    }

    public MWTextField(String string) {
        this(string, Math.max(string.length(), 20));
    }

    public MWTextField(int n) {
        this("", n);
    }

    public MWTextField(String string, int n) {
        super(string);
        this.setFont(Decorations.getFont(0));
        this.setVScrollStyle(1);
        this.setHScrollStyle(1);
        this.setColumns(n);
        this.getView().setBorderBeepOn(false);
        this.getView().setAllowDragAndDrop(false);
        if (sKeyMap == null) {
            sKeyMap = new MWKeyMap();
            sKeyMap.setKeyBinding(37, 0, 10);
            sKeyMap.setKeyBinding(37, 0, 9);
            sKeyMap.setKeyBinding(37, 1, 9);
            sKeyMap.setKeyBinding(0, 0, 38);
            sKeyMap.setKeyBinding(1, 1, 38);
            sKeyMap.setKeyBinding(3, 0, 40);
            sKeyMap.setKeyBinding(4, 1, 40);
        }
        this.setKeyMap(sKeyMap);
        this.addKeyListener(new KeyEventHandler());
        if (sClip == null) {
            sClip = this.getToolkit().getSystemClipboard();
            sPasteAction = new PasteAction();
        }
        this.getView().overrideCommand(34, sPasteAction);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.cacheDimensions();
    }

    public void setColumns(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("MWTextField.setColumns: Negative number of columns not allowed.");
        }
        this.fColumns = n;
        this.cacheDimensions();
        this.invalidate();
        if (this.getParent() != null) {
            this.getParent().validate();
        }
    }

    @Override
    public void requestFocus() {
        if (this.getView().isEnabled() && !this.getView().hasFocus() && this.getModel().isEditable()) {
            this.getView().setHScrollAmount(0);
            this.selectAll();
        }
        super.requestFocus();
    }

    private void cacheDimensions() {
        FontMetrics fontMetrics = this.getModel().getFontMetrics();
        Insets insets = this.getInsets();
        this.fWidth = this.fColumns * fontMetrics.charWidth('M') + insets.left + insets.right;
        this.fHeight = this.getModel().getFontHeight() + insets.top + insets.bottom;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.fWidth, this.fHeight);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void setStandardMargin(int n) {
        if (this.fStandardMargin != n) {
            this.fStandardMargin = n;
            this.invalidate();
        }
    }

    public int getStandardMargin() {
        return this.fStandardMargin;
    }

    public void setBottomMargin(int n) {
        if (this.fBottomMargin != n) {
            this.fBottomMargin = n;
            this.invalidate();
        }
    }

    public int getBottomMargin() {
        return this.fBottomMargin;
    }

    @Override
    public Insets getInsets() {
        Insets insets = super.getInsets();
        insets.top += this.fStandardMargin;
        insets.left += this.fStandardMargin;
        insets.bottom += this.fBottomMargin;
        insets.right += this.fStandardMargin;
        return insets;
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    @Override
    public void paint(Graphics graphics) {
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        int n3 = this.getBorderWidth();
        int n4 = n3 + this.fBottomMargin;
        graphics.setColor(this.getView().getBackground());
        graphics.fillRect(n3, n3, n - 2 * n3, this.fStandardMargin);
        graphics.fillRect(n3, n2 - n4, n - 2 * n3, n4);
        graphics.fillRect(n3, n3, this.fStandardMargin, n2 - 2 * n3);
        graphics.fillRect(n - n3 - this.fStandardMargin, n3, this.fStandardMargin, n2 - 2 * n3);
        super.paint(graphics);
    }

    public void fireAction() {
        if (this.fActionListener != null) {
            ActionEvent actionEvent = new ActionEvent(this, 1001, "");
            this.processActionEvent(actionEvent);
        }
    }

    @Override
    public void setCursor(Cursor cursor) {
        this.getView().setCursor(cursor);
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.fActionListener = AWTEventMulticaster.add(this.fActionListener, actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.fActionListener = AWTEventMulticaster.remove(this.fActionListener, actionListener);
    }

    @Override
    public void processEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)aWTEvent);
            return;
        }
        super.processEvent(aWTEvent);
    }

    protected void processActionEvent(ActionEvent actionEvent) {
        if (this.fActionListener != null) {
            this.fActionListener.actionPerformed(actionEvent);
        }
    }

    public static void main(String[] stringArray) {
        new Test();
    }

    private static class Test
    extends Frame {
        private Panel fPanel = new TestPanel();
        private Component fComponent;

        public Test() {
            super("Text Example");
            this.add((Component)this.fPanel, "Center");
            this.fPanel.setLayout(new FlowLayout());
            MWTextField mWTextField = new MWTextField();
            mWTextField.addActionListener(new TestActionListener());
            this.fComponent = mWTextField;
            mWTextField.setText("Does this show up?");
            this.fPanel.add(this.fComponent);
            this.fPanel.add(new MWTextField("hi there"));
            this.fPanel.add(new MWTextField(5));
            this.fPanel.add(new MWTextField("my butt hurts", 30));
            this.addWindowListener(new TestWindowEventHandler());
            this.pack();
            this.setVisible(true);
            this.fPanel.requestFocus();
        }

        class TestPanel
        extends Panel {
            TestPanel() {
                this.setBackground(Decorations.getColor(1));
            }

            @Override
            public void update(Graphics graphics) {
                this.paint(graphics);
            }
        }

        class TestWindowEventHandler
        extends WindowAdapter {
            TestWindowEventHandler() {
            }

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                System.exit(0);
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                Test.this.dispose();
            }

            @Override
            public void windowActivated(WindowEvent windowEvent) {
                Test.this.fPanel.requestFocus();
                Test.this.fComponent.requestFocus();
            }
        }

        class TestActionListener
        implements ActionListener {
            TestActionListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MWTextField mWTextField = (MWTextField)actionEvent.getSource();
                System.out.println("Text = '" + mWTextField.getText() + "'");
            }
        }
    }

    private static class PasteAction
    implements ActionListener {
        private ActionEvent fCurrentActionEvent;

        private PasteAction() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = null;
            this.fCurrentActionEvent = actionEvent;
            Transferable transferable = null;
            transferable = PlatformInfo.isXWindows() ? MWClipboard.getMWClipboard().getXSelectionContents(this) : sClip.getContents(this);
            if (transferable != null && transferable.getTransferDataFlavors() != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                try {
                    string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    unsupportedFlavorException.printStackTrace();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            this.doActualPaste(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doActualPaste(String string) {
            if (string != null) {
                int n = string.indexOf(10);
                if (n != -1) {
                    if (n > 0 && string.charAt(n - 1) == '\r') {
                        --n;
                    }
                } else {
                    n = string.indexOf(13);
                }
                if (n != -1) {
                    string = string.substring(0, n);
                }
                MWTextView mWTextView = null;
                for (Component component = (Component)((KeyEvent)this.fCurrentActionEvent.getSource()).getSource(); component != null; component = component.getParent()) {
                    if (!(component instanceof MWTextView)) continue;
                    mWTextView = (MWTextView)component;
                    break;
                }
                if (mWTextView != null) {
                    try {
                        mWTextView.getModel().startCommand("Paste");
                        mWTextView.getModel().replace(mWTextView.getSel(), string);
                    }
                    finally {
                        mWTextView.getModel().endCommand();
                    }
                }
            }
        }
    }

    private class KeyEventHandler
    extends KeyAdapter {
        private KeyEventHandler() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (!keyEvent.isConsumed()) {
                int n = keyEvent.getModifiers();
                int n2 = keyEvent.getKeyCode();
                if (n == 0 && n2 == 10) {
                    MWTextField.this.fireAction();
                }
            }
        }
    }
}

