/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt;

import com.mathworks.mwt.MWCanvas;
import com.mathworks.mwt.MWComponent;
import com.mathworks.mwt.MWPanel;
import com.mathworks.mwt.decorations.Decorations;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class MWSplitter
extends MWPanel {
    public static final int STYLE_PLAIN = 0;
    public static final int STYLE_GRABBER = 1;
    public static final int STYLE_SEPARATOR = 2;
    public static final int VERTICAL_SPLITTER = 0;
    public static final int HORIZONTAL_SPLITTER = 1;
    public static final String FIRST = "First";
    public static final String SECOND = "Second";
    private static final String DIVIDER = "Divider";
    private static final String DRAGSTRIP = "DragStrip";
    private int fOrientation;
    private int fStyle;
    private Component fFirst;
    private Component fSecond;
    private Divider fDivider;
    private int fDividerLocation;
    private DragStrip fDragStrip;
    private Dimension fCachedSize;
    private double fInitialProportion;
    private ComponentEventHandler fComponentEventHandler;

    public MWSplitter() {
        this(1);
    }

    public MWSplitter(int n) {
        this(null, null, n);
    }

    public MWSplitter(Component component, Component component2) {
        this(component, component2, 1);
    }

    public MWSplitter(Component component, Component component2, int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("Invalid orientation");
        }
        this.setLayout(null);
        this.fOrientation = n;
        this.fStyle = 0;
        this.fComponentEventHandler = new ComponentEventHandler();
        this.fCachedSize = null;
        this.fInitialProportion = 0.5;
        this.fDivider = new Divider();
        this.add((Component)this.fDivider, DIVIDER);
        this.setFirstComponent(component);
        this.setSecondComponent(component2);
        this.fDividerLocation = 0;
        this.fDragStrip = new DragStrip();
        this.add((Component)this.fDragStrip, DRAGSTRIP);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics graphics) {
        try {
            this.fDragStrip.setVisible(false);
            super.paint(graphics);
        }
        finally {
            this.fDragStrip.setVisible(this.fDivider.isVisible());
        }
    }

    public int getOrientation() {
        return this.fOrientation;
    }

    public void setOrientation(int n) {
        if (n == this.fOrientation) {
            return;
        }
        this.fOrientation = n;
        this.invalidate();
        this.validate();
    }

    public Component getFirstComponent() {
        return this.fFirst;
    }

    public void setFirstComponent(Component component) {
        if (component == this.fFirst) {
            return;
        }
        if (component == null) {
            this.fFirst.removeComponentListener(this.fComponentEventHandler);
            this.remove(this.fFirst);
            this.fFirst = null;
        } else {
            this.add(component, FIRST);
            this.fFirst.addComponentListener(this.fComponentEventHandler);
        }
        this.validate();
    }

    public Component getSecondComponent() {
        return this.fSecond;
    }

    public void setSecondComponent(Component component) {
        if (component == this.fSecond) {
            return;
        }
        if (component == null) {
            this.fSecond.removeComponentListener(this.fComponentEventHandler);
            this.remove(this.fSecond);
            this.fSecond = null;
        } else {
            this.add(component, SECOND);
            this.fSecond.addComponentListener(this.fComponentEventHandler);
        }
        this.validate();
    }

    public int getDividerLocation() {
        return this.fDividerLocation;
    }

    public void setDividerLocation(int n) {
        if (n == this.fDividerLocation) {
            return;
        }
        this.fDividerLocation = n < 0 ? 0 : (n > this.getSizeAcrossSplit() - this.getDividerSize() ? this.getSizeAcrossSplit() - this.getDividerSize() : n);
        if (this.fDivider != null && this.fDivider.isVisible()) {
            this.invalidate();
            this.validate();
        }
    }

    public void setDividerLocation(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("Divider location must be in the interval [0.0, 1.0]");
        }
        if (this.fCachedSize == null) {
            this.fInitialProportion = d;
        } else {
            this.setDividerLocation((int)(d * (double)(this.getSizeAcrossSplit() - this.getDividerSize())));
        }
    }

    @Override
    public void addImpl(Component component, Object object, int n) {
        if (object == null) {
            if (this.fFirst == null) {
                object = FIRST;
            } else if (this.fSecond == null) {
                object = SECOND;
            }
        }
        if (FIRST.equals(object)) {
            if (this.fFirst != null) {
                this.remove(this.fFirst);
            }
            this.fFirst = component;
            n = -1;
        } else if (SECOND.equals(object)) {
            if (this.fSecond != null) {
                this.remove(this.fSecond);
            }
            this.fSecond = component;
            n = -1;
        } else if (DIVIDER.equals(object) && component instanceof Divider) {
            this.fDivider = (Divider)component;
            n = -1;
        } else if (DRAGSTRIP.equals(object) && component instanceof DragStrip) {
            this.fDragStrip = (DragStrip)component;
            n = -1;
        } else {
            throw new IllegalArgumentException("illegal constraints");
        }
        super.addImpl(component, object, n);
    }

    @Override
    public void remove(int n) {
        Component component = this.getComponent(n);
        if (component == this.fFirst) {
            this.fFirst = null;
        } else if (component == this.fSecond) {
            this.fSecond = null;
        }
        super.remove(n);
    }

    @Override
    public void remove(Component component) {
        if (component == this.fFirst) {
            this.fFirst = null;
        } else if (component == this.fSecond) {
            this.fSecond = null;
        }
        super.remove(component);
    }

    @Override
    public void removeAll() {
        this.fFirst = null;
        this.fSecond = null;
        super.removeAll();
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dimension = new Dimension();
        Insets insets = this.getInsets();
        if (this.getOrientation() == 0) {
            Dimension dimension2;
            dimension.height = 0;
            dimension.width = this.fDivider.getWidth();
            if (this.fFirst != null && this.fFirst.isVisible()) {
                dimension2 = this.fFirst.getMinimumSize();
                dimension.height = Math.max(dimension.height, dimension2.height);
                dimension.width += dimension2.width;
            }
            if (this.fSecond != null && this.fSecond.isVisible()) {
                dimension2 = this.fSecond.getMinimumSize();
                dimension.height = Math.max(dimension.height, dimension2.height);
                dimension.width += dimension2.width;
            }
        } else {
            Dimension dimension3;
            dimension.width = 0;
            dimension.height = this.fDivider.getWidth();
            if (this.fFirst != null && this.fFirst.isVisible()) {
                dimension3 = this.fFirst.getMinimumSize();
                dimension.width = Math.max(dimension.width, dimension3.width);
                dimension.height += dimension3.height;
            }
            if (this.fSecond != null && this.fSecond.isVisible()) {
                dimension3 = this.fSecond.getMinimumSize();
                dimension.width = Math.max(dimension.width, dimension3.width);
                dimension.height += dimension3.height;
            }
        }
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = new Dimension();
        Insets insets = this.getInsets();
        if (this.getOrientation() == 0) {
            Dimension dimension2;
            dimension.height = 0;
            dimension.width = this.fDivider.getWidth();
            if (this.fFirst != null && this.fFirst.isVisible()) {
                dimension2 = this.fFirst.getPreferredSize();
                dimension.height = Math.max(dimension.height, dimension2.height);
                dimension.width += dimension2.width;
            }
            if (this.fSecond != null && this.fSecond.isVisible()) {
                dimension2 = this.fSecond.getPreferredSize();
                dimension.height = Math.max(dimension.height, dimension2.height);
                dimension.width += dimension2.width;
            }
        } else {
            Dimension dimension3;
            dimension.width = 0;
            dimension.height = this.fDivider.getWidth();
            if (this.fFirst != null && this.fFirst.isVisible()) {
                dimension3 = this.fFirst.getPreferredSize();
                dimension.width = Math.max(dimension.width, dimension3.width);
                dimension.height += dimension3.height;
            }
            if (this.fSecond != null && this.fSecond.isVisible()) {
                dimension3 = this.fSecond.getPreferredSize();
                dimension.width = Math.max(dimension.width, dimension3.width);
                dimension.height += dimension3.height;
            }
        }
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    @Override
    public void doLayout() {
        int n;
        Dimension dimension = this.getSize();
        if (this.fCachedSize == null) {
            this.fCachedSize = dimension;
            this.fDividerLocation = this.getOrientation() == 0 ? (int)((double)(dimension.width - this.fDivider.getWidth()) * this.fInitialProportion) : (int)((double)(dimension.height - this.fDivider.getWidth()) * this.fInitialProportion);
        } else if (!this.fCachedSize.equals(dimension)) {
            n = 0;
            if (this.getOrientation() == 0 && this.fCachedSize.width != 0) {
                n = this.fDividerLocation < 0 ? (int)((double)(dimension.width - this.fDivider.getWidth()) * this.fInitialProportion) : dimension.width * this.fDividerLocation / this.fCachedSize.width;
            } else if (this.fCachedSize.height != 0) {
                n = this.fDividerLocation < 0 ? (int)((double)(dimension.height - this.fDivider.getWidth()) * this.fInitialProportion) : dimension.height * this.fDividerLocation / this.fCachedSize.height;
            }
            this.fCachedSize = dimension;
            this.fDividerLocation = n;
        }
        if (this.getOrientation() == 0) {
            n = 0;
            if (this.fFirst != null && this.fFirst.isVisible()) {
                this.fFirst.setBounds(n, 0, this.fDividerLocation, dimension.height);
                n += this.fFirst.getSize().width;
            }
            if (this.fDivider != null && this.fDivider.isVisible()) {
                this.fDivider.setBounds(n, 0, this.fDivider.getWidth(), dimension.height);
                this.fDragStrip.setBounds(n - 1, 0, this.fDivider.getWidth() + 3, dimension.height);
                n += this.fDivider.getSize().width;
            }
            if (this.fSecond != null && this.fSecond.isVisible()) {
                this.fSecond.setBounds(n, 0, dimension.width - n, dimension.height);
                n += this.fSecond.getSize().width;
            }
        } else {
            n = 0;
            if (this.fFirst != null && this.fFirst.isVisible()) {
                this.fFirst.setBounds(0, n, dimension.width, this.fDividerLocation);
                n += this.fFirst.getSize().height;
            }
            if (this.fDivider != null && this.fDivider.isVisible()) {
                this.fDivider.setBounds(0, n, dimension.width, this.fDivider.getWidth());
                this.fDragStrip.setBounds(0, n - 1, dimension.width, this.fDivider.getWidth() + 3);
                n += this.fDivider.getSize().height;
            }
            if (this.fSecond != null && this.fSecond.isVisible()) {
                this.fSecond.setBounds(0, n, dimension.width, dimension.height - n);
                n += this.fSecond.getSize().height;
            }
        }
    }

    @Override
    public boolean isFocusTraversable() {
        return this.fFirst != null && this.fFirst.isVisible() && this.fFirst.isFocusTraversable() || this.fSecond != null && this.fSecond.isVisible() && this.fSecond.isFocusTraversable();
    }

    @Override
    public void requestFocus() {
        if (this.fFirst != null && this.fFirst.isVisible() && this.fFirst.isFocusTraversable()) {
            this.fFirst.requestFocus();
        }
        if (this.fSecond != null && this.fSecond.isVisible() && this.fSecond.isFocusTraversable()) {
            this.fSecond.requestFocus();
        }
    }

    public int getSizeAlongSplit() {
        return this.getSizeAlongSplit(this.getSize());
    }

    private int getSizeAlongSplit(Dimension dimension) {
        if (dimension == null) {
            throw new IllegalArgumentException();
        }
        if (this.fOrientation == 0) {
            return dimension.height;
        }
        return dimension.width;
    }

    private void setLengthAlongSplit(Dimension dimension, int n) {
        if (dimension == null) {
            throw new IllegalArgumentException();
        }
        if (this.fOrientation == 0) {
            dimension.height = n;
        } else {
            dimension.width = n;
        }
    }

    public int getSizeAcrossSplit() {
        return this.getSizeAcrossSplit(this.getSize());
    }

    private int getSizeAcrossSplit(Dimension dimension) {
        if (dimension == null) {
            throw new IllegalArgumentException();
        }
        if (this.fOrientation == 0) {
            return dimension.width;
        }
        return dimension.height;
    }

    private void setLengthAcrossSplit(Dimension dimension, int n) {
        if (dimension == null) {
            throw new IllegalArgumentException();
        }
        if (this.fOrientation == 0) {
            dimension.width = n;
        } else {
            dimension.height = n;
        }
    }

    private int getDividerSize() {
        return this.fDivider.getWidth();
    }

    public boolean bothPanesVisible() {
        return this.fFirst != null && this.fFirst.isVisible() && this.fSecond != null && this.fSecond.isVisible();
    }

    public int getStyle() {
        return this.fStyle;
    }

    public void setStyle(int n) {
        if (n != this.fStyle) {
            switch (n) {
                case 0: 
                case 1: 
                case 2: {
                    this.fStyle = n;
                }
            }
        }
    }

    public void setDividerDark(boolean bl) {
        if (bl) {
            this.setStyle(2);
        } else {
            this.setStyle(0);
        }
    }

    private class ComponentEventHandler
    extends ComponentAdapter {
        private ComponentEventHandler() {
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
            MWSplitter.this.validate();
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
            MWSplitter.this.validate();
        }
    }

    private class DragStrip
    extends MWComponent {
        boolean fVisible = true;

        public DragStrip() {
            this.enableEvents(48L);
        }

        @Override
        public void processMouseEvent(MouseEvent mouseEvent) {
            if (mouseEvent.getID() == 501 || mouseEvent.getID() == 502) {
                if (MWSplitter.this.getOrientation() == 0) {
                    mouseEvent.translatePoint(-1, 0);
                } else {
                    mouseEvent.translatePoint(0, -1);
                }
                MWSplitter.this.fDivider.processMouseEvent(mouseEvent);
            }
        }

        @Override
        protected void processMouseMotionEvent(MouseEvent mouseEvent) {
            int n;
            if (MWSplitter.this.getOrientation() == 0) {
                n = mouseEvent.getX();
                mouseEvent.translatePoint(-1, 0);
            } else {
                n = mouseEvent.getY();
                mouseEvent.translatePoint(0, -1);
            }
            if (mouseEvent.getID() == 506) {
                MWSplitter.this.fDivider.mouseDragged(mouseEvent);
            } else if (mouseEvent.getID() == 503 && n > 0 && n <= MWSplitter.this.fDivider.getWidth()) {
                MWSplitter.this.fDivider.mouseMoved(mouseEvent);
            }
        }

        @Override
        public boolean isVisible() {
            return this.fVisible;
        }

        @Override
        public void setVisible(boolean bl) {
            this.fVisible = bl;
        }
    }

    private class Divider
    extends MWCanvas
    implements MouseListener,
    MouseMotionListener {
        private int fDividerWidth = 3;
        private int fGrabberLength = 30;
        private Point fOffset;
        long fExitTime;

        Divider() {
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }

        @Override
        public void setVisible(boolean bl) {
            super.setVisible(bl);
            MWSplitter.this.fDragStrip.setVisible(bl);
        }

        @Override
        public void paint(Graphics graphics) {
            Dimension dimension = this.getSize();
            graphics.setColor(Decorations.getColor(6));
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            switch (MWSplitter.this.getStyle()) {
                case 1: {
                    this.drawGrabber(graphics, dimension.width, dimension.height);
                    break;
                }
                case 2: {
                    this.drawSeparator(graphics, dimension.width, dimension.height);
                }
            }
        }

        private void drawGrabber(Graphics graphics, int n, int n2) {
            if (MWSplitter.this.getOrientation() == 0) {
                int n3 = (n2 - this.fGrabberLength) / 2;
                int n4 = n / 2;
                graphics.setColor(Decorations.getColor(7));
                graphics.drawLine(n4 - 1, n3, n4 - 1, n3 + this.fGrabberLength);
                graphics.setColor(Decorations.getColor(9));
                graphics.drawLine(n4, n3, n4, n3 + this.fGrabberLength);
            } else {
                int n5 = (n - this.fGrabberLength) / 2;
                int n6 = n2 / 2;
                graphics.setColor(Decorations.getColor(7));
                graphics.drawLine(n5, n6 - 1, n5 + this.fGrabberLength, n6 - 1);
                graphics.setColor(Decorations.getColor(9));
                graphics.drawLine(n5, n6, n5 + this.fGrabberLength, n6);
            }
        }

        private void drawSeparator(Graphics graphics, int n, int n2) {
            if (MWSplitter.this.getOrientation() == 0) {
                int n3 = n / 2;
                graphics.setColor(Decorations.getColor(9));
                graphics.drawLine(n3 - 1, 0, n3 - 1, n2 - 1);
                graphics.setColor(Decorations.getColor(7));
                graphics.drawLine(n3, 0, n3, n2 - 1);
            } else {
                int n4 = n2 / 2;
                graphics.setColor(Decorations.getColor(9));
                graphics.drawLine(0, n4 - 1, n - 1, n4 - 1);
                graphics.setColor(Decorations.getColor(7));
                graphics.drawLine(0, n4, n - 1, n4);
            }
        }

        @Override
        public int getWidth() {
            return this.fDividerWidth;
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.getModifiers() == 16 && mouseEvent.getWhen() < this.fExitTime) {
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                mouseEvent.translatePoint(-n, -n2);
                this.mouseMoved(mouseEvent);
                MWSplitter.this.fDragStrip.setCursor(this.getCursor());
                mouseEvent.translatePoint(n, n2);
                this.fOffset = mouseEvent.getPoint();
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            Point point2 = this.getLocation();
            if (mouseEvent.getWhen() > this.fExitTime) {
                return;
            }
            if (this.fOffset == null) {
                this.mousePressed(mouseEvent);
                return;
            }
            int n = MWSplitter.this.getOrientation() == 0 ? point.x + point2.x - this.fOffset.x : point.y + point2.y - this.fOffset.y;
            MWSplitter.this.setDividerLocation(n);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            Dimension dimension = this.getSize();
            Point point = mouseEvent.getPoint();
            if (point.x >= 0 && point.y >= 0 && point.x < dimension.width && point.y < dimension.height) {
                this.fExitTime = Long.MAX_VALUE;
                if (MWSplitter.this.getOrientation() == 0) {
                    this.setCursor(Cursor.getPredefinedCursor(11));
                } else {
                    this.setCursor(Cursor.getPredefinedCursor(8));
                }
            } else {
                this.setCursor(Cursor.getDefaultCursor());
                MWSplitter.this.fDragStrip.setCursor(Cursor.getDefaultCursor());
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.fOffset = null;
            this.mouseMoved(mouseEvent);
            this.fExitTime = 0L;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            if (this.fOffset == null) {
                this.mouseMoved(mouseEvent);
                this.fExitTime = Long.MAX_VALUE;
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (this.fOffset == null) {
                this.mouseMoved(mouseEvent);
                this.fExitTime = mouseEvent.getWhen() + 250L;
            }
        }
    }
}

