/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt;

import com.mathworks.util.ResLoader;
import com.mathworks.util.jarloader.SimpleClassLoader;
import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.ImageProducer;
import java.awt.image.MemoryImageSource;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.net.URL;
import java.util.Hashtable;

public class MWImageResource {
    private static final String UNKNOWN_ICON = "/com/mathworks/mwt/resources/unknownicon.gif";
    private static ImageWaiter sWaiter = new ImageWaiter();
    private static Hashtable sImageCache = new Hashtable();
    private String fResourceName;
    private Class fOwnerClass;
    private ImageProducer fProducer;
    private int fWidth;
    private int fHeight;
    private int[] fData;
    private boolean fIsWrapper;
    private boolean fIsLoaded;
    private Image fImage;

    public MWImageResource(int n, int n2, int[] nArray) {
        this.fWidth = n;
        this.fHeight = n2;
        this.fData = nArray;
        this.fIsWrapper = false;
        this.fIsLoaded = false;
        this.fImage = null;
        this.fResourceName = null;
        this.fOwnerClass = null;
    }

    public MWImageResource(String string, Object object) {
        this(0, 0, null);
        if (object != null) {
            this.fOwnerClass = object.getClass();
        }
        this.setResourceName(string);
    }

    public MWImageResource(String string, Class clazz) {
        this(0, 0, null);
        this.fOwnerClass = clazz;
        this.setResourceName(string);
    }

    public MWImageResource(String string, ImageProducer imageProducer) {
        this(0, 0, null);
        this.fProducer = imageProducer;
        this.setResourceName(string);
    }

    public MWImageResource(String string) {
        this(string, (Object)null);
    }

    public MWImageResource(Image image) {
        this(0, 0, null);
        this.fImage = image;
        this.fIsWrapper = true;
    }

    public void setResourceName(String string) {
        this.dispose();
        this.fResourceName = string;
    }

    public String getResourceName() {
        return this.fResourceName;
    }

    public Image getImage(Component component) {
        return this.getImage();
    }

    public Image getImage() {
        if (this.fImage == null) {
            if (this.fData != null) {
                this.buildMemoryImage();
            } else if (this.fResourceName != null) {
                SharedImage sharedImage = this.getEntry();
                if (sharedImage != null) {
                    if (sharedImage.getImageResource().fProducer != null) {
                        this.fProducer = sharedImage.getImageResource().fProducer;
                    }
                    this.fImage = sharedImage.getImage();
                } else {
                    this.loadImage();
                }
            }
        } else if (this.fIsWrapper && !this.fIsLoaded) {
            MediaTracker mediaTracker = new MediaTracker(sWaiter);
            mediaTracker.addImage(this.fImage, 1);
            try {
                mediaTracker.waitForID(1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.fImage;
    }

    private void buildMemoryImage() {
        if (this.fWidth * this.fHeight == this.fData.length) {
            MemoryImageSource memoryImageSource = new MemoryImageSource(this.fWidth, this.fHeight, this.fData, 0, this.fWidth);
            this.fImage = Toolkit.getDefaultToolkit().createImage(memoryImageSource);
            MediaTracker mediaTracker = new MediaTracker(sWaiter);
            mediaTracker.addImage(this.fImage, 1);
            try {
                mediaTracker.waitForID(1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void loadImage() {
        Image image = null;
        String string = this.fResourceName;
        Class clazz = this.fOwnerClass != null ? this.fOwnerClass : Object.class;
        ResLoader resLoader = new ResLoader(clazz);
        if (this.fProducer != null) {
            image = resLoader.loadImage(this.fProducer);
        } else {
            image = resLoader.loadImage(this.fResourceName);
            if (image != null && string.charAt(0) != '/') {
                string = this.classToPath(this.fOwnerClass) + string;
            }
            if (image == null) {
                image = this.beanIcon(this.fResourceName);
            }
            if (image == null) {
                try {
                    image = resLoader.loadImage(new URL("file", "", this.fResourceName));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (image != null) {
            SharedImage sharedImage = new SharedImage(image, this);
            sImageCache.put(string, sharedImage);
            this.fImage = sharedImage.getImage();
        }
    }

    private String classToPath(Class clazz) {
        String string = "/";
        if (clazz != null) {
            string = string + clazz.getName();
            string = string.replace('.', '/');
            string = string.substring(0, string.lastIndexOf(47) + 1);
        }
        return string;
    }

    private Image beanIcon(String string) {
        BeanInfo beanInfo = null;
        Image image = null;
        try {
            Class clazz = SimpleClassLoader.ourLoader.loadClass(string);
            if (clazz != null) {
                beanInfo = Introspector.getBeanInfo(clazz);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (beanInfo != null && (image = beanInfo.getIcon(1)) == null) {
            ResLoader resLoader = new ResLoader(Object.class);
            image = resLoader.loadImage(UNKNOWN_ICON);
        }
        return image;
    }

    public void dispose() {
        if (this.fImage != null) {
            SharedImage sharedImage = this.getEntry();
            if (sharedImage != null) {
                sharedImage.flushImage();
            } else {
                this.fImage.flush();
            }
        }
        if (!this.fIsWrapper) {
            this.fImage = null;
        } else {
            this.fIsLoaded = false;
        }
    }

    private final SharedImage getEntry() {
        SharedImage sharedImage = null;
        if (this.fResourceName != null) {
            String string;
            if (sImageCache.containsKey(this.fResourceName)) {
                sharedImage = (SharedImage)sImageCache.get(this.fResourceName);
            } else if (this.fOwnerClass != null && this.fResourceName.charAt(0) != '/' && sImageCache.containsKey(string = this.classToPath(this.fOwnerClass) + this.fResourceName)) {
                sharedImage = (SharedImage)sImageCache.get(string);
            }
        }
        return sharedImage;
    }

    private static class ImageWaiter
    extends Component {
        private ImageWaiter() {
        }
    }

    private class SharedImage {
        private Image fImage;
        private int fReferenceCount;
        private MWImageResource fImageResource;

        SharedImage(Image image, MWImageResource mWImageResource2) {
            this.fImage = image;
            this.fReferenceCount = 0;
            this.fImageResource = mWImageResource2;
        }

        MWImageResource getImageResource() {
            return this.fImageResource;
        }

        Image getImage() {
            if (this.fReferenceCount == 0 && this.fImage != null) {
                MediaTracker mediaTracker = new MediaTracker(sWaiter);
                mediaTracker.addImage(this.fImage, 1);
                try {
                    mediaTracker.waitForID(1);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ++this.fReferenceCount;
            return this.fImage;
        }

        void flushImage() {
            if (this.fReferenceCount > 0) {
                --this.fReferenceCount;
                if (this.fReferenceCount == 0 && this.fImage != null) {
                    this.fImage.flush();
                }
            }
        }
    }
}

