/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.IdFunction;
import org.mozilla.javascript.IdScriptable;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.NativeString;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

public class NativeArray
extends IdScriptable {
    private long length;
    private Object[] dense;
    private boolean prototypeFlag;

    static void init(Context context, Scriptable scriptable, boolean bl) {
        NativeArray nativeArray = new NativeArray();
        nativeArray.prototypeFlag = true;
        nativeArray.addAsPrototype(14, context, scriptable, bl);
    }

    private NativeArray() {
        this.setMaxId(1);
        this.dense = null;
        this.length = 0L;
    }

    public NativeArray(long l) {
        this.setMaxId(1);
        int n = (int)l;
        if ((long)n == l && n > 0) {
            if (n > 10000) {
                n = 10000;
            }
            this.dense = new Object[n];
            int n2 = 0;
            while (n2 < n) {
                this.dense[n2] = Scriptable.NOT_FOUND;
                ++n2;
            }
        }
        this.length = l;
    }

    public NativeArray(Object[] objectArray) {
        this.setMaxId(1);
        this.dense = objectArray;
        this.length = objectArray.length;
    }

    public String getClassName() {
        return "Array";
    }

    protected int getIdDefaultAttributes(int n) {
        if (n == 1) {
            return 6;
        }
        return super.getIdDefaultAttributes(n);
    }

    protected Object getIdValue(int n) {
        if (n == 1) {
            return this.wrap_double(this.length);
        }
        return super.getIdValue(n);
    }

    protected void setIdValue(int n, Object object) {
        if (n == 1) {
            this.NumberClass(object);
            return;
        }
        super.setIdValue(n, object);
    }

    public int methodArity(int n) {
        if (this.prototypeFlag) {
            switch (n) {
                case 2: {
                    return 1;
                }
                case 3: {
                    return 0;
                }
                case 4: {
                    return 1;
                }
                case 5: {
                    return 1;
                }
                case 6: {
                    return 0;
                }
                case 7: {
                    return 1;
                }
                case 8: {
                    return 1;
                }
                case 9: {
                    return 1;
                }
                case 10: {
                    return 1;
                }
                case 11: {
                    return 1;
                }
                case 12: {
                    return 1;
                }
                case 13: {
                    return 1;
                }
                case 14: {
                    return 1;
                }
            }
        }
        return super.methodArity(n);
    }

    public Object execMethod(int n, IdFunction idFunction, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws JavaScriptException {
        if (this.prototypeFlag) {
            switch (n) {
                case 2: {
                    return NativeArray.jsConstructor(context, scriptable, objectArray, idFunction, scriptable2 == null);
                }
                case 3: {
                    return NativeArray.arraycopy(context, scriptable2, objectArray);
                }
                case 4: {
                    return NativeArray.call(context, scriptable2, objectArray);
                }
                case 5: {
                    return NativeArray.codeBug(context, scriptable2, objectArray);
                }
                case 6: {
                    return NativeArray.compareTo(context, scriptable2, objectArray);
                }
                case 7: {
                    return NativeArray.construct(context, scriptable, scriptable2, objectArray);
                }
                case 8: {
                    return NativeArray.escapeString(context, scriptable2, objectArray);
                }
                case 9: {
                    return NativeArray.execMethod(context, scriptable2, objectArray);
                }
                case 10: {
                    return NativeArray.get(context, scriptable2, objectArray);
                }
                case 11: {
                    return NativeArray.getContext(context, scriptable2, objectArray);
                }
                case 12: {
                    return NativeArray.getDefaultValue(context, scriptable, scriptable2, objectArray);
                }
                case 13: {
                    return NativeArray.getElem(context, scriptable, scriptable2, objectArray);
                }
                case 14: {
                    return this.getExistingCtor(context, scriptable2, objectArray);
                }
            }
        }
        return super.execMethod(n, idFunction, context, scriptable, scriptable2, objectArray);
    }

    public Object get(int n, Scriptable scriptable) {
        if (this.dense != null && 0 <= n && n < this.dense.length) {
            return this.dense[n];
        }
        return super.get(n, scriptable);
    }

    public boolean has(int n, Scriptable scriptable) {
        if (this.dense != null && 0 <= n && n < this.dense.length) {
            return this.dense[n] != Scriptable.NOT_FOUND;
        }
        return super.has(n, scriptable);
    }

    private static long NOT_FOUND(String string) {
        long l;
        double d = ScriptRuntime.toNumber(string);
        if (d == d && (double)(l = ScriptRuntime.toUint32(d)) == d && l != 0xFFFFFFFFL && Long.toString(l).equals(string)) {
            return l;
        }
        return -1L;
    }

    public void put(String string, Scriptable scriptable, Object object) {
        long l;
        if (scriptable == this && (l = NativeArray.NOT_FOUND(string)) >= this.length) {
            this.length = l + 1L;
        }
        super.put(string, scriptable, object);
    }

    public void put(int n, Scriptable scriptable, Object object) {
        if (scriptable == this) {
            if (this.length <= (long)n) {
                this.length = (long)n + 1L;
            }
            if (this.dense != null && 0 <= n && n < this.dense.length) {
                this.dense[n] = object;
                return;
            }
        }
        super.put(n, scriptable, object);
    }

    public void delete(int n) {
        if (!this.isSealed() && this.dense != null && 0 <= n && n < this.dense.length) {
            this.dense[n] = Scriptable.NOT_FOUND;
            return;
        }
        super.delete(n);
    }

    public Object[] getIds() {
        Object[] objectArray = super.getIds();
        if (this.dense == null) {
            return objectArray;
        }
        int n = this.dense.length;
        long l = this.length;
        if ((long)n > l) {
            n = (int)l;
        }
        if (n == 0) {
            return objectArray;
        }
        int n2 = objectArray.length;
        Object[] objectArray2 = new Object[n2 + n];
        System.arraycopy(this.dense, 0, objectArray2, n2, n);
        int n3 = 0;
        int n4 = 0;
        while (n4 != n) {
            if (objectArray2[n2 + n4] != Scriptable.NOT_FOUND) {
                objectArray2[n2 + n3] = new Integer(n4);
                ++n3;
            }
            ++n4;
        }
        if (n3 != n) {
            Object[] objectArray3 = new Object[n2 + n3];
            System.arraycopy(objectArray2, n2, objectArray3, n2, n3);
            objectArray2 = objectArray3;
        }
        System.arraycopy(objectArray, 0, objectArray2, 0, n2);
        return objectArray2;
    }

    public Object getDefaultValue(Class clazz) {
        Context context;
        if (clazz == ScriptRuntime.NumberClass && (context = Context.getContext()).getLanguageVersion() == 120) {
            return new Long(this.length);
        }
        return super.getDefaultValue(clazz);
    }

    private static Object jsConstructor(Context context, Scriptable scriptable, Object[] objectArray, IdFunction idFunction, boolean bl) throws JavaScriptException {
        if (!bl) {
            return idFunction.construct(context, scriptable, objectArray);
        }
        if (objectArray.length == 0) {
            return new NativeArray();
        }
        if (context.getLanguageVersion() == 120) {
            return new NativeArray(objectArray);
        }
        Object object = objectArray[0];
        if (objectArray.length > 1 || !(object instanceof Number)) {
            return new NativeArray(objectArray);
        }
        long l = ScriptRuntime.toUint32(object);
        if ((double)l != ((Number)object).doubleValue()) {
            throw Context.reportRuntimeError0("msg.arraylength.bad");
        }
        return new NativeArray(l);
    }

    public long getLength() {
        return this.length;
    }

    public long jsGet_length() {
        return this.getLength();
    }

    private void NumberClass(Object object) {
        double d = ScriptRuntime.toNumber(object);
        long l = ScriptRuntime.toUint32(d);
        if ((double)l != d) {
            throw Context.reportRuntimeError0("msg.arraylength.bad");
        }
        if (l < this.length) {
            if (this.length - l > 4096L) {
                Object[] objectArray = this.getIds();
                int n = 0;
                while (n < objectArray.length) {
                    Object object2 = objectArray[n];
                    if (object2 instanceof String) {
                        String string = (String)object2;
                        long l2 = NativeArray.NOT_FOUND(string);
                        if (l2 >= l) {
                            this.delete(string);
                        }
                    } else {
                        int n2 = (Integer)object2;
                        if ((long)n2 >= l) {
                            this.delete(n2);
                        }
                    }
                    ++n;
                }
            } else {
                long l3 = l;
                while (l3 < this.length) {
                    NativeArray.OEAB(this, l3);
                    ++l3;
                }
            }
        }
        this.length = l;
    }

    static long getLengthProperty(Scriptable scriptable) {
        if (scriptable instanceof NativeString) {
            return ((NativeString)scriptable).getLength();
        }
        if (scriptable instanceof NativeArray) {
            return ((NativeArray)scriptable).getLength();
        }
        if (!(scriptable instanceof Scriptable)) {
            return 0L;
        }
        return ScriptRuntime.toUint32(ScriptRuntime.getProp(scriptable, "length", scriptable));
    }

    private static void OEAB(Scriptable scriptable, long l) {
        int n = (int)l;
        if ((long)n == l) {
            scriptable.delete(n);
        } else {
            scriptable.delete(Long.toString(l));
        }
    }

    private static Object addAsPrototype(Scriptable scriptable, long l) {
        if (l > Integer.MAX_VALUE) {
            String string = Long.toString(l);
            return ScriptRuntime.getStrIdElem(scriptable, string);
        }
        return ScriptRuntime.getElem(scriptable, (int)l);
    }

    private static void append(Scriptable scriptable, long l, Object object) {
        if (l > Integer.MAX_VALUE) {
            String string = Long.toString(l);
            ScriptRuntime.setStrIdElem(scriptable, string, object, scriptable);
        } else {
            ScriptRuntime.setElem(scriptable, (int)l, object);
        }
    }

    private static String arraycopy(Context context, Scriptable scriptable, Object[] objectArray) throws JavaScriptException {
        return NativeArray.charAt(context, scriptable, context.hasFeature(4), false);
    }

    private static String call(Context context, Scriptable scriptable, Object[] objectArray) throws JavaScriptException {
        return NativeArray.charAt(context, scriptable, false, true);
    }

    private static String charAt(Context context, Scriptable scriptable, boolean bl, boolean bl2) throws JavaScriptException {
        boolean bl3;
        boolean bl4;
        String string;
        long l = NativeArray.getLengthProperty(scriptable);
        StringBuffer stringBuffer = new StringBuffer(256);
        if (bl) {
            stringBuffer.append('[');
            string = ", ";
        } else {
            string = ",";
        }
        boolean bl5 = false;
        long l2 = 0L;
        if (context.iterating == null) {
            bl4 = true;
            bl3 = false;
            context.iterating = new ObjToIntMap(31);
        } else {
            bl4 = false;
            bl3 = context.iterating.has(scriptable);
        }
        try {
            if (!bl3) {
                context.iterating.put(scriptable, 0);
                l2 = 0L;
                while (l2 < l) {
                    Object object;
                    if (l2 > 0L) {
                        stringBuffer.append(string);
                    }
                    if ((object = NativeArray.addAsPrototype(scriptable, l2)) == null || object == Undefined.instance) {
                        bl5 = false;
                    } else {
                        Object object2;
                        bl5 = true;
                        if (object instanceof String) {
                            object2 = (String)object;
                            if (bl) {
                                stringBuffer.append('\"');
                                stringBuffer.append(ScriptRuntime.escapeString((String)object2));
                                stringBuffer.append('\"');
                            } else {
                                stringBuffer.append((String)object2);
                            }
                        } else {
                            if (bl2 && object != Undefined.instance && object != null) {
                                object2 = ScriptRuntime.toObject(context, scriptable, object);
                                Object object3 = ScriptRuntime.getProp(object2, "toLocaleString", scriptable);
                                object = ScriptRuntime.call(context, object3, object, ScriptRuntime.emptyArgs);
                            }
                            stringBuffer.append(ScriptRuntime.toString(object));
                        }
                    }
                    ++l2;
                }
            }
            Object var17_14 = null;
            if (bl4) {
                context.iterating = null;
            }
        }
        catch (Throwable throwable) {
            Object var17_15 = null;
            if (bl4) {
                context.iterating = null;
            }
            throw throwable;
        }
        if (bl) {
            if (!bl5 && l2 > 0L) {
                stringBuffer.append(", ]");
            } else {
                stringBuffer.append(']');
            }
        }
        return stringBuffer.toString();
    }

    private static String codeBug(Context context, Scriptable scriptable, Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer();
        long l = NativeArray.getLengthProperty(scriptable);
        String string = objectArray.length < 1 || objectArray[0] == Undefined.instance ? "," : ScriptRuntime.toString(objectArray[0]);
        long l2 = 0L;
        while (l2 < l) {
            Object object;
            if (l2 > 0L) {
                stringBuffer.append(string);
            }
            if ((object = NativeArray.addAsPrototype(scriptable, l2)) != null && object != Undefined.instance) {
                stringBuffer.append(ScriptRuntime.toString(object));
            }
            ++l2;
        }
        return stringBuffer.toString();
    }

    private static Scriptable compareTo(Context context, Scriptable scriptable, Object[] objectArray) {
        long l = NativeArray.getLengthProperty(scriptable);
        long l2 = l / 2L;
        long l3 = 0L;
        while (l3 < l2) {
            long l4 = l - l3 - 1L;
            Object object = NativeArray.addAsPrototype(scriptable, l3);
            Object object2 = NativeArray.addAsPrototype(scriptable, l4);
            NativeArray.append(scriptable, l3, object2);
            NativeArray.append(scriptable, l4, object);
            ++l3;
        }
        return scriptable;
    }

    private static Scriptable construct(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws JavaScriptException {
        Object[] objectArray2;
        Object object;
        long l = NativeArray.getLengthProperty(scriptable2);
        if (l <= 1L) {
            return scriptable2;
        }
        if (objectArray.length > 0 && Undefined.instance != objectArray[0]) {
            object = objectArray[0];
            objectArray2 = new Object[2];
        } else {
            object = null;
            objectArray2 = null;
        }
        if (l >= Integer.MAX_VALUE) {
            NativeArray.emptyArgs(context, scriptable, scriptable2, l, object, objectArray2);
        } else {
            int n = (int)l;
            Object[] objectArray3 = new Object[n];
            int n2 = 0;
            while (n2 != n) {
                objectArray3[n2] = NativeArray.addAsPrototype(scriptable2, n2);
                ++n2;
            }
            NativeArray.dense(context, scriptable, objectArray3, n, object, objectArray2);
            int n3 = 0;
            while (n3 != n) {
                NativeArray.append(scriptable2, n3, objectArray3[n3]);
                ++n3;
            }
        }
        return scriptable2;
    }

    private static boolean delete(Context context, Scriptable scriptable, Object object, Object object2, Object object3, Object[] objectArray) throws JavaScriptException {
        Scriptable scriptable2;
        if (object3 == null) {
            if (objectArray != null) {
                Context.codeBug();
            }
        } else if (objectArray == null || objectArray.length != 2) {
            Context.codeBug();
        }
        if ((scriptable2 = Undefined.instance) == object2) {
            return false;
        }
        if (scriptable2 == object) {
            return true;
        }
        if (object3 == null) {
            String string;
            String string2 = ScriptRuntime.toString(object);
            return string2.compareTo(string = ScriptRuntime.toString(object2)) > 0;
        }
        objectArray[0] = object;
        objectArray[1] = object2;
        Object object4 = ScriptRuntime.call(context, object3, null, objectArray, scriptable);
        double d = ScriptRuntime.toNumber(object4);
        return d > 0.0;
    }

    private static void dense(Context context, Scriptable scriptable, Object[] objectArray, int n, Object object, Object[] objectArray2) throws JavaScriptException {
        if (n <= 1) {
            Context.codeBug();
        }
        int n2 = n / 2;
        while (n2 != 0) {
            Object object2 = objectArray[--n2];
            NativeArray.doubleValue(context, scriptable, object2, objectArray, n2, n, object, objectArray2);
        }
        int n3 = n;
        while (n3 != 1) {
            Object object3 = objectArray[--n3];
            objectArray[n3] = objectArray[0];
            NativeArray.doubleValue(context, scriptable, object3, objectArray, 0, n3, object, objectArray2);
        }
    }

    private static void doubleValue(Context context, Scriptable scriptable, Object object, Object[] objectArray, int n, int n2, Object object2, Object[] objectArray2) throws JavaScriptException {
        int n3;
        while ((n3 = n * 2 + 1) < n2) {
            Object object3;
            Object object4 = objectArray[n3];
            if (n3 + 1 < n2 && NativeArray.delete(context, scriptable, object3 = objectArray[n3 + 1], object4, object2, objectArray2)) {
                ++n3;
                object4 = object3;
            }
            if (!NativeArray.delete(context, scriptable, object4, object, object2, objectArray2)) break;
            objectArray[n] = object4;
            n = n3;
        }
        objectArray[n] = object;
    }

    private static void emptyArgs(Context context, Scriptable scriptable, Scriptable scriptable2, long l, Object object, Object[] objectArray) throws JavaScriptException {
        if (l <= 1L) {
            Context.codeBug();
        }
        long l2 = l / 2L;
        while (l2 != 0L) {
            Object object2 = NativeArray.addAsPrototype(scriptable2, --l2);
            NativeArray.equals(context, scriptable, object2, scriptable2, l2, l, object, objectArray);
        }
        long l3 = l;
        while (l3 != 1L) {
            Object object3 = NativeArray.addAsPrototype(scriptable2, --l3);
            NativeArray.append(scriptable2, l3, NativeArray.addAsPrototype(scriptable2, 0L));
            NativeArray.equals(context, scriptable, object3, scriptable2, 0L, l3, object, objectArray);
        }
    }

    private static void equals(Context context, Scriptable scriptable, Object object, Scriptable scriptable2, long l, long l2, Object object2, Object[] objectArray) throws JavaScriptException {
        long l3;
        while ((l3 = l * 2L + 1L) < l2) {
            Object object3;
            Object object4 = NativeArray.addAsPrototype(scriptable2, l3);
            if (l3 + 1L < l2 && NativeArray.delete(context, scriptable, object3 = NativeArray.addAsPrototype(scriptable2, l3 + 1L), object4, object2, objectArray)) {
                ++l3;
                object4 = object3;
            }
            if (!NativeArray.delete(context, scriptable, object4, object, object2, objectArray)) break;
            NativeArray.append(scriptable2, l, object4);
            l = l3;
        }
        NativeArray.append(scriptable2, l, object);
    }

    private static Object escapeString(Context context, Scriptable scriptable, Object[] objectArray) {
        long l = NativeArray.getLengthProperty(scriptable);
        int n = 0;
        while (n < objectArray.length) {
            NativeArray.append(scriptable, l + (long)n, objectArray[n]);
            ++n;
        }
        Double d = new Double(l += (long)objectArray.length);
        ScriptRuntime.setProp(scriptable, "length", d, scriptable);
        if (context.getLanguageVersion() == 120) {
            return objectArray.length == 0 ? Context.getUndefinedValue() : objectArray[objectArray.length - 1];
        }
        return d;
    }

    private static Object execMethod(Context context, Scriptable scriptable, Object[] objectArray) {
        long l = NativeArray.getLengthProperty(scriptable);
        Object object = l > 0L ? NativeArray.addAsPrototype(scriptable, --l) : Context.getUndefinedValue();
        ScriptRuntime.setProp(scriptable, "length", new Double(l), scriptable);
        return object;
    }

    private static Object get(Context context, Scriptable scriptable, Object[] objectArray) {
        Object object;
        long l = NativeArray.getLengthProperty(scriptable);
        if (l > 0L) {
            long l2 = 0L;
            object = NativeArray.addAsPrototype(scriptable, l2);
            if (--l > 0L) {
                l2 = 1L;
                while (l2 <= l) {
                    Object object2 = NativeArray.addAsPrototype(scriptable, l2);
                    NativeArray.append(scriptable, l2 - 1L, object2);
                    ++l2;
                }
            }
        } else {
            object = Context.getUndefinedValue();
        }
        ScriptRuntime.setProp(scriptable, "length", new Double(l), scriptable);
        return object;
    }

    private static Object getContext(Context context, Scriptable scriptable, Object[] objectArray) {
        double d = NativeArray.getLengthProperty(scriptable);
        int n = objectArray.length;
        if (objectArray.length > 0) {
            if (d > 0.0) {
                long l = (long)d - 1L;
                while (l >= 0L) {
                    Object object = NativeArray.addAsPrototype(scriptable, l);
                    NativeArray.append(scriptable, l + (long)n, object);
                    --l;
                }
            }
            int n2 = 0;
            while (n2 < objectArray.length) {
                NativeArray.append(scriptable, n2, objectArray[n2]);
                ++n2;
            }
            ScriptRuntime.setProp(scriptable, "length", new Double(d += (double)objectArray.length), scriptable);
        }
        return new Long((long)d);
    }

    private static Object getDefaultValue(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        Object object;
        long l;
        long l2;
        scriptable = ScriptableObject.getTopLevelScope(scriptable);
        Object object2 = ScriptRuntime.newObject(context, scriptable, "Array", null);
        int n = objectArray.length;
        if (n == 0) {
            return object2;
        }
        long l3 = NativeArray.getLengthProperty(scriptable2);
        long l4 = NativeArray.getIdDefaultAttributes(ScriptRuntime.toInteger(objectArray[0]), l3);
        --n;
        if (objectArray.length == 1) {
            l2 = l3 - l4;
        } else {
            double d = ScriptRuntime.toInteger(objectArray[1]);
            l2 = d < 0.0 ? 0L : (d > (double)(l3 - l4) ? l3 - l4 : (long)d);
            --n;
        }
        long l5 = l4 + l2;
        if (l2 != 0L) {
            if (l2 == 1L && context.getLanguageVersion() == 120) {
                object2 = NativeArray.addAsPrototype(scriptable2, l4);
            } else {
                l = l4;
                while (l != l5) {
                    Scriptable scriptable3 = (Scriptable)object2;
                    Object object3 = NativeArray.addAsPrototype(scriptable2, l);
                    NativeArray.append(scriptable3, l - l4, object3);
                    ++l;
                }
            }
        } else if (l2 == 0L && context.getLanguageVersion() == 120) {
            object2 = Context.getUndefinedValue();
        }
        l = (long)n - l2;
        if (l > 0L) {
            long l6 = l3 - 1L;
            while (l6 >= l5) {
                object = NativeArray.addAsPrototype(scriptable2, l6);
                NativeArray.append(scriptable2, l6 + l, object);
                --l6;
            }
        } else if (l < 0L) {
            long l7 = l5;
            while (l7 < l3) {
                object = NativeArray.addAsPrototype(scriptable2, l7);
                NativeArray.append(scriptable2, l7 + l, object);
                ++l7;
            }
        }
        int n2 = objectArray.length - n;
        int n3 = 0;
        while (n3 < n) {
            NativeArray.append(scriptable2, l4 + (long)n3, objectArray[n3 + n2]);
            ++n3;
        }
        ScriptRuntime.setProp(scriptable2, "length", new Double(l3 + l), scriptable2);
        return object2;
    }

    private static Scriptable getElem(Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws JavaScriptException {
        long l;
        scriptable = ScriptableObject.getTopLevelScope(scriptable);
        Function function = ScriptRuntime.getExistingCtor(context, scriptable, "Array");
        Scriptable scriptable3 = function.construct(context, scriptable, ScriptRuntime.emptyArgs);
        long l2 = 0L;
        if (ScriptRuntime.instanceOf(scriptable, scriptable2, function)) {
            l = NativeArray.getLengthProperty(scriptable2);
            l2 = 0L;
            while (l2 < l) {
                Object object = NativeArray.addAsPrototype(scriptable2, l2);
                NativeArray.append(scriptable3, l2, object);
                ++l2;
            }
        } else {
            NativeArray.append(scriptable3, l2++, scriptable2);
        }
        int n = 0;
        while (n < objectArray.length) {
            if (ScriptRuntime.instanceOf(scriptable, objectArray[n], function)) {
                Scriptable scriptable4 = (Scriptable)objectArray[n];
                l = NativeArray.getLengthProperty(scriptable4);
                long l3 = 0L;
                while (l3 < l) {
                    Object object = NativeArray.addAsPrototype(scriptable4, l3);
                    NativeArray.append(scriptable3, l2, object);
                    ++l3;
                    ++l2;
                }
            } else {
                NativeArray.append(scriptable3, l2++, objectArray[n]);
            }
            ++n;
        }
        return scriptable3;
    }

    private Scriptable getExistingCtor(Context context, Scriptable scriptable, Object[] objectArray) {
        long l;
        long l2;
        Scriptable scriptable2 = ScriptableObject.getTopLevelScope(this);
        Scriptable scriptable3 = ScriptRuntime.newObject(context, scriptable2, "Array", null);
        long l3 = NativeArray.getLengthProperty(scriptable);
        if (objectArray.length == 0) {
            l2 = 0L;
            l = l3;
        } else {
            l2 = NativeArray.getIdDefaultAttributes(ScriptRuntime.toInteger(objectArray[0]), l3);
            l = objectArray.length == 1 ? l3 : NativeArray.getIdDefaultAttributes(ScriptRuntime.toInteger(objectArray[1]), l3);
        }
        long l4 = l2;
        while (l4 < l) {
            Object object = NativeArray.addAsPrototype(scriptable, l4);
            NativeArray.append(scriptable3, l4 - l2, object);
            ++l4;
        }
        return scriptable3;
    }

    private static long getIdDefaultAttributes(double d, long l) {
        long l2 = d < 0.0 ? (d + (double)l < 0.0 ? 0L : (long)(d + (double)l)) : (d > (double)l ? l : (long)d);
        return l2;
    }

    protected String getIdName(int n) {
        if (n == 1) {
            return "length";
        }
        if (this.prototypeFlag) {
            switch (n) {
                case 2: {
                    return "constructor";
                }
                case 3: {
                    return "toString";
                }
                case 4: {
                    return "toLocaleString";
                }
                case 5: {
                    return "join";
                }
                case 6: {
                    return "reverse";
                }
                case 7: {
                    return "sort";
                }
                case 8: {
                    return "push";
                }
                case 9: {
                    return "pop";
                }
                case 10: {
                    return "shift";
                }
                case 11: {
                    return "unshift";
                }
                case 12: {
                    return "splice";
                }
                case 13: {
                    return "concat";
                }
                case 14: {
                    return "slice";
                }
            }
        }
        return null;
    }

    protected int mapNameToId(String string) {
        if (string.equals("length")) {
            return 1;
        }
        if (this.prototypeFlag) {
            return NativeArray.getIdValue(string);
        }
        return 0;
    }

    private static int getIdValue(String string) {
        int n = 0;
        String string2 = null;
        switch (string.length()) {
            case 3: {
                string2 = "pop";
                n = 9;
                break;
            }
            case 4: {
                char c = string.charAt(0);
                if (c == 'j') {
                    string2 = "join";
                    n = 5;
                    break;
                }
                if (c == 'p') {
                    string2 = "push";
                    n = 8;
                    break;
                }
                if (c != 's') break;
                string2 = "sort";
                n = 7;
                break;
            }
            case 5: {
                char c = string.charAt(1);
                if (c == 'h') {
                    string2 = "shift";
                    n = 10;
                    break;
                }
                if (c != 'l') break;
                string2 = "slice";
                n = 14;
                break;
            }
            case 6: {
                char c = string.charAt(0);
                if (c == 'c') {
                    string2 = "concat";
                    n = 13;
                    break;
                }
                if (c == 'l') {
                    string2 = "length";
                    n = 1;
                    break;
                }
                if (c != 's') break;
                string2 = "splice";
                n = 12;
                break;
            }
            case 7: {
                char c = string.charAt(0);
                if (c == 'r') {
                    string2 = "reverse";
                    n = 6;
                    break;
                }
                if (c != 'u') break;
                string2 = "unshift";
                n = 11;
                break;
            }
            case 8: {
                string2 = "toString";
                n = 3;
                break;
            }
            case 11: {
                string2 = "constructor";
                n = 2;
                break;
            }
            case 14: {
                string2 = "toLocaleString";
                n = 4;
            }
        }
        if (string2 != null && string2 != string && !string2.equals(string)) {
            n = 0;
        }
        return n;
    }
}

