/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install.command;

import com.google.inject.Inject;
import com.mathworks.install.CommandErrorHandler;
import com.mathworks.install.InstallConfiguration;
import com.mathworks.install.InstallConfigurationPersistence;
import com.mathworks.install.InstallOption;
import com.mathworks.install.RegisterAppPath;
import com.mathworks.install.command.AbstractCommandFactory;
import com.mathworks.install.command.Command;
import com.mathworks.install.command.InstallLicenseFileCommand;
import com.mathworks.install.command.NoOpCommand;
import com.mathworks.install.command.WriteInstallConfiguration;
import com.mathworks.install.service.Service;
import com.mathworks.instutil.FilePermissions;
import com.mathworks.instutil.IO;
import com.mathworks.instutil.Machine;
import java.io.FilenameFilter;

abstract class AbstractNonWindowsCommandFactory
extends AbstractCommandFactory {
    private final Machine machine;
    private final FilePermissions filePermissionsUtil;
    private final IO io;

    @Inject
    AbstractNonWindowsCommandFactory(FilePermissions filePermissions, Machine machine, IO iO) {
        super(iO);
        this.filePermissionsUtil = filePermissions;
        this.machine = machine;
        this.io = iO;
    }

    @Override
    public final Command createRegisterDllsCommand(String string, String ... stringArray) {
        return AbstractNonWindowsCommandFactory.createNoOpCommand();
    }

    @Override
    public final Command createRegister32BitDllsCommand(String string, String ... stringArray) {
        return AbstractNonWindowsCommandFactory.createNoOpCommand();
    }

    @Override
    public final Command createRegisterSystemDllsCommand(String ... stringArray) {
        return AbstractNonWindowsCommandFactory.createNoOpCommand();
    }

    @Override
    public final Command createRemoveServicesCommand(Service ... serviceArray) {
        return AbstractNonWindowsCommandFactory.createNoOpCommand();
    }

    @Override
    public final Command createStopServicesCommand(Service ... serviceArray) {
        return AbstractNonWindowsCommandFactory.createNoOpCommand();
    }

    @Override
    public final Command createInstallServicesCommand(Service ... serviceArray) {
        return AbstractNonWindowsCommandFactory.createNoOpCommand();
    }

    @Override
    public final Command createRegisterAssemblyFilesCommand(String string, String string2, String ... stringArray) {
        return AbstractNonWindowsCommandFactory.createNoOpCommand();
    }

    @Override
    public final Command createOLEAutomationCommand(String string, String string2, String string3) {
        return AbstractNonWindowsCommandFactory.createNoOpCommand();
    }

    @Override
    public final Command createInstallAssemblyFilesCommand(String string, String ... stringArray) {
        return AbstractNonWindowsCommandFactory.createNoOpCommand();
    }

    @Override
    public final Command createRegisterAssemblyFolderCommand(String string, String string2) {
        return AbstractNonWindowsCommandFactory.createNoOpCommand();
    }

    @Override
    public final Command createAssemblyFrameworkCommand(String string, CommandErrorHandler commandErrorHandler, Command ... commandArray) {
        return AbstractNonWindowsCommandFactory.createNoOpCommand();
    }

    @Override
    public final Command createRegisterUninstallerCommand(String string, String string2, String string3, String string4, String string5, String string6) {
        return AbstractNonWindowsCommandFactory.createNoOpCommand();
    }

    @Override
    public final Command createRegisterApplicationCommand(RegisterAppPath registerAppPath) {
        return AbstractNonWindowsCommandFactory.createNoOpCommand();
    }

    @Override
    public final Command createInsertPathIntoSystemPathCommand(String string, String string2) {
        return AbstractNonWindowsCommandFactory.createNoOpCommand();
    }

    @Override
    public final Command createInstallFilesToSystemDirectoryCommand(String string, String ... stringArray) {
        return AbstractNonWindowsCommandFactory.createNoOpCommand();
    }

    @Override
    public final Command createCopyFilesToSystemDirectoryCommand(String string, String ... stringArray) {
        return AbstractNonWindowsCommandFactory.createNoOpCommand();
    }

    @Override
    public final Command createCopyFilesToInstallationCommand(String string, String string2, FilenameFilter filenameFilter) {
        return AbstractNonWindowsCommandFactory.createNoOpCommand();
    }

    @Override
    public final Command createWriteLicenseFileCommand(InstallOption installOption) {
        return new InstallLicenseFileCommand(installOption, this.filePermissionsUtil, this.machine, this.io);
    }

    @Override
    public final Command createDeletePreferencesCommand(InstallOption installOption) {
        return AbstractNonWindowsCommandFactory.createNoOpCommand();
    }

    @Override
    public final Command createWriteInstallConfigurationCommand(InstallConfigurationPersistence installConfigurationPersistence, InstallConfiguration installConfiguration) {
        return new WriteInstallConfiguration(installConfigurationPersistence, installConfiguration);
    }

    @Override
    public final Command createDesktopShortcutCommand(String string, String string2, String string3, String string4) {
        return AbstractNonWindowsCommandFactory.createNoOpCommand();
    }

    @Override
    public final Command createStartMenuShortcutCommand(String string, String string2, String string3, String string4, String string5) {
        return AbstractNonWindowsCommandFactory.createNoOpCommand();
    }

    @Override
    public final Command createFileAssociationsCommand(String[] stringArray) {
        return AbstractNonWindowsCommandFactory.createNoOpCommand();
    }

    private static Command createNoOpCommand() {
        return new NoOpCommand();
    }
}

