/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install.archive;

import com.google.inject.Inject;
import com.mathworks.install.InstallFlowControlHandler;
import com.mathworks.install.archive.ArchiveInputStreamExtractor;
import com.mathworks.install.status.InstallStatusObserver;
import com.mathworks.instutil.DecodeInputStream;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;

public final class DecodeArchiveInputStreamExtractor
implements ArchiveInputStreamExtractor {
    private ArchiveInputStreamExtractor extractor;

    @Inject
    public DecodeArchiveInputStreamExtractor(ArchiveInputStreamExtractor archiveInputStreamExtractor) {
        this.extractor = archiveInputStreamExtractor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void extract(InputStream inputStream, File file, InstallFlowControlHandler installFlowControlHandler, InstallStatusObserver ... installStatusObserverArray) throws IOException, InterruptedException {
        DecodeInputStream decodeInputStream = null;
        BufferedInputStream bufferedInputStream = null;
        try {
            decodeInputStream = new DecodeInputStream(inputStream);
            bufferedInputStream = new BufferedInputStream((InputStream)decodeInputStream);
            this.extractor.extract(bufferedInputStream, file, installFlowControlHandler, installStatusObserverArray);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(bufferedInputStream);
            IOUtils.closeQuietly((InputStream)decodeInputStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)bufferedInputStream);
        IOUtils.closeQuietly((InputStream)decodeInputStream);
    }
}

