/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.install;

import com.mathworks.install.ComponentContainer;
import com.mathworks.install.ComponentData;
import com.mathworks.install.InstallableComponent;
import com.mathworks.install.InstallableComponentImpl;
import com.mathworks.install.input.ComponentSourceProvider;
import com.mathworks.install.input.NoOpComponentSourceProvider;
import com.mathworks.instutil.VersionUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

final class ComponentContainerImpl
implements ComponentContainer {
    private final Map<String, ComponentData> componentFlyweightMap = new HashMap<String, ComponentData>();
    private final Map<ComponentData, InstallableComponent> componentToInstallableComponentMap = new HashMap<ComponentData, InstallableComponent>();
    private final Map<ComponentData, InstallableComponent> installedComponentMap = new HashMap<ComponentData, InstallableComponent>();

    ComponentContainerImpl() {
    }

    @Override
    public synchronized InstallableComponent addInstallableComponent(ComponentData componentData, String string, String string2, String string3, String string4, String string5, long l, long l2, ComponentSourceProvider componentSourceProvider, String ... stringArray) {
        InstallableComponent installableComponent = this.componentToInstallableComponentMap.get(componentData);
        if (installableComponent == null) {
            installableComponent = new InstallableComponentImpl(componentData, string, string2, string5, l, l2, componentSourceProvider, stringArray);
            this.componentToInstallableComponentMap.put(componentData, installableComponent);
        }
        componentSourceProvider.addComponent(componentData.getComponentNameAndVersion());
        return installableComponent;
    }

    @Override
    public synchronized InstallableComponent addUninstallableComponent(ComponentData componentData, String string, String string2, String string3, String string4, String string5, long l, long l2) {
        InstallableComponent installableComponent = this.componentToInstallableComponentMap.get(componentData);
        if (installableComponent == null) {
            installableComponent = new InstallableComponentImpl(componentData, string, string2, string5, l, l2, new NoOpComponentSourceProvider(), new String[0]);
            this.componentToInstallableComponentMap.put(componentData, installableComponent);
        }
        this.installedComponentMap.put(componentData, installableComponent);
        return installableComponent;
    }

    @Override
    public synchronized ComponentData createComponent(String string, String string2, String string3, String[] stringArray) {
        String string4 = string + " " + string2;
        ComponentData componentData = this.componentFlyweightMap.get(string4);
        if (componentData == null) {
            componentData = new ComponentDataFlyweight(string, string2, string3, stringArray);
            this.componentFlyweightMap.put(string4, componentData);
        } else if (!componentData.matches(string3, stringArray)) {
            // empty if block
        }
        return componentData;
    }

    @Override
    public synchronized InstallableComponent getInstallableComponent(ComponentData componentData) {
        return this.componentToInstallableComponentMap.get(componentData);
    }

    @Override
    public InstallableComponent[] getInstalledComponents() {
        return this.installedComponentMap.values().toArray(new InstallableComponent[this.installedComponentMap.size()]);
    }

    @Override
    public void uninstallComponents(InstallableComponent[] installableComponentArray) {
        for (InstallableComponent installableComponent : installableComponentArray) {
            this.installedComponentMap.remove(installableComponent.getComponentData());
        }
    }

    private static final class ComponentDataFlyweight
    implements ComponentData {
        private final Collection<String> platforms = new ArrayList<String>();
        private final String componentName;
        private final String version;
        private final String locale;

        ComponentDataFlyweight(String string, String string2, String string3, String[] stringArray) {
            this.componentName = string;
            this.version = string2;
            this.locale = string3;
            this.platforms.addAll(Arrays.asList(stringArray));
        }

        @Override
        public String getVersion() {
            return this.version;
        }

        @Override
        public String getName() {
            return this.componentName;
        }

        @Override
        public boolean isOlderThan(ComponentData componentData) {
            return VersionUtils.compareVersionNumbers((String)this.getVersion(), (String)componentData.getVersion()) < 0;
        }

        @Override
        public boolean hasPlatform(String string) {
            for (String string2 : this.platforms) {
                if (!string2.equalsIgnoreCase(string)) continue;
                return this.isSupportedByCurrentLocale();
            }
            return false;
        }

        private boolean isSupportedByCurrentLocale() {
            return this.locale.isEmpty() || this.locale.equalsIgnoreCase(Locale.getDefault().toString());
        }

        @Override
        public String getComponentNameAndVersion() {
            return this.getName() + ' ' + this.getVersion();
        }

        @Override
        public boolean matches(String string, String[] stringArray) {
            return string.equals(this.locale) && Arrays.equals(stringArray, this.platforms.toArray(new String[this.platforms.size()]));
        }
    }
}

