/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.toolstrip;

import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.project.impl.filesetui.FileSetEditor;
import com.mathworks.project.impl.filesetui.FileSetEditorGroup;
import com.mathworks.project.impl.model.FileSetInstance;
import com.mathworks.project.impl.model.Project;
import com.mathworks.util.MulticastChangeListener;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;

public final class FileNavigator {
    private final MJPanel fComponent = new MJPanel();
    private final MulticastChangeListener fSelectionChangeListeners = new MulticastChangeListener();
    private final Map<String, FileSetEditor> fEditors = new LinkedHashMap<String, FileSetEditor>();
    private final TreeSelectionListener fTreeSelectionListener = new TreeSelectionListener(){

        @Override
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            FileNavigator.this.fSelectionChangeListeners.stateChanged(new ChangeEvent(FileNavigator.this));
        }
    };

    public JComponent getComponent() {
        return this.fComponent;
    }

    public void setup(Project project, List<FileSetInstance> list) {
        FileSetEditor fileSetEditor2;
        for (FileSetEditor fileSetEditor2 : this.fEditors.values()) {
            fileSetEditor2.getSelectionModel().removeTreeSelectionListener(this.fTreeSelectionListener);
        }
        this.fEditors.clear();
        this.fComponent.removeAll();
        this.fComponent.setLayout((LayoutManager)new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        fileSetEditor2 = new FileSetEditorGroup();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        for (FileSetInstance fileSetInstance : list) {
            gridBagConstraints.insets.left = 0;
            MJLabel mJLabel = new MJLabel(fileSetInstance.getDefinition().getName());
            mJLabel.setFont(mJLabel.getFont().deriveFont(1));
            gridBagConstraints.insets.bottom = 3;
            this.fComponent.add((Component)mJLabel, (Object)gridBagConstraints);
            gridBagConstraints.insets.left = 12;
            gridBagConstraints.insets.bottom = 16;
            ++gridBagConstraints.gridy;
            FileSetEditor fileSetEditor3 = new FileSetEditor(project, fileSetInstance, (FileSetEditorGroup)fileSetEditor2, false);
            fileSetEditor3.getSelectionModel().addTreeSelectionListener(this.fTreeSelectionListener);
            this.fEditors.put(fileSetInstance.getDefinition().getKey(), fileSetEditor3);
            this.fComponent.add((Component)fileSetEditor3.getComponent(), (Object)gridBagConstraints);
            ++gridBagConstraints.gridy;
        }
        MJPanel mJPanel = new MJPanel();
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.fComponent.add((Component)mJPanel, (Object)gridBagConstraints);
        this.fComponent.revalidate();
        this.fComponent.repaint();
    }

    public void addSelectionChangeListener(ChangeListener changeListener) {
        this.fSelectionChangeListeners.addChangeListener(changeListener);
    }

    public void removeSelectionChangeListener(ChangeListener changeListener) {
        this.fSelectionChangeListeners.removeChangeListener(changeListener);
    }

    public File getSelectedFile() {
        for (FileSetEditor fileSetEditor : this.fEditors.values()) {
            List list = fileSetEditor.getSelectedFiles();
            if (list.size() == 1) {
                return (File)list.get(0);
            }
            if (list.isEmpty()) continue;
            return null;
        }
        return null;
    }

    public FileSetEditor getFileSetEditor(String string) {
        return this.fEditors.get(string);
    }
}

