/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.screener;

import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJTextArea;
import com.mathworks.project.impl.util.StringUtils;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.screener.Divider;
import com.mathworks.toolbox.coder.screener.ScoreWidget;
import com.mathworks.toolbox.coder.screener.ScreenerFileWidget;
import com.mathworks.toolbox.coder.screener.ScreenerProblemType;
import com.mathworks.toolbox.coder.screener.ScreenerReportModel;
import com.mathworks.toolbox.coder.screener.SectionedReportView;
import com.mathworks.toolbox.coder.screener.UnsupportedFunctionDisplay;
import com.mathworks.util.PlatformInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.File;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;

public final class ScreenerSummaryView {
    private final SectionedReportView fComponent;
    private final ScreenerReportModel fModel;
    private static final int INDENTATION_MARGIN = PlatformInfo.isMacintosh() ? 30 : 18;
    private static final int FUNCTION_INDENTATION_MARGIN = PlatformInfo.isMacintosh() ? 22 : 10;

    public ScreenerSummaryView(ScreenerReportModel screenerReportModel) {
        Object object;
        this.fModel = screenerReportModel;
        this.fComponent = new SectionedReportView(true);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        if (PlatformInfo.isMacintosh()) {
            this.fComponent.add((Component)((Object)new Divider()), gridBagConstraints);
            ++gridBagConstraints.gridy;
        }
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(12, 12, 9, 12);
        MJPanel mJPanel = ScreenerSummaryView.buildScorePanel(screenerReportModel);
        mJPanel.setOpaque(false);
        this.fComponent.add((Component)mJPanel, gridBagConstraints);
        MJLabel mJLabel = new MJLabel(CoderResources.getString(screenerReportModel.getScore().getScore() == 5 ? "screener.summary.5" : "screener.summary"));
        gridBagConstraints.anchor = 10;
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.top = 12;
        if (screenerReportModel.getScore().getScore() != 5) {
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
        } else {
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
        }
        this.fComponent.add((Component)mJLabel, gridBagConstraints);
        boolean bl = true;
        if (screenerReportModel.getScore().getScore() != 5) {
            ++gridBagConstraints.gridy;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            object = screenerReportModel.getProblemsByImpact();
            gridBagConstraints.insets.top = 3;
            gridBagConstraints.insets.bottom = 0;
            gridBagConstraints.insets.left = 0;
            gridBagConstraints.insets.right = 0;
            gridBagConstraints.anchor = 17;
            for (int i = 0; i < object.size(); ++i) {
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridwidth = 6;
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 1.0;
                ScreenerProblemType screenerProblemType = (ScreenerProblemType)((Object)object.get(i));
                this.fComponent.startSection(gridBagConstraints, screenerProblemType, this.fModel.getProblemViolationCount(screenerProblemType));
                if (screenerProblemType == ScreenerProblemType.UNSUPPORTED_FUNCTION) {
                    bl = false;
                    gridBagConstraints.fill = 1;
                    gridBagConstraints.weighty = 1.0;
                    gridBagConstraints.insets.left = FUNCTION_INDENTATION_MARGIN;
                    gridBagConstraints.insets.right = 12;
                    this.fComponent.add(new UnsupportedFunctionDisplay(this.fModel).getComponent(), gridBagConstraints);
                    gridBagConstraints.insets.left = 6;
                    gridBagConstraints.insets.right = 6;
                } else {
                    List<File> list = screenerReportModel.getOffendersByImpact(screenerProblemType);
                    String string = StringUtils.upperCaseToCamelCase((String)screenerProblemType.toString(), (boolean)false);
                    JTextComponent jTextComponent = ScreenerSummaryView.createDescriptionLabel(CoderResources.getString("screener.problem." + string + ".desc"));
                    gridBagConstraints.insets.left = INDENTATION_MARGIN;
                    gridBagConstraints.insets.right = 16;
                    this.fComponent.add(jTextComponent, gridBagConstraints);
                    gridBagConstraints.insets.right = 6;
                    if (list.size() == 1) {
                        jTextComponent.setText(MessageFormat.format(CoderResources.getString("screener.problem." + string + ".desc.single"), list.get(0).getName()));
                        gridBagConstraints.insets.bottom += 6;
                        ((GridBagLayout)this.fComponent.getLayout()).setConstraints(jTextComponent, gridBagConstraints);
                    } else {
                        Serializable serializable;
                        ++gridBagConstraints.gridy;
                        gridBagConstraints.gridwidth = 1;
                        if (i == object.size() - 1) {
                            gridBagConstraints.insets.bottom = 12;
                        }
                        gridBagConstraints.weightx = 0.0;
                        gridBagConstraints.fill = 0;
                        for (int j = 0; j < list.size(); ++j) {
                            serializable = list.get(j);
                            ScreenerFileWidget screenerFileWidget = new ScreenerFileWidget((File)serializable, screenerReportModel.getOffenseCount((File)serializable, screenerProblemType), screenerReportModel.getOffenseLines((File)serializable, screenerProblemType).iterator().next());
                            this.fComponent.add(screenerFileWidget.getComponent(), gridBagConstraints);
                            ++gridBagConstraints.gridx;
                            if (gridBagConstraints.gridx == 4) {
                                MJLabel mJLabel2 = new MJLabel(MessageFormat.format(CoderResources.getString("screener.files.more"), list.size() - j));
                                mJLabel2.setForeground(new Color(0x444444));
                                int n = gridBagConstraints.insets.left;
                                gridBagConstraints.insets.left = 12;
                                this.fComponent.add((Component)mJLabel2, gridBagConstraints);
                                gridBagConstraints.insets.left = n;
                                break;
                            }
                            gridBagConstraints.insets.left = 6;
                        }
                        MJPanel mJPanel2 = new MJPanel();
                        mJPanel2.setOpaque(false);
                        serializable = new GridBagConstraints();
                        ((GridBagConstraints)serializable).fill = 2;
                        ((GridBagConstraints)serializable).gridx = 5;
                        ((GridBagConstraints)serializable).gridy = gridBagConstraints.gridy;
                        ((GridBagConstraints)serializable).weightx = 1.0;
                        ((GridBagConstraints)serializable).insets = new Insets(0, 0, 0, 0);
                        this.fComponent.add((Component)mJPanel2, serializable);
                    }
                }
                if (i >= object.size() - 1) continue;
                this.fComponent.endSection(gridBagConstraints);
            }
        }
        if (bl) {
            object = new MJPanel();
            object.setOpaque(false);
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 6;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 1;
            this.fComponent.add((Component)object, gridBagConstraints);
        }
    }

    public JComponent getComponent() {
        return this.fComponent;
    }

    private static MJPanel buildScorePanel(ScreenerReportModel screenerReportModel) {
        MJPanel mJPanel = new MJPanel((LayoutManager)new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 0, 0, 6);
        MJLabel mJLabel = new MJLabel(CoderResources.getString("screener.score.label"));
        mJPanel.add((Component)mJLabel, (Object)gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 6, 0, 0);
        ++gridBagConstraints.gridx;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        mJPanel.add((Component)new ScoreWidget(screenerReportModel.getScore()).getComponent(), (Object)gridBagConstraints);
        return mJPanel;
    }

    private static JTextComponent createDescriptionLabel(String string) {
        MJTextArea mJTextArea = new MJTextArea(string);
        mJTextArea.setFont(UIManager.getFont("Label.font"));
        mJTextArea.setOpaque(false);
        mJTextArea.setEditable(false);
        mJTextArea.setText(string);
        mJTextArea.setLineWrap(true);
        mJTextArea.setWrapStyleWord(true);
        return mJTextArea;
    }
}

