/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.screener;

import com.mathworks.matlab.api.explorer.Status;
import com.mathworks.mde.desk.MLDesktop;
import com.mathworks.mwswing.MJFrame;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.screener.ScreenerCombinedView;
import com.mathworks.toolbox.coder.screener.ScreenerReportModel;
import com.mathworks.toolbox.coder.screener.ScreenerSummaryView;
import com.mathworks.util.Holder;
import com.mathworks.util.PlatformInfo;
import java.awt.Component;
import java.awt.Window;
import java.io.File;
import java.text.MessageFormat;
import java.util.List;

public final class ScreenerReportDialog {
    private static final int MIN_HEIGHT = PlatformInfo.isMacintosh() ? 640 : 575;
    private static final int MIN_WIDTH = 650;

    private ScreenerReportDialog() {
    }

    public static Window show(String string, ScreenerReportModel screenerReportModel) {
        return ScreenerReportDialog.show(string, screenerReportModel, null);
    }

    public static Status show(final List<File> list) {
        final Status status = new Status(CoderResources.getString("screener.loading"), true);
        new Thread(new Runnable(){

            @Override
            public void run() {
                ScreenerReportModel screenerReportModel = new ScreenerReportModel(list);
                String string = MessageFormat.format(CoderResources.getString("screener.title"), ((File)list.get(0)).getName() + " etc.");
                ScreenerReportDialog.show(string, screenerReportModel, status);
            }
        }).start();
        return status;
    }

    public static Status show(final File file) {
        final Status status = new Status(CoderResources.getString("screener.loading"), true);
        new Thread(new Runnable(){

            @Override
            public void run() {
                ScreenerReportModel screenerReportModel = new ScreenerReportModel(file);
                String string = MessageFormat.format(CoderResources.getString("screener.title"), file.getName());
                ScreenerReportDialog.show(string, screenerReportModel, status);
            }
        }).start();
        return status;
    }

    private static Window show(final String string, final ScreenerReportModel screenerReportModel, final Status status) {
        final Holder holder = new Holder();
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                int n;
                MJFrame mJFrame = new MJFrame(string);
                mJFrame.setName("Screener");
                if (screenerReportModel.getNonMathWorksFileCount() > 1) {
                    mJFrame.add((Component)new ScreenerCombinedView(screenerReportModel).getComponent());
                } else {
                    mJFrame.add((Component)new ScreenerSummaryView(screenerReportModel).getComponent());
                }
                boolean bl = screenerReportModel.hasDifferentFileScores();
                mJFrame.setSize(650, MIN_HEIGHT);
                if (!bl || PlatformInfo.isMacintosh()) {
                    mJFrame.pack();
                } else {
                    n = (int)mJFrame.getContentPane().getPreferredSize().getHeight();
                    mJFrame.setSize((int)Math.max(mJFrame.getPreferredSize().getWidth(), (double)mJFrame.getWidth()), n + 40);
                }
                int n2 = n = screenerReportModel.getScore().getScore() == 5 ? 580 : 750;
                if (mJFrame.getWidth() > n) {
                    mJFrame.setSize(n, mJFrame.getHeight() + 24);
                }
                if (mJFrame.getHeight() < 650 && bl) {
                    mJFrame.setSize(mJFrame.getWidth(), 650);
                }
                if (mJFrame.getWidth() < MIN_HEIGHT && bl) {
                    mJFrame.setSize(MIN_HEIGHT, mJFrame.getHeight());
                }
                mJFrame.setLocationRelativeTo((Component)MLDesktop.getInstance().getMainFrame());
                mJFrame.setMinimumSize(mJFrame.getSize());
                mJFrame.setVisible(true);
                if (status != null) {
                    status.markCompleted();
                }
                holder.set((Object)mJFrame);
            }
        });
        return (Window)holder.get();
    }
}

