/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.screener;

import com.mathworks.toolbox.coder.screener.DependencyFileSystem;
import com.mathworks.toolbox.coder.screener.FileImpactModel;
import com.mathworks.toolbox.coder.screener.ScreenerTarget;
import com.mathworks.util.tree.Visitor;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public final class CallTreeImpactModel {
    private final ScreenerTarget fTarget;
    private final Map<File, Set<File>> fChildren;
    private final Map<File, Set<File>> fParents;
    private final Map<File, FileImpactModel> fFiles;

    public CallTreeImpactModel(ScreenerTarget screenerTarget) {
        this.fTarget = screenerTarget;
        this.fChildren = new HashMap<File, Set<File>>();
        this.fParents = new HashMap<File, Set<File>>();
        this.fFiles = new HashMap<File, FileImpactModel>();
    }

    public ScreenerTarget getTarget() {
        return this.fTarget;
    }

    public Set<File> getRootFiles() {
        TreeSet<File> treeSet = new TreeSet<File>();
        for (File file : this.fFiles.keySet()) {
            if (this.fParents.containsKey(file) && !this.fParents.get(file).isEmpty()) continue;
            treeSet.add(file);
        }
        return treeSet;
    }

    public void addInvocation(File file, File file2) {
        CallTreeImpactModel.add(this.fChildren, file, file2);
        CallTreeImpactModel.add(this.fParents, file2, file);
    }

    public void setFileImpact(File file, FileImpactModel fileImpactModel) {
        this.fFiles.put(file, fileImpactModel);
    }

    public FileImpactModel getFileImpact(File file) {
        return this.fFiles.get(file);
    }

    public void visitAll(Visitor<File> visitor) {
        for (File file : this.fFiles.keySet()) {
            visitor.visit((Object)file);
        }
    }

    public void visitAllNonMathWorks(final Visitor<File> visitor) {
        this.visitAll(new Visitor<File>(){

            public void visit(File file) {
                if (!DependencyFileSystem.isInToolbox(file.getAbsolutePath())) {
                    visitor.visit((Object)file);
                }
            }
        });
    }

    public List<File> getNonMathWorksFilesInvoked(File file) {
        ArrayList<File> arrayList = new ArrayList<File>();
        Set<File> set = this.fChildren.get(file);
        if (set != null) {
            for (File file2 : set) {
                if (DependencyFileSystem.isInToolbox(file2.getAbsolutePath())) continue;
                arrayList.add(file2);
            }
        }
        return arrayList;
    }

    public List<File> getMathWorksFilesInvoked(File file) {
        ArrayList<File> arrayList = new ArrayList<File>();
        Set<File> set = this.fChildren.get(file);
        if (set != null) {
            for (File file2 : set) {
                if (!DependencyFileSystem.isInToolbox(file2.getAbsolutePath())) continue;
                arrayList.add(file2);
            }
        }
        return arrayList;
    }

    private static <T> void add(Map<T, Set<T>> map, T t, T t2) {
        Set<T> set = map.get(t);
        if (set == null) {
            set = new HashSet<T>();
            map.put(t, set);
        }
        set.add(t2);
    }
}

