/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.plugin.workflow;

import com.mathworks.jmi.Matlab;
import com.mathworks.jmi.MatlabEvent;
import com.mathworks.jmi.MatlabListener;
import com.mathworks.matlab.api.editor.EditorLayer;
import com.mathworks.matlab.api.editor.EditorMessage;
import com.mathworks.matlab.api.editor.EditorMessageBarContributor;
import com.mathworks.mwswing.MJDialog;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.toolbox.coder.plugin.workflow.GenericEditorPopup;
import com.mathworks.toolbox.coder.plugin.workflow.IdentifierPopupInterface;
import com.mathworks.toolbox.coder.plugin.workflow.ProposeTypesWidget;
import com.mathworks.toolbox.coder.plugin.workflow.ProposedTypesListener;
import com.mathworks.toolbox.coder.plugin.workflow.ProposedTypesModel;
import com.mathworks.util.Log;
import com.mathworks.widgets.SyntaxTextPane;
import com.mathworks.widgets.text.MWToolTipSupport;
import com.mathworks.widgets.text.STPBaseInterface;
import java.awt.Color;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.ext.ExtEditorUI;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.netbeans.editor.ext.ExtUtilities;

public class MatlabCoderEditorLayer
implements EditorLayer,
ProposedTypesListener {
    private static final Matlab MATLAB = new Matlab();
    public static final String LAYER_NAME = "Proposed Types Editor Highlighter Layer";
    public static final long DELAY = 4000L;
    public static final long PERIOD = 500L;
    private SyntaxTextPane fPane = null;
    private Timer fPeriodicTimer;
    private ProposedTypesModel fProposedTypesMap = null;
    private Map<String, Map<String, String>> fVariablesMap = null;
    private static Poppy sIdentifierPopupMenu;
    private static long sStartTime;

    private void init(SyntaxTextPane syntaxTextPane) {
        this.fPane = syntaxTextPane;
        this.fPeriodicTimer = new Timer(true);
        this.fPeriodicTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        MWToolTipSupport mWToolTipSupport;
                        if (MatlabCoderEditorLayer.this.fPane != null && (mWToolTipSupport = (MWToolTipSupport)ExtUtilities.getExtEditorUI((JTextComponent)MatlabCoderEditorLayer.this.fPane).getToolTipSupport()) != null && MatlabCoderEditorLayer.this.fProposedTypesMap != null && MatlabCoderEditorLayer.this.fVariablesMap != null) {
                            mWToolTipSupport.setInitialDelay(0);
                            Point point = MatlabCoderEditorLayer.this.fPane.getMousePosition(true);
                            IdentifierInfo identifierInfo = null;
                            if (point != null) {
                                identifierInfo = MatlabCoderEditorLayer.identifierUnderPoint(point, (STPBaseInterface)MatlabCoderEditorLayer.this.fPane);
                            }
                            boolean bl = false;
                            if (identifierInfo != null) {
                                String string = identifierInfo.getIdentifier();
                                String string2 = MatlabCoderEditorLayer.this.fProposedTypesMap.getFunctionNames().iterator().next();
                                if (sIdentifierPopupMenu != null && sIdentifierPopupMenu.isShowing()) {
                                    if (sIdentifierPopupMenu.getIdentifier().equals(string)) {
                                        return;
                                    }
                                    sIdentifierPopupMenu.dispose();
                                    sIdentifierPopupMenu = null;
                                }
                                JFrame.setDefaultLookAndFeelDecorated(true);
                                GenericEditorPopup genericEditorPopup = null;
                                switch (identifierInfo.getTokenId()) {
                                    case 40: {
                                        if (string.equals(string2)) {
                                            genericEditorPopup = new GenericEditorPopup("TopFunction", MatlabCoderEditorLayer.this.fProposedTypesMap, string2, string, null);
                                            break;
                                        }
                                        if (!MatlabCoderEditorLayer.this.fProposedTypesMap.hasProposedData(string2, string)) break;
                                        Map map = (Map)MatlabCoderEditorLayer.this.fVariablesMap.get(string2);
                                        String string3 = (String)map.get(string);
                                        Map<String, Object> map2 = MatlabCoderEditorLayer.this.fProposedTypesMap.getProposedData(string2, string);
                                        genericEditorPopup = new GenericEditorPopup(string3, MatlabCoderEditorLayer.this.fProposedTypesMap, string, string, map2);
                                    }
                                }
                                if (genericEditorPopup != null) {
                                    bl = true;
                                    sIdentifierPopupMenu = new Poppy(string, genericEditorPopup, point.x + ((MatlabCoderEditorLayer)MatlabCoderEditorLayer.this).fPane.getLocationOnScreen().x, point.y + ((MatlabCoderEditorLayer)MatlabCoderEditorLayer.this).fPane.getLocationOnScreen().y);
                                    sIdentifierPopupMenu.setVisible(true);
                                }
                            }
                            if (!bl && sIdentifierPopupMenu != null) {
                                if (sIdentifierPopupMenu.getMousePosition() == null && !sIdentifierPopupMenu.getBounds().contains(MouseInfo.getPointerInfo().getLocation())) {
                                    if (sStartTime > 0L) {
                                        if (System.currentTimeMillis() - sStartTime > 4000L) {
                                            sIdentifierPopupMenu.dispose();
                                            sIdentifierPopupMenu = null;
                                        }
                                    } else {
                                        sStartTime = System.currentTimeMillis();
                                    }
                                } else {
                                    sStartTime = System.currentTimeMillis();
                                }
                            }
                        }
                    }
                });
            }
        }, 4000L, 500L);
    }

    public MatlabCoderEditorLayer() {
        ProposeTypesWidget.registerListener(this);
    }

    public void enable(JTextComponent jTextComponent) {
        if (jTextComponent instanceof SyntaxTextPane) {
            SyntaxTextPane syntaxTextPane = (SyntaxTextPane)jTextComponent;
            this.init(syntaxTextPane);
        }
    }

    public void disable() {
    }

    public void updateDocuments(Document document, Document document2) {
    }

    public String getLayerName() {
        return LAYER_NAME;
    }

    public boolean supportsMessageBar() {
        return false;
    }

    public EditorMessageBarContributor getMessageBarContributor() {
        return null;
    }

    public void settingsChanged(String string, ExtEditorUI extEditorUI) {
    }

    public void cleanup() {
        ProposeTypesWidget.unregisterListener(this);
        if (this.fPeriodicTimer != null) {
            this.fPeriodicTimer.cancel();
            this.fPeriodicTimer.purge();
            this.fPeriodicTimer = null;
        }
    }

    public List<? extends EditorMessage> getMessagesAtPosition(int n, int n2) {
        return Collections.emptyList();
    }

    @Override
    public void updateData(ProposedTypesModel proposedTypesModel) {
        this.fProposedTypesMap = proposedTypesModel;
        if (this.fPane == null) {
            return;
        }
        String string = this.fPane.getFilename();
        MATLAB.feval("eval", new Object[]{"coder.internal.MCodeIdUtils('" + string + "').computeFunctionInfo"}, 1, new MatlabListener(){

            public void matlabEvent(MatlabEvent matlabEvent) {
                Object object;
                if (Matlab.getExecutionStatus((int)matlabEvent.getStatus()) == 0 && (object = matlabEvent.getResult()) != null) {
                    Object[] objectArray;
                    MatlabCoderEditorLayer.this.fVariablesMap = new LinkedHashMap();
                    for (Object object2 : objectArray = (Object[])object) {
                        Object[] objectArray2;
                        Object[] objectArray3 = (Object[])object2;
                        String string = (String)objectArray3[0];
                        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
                        Object[] objectArray4 = (Object[])objectArray3[1];
                        Object[] objectArray5 = (Object[])objectArray4[1];
                        Object[] objectArray6 = (Object[])objectArray5[0];
                        for (Object object3 : objectArray2 = (Object[])objectArray6[1]) {
                            Object[] objectArray7 = (Object[])object3;
                            Object[] objectArray8 = (Object[])objectArray7[0];
                            Object[] objectArray9 = (Object[])objectArray7[1];
                            Object[] objectArray10 = (Object[])objectArray9[0];
                            String string2 = (String)objectArray10[0];
                            String string3 = null;
                            for (int i = 1; i < objectArray8.length; ++i) {
                                boolean bl = ((boolean[])objectArray10[i])[0];
                                if (!bl) continue;
                                String string4 = objectArray8[i].toString();
                                if (string4.equals("isinp") || string4.equals("isout")) {
                                    string3 = "IOVariables";
                                    break;
                                }
                                if (string4.equals("istemp")) {
                                    string3 = "TempVariables";
                                    break;
                                }
                                if (string4.equals("ispersistent")) {
                                    string3 = "PersistentVariables";
                                    break;
                                }
                                if (!string4.equals("isindex")) break;
                                string3 = "IndexVariables";
                                break;
                            }
                            if (string3 == null) {
                                System.err.println("Unknown variable type: " + string2);
                            }
                            linkedHashMap.put(string2, string3);
                        }
                        MatlabCoderEditorLayer.this.fVariablesMap.put(string, linkedHashMap);
                    }
                }
            }
        });
    }

    @Override
    public void notifyLoading() {
    }

    private static IdentifierInfo identifierUnderPoint(Point point, STPBaseInterface sTPBaseInterface) {
        try {
            TokenItem tokenItem;
            int n;
            int n2;
            int n3;
            int n4 = n3 = sTPBaseInterface.getPosFromPoint(point);
            if (n3 < sTPBaseInterface.getLength() - 1) {
                ++n4;
            }
            if ((n2 = sTPBaseInterface.getWordStartFromPos(n4)) == -1) {
                n2 = 0;
            }
            if ((n = sTPBaseInterface.getWordEndFromPos(n3)) == -1) {
                n = sTPBaseInterface.getLength();
            }
            if (n2 > n) {
                n2 = sTPBaseInterface.getWordStartFromPos(n);
            }
            if (n2 == -1) {
                n2 = 0;
            }
            Point point2 = sTPBaseInterface.getPointFromPos(n2);
            Point point3 = sTPBaseInterface.getPointFromPos(n);
            int n5 = 3;
            if (n2 < n && point3.x >= point.x - n5 && point2.x <= point.x + n5 && (tokenItem = ((ExtSyntaxSupport)((BaseDocument)sTPBaseInterface.getDocument()).getSyntaxSupport()).getTokenChain(n2, n)) != null) {
                IdentifierInfo identifierInfo = new IdentifierInfo();
                identifierInfo.setIdentifier(sTPBaseInterface.getTextStartEnd(n2, n));
                identifierInfo.setTokenId(tokenItem.getTokenID().getNumericID());
                return identifierInfo;
            }
        }
        catch (BadLocationException badLocationException) {
            Log.logException((Exception)badLocationException);
        }
        return null;
    }

    static {
        sStartTime = 0L;
    }

    public static class Poppy
    extends MJDialog
    implements MouseListener {
        private JPanel fPanel;
        private String fIdentifier;

        public Poppy(String string, IdentifierPopupInterface identifierPopupInterface, int n, int n2) {
            this.fIdentifier = string;
            this.setLocation(n, n2);
            this.setUndecorated(true);
            this.setAlwaysOnTop(true);
            this.setResizable(false);
            this.setDefaultCloseOperation(2);
            this.fPanel = identifierPopupInterface.getRootComponent();
            this.fPanel.setBackground(Color.white);
            this.fPanel.setBorder(LineBorder.createBlackLineBorder());
            this.fPanel.addMouseListener(this);
            this.add(this.fPanel);
            this.setSize(this.fPanel.getPreferredSize());
        }

        public String getIdentifier() {
            return this.fIdentifier;
        }

        public void dispose() {
            super.dispose();
            this.fPanel.removeMouseListener(this);
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (!this.fPanel.getBounds().contains(mouseEvent.getPoint())) {
                this.dispose();
            }
        }
    }

    private static class IdentifierInfo {
        private String fIdentifier;
        private int fTokenId;

        private IdentifierInfo() {
        }

        public String getIdentifier() {
            return this.fIdentifier;
        }

        public void setIdentifier(String string) {
            this.fIdentifier = string;
        }

        public int getTokenId() {
            return this.fTokenId;
        }

        public void setTokenId(int n) {
            this.fTokenId = n;
        }
    }
}

