/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.plugin.inputtypes;

import com.mathworks.mwswing.FontUtils;
import com.mathworks.mwswing.MJCheckBox;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.project.impl.table.PropertyTable;
import com.mathworks.project.impl.textfield.AutoCompleter;
import com.mathworks.project.impl.textfield.CharacterFilter;
import com.mathworks.project.impl.textfield.DefaultFormattedTextFieldPainter;
import com.mathworks.project.impl.textfield.FormatTipContent;
import com.mathworks.project.impl.textfield.FormatTipProvider;
import com.mathworks.project.impl.textfield.FormatTokenizer;
import com.mathworks.project.impl.textfield.FormattedTextField;
import com.mathworks.project.impl.textfield.FormattedTextFieldPainter;
import com.mathworks.project.impl.textfield.Token;
import com.mathworks.project.impl.util.StringUtils;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.plugin.Utilities;
import com.mathworks.toolbox.coder.plugin.inputtypes.IDPClassEnum;
import com.mathworks.toolbox.coder.plugin.inputtypes.InputDataProperty;
import com.mathworks.toolbox.coder.plugin.inputtypes.TypeEntryMode;
import com.mathworks.util.Holder;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.widgets.HyperlinkTextLabel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import javax.swing.FocusManager;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class FormattedTypeField {
    private final FormattedTextField fField;
    private final PropertyTable<InputDataProperty> fTable;
    private final ParameterRunnable<Runnable> fShowProperties;
    private final InputDataProperty fProperty;
    private final boolean fIsGlobal;
    private TypeEntryMode fMode;
    private boolean fComplex;
    private TypeListPanel fTypeListPanel;
    private static final int DIMENSION = 0;
    private static final int DIMENSION_SEPARATOR = 1;
    private static final int TYPE_NAME = 2;
    private static final int DEFAULT = 3;
    private static final char PROMPT_CHAR = '?';
    private static final String PROMPT_STRING = "?";
    private static final Color HINT_COLOR = new Color(0x545353);

    public FormattedTypeField(PropertyTable<InputDataProperty> propertyTable, InputDataProperty inputDataProperty, boolean bl, ParameterRunnable<Runnable> parameterRunnable) {
        this.fTable = propertyTable;
        this.fProperty = inputDataProperty;
        this.fIsGlobal = bl;
        this.fComplex = this.fProperty.isComplex();
        this.fShowProperties = parameterRunnable;
        this.fField = new FormattedTextField((FormattedTextFieldPainter)new Painter()){

            public void type(char c) {
                String string;
                if (Character.isWhitespace(c) && (this.getText().length() == 0 || this.getSelectedText().length() == this.getText().length() || this.getText().substring(0, this.getInsertionPoint()).trim().isEmpty())) {
                    return;
                }
                if (c == 'x') {
                    if (FormattedTypeField.this.getTypeName() == null || FormattedTypeField.this.fMode != TypeEntryMode.TYPE) {
                        super.type(c);
                        return;
                    }
                    if (this.getSelectedFieldToken() != null && this.getSelectedFieldToken().getType() == 0) {
                        FormattedTypeField.this.fField.setInsertionPoint(this.getTextBefore(this.getSelectedFieldToken()).length() + this.getSelectedFieldToken().getText().length());
                        FormattedTypeField.this.fField.select(FormattedTypeField.this.fField.getInsertionPoint(), FormattedTypeField.this.fField.getInsertionPoint());
                        this.type('x');
                        return;
                    }
                    string = this.getTokenForCharIndex(this.getInsertionPoint());
                    if (!(string != null && this.isField((Token)string) || this.getInsertionPoint() <= 0)) {
                        string = this.getTokenForCharIndex(this.getInsertionPoint() - 1);
                    }
                    if (string != null && !this.isField((Token)string)) {
                        string = null;
                    }
                    if (string != null && this.getSelectedFieldToken() == null && this.getTextBefore((Token)string).length() + string.getText().length() > this.getInsertionPoint()) {
                        string = null;
                    }
                    if (string != null) {
                        int n = FormattedTypeField.this.fField.getTextBefore((Token)string).length() + string.getText().length();
                        if (string.getType() == 0 && this.getInsertionPoint() < this.getText().length() - 1 && this.getText().substring(n + 1).trim().startsWith("x")) {
                            FormattedTypeField.this.fField.setInsertionPointWithAutoSelect(n + 3);
                            return;
                        }
                    }
                    if (!this.getText().endsWith(" ")) {
                        super.type(' ');
                    }
                }
                super.type(c);
                if (FormattedTypeField.this.fMode.equals((Object)TypeEntryMode.TYPE) && ((string = FormattedTypeField.this.getTypeName()) != null && this.getText().endsWith(string) || this.getText().endsWith("x"))) {
                    super.type(' ');
                }
            }

            protected boolean isField(Token token) {
                return token.getType() != 3 && token.getType() != 1;
            }

            protected boolean isSkippable(Token token) {
                return token.getType() == 1;
            }

            protected boolean isPrompt(Token token) {
                return token.getType() == 0 && token.getText().contains(FormattedTypeField.PROMPT_STRING);
            }

            public void doEscape() {
                FormattedTypeField.this.fTable.stopEditing(true);
            }

            public void doEnter() {
                FormattedTypeField.this.fTable.stopEditing(false);
            }

            public String doExtraPasteFiltering(String string) {
                if (FormattedTypeField.this.containsTypeName(string)) {
                    return string.replaceAll("[\\(\\)]", " ");
                }
                return string;
            }
        };
        this.setMode(TypeEntryMode.TYPE);
    }

    public void clickFromRendererIntoEditor(String string, Point point) {
        if (this.fMode != TypeEntryMode.EXAMPLE && this.fMode != TypeEntryMode.CONSTANT) {
            BufferedImage bufferedImage = new BufferedImage(1, 1, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setFont(this.fField.getComponent().getFont());
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            int[] nArray = fontMetrics.getWidths();
            int n = 0;
            int n2 = 0;
            while (n2 < string.length() && (double)n < point.getX()) {
                n += nArray[string.charAt(n2++)];
            }
            int n3 = --n2;
            for (int i = 0; i < n3; ++i) {
                if (string.indexOf("constant", i) == i) {
                    n2 -= "constant".length() + 1;
                    continue;
                }
                if (string.indexOf("complex", i) != i) continue;
                n2 -= "complex".length() + 1;
            }
            if ((double)n < point.getX()) {
                this.fField.setInsertionPoint(this.fField.getText().length());
                this.fField.doRightArrow(false, false);
            } else {
                this.fField.setInsertionPointWithAutoSelect(n2);
            }
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.fField.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.fField.removeChangeListener(changeListener);
    }

    public void setEditable(boolean bl) {
        this.fField.setEditable(bl);
    }

    public JComponent getComponent() {
        return this.fField.getComponent();
    }

    public void dispose() {
        this.fField.dispose();
    }

    public void closeFormatTip() {
        this.fField.closeFormatTip();
    }

    public String getText() {
        return this.fField.getText();
    }

    public String getFullText() {
        return this.fField.getTextWithCompletion();
    }

    public void selectAll() {
        this.fField.selectAll();
    }

    public void lockFormatTip() {
        this.fField.lockFormatTip();
    }

    public void unlockFormatTip() {
        this.fField.unlockFormatTip();
    }

    public void setText(String string) {
        this.fField.setText(this.convertRendererTextToEditorText(string));
    }

    public String convertRendererTextToEditorText(String string) {
        if (string.equals("<Undefined>")) {
            return "";
        }
        return string.replaceAll("\\Q(\\E", " ").replaceAll("\\Q)\\E", "");
    }

    public TypeEntryMode getMode() {
        return this.fMode;
    }

    public void setMode(TypeEntryMode typeEntryMode) {
        this.fMode = typeEntryMode;
        this.fField.setPrompt(CoderResources.getString("typedef.prompt." + StringUtils.upperCaseToCamelCase((String)this.fMode.toString(), (boolean)false)));
        if (typeEntryMode == TypeEntryMode.TYPE) {
            this.fField.setText("");
            this.fField.setFilter((CharacterFilter)new TypeModeCharacterFilter());
            this.fField.setCompleter((AutoCompleter)new TypeCompleter());
            this.fField.setTipProvider((FormatTipProvider)new TypeTipProvider());
            this.fField.setTokenizer((FormatTokenizer)new TypeTokenizer());
        } else if (typeEntryMode == TypeEntryMode.EXAMPLE || typeEntryMode == TypeEntryMode.CONSTANT || typeEntryMode == TypeEntryMode.INITIAL_VALUE) {
            String string;
            this.fField.setText("");
            this.fField.setFilter((CharacterFilter)new DefaultCharacterFilter());
            this.fField.setCompleter((AutoCompleter)new MatlabExpressionCompleter());
            this.fField.setTipProvider((FormatTipProvider)new DefaultTipProvider());
            this.fField.setTokenizer((FormatTokenizer)new DefaultTokenizer());
            String string2 = string = typeEntryMode == TypeEntryMode.INITIAL_VALUE ? this.fProperty.getInitialValue() : this.fProperty.getValue();
            if (string != null) {
                this.fField.setText(string);
                this.fField.selectAll();
            }
        } else {
            this.fField.setFilter((CharacterFilter)new DefaultCharacterFilter());
            this.fField.setCompleter((AutoCompleter)new DefaultCompleter());
            this.fField.setTipProvider((FormatTipProvider)new DefaultTipProvider());
            this.fField.setTokenizer((FormatTokenizer)new DefaultTokenizer());
        }
    }

    private static boolean isValidTypeName(String string) {
        for (IDPClassEnum iDPClassEnum : IDPClassEnum.values()) {
            if (!iDPClassEnum.isListable().booleanValue() || !iDPClassEnum.getClassName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean isComplex() {
        return FormattedTypeField.canBeComplex(this.getTypeName()) && this.fComplex;
    }

    private static boolean canBeComplex(String string) {
        return string.equals("single") || string.equals("double") || string.equals("embedded.fi") || string.equals("int8") || string.equals("int16") || string.equals("int32") || string.equals("uint8") || string.equals("uint16") || string.equals("uint32");
    }

    public String getTypeName() {
        for (Token token : this.fField.getTokens()) {
            if (token.getType() != 2) continue;
            return token.getText();
        }
        return null;
    }

    public String getSize() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Token token : this.fField.getTokens()) {
            if (token.getType() != 0 && token.getType() != 1) continue;
            if (stringBuilder.length() != 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(token.getText());
        }
        return stringBuilder.toString();
    }

    private boolean containsTypeName(String string) {
        for (IDPClassEnum iDPClassEnum : IDPClassEnum.values()) {
            if (!string.contains(iDPClassEnum.getClassName())) continue;
            return true;
        }
        return false;
    }

    private TypeListPanel recycleTypeListPanel() {
        if (this.fTypeListPanel == null || !this.fTypeListPanel.isShowing()) {
            this.fTypeListPanel = new TypeListPanel();
        }
        return this.fTypeListPanel;
    }

    private Runnable delay(final Runnable runnable) {
        return new Runnable(){

            @Override
            public void run() {
                final Holder holder = new Holder();
                holder.set((Object)new Timer(25, new ActionListener(){
                    private int i;

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (++this.i == 2) {
                            FormattedTypeField.this.fField.getComponent().requestFocus();
                            ((Timer)holder.get()).stop();
                        } else {
                            FormattedTypeField.this.fField.lockFormatTip();
                            runnable.run();
                            FormattedTypeField.this.fField.unlockFormatTip();
                            FocusManager.getCurrentKeyboardFocusManager().clearGlobalFocusOwner();
                        }
                    }
                }));
                ((Timer)holder.get()).setRepeats(true);
                ((Timer)holder.get()).start();
            }
        };
    }

    private class SizeModePanel
    extends MJPanel {
        private final GridBagConstraints fConstraints;
        private final String fSize;

        SizeModePanel(String string) {
            this.fSize = string;
            this.fConstraints = new GridBagConstraints();
            this.fConstraints.anchor = 17;
            this.setOpaque(false);
            this.setDoubleBuffered(false);
            this.setLayout(new GridBagLayout());
            this.fConstraints.gridx = 0;
            this.fConstraints.gridy = 0;
            this.fConstraints.insets = new Insets(2, 4, 2, 4);
            String string2 = "n";
            if (this.fSize != null) {
                string2 = this.fSize;
            }
            if (string2.startsWith(":")) {
                string2 = string2.substring(1);
            }
            if (this.fSize == null || this.fSize.trim().isEmpty() || this.fSize.trim().equals(FormattedTypeField.PROMPT_STRING) || this.fSize.trim().equals("0") || this.fSize.trim().equalsIgnoreCase(":inf")) {
                this.fConstraints.gridwidth = 2;
                MJLabel mJLabel = new MJLabel(CoderResources.getString("typedef.typeNumber"));
                mJLabel.setForeground(HINT_COLOR);
                this.add((Component)mJLabel, this.fConstraints);
                ++this.fConstraints.gridy;
                this.fConstraints.gridwidth = 1;
            } else {
                this.add(string2, MessageFormat.format(CoderResources.getString("typedef.size.fixed"), string2));
                this.add(":" + string2, MessageFormat.format(CoderResources.getString("typedef.size.variable"), string2));
            }
            this.add(":Inf", MessageFormat.format(CoderResources.getString("typedef.size.unbounded"), string2));
        }

        public String getSizeString() {
            return this.fSize;
        }

        private void add(final String string, String string2) {
            final Runnable runnable = FormattedTypeField.this.delay(new Runnable(){

                @Override
                public void run() {
                    FormattedTypeField.this.fField.replaceFieldToken(string, false);
                    boolean bl = FormattedTypeField.this.fField.jumpToNextPromptIfAny();
                    if (!bl && string.equalsIgnoreCase(":inf")) {
                        FormattedTypeField.this.fField.doRightArrow(false, false);
                    }
                }
            });
            HyperlinkTextLabel hyperlinkTextLabel = Utilities.createLink(string, "sizing." + string, runnable);
            this.fConstraints.gridx = 0;
            this.add(hyperlinkTextLabel.getComponent(), this.fConstraints);
            ++this.fConstraints.gridx;
            MJLabel mJLabel = new MJLabel(string2);
            mJLabel.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    runnable.run();
                }
            });
            mJLabel.setForeground(HINT_COLOR);
            this.add((Component)mJLabel, this.fConstraints);
            ++this.fConstraints.gridy;
        }
    }

    private class ShapeListPanel
    extends MJPanel {
        private final GridBagConstraints fConstraints;

        ShapeListPanel() {
            this.setOpaque(false);
            this.setDoubleBuffered(false);
            this.setLayout(new GridBagLayout());
            this.fConstraints = new GridBagConstraints();
            this.fConstraints.anchor = 17;
            this.fConstraints.gridx = 0;
            this.fConstraints.gridy = 0;
            this.add("1 x 1", CoderResources.getString("typedef.shape.scalar"), CoderResources.getIcon("scalar.png"));
            this.add("1 x n", CoderResources.getString("typedef.shape.vector"), CoderResources.getIcon("row_vector.png"));
            this.add("m x 1", CoderResources.getString("typedef.shape.vector"), CoderResources.getIcon("column_vector.png"));
            this.add("m x n", CoderResources.getString("typedef.shape.matrix"), CoderResources.getIcon("matrix.png"));
        }

        private void add(final String string, String string2, Icon icon) {
            this.fConstraints.insets = new Insets(2, 4, 2, 4);
            final Runnable runnable = FormattedTypeField.this.delay(new Runnable(){

                @Override
                public void run() {
                    String string2 = string.replaceAll("m", FormattedTypeField.PROMPT_STRING).replaceAll("n", FormattedTypeField.PROMPT_STRING);
                    int n = string2.indexOf(FormattedTypeField.PROMPT_STRING);
                    FormattedTypeField.this.fField.insert(string2);
                    int n2 = FormattedTypeField.this.fField.getInsertionPoint();
                    if (n != -1) {
                        FormattedTypeField.this.fField.select(n2 - string2.length() + n, n2 - string2.length() + n + 1);
                        FormattedTypeField.this.fField.setInsertionPoint(n2 - string2.length() + n);
                    }
                }
            });
            this.add(Utilities.createLink(string, "link." + this.fConstraints.gridy, runnable).getComponent(), this.fConstraints);
            ++this.fConstraints.gridx;
            MJLabel mJLabel = new MJLabel(icon);
            mJLabel.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    runnable.run();
                }
            });
            mJLabel.setCursor(Cursor.getPredefinedCursor(12));
            MJLabel mJLabel2 = new MJLabel(string2);
            mJLabel2.addMouseListener((MouseListener)new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    runnable.run();
                }
            });
            mJLabel2.setForeground(HINT_COLOR);
            this.add((Component)mJLabel, this.fConstraints);
            ++this.fConstraints.gridx;
            this.add((Component)mJLabel2, this.fConstraints);
            ++this.fConstraints.gridy;
            this.fConstraints.gridx = 0;
        }
    }

    private class Separator
    extends MJPanel {
        private Separator() {
        }

        public Dimension getPreferredSize() {
            return new Dimension(1, 1);
        }

        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public void paintComponent(Graphics graphics) {
            graphics.setColor(new Color(0xC3C3C3));
            ((Graphics2D)graphics).setStroke(new BasicStroke(0.8f));
            graphics.drawLine(1, 0, this.getWidth() - 7, 0);
        }
    }

    private class TypeListPanel
    extends MJPanel {
        public TypeListPanel() {
            this.setOpaque(false);
            this.setDoubleBuffered(false);
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(2, 6, 2, 4);
            boolean bl = false;
            boolean bl2 = false;
            gridBagConstraints.gridy = -1;
            for (final IDPClassEnum iDPClassEnum : IDPClassEnum.values()) {
                boolean bl3;
                gridBagConstraints.insets.right = 4;
                if (!iDPClassEnum.isListable().booleanValue()) continue;
                boolean bl4 = iDPClassEnum.toString().startsWith("INT");
                boolean bl5 = iDPClassEnum.toString().startsWith("UINT");
                boolean bl6 = iDPClassEnum == IDPClassEnum.SINGLE;
                boolean bl7 = bl3 = iDPClassEnum == IDPClassEnum.CHAR;
                if (bl4 && bl || bl5 && bl2 || bl6 || bl3) {
                    ++gridBagConstraints.gridx;
                } else {
                    gridBagConstraints.gridx = 0;
                    ++gridBagConstraints.gridy;
                }
                gridBagConstraints.gridwidth = bl4 || bl5 ? 1 : 3;
                bl = bl4;
                bl2 = bl5;
                String string = iDPClassEnum.getClassName();
                if (iDPClassEnum == IDPClassEnum.FI) {
                    string = string + "...";
                }
                if (iDPClassEnum == IDPClassEnum.STRUCT) {
                    this.addSeparator(gridBagConstraints);
                }
                if (gridBagConstraints.gridx == 3) {
                    gridBagConstraints.insets.right = 0;
                }
                this.add(Utilities.createLink(string, "link." + iDPClassEnum.getClassName(), FormattedTypeField.this.delay(new Runnable(){

                    @Override
                    public void run() {
                        boolean bl;
                        boolean bl2 = bl = FormattedTypeField.this.getTypeName() != null;
                        if (iDPClassEnum == IDPClassEnum.FI) {
                            FormattedTypeField.this.fField.closeFormatTip();
                            FormattedTypeField.this.fField.lockFormatTip();
                        }
                        if (FormattedTypeField.this.fField.getTokens().size() == 1) {
                            FormattedTypeField.this.fField.setText("");
                            for (int i = 0; i < iDPClassEnum.getClassName().length(); ++i) {
                                FormattedTypeField.this.fField.type(iDPClassEnum.getClassName().charAt(i));
                            }
                        } else {
                            FormattedTypeField.this.fField.replaceFieldToken(iDPClassEnum.getClassName(), true);
                        }
                        if (bl) {
                            FormattedTypeField.this.fField.setInsertionPoint(0);
                            FormattedTypeField.this.fField.select(FormattedTypeField.this.fField.getFieldTokenForCharIndex(0));
                        }
                        if (iDPClassEnum == IDPClassEnum.FI) {
                            FormattedTypeField.this.fShowProperties.run((Object)new Runnable(){

                                @Override
                                public void run() {
                                    FormattedTypeField.this.fField.unlockFormatTip();
                                }
                            });
                        }
                    }
                })).getComponent(), gridBagConstraints);
            }
            ++gridBagConstraints.gridy;
            this.addSeparator(gridBagConstraints);
            final MJCheckBox mJCheckBox = new MJCheckBox(CoderResources.getString("typedef.complex"));
            mJCheckBox.setOpaque(false);
            mJCheckBox.setForeground(new Color(2118279));
            mJCheckBox.setFont(FontUtils.getSystemUIFont());
            mJCheckBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    FormattedTypeField.this.fComplex = mJCheckBox.isSelected();
                }
            });
            mJCheckBox.addKeyListener((KeyListener)new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (keyEvent.getKeyCode() == 10) {
                        FormattedTypeField.this.fField.doEnter();
                    }
                }
            });
            FormattedTypeField.this.fField.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    mJCheckBox.setEnabled(FormattedTypeField.this.getTypeName() == null || FormattedTypeField.canBeComplex(FormattedTypeField.this.getTypeName()));
                    if (!mJCheckBox.isEnabled()) {
                        mJCheckBox.setSelected(false);
                    }
                }
            });
            mJCheckBox.setSelected(FormattedTypeField.this.fComplex && (FormattedTypeField.this.getTypeName() == null || FormattedTypeField.canBeComplex(FormattedTypeField.this.getTypeName())));
            mJCheckBox.setEnabled(FormattedTypeField.this.getTypeName() == null || FormattedTypeField.canBeComplex(FormattedTypeField.this.getTypeName()));
            gridBagConstraints.insets.left = 2;
            this.add((Component)mJCheckBox, gridBagConstraints);
            gridBagConstraints.insets.left = 4;
            ++gridBagConstraints.gridy;
            this.addSeparator(gridBagConstraints);
            this.add(Utilities.createLink(CoderResources.getString("action.defineByExample"), "link.example", FormattedTypeField.this.delay(new Runnable(){

                @Override
                public void run() {
                    FormattedTypeField.this.setMode(TypeEntryMode.EXAMPLE);
                }
            })).getComponent(), gridBagConstraints);
            ++gridBagConstraints.gridy;
            if (!FormattedTypeField.this.fIsGlobal) {
                this.add(Utilities.createLink(CoderResources.getString("action.defineConstant"), "link.constant", FormattedTypeField.this.delay(new Runnable(){

                    @Override
                    public void run() {
                        FormattedTypeField.this.setMode(TypeEntryMode.CONSTANT);
                    }
                })).getComponent(), gridBagConstraints);
            } else {
                this.add(Utilities.createLink(CoderResources.getString("action.defineInitialValue"), "link.initialValue", FormattedTypeField.this.delay(new Runnable(){

                    @Override
                    public void run() {
                        FormattedTypeField.this.setMode(TypeEntryMode.INITIAL_VALUE);
                    }
                })).getComponent(), gridBagConstraints);
            }
        }

        public boolean equals(Object object) {
            return object instanceof TypeListPanel;
        }

        private void addSeparator(GridBagConstraints gridBagConstraints) {
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets.left = 0;
            gridBagConstraints.insets.right = 0;
            this.add((Component)((Object)new Separator()), gridBagConstraints);
            gridBagConstraints.insets.left = 4;
            gridBagConstraints.insets.right = 4;
            ++gridBagConstraints.gridy;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
        }
    }

    private class TypeTipProvider
    implements FormatTipProvider {
        private TypeTipProvider() {
        }

        public FormatTipContent getTipComponent(FormattedTextField formattedTextField) {
            List list = formattedTextField.getTokens();
            if (list.isEmpty()) {
                return new FormatTipContent((Component)((Object)FormattedTypeField.this.recycleTypeListPanel()), null);
            }
            Token token = formattedTextField.getFieldTokenForCharIndex(formattedTextField.getInsertionPoint());
            if (token == null) {
                token = formattedTextField.getTokenForCharIndex(formattedTextField.getInsertionPoint());
            }
            if (formattedTextField.getInsertionPoint() == formattedTextField.getText().length()) {
                if (FormattedTypeField.this.getTypeName() != null && list.size() == 2) {
                    return new FormatTipContent((Component)((Object)new ShapeListPanel()), null);
                }
                token = (Token)list.get(list.size() - 1);
            }
            if (token.getType() == 2 || list.size() == 1) {
                return new FormatTipContent((Component)((Object)FormattedTypeField.this.recycleTypeListPanel()), token);
            }
            if (token.getType() == 0 && !token.getText().equals("1") || FormattedTypeField.this.fField.getInsertionPoint() == FormattedTypeField.this.fField.getText().length() && FormattedTypeField.this.fField.getText().trim().endsWith("x")) {
                return new FormatTipContent((Component)((Object)new SizeModePanel(token.getType() == 0 ? token.getText() : null)), token);
            }
            return null;
        }
    }

    private class DefaultTipProvider
    implements FormatTipProvider {
        private DefaultTipProvider() {
        }

        public FormatTipContent getTipComponent(FormattedTextField formattedTextField) {
            return null;
        }
    }

    private class DefaultTokenizer
    implements FormatTokenizer {
        private DefaultTokenizer() {
        }

        public List<Token> tokenize(String string) {
            return Arrays.asList(new Token(3, string));
        }
    }

    private class MatlabExpressionCompleter
    implements AutoCompleter {
        private MatlabExpressionCompleter() {
        }

        public List<Token> getSuggestedCompletion(List<Token> list) {
            return new ArrayList<Token>();
        }
    }

    private class DefaultCompleter
    implements AutoCompleter {
        private DefaultCompleter() {
        }

        public List<Token> getSuggestedCompletion(List<Token> list) {
            return new ArrayList<Token>();
        }
    }

    private class TypeCompleter
    implements AutoCompleter {
        private TypeCompleter() {
        }

        public List<Token> getSuggestedCompletion(List<Token> list) {
            if (FormattedTypeField.this.fField.getText().length() > 0 && !FormattedTypeField.this.fField.getText().endsWith(" ")) {
                return Arrays.asList(new Token(3, " "));
            }
            return new ArrayList<Token>(0);
        }
    }

    private class TypeTokenizer
    implements FormatTokenizer {
        private TypeTokenizer() {
        }

        public List<Token> tokenize(String string) {
            if (!FormattedTypeField.this.containsTypeName(string)) {
                return Arrays.asList(new Token(3, string));
            }
            LinkedList<Token> linkedList = new LinkedList<Token>();
            final LinkedList<String> linkedList2 = new LinkedList<String>();
            final StringBuilder stringBuilder = new StringBuilder();
            boolean bl = false;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (stringBuilder.length() > 0) {
                        linkedList2.add(stringBuilder.toString());
                        stringBuilder.setLength(0);
                    }
                }
            };
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == ' ') {
                    if ((linkedList2.isEmpty() || bl) && stringBuilder.length() > 0) {
                        linkedList2.add(stringBuilder.toString());
                        stringBuilder.setLength(0);
                    }
                    stringBuilder.append(' ');
                    bl = false;
                    continue;
                }
                if (string.charAt(i) == '?') {
                    runnable.run();
                    linkedList2.add(FormattedTypeField.PROMPT_STRING);
                    continue;
                }
                if (string.toLowerCase(Locale.ENGLISH).indexOf(":inf", i) == i) {
                    runnable.run();
                    linkedList2.add(string.substring(i, i + 4));
                    i += 3;
                    continue;
                }
                if (!(!Character.isDigit(string.charAt(i)) && string.charAt(i) != ':' || bl || i != 0 && string.charAt(i - 1) != 'x' && string.charAt(i - 1) != ' ')) {
                    runnable.run();
                    stringBuilder.append(string.charAt(i));
                    bl = true;
                    continue;
                }
                if (string.charAt(i) == 'x' && !stringBuilder.toString().endsWith(" ")) {
                    runnable.run();
                    bl = false;
                    stringBuilder.append(string.charAt(i));
                    continue;
                }
                stringBuilder.append(string.charAt(i));
            }
            runnable.run();
            for (String string2 : linkedList2) {
                if (FormattedTypeField.isValidTypeName(string2)) {
                    linkedList.add(new Token(2, string2));
                    continue;
                }
                if (string2.equals(FormattedTypeField.PROMPT_STRING)) {
                    linkedList.add(new Token(0, FormattedTypeField.PROMPT_STRING));
                    continue;
                }
                if (string2.equalsIgnoreCase(":inf")) {
                    linkedList.add(new Token(0, string2));
                    continue;
                }
                try {
                    Integer.parseInt(string2.startsWith(":") ? string2.substring(1) : string2);
                    linkedList.add(new Token(0, string2));
                }
                catch (NumberFormatException numberFormatException) {
                    if (string2.contains("x")) {
                        linkedList.add(new Token(1, string2));
                        continue;
                    }
                    linkedList.add(new Token(3, string2));
                }
            }
            return linkedList;
        }
    }

    private class DefaultCharacterFilter
    implements CharacterFilter {
        private DefaultCharacterFilter() {
        }

        public boolean accept(FormattedTextField formattedTextField, char c) {
            return true;
        }
    }

    private class TypeModeCharacterFilter
    implements CharacterFilter {
        private TypeModeCharacterFilter() {
        }

        public boolean accept(FormattedTextField formattedTextField, char c) {
            if (FormattedTypeField.this.getTypeName() != null) {
                Token token = formattedTextField.getTokenForCharIndex(FormattedTypeField.this.fField.getInsertionPoint());
                if (FormattedTypeField.this.fField.getSelectionStart() != FormattedTypeField.this.fField.getSelectionEnd()) {
                    token = formattedTextField.getTokenForCharIndex(Math.min(FormattedTypeField.this.fField.getSelectionEnd(), FormattedTypeField.this.fField.getSelectionStart()));
                }
                boolean bl = token != null && formattedTextField.getTextBefore(token).isEmpty();
                return Character.isDigit(c) || c == 'x' || c == ' ' || c == ':' || "inf".indexOf(Character.toLowerCase(c)) >= 0 || Character.isLetter(c) && (bl || token != null && token.getType() == 2);
            }
            return true;
        }
    }

    private class Painter
    extends DefaultFormattedTextFieldPainter {
        private Painter() {
        }

        protected boolean hasBorder(Token token) {
            return token.getType() == 2 || token.getType() == 0;
        }

        protected boolean isPromptChar(char c) {
            return c == '?';
        }
    }
}

