/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.plugin;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.jmi.MatlabWorker;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJButton;
import com.mathworks.project.api.FileDataWidget;
import com.mathworks.project.api.ValidationMessage;
import com.mathworks.project.api.WritableConfiguration;
import com.mathworks.project.api.WritableFileSet;
import com.mathworks.project.api.XmlApi;
import com.mathworks.project.api.XmlReader;
import com.mathworks.project.impl.DeployTool;
import com.mathworks.project.impl.filesetui.FileSetEditor;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.plugin.EntryPointFileDataWidget;
import com.mathworks.toolbox.coder.plugin.TestBenchResult;
import com.mathworks.toolbox.coder.plugin.Utilities;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;

public class TestBenchFileDataWidget
implements FileDataWidget {
    private File fTestBenchFile = null;
    private WritableConfiguration fConfig = DeployTool.getInstance().getProject().getConfiguration();
    private Component fComponent = null;
    private TestBenchResult fTestBenchResult;

    public TestBenchFileDataWidget(File file) {
        this.fTestBenchFile = file;
        this.fComponent = this.configureComponent();
    }

    private Component configureComponent() {
        MJButton mJButton = new MJButton((Action)new MJAbstractAction(CoderResources.getString("action.testbench.Run")){

            public void actionPerformed(ActionEvent actionEvent) {
                TestBenchFileDataWidget.this.runTestBench();
            }
        });
        String string = "p:grow, p, 1dlu";
        String string2 = "3dlu, p";
        FormLayout formLayout = new FormLayout(string, string2);
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)mJButton, cellConstraints.xy(2, 2));
        JPanel jPanel = panelBuilder.getPanel();
        jPanel.setOpaque(true);
        jPanel.setBackground(Utilities.BACKGROUND);
        return jPanel;
    }

    private void runTestBench() {
        WritableFileSet writableFileSet = this.fConfig.getFileSet("fileset.entrypoints");
        final Set set = writableFileSet.getFiles();
        MatlabWorker<TestBenchResult> matlabWorker = new MatlabWorker<TestBenchResult>(){

            public TestBenchResult runOnMatlabThread() throws Exception {
                Object[] objectArray = new Object[]{TestBenchFileDataWidget.this.fTestBenchFile, set};
                return (TestBenchResult)2.feval((String)"coder.internal.inferTestBench", (Object[])objectArray, (int)1);
            }

            public void runOnAWTEventDispatchThread(TestBenchResult testBenchResult) {
                TestBenchFileDataWidget.this.fTestBenchResult = testBenchResult;
                if (TestBenchFileDataWidget.this.getTestBenchResult().getMessage().isEmpty()) {
                    TestBenchFileDataWidget.this.applyTestBenchResults();
                } else {
                    TestBenchFileDataWidget.this.reportTestBenchFailed();
                }
            }
        };
        matlabWorker.start();
    }

    TestBenchResult getTestBenchResult() {
        return this.fTestBenchResult;
    }

    private void reportTestBenchFailed() {
    }

    private void applyTestBenchResults() {
        FileSetEditor fileSetEditor = DeployTool.getInstance().getFileSetEditor("fileset.entrypoints");
        Map<String, String> map = this.getTestBenchResult().getEntryPointTypes();
        WritableFileSet writableFileSet = this.fConfig.getFileSet("fileset.entrypoints");
        Set set = writableFileSet.getFiles();
        EntryPointFileDataWidget entryPointFileDataWidget = Utilities.getEntryPointFileDataWidget();
        for (File file : set) {
            String string = file.getName();
            String string2 = string.substring(0, string.length() - 2);
            String string3 = map.get(string2);
            if (string3 == null) continue;
            fileSetEditor.getFileSet().setCustomData(file, string3);
            if (entryPointFileDataWidget == null || !file.getAbsoluteFile().equals(entryPointFileDataWidget.getEntryPointFile().getAbsoluteFile())) continue;
            try {
                XmlReader xmlReader = XmlApi.getInstance().read(string3);
                entryPointFileDataWidget.setData(xmlReader);
            }
            catch (IOException iOException) {
                System.out.println(iOException.getMessage());
            }
        }
    }

    public void fileChanged() {
    }

    public void setData(XmlReader xmlReader) {
    }

    public XmlReader getData() {
        return null;
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    public boolean showValidationMessage(ValidationMessage validationMessage) {
        return false;
    }

    public void clearValidationMessage() {
    }

    public Component getComponent() {
        return this.fComponent;
    }

    public void dispose() {
    }
}

