/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.plugin;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.mlwidgets.explorer.util.PrefUtils;
import com.mathworks.mwswing.ColorUtils;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJButton;
import com.mathworks.mwswing.MJMenu;
import com.mathworks.mwswing.MJMenuBar;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.project.api.DeploymentProcess;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.DataTransferSupport;
import com.mathworks.project.impl.ProjectGUI;
import com.mathworks.project.impl.SectionPanel;
import com.mathworks.project.impl.SectionedProjectTab;
import com.mathworks.project.impl.desktop.BuildAction;
import com.mathworks.project.impl.desktop.HelpAction;
import com.mathworks.project.impl.desktop.NewProjectAction;
import com.mathworks.project.impl.desktop.OpenProjectAction;
import com.mathworks.project.impl.desktop.ProjectAction;
import com.mathworks.project.impl.desktop.ProjectClient;
import com.mathworks.project.impl.desktop.RenameProjectAction;
import com.mathworks.project.impl.desktop.ToolbarProjectClient;
import com.mathworks.project.impl.filesetui.FileSetEditor;
import com.mathworks.project.impl.model.FileSetDefinition;
import com.mathworks.project.impl.model.Project;
import com.mathworks.project.impl.model.ProjectTabDefinition;
import com.mathworks.project.impl.workflowui.WorkflowDialog;
import com.mathworks.toolbox.coder.plugin.CoderResources;
import com.mathworks.toolbox.coder.plugin.Utilities;
import com.mathworks.toolbox.coder.screener.ProjectScreenerBar;
import com.mathworks.widgets.desk.DTLocation;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class HDLCoderClient
extends ToolbarProjectClient {
    private final MJMenu fProjectMenu;
    private final MJMenuBar fMenuBar;
    private final MJPanel fContentPane = new MJPanel((LayoutManager)new BorderLayout(0, 0));
    private final MJPanel fButtonPanel;
    private ProjectScreenerBar fScreenerBar;
    private SectionedProjectTab fPanel;
    public static final String NAME = "Deploy Tool";
    public static final String TITLE = BuiltInResources.getString((String)"title");
    private static final Color BORDER_COLOR = ColorUtils.convertToCurrentColorScheme((Color)new Color(128, 128, 128), (Color)UIManager.getColor("control"));

    public HDLCoderClient() {
        super(NAME, TITLE);
        this.fMenuBar = new MJMenuBar();
        this.fMenuBar.setName("deploytool.menubar");
        this.fProjectMenu = new MJMenu(BuiltInResources.getString((String)"menu.project"));
        this.fProjectMenu.setName("menu.project");
        this.fMenuBar.add((JMenu)this.fProjectMenu);
        this.addAction((ProjectAction)new NewProjectAction(), false);
        this.addAction((ProjectAction)new OpenProjectAction(), false);
        this.addAction((ProjectAction)new RenameProjectAction((Component)((Object)this)), false);
        this.addAction((ProjectAction)new BuildAction((ProjectClient)this), true);
        this.addAction((ProjectAction)new HelpAction((Component)((Object)this)), false);
        this.switchToNoProjectMode();
        this.updateProjectMenu();
        this.setMenuBar((JMenuBar)this.fMenuBar);
        this.setContentPane((Component)this.fContentPane);
        PrefUtils.manageBackgroundColor((Container)((Object)this));
        DataTransferSupport.installDropToOpenSupport((Component)((Object)this));
        CellConstraints cellConstraints = new CellConstraints();
        this.fButtonPanel = new MJPanel((LayoutManager)new FormLayout("8px, fill:d, fill:d:grow, 3dlu", "3dlu, fill:d, 3dlu, fill:d"));
        this.fButtonPanel.setBackground(SectionPanel.BACKGROUND);
        MJButton mJButton = new MJButton((Action)this.getAction("BUILD"));
        mJButton.setText(CoderResources.getString("link.WorkflowPanel"));
        mJButton.setName("action.workflow");
        mJButton.setToolTipText(null);
        this.fButtonPanel.add((Component)Utilities.createDescriptionComponent("desc.workflow"), (Object)cellConstraints.xyw(2, 2, 2));
        this.fButtonPanel.add((Component)mJButton, (Object)cellConstraints.xy(2, 4));
    }

    public static Component getInstance() {
        return ProjectGUI.getInstance().getClient(true).getComponent();
    }

    protected void customizeActionMenu(JPopupMenu jPopupMenu) {
        jPopupMenu.removeAll();
        HDLCoderClient.addToActionMenu((JPopupMenu)jPopupMenu, (MJAbstractAction)this.getAction("NEW"));
        HDLCoderClient.addToActionMenu((JPopupMenu)jPopupMenu, (MJAbstractAction)this.getAction("OPEN"));
        jPopupMenu.addSeparator();
        HDLCoderClient.addToActionMenu((JPopupMenu)jPopupMenu, (MJAbstractAction)this.getAction("RENAME_PROJECT"));
        jPopupMenu.addSeparator();
        HDLCoderClient.addToActionMenu((JPopupMenu)jPopupMenu, (MJAbstractAction)this.getAction("BUILD"));
        jPopupMenu.addSeparator();
        HDLCoderClient.addToActionMenu((JPopupMenu)jPopupMenu, (MJAbstractAction)this.getAction("HELP"));
    }

    public DTLocation getDefaultLocation() {
        return DTLocation.create((String)"EE");
    }

    public void loadingFinished(Project project) {
        super.loadingFinished(project);
        if (this.fPanel != null) {
            this.fPanel.dispose();
        }
        this.fContentPane.removeAll();
        this.fPanel = new SectionedProjectTab(project, ((ProjectTabDefinition)project.getConfiguration().getTarget().getProjectTabs().get(0)).getSections());
        this.fPanel.addSectionWithoutHeader((Component)this.fButtonPanel);
        this.fPanel.getComponent().setBorder(new TopBorder());
        this.fButtonPanel.setBorder((Border)new TopBorder());
        this.fContentPane.setLayout((LayoutManager)new FormLayout("fill:d:grow", "fill:d, fill:d:grow"));
        CellConstraints cellConstraints = new CellConstraints();
        this.fContentPane.add((Component)this.fPanel.getComponent(), (Object)cellConstraints.xy(1, 2));
        this.setContentPane((Component)this.fContentPane);
        this.fContentPane.revalidate();
        this.fContentPane.repaint();
        this.revalidate();
        this.repaint();
        this.updateProjectMenu();
        this.fScreenerBar = new ProjectScreenerBar(project.getConfiguration());
        this.fContentPane.add((Component)this.fScreenerBar.getComponent(), (Object)cellConstraints.xy(1, 1));
    }

    public void projectClosed() {
        WorkflowDialog.close();
        super.projectClosed();
    }

    public void start(DeploymentProcess deploymentProcess) {
    }

    protected void switchToNoProjectMode() {
        super.switchToNoProjectMode();
        if (this.fPanel != null) {
            this.fPanel.dispose();
            this.fPanel = null;
        }
        if (this.fScreenerBar != null) {
            this.fScreenerBar.dispose();
            this.fScreenerBar = null;
        }
    }

    private void updateProjectMenu() {
        JMenuItem jMenuItem;
        Project project = this.getProject();
        this.fProjectMenu.removeAll();
        JMenuItem jMenuItem2 = this.fProjectMenu.add((Action)this.getAction("RENAME_PROJECT"));
        jMenuItem2.setName("menuitem.rename.project");
        if (project != null && !project.getConfiguration().getTarget().getNonWorkflowParamSets().isEmpty()) {
            this.fProjectMenu.addSeparator();
            jMenuItem = this.fProjectMenu.add((Action)this.getAction("SETTINGS"));
            jMenuItem.setName("menuitem.settings");
        }
        this.fProjectMenu.addSeparator();
        jMenuItem = this.fProjectMenu.add((Action)this.getAction("BUILD"));
        jMenuItem.setName("menuitem.build");
        if (project != null && project.getConfiguration().getTarget().getPackageScript() != null) {
            JMenuItem jMenuItem3 = this.fProjectMenu.add((Action)this.getAction("PACKAGE"));
            jMenuItem3.setName("menuitem.package");
        }
        this.setMenuBar((JMenuBar)this.fMenuBar);
    }

    public List<FileSetEditor> getFileSetEditors() {
        ArrayList<FileSetEditor> arrayList = new ArrayList<FileSetEditor>();
        for (FileSetDefinition fileSetDefinition : this.getProject().getConfiguration().getTarget().getFileSets()) {
            arrayList.add(this.fPanel.getFileSetEditor(fileSetDefinition.getKey()));
        }
        return arrayList;
    }

    public FileSetEditor getFileSetEditor(String string) {
        return this.fPanel == null ? null : this.fPanel.getFileSetEditor(string);
    }

    private static class TopBorder
    implements Border {
        private TopBorder() {
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            graphics.setColor(BORDER_COLOR);
            graphics.drawLine(n, n2, n + n3, n2);
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return new Insets(1, 0, 0, 0);
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }
    }
}

