/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.coder.plugin;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.project.api.FileDataWidget;
import com.mathworks.project.api.ProjectComponentWithSelection;
import com.mathworks.project.api.ValidationMessage;
import com.mathworks.project.api.XmlApi;
import com.mathworks.project.api.XmlReader;
import com.mathworks.project.api.XmlWriter;
import com.mathworks.project.impl.DeployTool;
import com.mathworks.project.impl.ProjectGUI;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.toolbox.coder.plugin.EntryPoint;
import com.mathworks.toolbox.coder.plugin.ParsedFunctionParameterNames;
import com.mathworks.toolbox.coder.plugin.Utilities;
import com.mathworks.toolbox.coder.plugin.inputtypes.IDPAttributes;
import com.mathworks.toolbox.coder.plugin.inputtypes.IDPChangeEvent;
import com.mathworks.toolbox.coder.plugin.inputtypes.IDPChangeListener;
import com.mathworks.toolbox.coder.plugin.inputtypes.InputDataProperty;
import com.mathworks.toolbox.coder.plugin.inputtypes.InputTable;
import com.mathworks.widgets.text.mcode.MTree;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.border.AbstractBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class EntryPointFileDataWidget
implements FileDataWidget,
ProjectComponentWithSelection,
IDPChangeListener,
PropertyChangeListener {
    private File fEntryPointFile;
    private InputTable fTable;
    private Set<ChangeListener> fChangeListeners = new HashSet<ChangeListener>();
    private EntryPoint fEntryPoint;
    private final JPanel fPanel;

    public EntryPointFileDataWidget(File file) {
        this.fEntryPointFile = file;
        this.reloadEntryPoint(file);
        this.fTable = new InputTable(ProjectGUI.getInstance().getCurrentProject().getConfiguration(), this.fEntryPoint, (IDPChangeListener)this, new Runnable(){

            @Override
            public void run() {
                EntryPointFileDataWidget.this.changeEvent();
            }
        });
        String string = "default:grow";
        String string2 = "p, p";
        FormLayout formLayout = new FormLayout(string, string2);
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.add((Component)this.fTable.getComponent(), cellConstraints.xy(1, 1));
        this.fPanel = panelBuilder.getPanel();
        AbstractBorder abstractBorder = new AbstractBorder(){

            @Override
            public Insets getBorderInsets(Component component) {
                return new Insets(0, 10, 0, 0);
            }

            @Override
            public boolean isBorderOpaque() {
                return false;
            }

            @Override
            public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
                graphics.clearRect(n, n2, n3, n4);
            }
        };
        this.fPanel.setBorder(abstractBorder);
        this.fPanel.setOpaque(false);
        Configuration configuration = DeployTool.getInstance((boolean)false).getProject().getConfiguration();
        configuration.addPropertyChangeListener((PropertyChangeListener)this);
        this.setUsePreconditions(configuration.getParamAsBoolean("param.UsePreconditions"));
        Utilities.setEntryPointFileDataWidget(this);
    }

    File getEntryPointFile() {
        return this.fEntryPointFile;
    }

    private void reloadEntryPoint(File file) {
        this.fEntryPoint = this.getEntryPoint(file);
    }

    public void clearSelection() {
        this.fTable.clearSelection();
    }

    @Override
    public void stateChanged(IDPChangeEvent<?> iDPChangeEvent) {
        this.changeEvent();
    }

    private void addChangeListener(InputDataProperty inputDataProperty) {
        inputDataProperty.setChangeListener(this);
    }

    private void changeEvent() {
        for (ChangeListener changeListener : this.fChangeListeners) {
            changeListener.stateChanged(new ChangeEvent(this));
        }
    }

    private InputDataProperty createInputDataProperty(EntryPoint entryPoint, String string) {
        InputDataProperty inputDataProperty = new InputDataProperty(entryPoint, string);
        this.addChangeListener(inputDataProperty);
        return inputDataProperty;
    }

    private EntryPoint getEntryPoint(File file) {
        EntryPoint entryPoint = null;
        try {
            MTree mTree = MTree.parse((File)file);
            List list = mTree.findAsList(new MTree.NodeType[]{MTree.NodeType.FUNCTION});
            String string = file.getName();
            String string2 = list.isEmpty() ? "unknown" : ((MTree.Node)list.get(0)).getFunctionName().getText();
            entryPoint = new EntryPoint(string, string2);
            ArrayList<String> arrayList = new ArrayList<String>(0);
            Utilities.getEntryPointInputNames(mTree, arrayList);
            for (String string3 : arrayList) {
                entryPoint.addInput(this.createInputDataProperty(entryPoint, string3));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return entryPoint;
    }

    public void fileChanged() {
        ParsedFunctionParameterNames parsedFunctionParameterNames;
        if (this.fEntryPoint == null) {
            this.reloadEntryPoint(this.fEntryPointFile);
            if (this.fEntryPoint == null) {
                return;
            }
        }
        if (!(parsedFunctionParameterNames = Utilities.getEntryPointInputNames(this.fEntryPointFile)).isValid()) {
            this.reloadEntryPoint(this.fEntryPointFile);
            return;
        }
        List<String> list = this.fEntryPoint.getInputNames();
        if (!EntryPointFileDataWidget.isSignatureChange(parsedFunctionParameterNames.getInputNames(), list)) {
            return;
        }
        this.syncInputs(parsedFunctionParameterNames.getInputNames(), list, this.fEntryPoint.getInputDataProperties());
        this.changeEvent();
        this.fTable.getComponent().revalidate();
        this.fTable.getComponent().repaint();
    }

    private void syncInputs(List<String> list, List<String> list2, List<InputDataProperty> list3) {
        int n;
        int n2;
        ArrayList<Integer> arrayList = new ArrayList<Integer>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(i, -1);
        }
        ArrayList<Boolean> arrayList2 = new ArrayList<Boolean>(list2.size());
        for (n2 = 0; n2 < list2.size(); ++n2) {
            arrayList2.add(n2, true);
        }
        block2: for (n2 = 0; n2 < list.size(); ++n2) {
            String string = list.get(n2);
            for (n = 0; n < list2.size(); ++n) {
                String string2;
                if (!((Boolean)arrayList2.get(n)).booleanValue() || !string.equals(string2 = list2.get(n))) continue;
                arrayList.set(n2, n);
                arrayList2.set(n, false);
                continue block2;
            }
        }
        ArrayList<InputDataProperty> arrayList3 = new ArrayList<InputDataProperty>();
        for (int i = 0; i < list.size(); ++i) {
            InputDataProperty inputDataProperty;
            int n3;
            n = (Integer)arrayList.get(i);
            if (n != -1) {
                arrayList3.add(list3.get(n));
                continue;
            }
            boolean bl = false;
            String string = list.get(i);
            if (!IDPAttributes.isVarargin(string) && (n3 = arrayList2.indexOf(true)) != -1 && !IDPAttributes.isVarargin((inputDataProperty = list3.get(n3)).getName())) {
                inputDataProperty.setName(string, false);
                arrayList3.add(inputDataProperty);
                arrayList2.set(n3, false);
                bl = true;
            }
            if (bl) continue;
            arrayList3.add(this.createInputDataProperty(this.fEntryPoint, string));
        }
        this.fEntryPoint.replaceInputs(arrayList3, this);
        this.fTable.reload();
        this.changeEvent();
    }

    private static boolean isSignatureChange(List<String> list, List<String> list2) {
        if (list.size() != list2.size()) {
            return true;
        }
        for (int i = 0; i < list2.size(); ++i) {
            if (list2.get(i).equals(list.get(i))) continue;
            return true;
        }
        return false;
    }

    void setUsePreconditions(boolean bl) {
        if (this.fEntryPoint != null) {
            this.fEntryPoint.setUsePreconditions(bl);
        }
    }

    public void setData(XmlReader xmlReader) {
        if (this.fEntryPoint == null) {
            return;
        }
        List<InputDataProperty> list = InputDataProperty.parse(xmlReader, this, this.fEntryPoint);
        List<String> list2 = this.fEntryPoint.getInputNames();
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (InputDataProperty inputDataProperty : list) {
            arrayList.add(inputDataProperty.getName());
        }
        if (EntryPointFileDataWidget.isSignatureChange(list2, arrayList)) {
            this.syncInputs(list2, arrayList, list);
        } else {
            this.fEntryPoint.reconcileInputs(list);
        }
        this.fTable.reload();
    }

    public XmlReader getData() {
        try {
            XmlWriter xmlWriter = XmlApi.getInstance().create("Inputs");
            xmlWriter.writeAttribute("fileName", (Object)this.fEntryPoint.getFileName());
            xmlWriter.writeAttribute("functionName", (Object)this.fEntryPoint.getFunctionName());
            for (InputDataProperty inputDataProperty : this.fEntryPoint.getInputDataProperties()) {
                inputDataProperty.getData(xmlWriter);
            }
            return XmlApi.getInstance().read(xmlWriter.getXML());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.fChangeListeners.add(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.fChangeListeners.remove(changeListener);
    }

    public boolean showValidationMessage(ValidationMessage validationMessage) {
        return false;
    }

    public void clearValidationMessage() {
    }

    public Component getComponent() {
        return this.fPanel;
    }

    public void dispose() {
        this.fTable.dispose();
        Utilities.setEntryPointFileDataWidget(null);
        if (this.fEntryPoint == null) {
            return;
        }
        for (InputDataProperty inputDataProperty : this.fEntryPoint.getInputDataProperties()) {
            inputDataProperty.clearChangeListenerAndActiveDialog();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("param.UsePreconditions".equals(string)) {
            this.setUsePreconditions((Boolean)propertyChangeEvent.getNewValue());
        }
    }
}

